<?PHP
/**
* Dynamically render HTML form elements.
* 
* To be used in the place of hard coded HTML form elements.
*
* @package System_Lib
* @author Andy Rockwell <andy@solidphp.com>
*/
class forms
	{
	/**
	* Generate a spinner
	* 
	* @param integer $id
	* @return string 
	*/
	function spinner($id)
		{
		return "<img id='{$id}' class='spinner' src='spinner.gif' alt='"._w('working...')."' />";
		}

	/**
	* Sets the default value for a posted form
	* 
	* @param string $key The key to look for in $_POST
	* @param mixed $default The default value to use if $key is not found in $_POST
	* @param mixed $radio Indicates the current selected radio index
	* @param array $checkbox Indicates the current selected checkbox index
	* @return mixed The results
	*/
	function value($key, $default=false, $radio=false, $checkbox=false)
		{
		if ($radio)
			{
			if ($_POST[$key]==$radio) {	return true; }
			if ($default==$radio) {	return true; }

			return false;
			}

		if ($checkbox)
			{
			if ($_POST[$key]&&is_array($_POST[$key]))
				{
				return in_array($checkbox, $_POST[$key]);
				}

			if (!is_array($default)) { return false; }
			
			return in_array($checkbox, $default);
			}

		if ($_POST[$key]) { return htmlspecialchars($_POST[$key]); }
		if ($default!==false) { return htmlspecialchars($default); }

		return '';
		}

	/**
	* Displays the overlib.js help hint.
	* 
	* <code>
	* <?PHP
	* forms::overlib('hey now!');
	* forms::overlib('hey now!', 'index2.php?x=y');
	* forms::overlib('hey now!', 'index2.php?x=y', 0);
	* ?>
	* </code>
	* 
	* @param string $content
	* @param string $url defaults to javascript:void(0);
	* @param boolean $echo defaults to true, false returns the buffer
	* @param string $custom_image A full img tag
	* @param boolean $no_image Don't display an image if true. Any text entered on this variable will be displayed as the link.
	* @param boolean $css Specifiy a style for the anchor tag.
	* @return string Complete overlib with image ready to use.
	*/
	function overlib($content, $url=false, $echo=true, $custom_image=false, $no_image=false, $css=false)
		{
		if ($GLOBALS['session']['admin']['profile']['show_help_hints']=='No'&&$GLOBALS['session']['admin']['profile']['show_help_hints']) { return ''; }

		$display="[?]";
		if ($custom_image) { $display=$custom_image; }
		else if ($no_image) { $display=$no_image; }
		else
			{
			$display="<img src='templates/default/common/".config('template')."/images/tool_tip.gif' class='prototip_image' />"; 
			}

		$content=wordwrap($content, 400, '<br />', true);
		$content=str_replace("\r\n", '', nl2br($content));
		$buffer="<a href='#' onmouseover='do_tooltip(this, \"{$content}\");'>{$display}</a>";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}

	/**
	* Displays a radio button.
	* 
	* <code>
	* <?PHP
	* forms::radio('x1', 'x1', 50, $checked=true, $js=false, $style=false);
	* forms::radio('x1', 'x1', 50, true, false, false);
	* forms::radio('x1', 'x1', 50, 1, 0, 0);
	* forms::radio('x1', 'x1', 50);
	* forms::radio('x1', 0, 50);
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param boolean $checked Sets the state of the radio button
	* @param boolean $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete radio button ready to use.
	*/
	function radio($id, $name, $value, $checked=false, $js=false, $style=false, $echo=true)
		{
		$buffer="<input ";
		$buffer.="type='radio' ";
		$buffer.="id='{$id}' ";
		$buffer.="name='".(($name)?$name:$id)."' ";
		$buffer.="value='{$value}' ";
		//if ($style) { $buffer.="style='{$style}' "; }
		if ($checked) { $buffer.="checked='{$checked}' "; }
		if ($js) { $buffer.=$js.' '; }
		$buffer.=" tabindex='".($GLOBALS['tabindex']+=1)."' />";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}


	/**
	* Displays a checkbox.
	* 
	* <code>
	* <?PHP
	* forms::checkbox('x1', 'x1', 50, $checked=true, $js=false, $style=false);
	* forms::checkbox('x1', 'x1', 50, true, false, false);
	* forms::checkbox('x1', 'x1', 50, 1, 0, 0);
	* forms::checkbox('x1', 'x1', 50);
	* forms::checkbox('x1', 0, 50);
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param boolean $checked Sets the state of the radio button
	* @param boolean $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete checkbox ready to use.
	*/
	function checkbox($id, $name, $value, $checked=false, $js=false, $style=false, $echo=true)
		{
		$buffer="<input ";
		$buffer.="type='checkbox' ";
		$buffer.="id='{$id}' ";
		$buffer.="name='".(($name)?$name:$id)."' ";
		$buffer.="value='{$value}' ";
		//if ($style) { $buffer.="style='{$style}' "; }
		if ($checked) { $buffer.="checked='{$checked}' "; }
		if ($js) { $buffer.=$js.' '; }
		$buffer.=" tabindex='".($GLOBALS['tabindex']+=1)."' />";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}



	/**
	* Displays a text input box.
	* 
	* <code>
	* <?PHP
	* forms::text('x1', 'x1', 50, $checked=true, $js=false, $style=false);
	* forms::text('x1', 'x1', 50, true, false, false);
	* forms::text('x1', 'x1', 50, 1, 0, 0);
	* forms::text('x1', 'x1', 50);
	* forms::text('x1', 0, 50);
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param boolean $checked Sets the state of the radio button
	* @param boolean $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete text input ready to use.
	*/
	function text($id, $name=false, $value=false, $js=false, $style=false, $echo=true)
		{
		$buffer="<input ";
		$buffer.="type='text' ";
		$buffer.="id='{$id}' ";
		$buffer.="name='".(($name)?$name:$id)."' ";
		if (strlen(trim($value))!=0) { $buffer.="value=\"{$value}\" "; }

		$use_this="class='text' ";
		if ($style) { $use_this="class='{$style}' "; }
		$buffer.=$use_this;

		if ($js) { $buffer.=$js.' '; }

		$buffer.=" tabindex='".($GLOBALS['tabindex']+=1)."' />";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}


	/**
	* Displays a password input box.
	* 
	* <code>
	* <?PHP
	* forms::password('x1', 'x1', 50, $checked=true, $js=false, $style=false);
	* forms::password('x1', 'x1', 50, true, false, false);
	* forms::password('x1', 'x1', 50, 1, 0, 0);
	* forms::password('x1', 'x1', 50);
	* forms::password('x1', 0, 50);
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param boolean $checked Sets the state of the radio button
	* @param boolean $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete password input ready to use.
	*/
	function password($id, $name=false, $value=false, $js=false, $style=false, $echo=true)
		{
		$buffer="<input ";
		$buffer.="type='password' ";
		$buffer.="id='{$id}' ";
		$buffer.="name='".(($name)?$name:$id)."' ";
		if ($value) { $buffer.="value='{$value}' "; }

		$use_this="class='text' ";
		if ($style) { $use_this="class='{$style}' "; }
		$buffer.=$use_this;

		if ($js) { $buffer.=$js.' '; }

		$buffer.=" tabindex='".($GLOBALS['tabindex']+=1)."' />";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}


	/**
	* Displays a hidden input box.
	* 
	* <code>
	* <?PHP
	* forms::hidden('x1', 'x1', 50);
	* forms::hidden('x1', 0, 50);
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete hidden input ready to use.
	*/
	function hidden($id, $name, $value, $echo=true)
		{
		$input="<input type='hidden' id='{$id}' name='".(($name)?$name:$id)."' value='{$value}' />";

		if (!$echo) { return $input; }

		echo $input;
		}
		

	/**
	* Displays a textarea box.
	* 
	* <code>
	* <?PHP
	* forms::textarea('x1', 'x1', 50, 100);
	* forms::textarea('x1', 0, 50, 50, 100);
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param integer $width Width in pixels without the px
	* @param integer $height Height in pixels without the px
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete textarea box ready to use.
	*/
	function textarea($id, $name, $value, $width, $height, $echo=true)
		{
		$buffer="<textarea ";
		$buffer.="id='".(($id)?$id:$name)."' ";
		$buffer.="name='".(($name)?$name:$id)."' ";
		$buffer.="style='width: {$width}; height: {$height};' tabindex='".($GLOBALS['tabindex']+=1)."'>";
		$buffer.=$value;
		$buffer.="</textarea>";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}
		

	/**
	* Displays a select box.
	* 
	* <code>
	* <?PHP
	* forms::select('x1', 'x1', array('key'=>'value', 'key1'=>'value1'), $js=false, $style=false);
	* forms::select('x1', 'x1', array('key'=>'value', 'key1'=>'value1'), $js=false);
	* forms::select('x1', 'x1', array('key'=>'value', 'key1'=>'value1'));
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param array $options An array of key / value pairs to use as the select options.
	* @param boolean $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete textarea box ready to use.
	*/
	function select($id, $name, $options, $current=false, $js=false, $style=false, $echo=true)
		{
		$buffer="<select ";
		$buffer.="id='{$id}' ";
		$buffer.="name='".(($name)?$name:$id)."' ";

		$use_this="class='text' ";
		if ($style) { $use_this="class='{$style}' "; }
		//$buffer.=$use_this;

		if ($js) { $buffer.=$js.' '; }

		$buffer.=" style='z-index: 1;' tabindex='".($GLOBALS['tabindex']+=1)."'>\n";
		
		if (!is_array($options)) { $options=array(); }
		
		foreach ($options as $key => $value)
			{
			$selected=''; $star='';
			// removed due to skin setting on admin profile editor
			// and no default skin selected 
			// if ($key==$current) 
			if (strcmp($key, $current)==0) 
				{ 
				$selected=' selected'; $star='* '; 
				}

			$buffer.="<option value='{$key}'{$selected}>";
			$buffer.=$star.$value;
			$buffer.="</option>\n";
			}

		$buffer.='</select>';

		if (!$echo) { return $buffer; }

		echo $buffer;
		}


	/**
	* Displays a submit button.
	* 
	* <code>
	* <?PHP
	* forms::submit('x1', 'x1', 'hello world', $js=false, $style=false);
	* forms::submit('x1', 'x1', 'hello world', $js=false);
	* forms::submit('x1', 'x1', 'hello world');
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param boolean $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete textarea box ready to use.
	*/
	function submit($id, $name, $value, $js=false, $style=false, $echo=true)
		{
		// set to default form_submission, this will prevent the ajax
		// redirect functions from accidently triggering a form submission.
		// The key "form_submission" is a special value.
		if (!$id) { $id='form_submission'; }

		$buffer="<input ";
		$buffer.="type='submit' ";
		$buffer.="id='{$id}' ";
		$buffer.="name='".(($name)?$name:$id)."' ";
		$buffer.="value='{$value}' ";

		$use_this="class='submit' ";
		if ($style) { $use_this="class='{$style}' "; }
		$buffer.=$use_this;

		if ($js) { $buffer.=$js.' '; }
		$buffer.=" tabindex='".($GLOBALS['tabindex']+=1)."' />";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}


	/**
	* Displays a button.
	* 
	* <code>
	* <?PHP
	* forms::button('x1', 'x1', 'hello world', $js=false, $style=false);
	* forms::button('x1', 'x1', 'hello world', $js=false);
	* forms::button('x1', 'x1', 'hello world');
	* ?>
	* </code>
	* 
	* @param string $id
	* @param string $name Defaults to $id if false
	* @param mixed $value
	* @param boolean $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @return string Complete textarea box ready to use.
	*/
	function button($id, $name, $value, $js=false, $style=false, $echo=true)
		{
		// set to default form_submission, this will prevent the ajax
		// redirect functions from accidently triggering a form submission.
		// The key "form_submission" is a special value.
		if (!$id) { $id='form_submission'; }

		$buffer="<input ";
		$buffer.="type='button' ";
		$buffer.="id='{$id}' ";
		$buffer.="name='".(($name)?$name:$id)."' ";
		$buffer.="value='{$value}' ";

		$use_this="class='button' ";
		if ($style) { $use_this="class='{$style}' "; }
		//$buffer.=$use_this;

		if ($js) { $buffer.=$js.' '; }
		$buffer.=" tabindex='".($GLOBALS['tabindex']+=1)."' />";

		if (!$echo) { return $buffer; }

		echo $buffer;
		}


	/**
	* Displays the form action.
	* 
	* <code>
	* <?PHP
	* forms::action();
	* ?>
	* </code>
	* 
	* @param mixed $action The action of the form.
	* @param string $method
	* @param mixed $js Applies any JS
	* @param mixed $style Override the default css style
	* @param boolean $echo defaults to true, false returns the buffer
	* @param boolean $id pass a unique ID for the form
	* @return string Complete textarea box ready to use.
	*/
	function action($action=false, $method='POST', $js=false, $style=false, $echo=true, $id=false)
		{
		$buffer="<form ";
		$buffer.="action='".($action?$action:$_SERVER['PHP_SELF'])."' ";
		$buffer.="name='".((!$id)?'main':$id)."' ";
		$buffer.="id='".((!$id)?'main':$id)."' ";
		$buffer.="method='{$method}' ";

		//if ($style) { $buffer.="class='{$style}' "; }

		if ($js) { $buffer.=$js.' '; }
		$buffer.="/>";

		if (defined('CSRF') && CSRF != '') {
			$buffer .= forms::hidden('csrf', 0, CSRF, false);
		}

		if (!$echo) { return $buffer; }

		echo $buffer;
		}

	/**
	* Include the form handler and return any errors.
	*  
	* @see modules/system/environment.php
	* @param string $page The filename without extension.
	* @return mixed false on on page passed or include the file and return any errors
	
	function handler($page)
		{
		if (!$page) { return false; }
	
		if (file_exists("modules/system/form_handler/{$page}.php"))
			{
			include_once "modules/system/form_handler/{$page}.php";
			}

		return $errors;
		}
	*/

	/**
	* Include the form handler and return any errors.
	*  
	* @see modules/system/environment.php
	* @param string $page The filename without extension.
	* @return boolean false do not valdate; true validate
	*/
	function do_validate_form()
		{
		$form_handler=false;

		if ($_POST) { return true; }
		
		if (!empty($_GET))
			{
			$form_handler=true;
			if (count($_GET)==1)
				{
				if (isset($_GET['run']))
					{
					$form_handler=false;
					}
				}
			}

		return $form_handler;
		}

	/**
	* Find a target $id in an $array for a matching $key, return boolean. To be used with call_user_func()
	* 
	* @param array $id		The current ID in the loop ex. 4
	* @param array $array	The array to search for $key ex. array( array('wss_id' => 4) );
	* @param array $key		The key name to match up. ex. wss_id 
	* @return boolean
	*/
	function exists_in_array($id, $array, $key)
		{
		if (!is_array($array)) { $array=array(); }
		foreach ($array as $instance)
			{
			if ($instance[$key]==$id)
				{
				return true;
				}
			}
	
		return false;
		}

	/**
	* Find a target $id in an $array for a matching $key, return key value of $return. To be used with call_user_func()
	* 
	* @param array $id		The current ID in the loop ex. 4
	* @param array $array	The array to search for $key ex. array( array('wss_id' => 4) );
	* @param array $key		The key name to match up. ex. wss_id 
	* @param array $return	The key name to return. ex. display_order 
	* @return boolean
	*/
	function exists_in_array_return_value($id, $array, $key, $return)
		{
		foreach($array as $element)
			{
			if ($id==$element[$key])
				{
				return $element[$return];
				}
			}
		}
	}
?>