<?PHP
/**
* Handles pagination
*
* @author Andy Rockwell <andy@solidphp.com>
*/
class paging
	{
	/**
	* Upper and lower limits based on the current page.
	*
	* @param integer $total_records
	* @param integer $current_page
	* @param integer $max_pages
	* @param integer $max_rows
	* @return array
	*/
	function limits($total_records, $current_page, $max_pages, $max_rows)
		{
		// not enough records to paginate
		if ($total_records<=$max_rows) { return false; }
		
		// the total number of pages we have
		$total_pages=ceil($total_records/$max_rows);
	
		// skip handles cases where we are known to be out of scope
		// with the upper or lower limits
		$skip=false;
		if (!$current_page||$current_page<=1)
			{
			$start=($current_page)?$current_page:1;
			$end=($max_pages>$total_pages)?$total_pages:$max_pages;

			$skip=true;
			}
		else if ($current_page<$max_pages)
			{
			$start=1;
			$end=($max_pages>$total_pages)?$total_pages:$max_pages;
	
			$skip=true;
			}
		else if ($current_page<$total_pages)
			{
			$max_pages-=1;
			$offset=ceil($max_pages/2);
			$start=$current_page-$offset;
			$end=$start+$max_pages;
			}
		else
			{
			$start=$total_pages-($max_pages-1);
			$end=$total_pages;
			}
			
		if ($end>$total_pages&&!$skip)
			{
			$start=$total_pages-$max_pages;
			$end=$total_pages;
			}
	
		return array('start' => $start, 'end' => $end);
		}


	/**
	* Draw the HTML tags and text
	*
	* < << [1][2][3] >> >
	* 
	* @param array $limits
	* @param integer $current_page
	* @param string $tab
	* @return array
	*/
	function draw($limits, $current_page, $tab='')
		{
		$buffer='';
		// pr($limits);
		// show the <
		// if ($current_page>1&&$limits['start']>=4)
		if ($current_page>1&&$limits['start']<$current_page)
			{
			$link=href(x('task'), paging::query($limits['start'], $tab));
			$buffer.="<a href='{$link}'>|&laquo;</a>";

			$link=href(x('task'), paging::query($current_page-1, $tab));
			$buffer.="<a href='{$link}'>&laquo;</a>";
			}

		for ($i=$limits['start']; $i<=$limits['end']; $i++)
			{
			$class=($i==$current_page)?" class='on'":'';
			$link=href(x('task'), paging::query($i, $tab));
			$buffer.="<a href='{$link}'{$class}>{$i}</a>";
			}	

		// show the >
		$next_page=$current_page+=1;
		if ($next_page<=$limits['end'])
			{
			$link=href(x('task'), paging::query($next_page, $tab));
			$buffer.="<a href='{$link}'>&raquo;</a>";

			$link=href(x('task'), paging::query($limits['end'], $tab));
			$buffer.="<a href='{$link}'>&raquo;|</a>";
			}

		return "<div class='pagination'>{$buffer}</div>";
		}

	/**
	* Build a querystring
	*
	* @param integer $current_page
	* @param string $tab
	* @return string
	*/
	function query($current_page, $tab='')
		{
		$buffer=array();
		$buffer['task']=x('task');
		$buffer['current_page']=$current_page;
		if ($tab) { $buffer['tab'] = $tab; }

		$use=($_POST)?$_POST:$_GET;
		foreach ($use as $key => $value)
			{
			if (in_array($key, array('task', 'current_page', 'max_rows', 'tab'))) { continue; }
			$buffer[$key]=$value;
			}
	
		return $buffer;
		}
	

	/**
	* Maps out a cross section used in paging::draw()
	*
	* @param integer $max_rows
	* @param array $limits
	* @param integer $current_page
	* @param integer $total_records
	* @return array
	*/
	function recordset($max_rows, $limits, $current_page, $total_records)
		{
		if ($current_page<=1) 
			{
			$start=0; 
			$end=$max_rows;
			}
		else
			{
			$start=$max_rows*($current_page-1);
			$end=$start+$max_rows;
			if ($end>$total_records) { $end=$total_records; }
			}

		return array('start' => $start, 'end' => $end);
		}


	/**
	* Easy use wrapper for pagination
	*
	* @param array $data
	* @param integer $max_pages
	* @param integer $max_rows
	* @param string $tab
	* @return array
	*/
	function compile($data, $max_pages=7, $max_rows=25, $tab='')
		{
		if (!$data) { return false; }

		$current_page=1;
		if ($_GET['current_page']) { $current_page=$_GET['current_page']; }
		else if ($_POST['current_page']) { $current_page=$_POST['current_page']; }
		else if ($GLOBALS['current_page']) { $current_page=$GLOBALS['current_page']; }

		$total_records=count($data)-1;

		if ($total_records<=$max_rows) { return false; }

		$limits=paging::limits($total_records, $current_page, $max_pages, $max_rows);
		
		// $recordset=paging::recordset($max_rows, $limits, $current_page, $total_records);
		
		$pagination=paging::draw($limits, $current_page, $tab);

		// $data=array_slice($data, $recordset['start'], $recordset['end']);
		$data=array_chunk($data, $max_rows, true);
		$data=$data[$current_page-1];

		return array('pagination' => $pagination, 'data' => $data);
		}
	}
?>