<?PHP if (!defined('SAFE')) { die('invalid'); }

// query the API
$request=api_kb::listings(
		$conf['api_handler'], 
		$conf['api_key'], 
		'kb', 
		'listings', 
		false, // set to true for debug 
		((x('category_id'))?x('category_id'):0)
		);

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];

if ($conf['site']['status']=='Down for Maintenance')
	{
	$link=href('down_for_maintenance');
	die(header("Location: {$link}"));
	}
else if ($conf['site']['status']=='Private')
	{
	$link=href('private');
	die(header("Location: {$link}"));
	}

if ($request['errors']) { die(header("Location: ".href('index'))); }

$categories=array_chunk($request['categories'], 3);// pr($request);
$breadcrumb=breadcrumb($request['breadcrumb']);
$sticky_articles=$request['sticky_articles'];
$articles=$request['articles'];
unset($request);

// sort pagination
$pagination=paging::compile($articles, $conf['pages'], $conf['rows'], ''); // pr($pagination);
if ($pagination)
	{
	$articles=$pagination['data'];
	$pagination=$pagination['pagination'];
	}

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare($data)
	{
	$buffer=array();

	for ($i=0; $i<=2; $i++)
		{
		if (!$data[$i]) { continue; }

		// the category icon
		$buffer[$i]['icon']='';
		if ($data[$i]['icon'])
			{
			$buffer[$i]['icon']="templates/".config('template')."/images/icons/{$data[$i]['icon']}";
			}

		$buffer[$i]['link_out']=href('listings', array('category_id' => $data[$i]['id']));
		$buffer[$i]['name']=$data[$i]['name'];
		$buffer[$i]['article_count']=$data[$i]['article_count'];

		// the category description
		$buffer[$i]['description']='';
		if ($data[$i]['description'])
			{
			$buffer[$i]['description']="<div>{$data[$i]['description']}</div>";
			}
		}

	return $buffer;
	}

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_blocks($data)
	{
	$buffer=array();

	// the article icon
	$icon='';
	if ($data['icon'])
		{
		$buffer['icon']="templates/".config('template')."/images/icons/{$data['icon']}";
		}

	$buffer['link_out']=href('article', array('article_id' => $data['id'], 'category_id' => x('category_id')));

	$buffer['title']=$data['title'];

	return $buffer;
	}
?>