<?PHP if (!defined('SAFE')) { die('invalid'); } ?>

<?PHP if (!$invoice || $invoice['deleted']=='Yes'): ?>
	<br /><br />
	<div class='error'>
		<?PHP echo $title; ?>
		<?php if ($invoice && $invoice['deleted']=='Yes') {?> (<?php echo _w('Invoice Deleted'); ?>)<?php } ?>
	</div><br /><br />
<?PHP else: ?>
	<div id='invoice'>
		<ul>
			<li class='left'><h1><?PHP echo $company_name; ?></h1></li>
			<li class='right_aligned'><h1><?PHP echo _w('invoice'); ?> #<?PHP echo $invoice['invoice_id']; ?> - <?PHP echo $invoice['status']; ?> <?PHP echo (($invoice['status']=='Paid')?'':$balance); ?></h1>
				<?PHP if ($show_pay_option&&!$auto_pay): ?>
					<ul id='pay_form'>
						<li><input onclick='window.location="<?PHP echo $make_payment?>"' type='submit' class='submit' value='<?PHP echo _w('make_payment'); ?>' /></li>
					</ul>
				<?PHP elseif ($auto_pay): ?>
					<ul id='pay_form'>
						<li><?PHP echo _w('pending_auto_pay'); ?></li>
					</ul>
				<?PHP elseif($invoice['status']=='Due'): ?>
					<ul id='pay_form'>
						<li><?PHP echo _w('pending_payment'); ?></li>
					</ul>
				<?PHP endif; ?>
			</li>
		</ul>
		<div class='clear'><!--ie--></div>

		<ul>
			<li class='left'><b><?PHP echo _w('invoice_to'); ?></b></li>
			<li class='right'><b><?PHP echo _w('pay_to'); ?></b></li>
			<li class='left'>
				<br /><?PHP echo $customer['display_address']; ?>
				<?PHP if ($order_form['enable_vat']=='Yes'&&$customer['vat_number']): ?>
					<?PHP echo _w('V.A.T.'); ?> <?PHP echo (($customer['vat_number'])?$customer['vat_number']:_w('unknown_vat')); ?><br />
				<?PHP endif; ?>
			</li>
			<li class='right'>
				<br /><?PHP echo $company_name; ?>
				<br /><?PHP echo $company_address; ?>
				<?PHP if ($order_form['enable_vat']=='Yes'&&$order_form['vat_number']): ?>
					<br /><?PHP echo _w('V.A.T.'); ?> <?PHP echo $order_form['vat_number']; ?>
				<?PHP endif; ?>
			</li>
		</ul>
		<div class='clear'><!--ie--></div><br /><br />

		<b><?PHP echo _w('invoice_items'); ?></b><br /><br />
		<table class='data_grid'>
			<tr class='th'>
				<th><?PHP echo _w('line_item'); ?></th>
				<th><?PHP echo _w('Item Price'); ?></th>
				<th><?PHP echo _w('discount'); ?></th>
				<th><?PHP echo _w('total'); ?></th>
			</tr>

			<?PHP if (is_array($line_items)&&!empty($line_items)): ?>
				<?PHP $m3=0; foreach($line_items as $unique): $data=prepare_line_items($unique, $invoice['currency_id']); ?>
					<tr <?PHP echo $data['alt']; ?>>
						<td><?PHP echo $data['description']; ?></td>
						<td><?PHP echo $data['total']; ?></td>
						<td><?PHP echo $data['discount']; ?></td>
						<td><?PHP echo $data['total_due']; ?></td>
					</tr>
				<?PHP endforeach; ?>
			<?PHP endif; ?>
		</table><br /><br />


		<?PHP if (is_array($credits_used)&&!empty($credits_used)): ?>
			<b><?PHP echo _w('invoice_credits'); ?></b><br /><br />
			<table class='data_grid'>
				<tr class='th'>
					<th><?PHP echo _w('description'); ?></th>
					<th><?PHP echo _w('applied_on'); ?></th>
					<th><?PHP echo _w('amount'); ?></th>
				</tr>
				<?PHP $m3=0; foreach($credits_used as $unique): $data=prepare_credit_usage($unique); ?>
					<tr <?PHP echo $data['alt']; ?>>
						<td><?PHP echo $data['description']; ?></td>
						<th><?PHP echo $data['created']?></th>
						<td><?PHP echo $data['amount']?></td>
					</tr>
				<?PHP endforeach; ?>
			</table><br /><br />
		<?PHP endif; ?>


		<?PHP if (is_array($invoice_payments)&&!empty($invoice_payments)): ?>
			<b><?PHP echo _w('invoice_payments'); ?></b><br /><br />
			<table class='data_grid'>
					<tr class='th'>
						<th><?PHP echo _w('description'); ?></th>
						<th><?PHP echo _w('transaction_id'); ?></th>
						<th><?PHP echo _w('subscription_id'); ?></th>
						<th><?PHP echo _w('created'); ?></th>
						<th><?PHP echo _w('amount'); ?></th>
					</tr>

			<?PHP $m3=0; foreach($invoice_payments as $unique): $data=prepare_payments($unique, $invoice['currency_id']); ?>
				<tr <?PHP echo $data['alt']; ?>>
					<td><?PHP echo $data['description']?></td>
					<td><?PHP echo $data['transaction_id']; ?></td>
					<td><?PHP echo $data['subscription_id']; ?></td>
					<td><?PHP echo $data['created']; ?></td>
					<td><?PHP echo $data['amount']; ?></td>
				</tr>
			<?PHP endforeach; ?>
			</table><br /><br />
		<?PHP else: ?>
			<?PHP echo ('No payments to date.'); ?>
		<?PHP endif; ?>

	</div>
	<div class='clear'><!--ie--></div>

	<ul>
		<li class='left'><?PHP echo _w('generated_on'); ?> <?PHP echo date(config('date_format'), $invoice['created']); ?>.</li>
		<li class='right_aligned'><b><?PHP echo _w('end_of_invoice'); ?></b></li>
	</ul>
	<div class='clear'><!--ie--></div>

	<?PHP if ($conf['site']['invoice_statement']): ?>
		<br /><p><?PHP echo nl2br($conf['site']['invoice_statement']); ?></p>
	<?PHP endif; ?>

	<?PHP if ($invoice['public_notes']): ?>
		<br /><p><?PHP echo $invoice['public_notes']; ?></p>
	<?PHP endif; ?>

	<?PHP if ($show_pay_option && $wire_transfer_instructions): ?>
		<br /><p><?PHP echo nl2br($wire_transfer_instructions); ?></p>
	<?PHP endif; ?>
<?PHP endif; ?>