<?PHP
error_reporting(6135);
ini_set('display_errors', '1');
define('SAFE', true);

/**
* Recursively search for the configuration file!
* 
* @return string 
*/
function start_storefront()
	{
	$try=''; 
	while (strlen($try)<=3)
		{
		$conf="{$try}m3_configuration.php";
		if (file_exists($conf)) {  return $conf; }
		$try.='../';
		}

	return false;
	}

// start m3
$installed=start_storefront();
if (!$installed) { die(header('Location: ../install')); }
$spbas='customers';
define('SPBAS', $spbas);
include $installed;
unset($spbas);

include 'includes/globals.php';
$conf['template']=getTemplatePath($conf['template']);

clear_cache();

// What to run?
$mod='customer_areas';
$task=(x('task'))?x('task'):'index';

// Validate the task.
$task=in_array($task, $conf['valid_tasks'])?$task:'index';

// make sure the IDs are integer
foreach (array('id','package_id','category_id','license_id','max_rows','department_id') as $key)
	{
	if (in_array($task, array('opt_out','invoice','view_email'))) { continue; }
	if (isset($_GET[$key])) { $_GET[$key]=intval($_GET[$key]); }
	if (isset($_POST[$key])) { $_POST[$key]=intval($_POST[$key]); }
	if (isset($_COOKIE[$key])) { $_COOKIE[$key]=intval($_COOKIE[$key]); }
	}

// validate the tab
$valid_tabs=array('my_info', 'contacts', 'addresses', 'security_question', 'change_password', 'due', 'paid', 'open_tickets', 'closed_tickets', 'start_ticket', 'downloads', 'licenses', 'addon_packages', 'hosting', 'domains', 'package', 'new_order', 'resold_packages');
if (isset($_POST['tab'])&&!in_array($_POST['tab'], $valid_tabs)) { unset($GLOBALS['_POST']['tab']); }
elseif (isset($_GET['tab'])&&!in_array($_GET['tab'], $valid_tabs)) { unset($GLOBALS['_GET']['tab']); }
elseif (isset($_COOKIE['tab'])&&!in_array($_COOKIE['tab'], $valid_tabs)) { set_cookie('tab', 0); unset($GLOBALS['_COOKIE']['tab']); }


// Process password protected pages.
$password_protected=in_array($task, $conf['password_protected']);
if ($_COOKIE['customer_session']||$password_protected)
	{
	$request=api_customer_area::process_session(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'process_session', 
			false, // set to true for debug 
			$_COOKIE['customer_session']
			); 

	$session=$request['session'];

	if (!$session&&$password_protected)
		{
		set_cookie('customer_session', 0);
		die(header("Location: logout.php"));
		}
	}

// set the default language
// if (!$_COOKIE['spbas_language']) { set_cookie('spbas_language', 'en-us'); }


// get the available language switcher
$switch=api_customer_area::available_languages(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'available_languages', 
		false // set to true for debug 
		);

// change the language on demand
if ($_GET['change_language']&&strlen($_GET['change_language'])==5) 
	{ 
	$_COOKIE['change_language']=$_GET['change_language'];
	set_cookie('change_language', 0); 
	set_cookie('change_language', $_GET['change_language']); 
	}

// try and change the language automatically
else if (!$_COOKIE['change_language']&&$detected_language=detect_browser_language())
	{
	if (in_array($detected_language, (array)$switch['available_languages_array']))
		{
		$_COOKIE['change_language']=$detected_language;
		set_cookie('change_language', 0); 
		set_cookie('change_language', $_GET['change_language']);
		unset($detected_language);
		}
	}

// got a cookie and detected languages
else if ($_COOKIE['change_language']&&$detected_language)
	{
	// does the cookie contain a language that is actually installed?
	if (!in_array($_COOKIE['change_language'], (array)$switch['available_languages_array']))
		{
		// nope, let's default to en-us and rmeove the cookie
		$_COOKIE['change_language']='en-us';
		set_cookie('change_language', 0); 
		}
	}

$errors = array();

// CSRF
// ----------------------------------------------------------------------------
$request=api_customer_area::crsf_validate(
	$conf['api_handler'], 
	$conf['api_key'], 
	'customer_areas', 
	'csrf_validate', 
	false, // set to true for debug 
	$_COOKIE['customer_session'],
	$_POST['csrf'],
	$_POST
);

$isValidCSRF = (isset($request['isValidCSRF']) && $request['isValidCSRF']);
if (!$isValidCSRF && !empty($request['errors'])) {
	$errors = array_merge($errors, $request['errors']);
}
define(VALID_CSRF, $isValidCSRF);
define(CSRF, $request['csrf']);
unset($request, $isValidCSRF, $_POST['csrf']);
// ----------------------------------------------------------------------------
// END: CSRF

$no_header_footer=array('invoice','view_email');
if (file_exists($m3="compiler/{$task}.php")) { include_once $m3; }

if (x('rss')) 
	{ 
	header("Content-type: application/xml"); 
	$m3="templates/{$conf['template']}/{$task}_rss.php";
	if (file_exists($m3)) { include_once $m3; }
	exit;
	}

$m3="templates/{$conf['template']}/header.php";
if (in_array($task, $no_header_footer)) { $m3="templates/{$conf['template']}/header_print.php"; } 
include_once $m3;

$m3="templates/{$conf['template']}/{$task}.php";
if (file_exists($m3)) { include_once $m3; }

$m3="templates/{$conf['template']}/footer.php";
if (in_array($task, $no_header_footer)) { $m3="templates/{$conf['template']}/footer_print.php"; }
include_once $m3;
?>