<?PHP
/**
 * SPBAS Storefront API Wrappers for the Customer Area API
 *
 * @package    Storefront_API_Wrappers_Customers
 * @author     Andy Rockwell <support@solidphp.com>
 */
class api_customer_area extends api
	{
	/**
	* Validates a CSRF token
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $customer_session
	* @param string $csrf
	* @param boolean $enforce
	* @return array 
	*/
	function crsf_validate($api_handler, $api_key, $mod, $task, $debug, $customer_session, $csrf, $enforce)
		{
		$data=array(
					'customer_session' => $customer_session, 
					'csrf' => $csrf,  
					'enforce' => $enforce ? 1 : 0, 
					);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Add a new customer by a reseller.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param string $customer_name
	* @param string $first_name
	* @param string $last_name
	* @param string $username
	* @param string $email
	* @param string $password
	* @return array 
	*/
	function add_resold_customer($api_handler, $api_key, $mod, $task, $debug, $session_id,  $customer_name, $first_name, $last_name, $username, $email, $password)
		{
		$data=array(
				'session_id' => $session_id,
				'customer_name' => $customer_name,
				'first_name' => $first_name,
				'last_name' => $last_name,
				'username' => $username,
				'email' => $email,
				'password' => $password,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the my reseller page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @return array 
	*/
	function reseller($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Start an order for a resold customer
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id
	* @param string $email
	* @param string $customer_name
	* @return array 
	*/
	function reseller_start_order($api_handler, $api_key, $mod, $task, $debug, $session_id, $email, $customer_name)
		{
		$data=array();
		$data['session_id']=$session_id;
		$data['email']=$email;
		$data['customer_name']=$customer_name;

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Finds the target customer for resold orders
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id
	* @param string $email
	* @return array 
	*/
	function reseller_find_customer($api_handler, $api_key, $mod, $task, $debug, $session_id, $email)
		{
		$data=array();
		$data['session_id']=$session_id;
		$data['email']=$email;

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Builds language changer links
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function available_languages($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Build the contact form page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function contact($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Get department options for the chosen department ID.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id
	* @param integer $department_id
	* @param integer $package_id
	* @param integer $show_renewal_options
	* @return array 
	*/
	function choose_department($api_handler, $api_key, $mod, $task, $debug, $session_id, $department_id, $package_id=0, $show_renewal_options=0)
		{
		$data=array(
				'session_id' => $session_id,
				'department_id' => $department_id,
				'package_id' => $package_id,
				'renewal_options' => $show_renewal_options,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* View a support ticket
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id
	* @param integer $ticket_id
	* @return array 
	*/
	function view_ticket($api_handler, $api_key, $mod, $task, $debug, $session_id, $ticket_id)
		{
		$data=array(
				'session_id' => $session_id,
				'ticket_id' => $ticket_id,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Process the submitted contact form
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $first_name
	* @param string $last_name
	* @param string $email
	* @param string $subject
	* @param string $message
	* @return array 
	*/
	function contact_form_send($api_handler, $api_key, $mod, $task, $debug, $first_name, $last_name, $email, $subject, $message)
		{
		$data=array(
				'first_name' => $first_name,
				'last_name' => $last_name,
				'email' => $email,
				'subject' => $subject,
				'message' => $message,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the helpdesk page of the customer area.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id  e.g. $_COOKIE['customer_session']
	* @param string $ticket_id
	* @return array 
	*/
	function helpdesk_close_ticket($api_handler, $api_key, $mod, $task, $debug, $session_id, $ticket_id)
		{
		$data=array('session_id' => $session_id, 'ticket_id' => $ticket_id, 'close_ticket' => 'y');

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the helpdesk page of the customer area.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id  e.g. $_COOKIE['customer_session']
	* @return array 
	*/
	function helpdesk($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Process the session for a logged in user.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id  e.g. $_COOKIE['customer_session']
	* @return array 
	*/
	function process_session($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Get announcements available to logged in users only.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id e.g. $session['session_id']
	* @return array 
	*/
	function announcements($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Get the customer area dashboard.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id e.g. $session['session_id']
	* @return array 
	*/
	function dashboard($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Download a public file
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id e.g. $session['session_id']
	* @param string $file_id
	* @return nothing 
	*/
	function download($api_handler, $mod, $task, $debug, $session_id, $file_id)
		{ 
		die(header("Location: {$api_handler}?mod={$mod}&task={$task}&session_id={$session_id}&file_id={$file_id}"));
		}

	/**
	* Get the download categories & contents for $category_id.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param integer $category_id
	* @return array 
	*/
	function downloads($api_handler, $api_key, $mod, $task, $debug, $category_id)
		{
		$data=array('category_id' => $category_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the main customer area index page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function index($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Build the invoice page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $token
	* @param string $ip
	* @param string $download_pdf
	* @return array 
	*/
	function invoice($api_handler, $api_key, $mod, $task, $debug, $token, $ip, $download_pdf='No')
		{
		$data=array(
				'token' => $token,
				'ip' => $ip,
				'download_pdf' => $download_pdf,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the login page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function build_login_page($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Send the login request to create a new session.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $email
	* @param string $password
	* @param string $ip
	* @return array 
	*/
	function login($api_handler, $api_key, $mod, $task, $debug, $email, $password, $ip)
		{
		$data=array(
				'email' => $email,
				'password' => $password,
				'ip' => $ip,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Send the resend password request.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $email
	* @return array 
	*/
	function resend_password($api_handler, $api_key, $mod, $task, $debug, $email)
		{
		$data=array('email' => $email);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the my account page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @return array 
	*/
	function my_account($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Delete an address on file.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $address_id
	* @return array 
	*/
	function delete_address($api_handler, $api_key, $mod, $task, $debug, $session_id, $address_id)
		{
		$data=array(
				'session_id' => $session_id,
				'address_id' => $address_id
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Add a new address for the customer.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param string $contact_type
	* @param string $business_name
	* @param string $address
	* @param string $city
	* @param integer $country_id
	* @param integer $state_id
	* @param string $province
	* @param string $postal_code
	* @param string $phone
	* @return array 
	*/
	function add_address($api_handler, $api_key, $mod, $task, $debug, $session_id, $contact_type, $business_name, $address, $city, $country_id, $state_id, $province, $postal_code, $phone)
		{
		$data=array(
				'session_id' => $session_id,
				'contact_type' => $contact_type,
				'business_name' => $business_name,
				'address' => $address,
				'city' => $city,
				'country_id' => $country_id,
				'state_id' => $state_id,
				'province' => $province,
				'postal_code' => $postal_code,
				'phone' => $phone,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Update the customers address
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $address_id
	* @param string $contact_type
	* @param string $business_name
	* @param string $address
	* @param string $city
	* @param integer $country_id
	* @param integer $state_id
	* @param string $province
	* @param string $postal_code
	* @param string $phone
	* @return array 
	*/
	function update_address($api_handler, $api_key, $mod, $task, $debug, $session_id, $address_id, $contact_type, $business_name, $address, $city, $country_id, $state_id, $province, $postal_code, $phone)
		{
		$data=array(
				'session_id' => $session_id,
				'address_id' => $address_id,
				'contact_type' => $contact_type,
				'business_name' => $business_name,
				'address' => $address,
				'city' => $city,
				'country_id' => $country_id,
				'state_id' => $state_id,
				'province' => $province,
				'postal_code' => $postal_code,
				'phone' => $phone,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Delete a contact.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $contact_id
	* @return array 
	*/
	function delete_contact($api_handler, $api_key, $mod, $task, $debug, $session_id, $contact_id)
		{
		$data=array(
				'session_id' => $session_id,
				'contact_id' => $contact_id,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Update a contact.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $contact_id
	* @param string $first_name
	* @param string $last_name
	* @param string $username
	* @param string $email
	* @param string $password
	* @param string $update_user
	* @return array 
	*/
	function update_contact($api_handler, $api_key, $mod, $task, $debug, $session_id, $contact_id, $first_name, $last_name, $username, $email, $password, $update_user)
		{
		$data=array(
				'session_id' => $session_id,
				'contact_id' => $contact_id,
				'first_name' => $first_name,
				'last_name' => $last_name,
				'username' => $username,
				'email' => $email,
				'password' => $password,
				'update_user' => $update_user,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Add a new contact.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param string $first_name
	* @param string $last_name
	* @param string $username
	* @param string $email
	* @param string $password
	* @return array 
	*/
	function add_contact($api_handler, $api_key, $mod, $task, $debug, $session_id, $first_name, $last_name, $username, $email, $password)
		{
		$data=array(
				'session_id' => $session_id,
				'first_name' => $first_name,
				'last_name' => $last_name,
				'username' => $username,
				'email' => $email,
				'password' => $password,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Get contact details.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $contact_id
	* @return array 
	*/
	function get_contact($api_handler, $api_key, $mod, $task, $debug, $session_id, $contact_id)
		{
		$data=array(
				'session_id' => $session_id,
				'contact_id' => $contact_id,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Change the logged in users password.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param string $current_password
	* @param string $new_password
	* @return array 
	*/
	function change_password($api_handler, $api_key, $mod, $task, $debug, $session_id, $current_password, $new_password)
		{
		$data=array(
				'session_id' => $session_id,
				'current_password' => $current_password,
				'new_password' => $new_password,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Change the logged in users security question.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param string $answer
	* @param string $question
	* @return array 
	*/
	function change_security_question($api_handler, $api_key, $mod, $task, $debug, $session_id, $answer, $question)
		{
		$data=array(
				'session_id' => $session_id,
				'answer' => $answer,
				'question' => $question,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Change the logged in users information.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param string $first_name
	* @param string $last_name
	* @param string $username
	* @param string $update_user
	* @param string $vat_number
	* @return array 
	*/
	function update_my_info($api_handler, $api_key, $mod, $task, $debug, $session_id, $first_name, $last_name, $username, $update_user, $vat_number='')
		{
		$data=array(
				'session_id' => $session_id,
				'first_name' => $first_name,
				'last_name' => $last_name,
				'username' => $username,
				'update_user' => $update_user,
				'vat_number' => $vat_number,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
/*
		if (isset($result['third_party']))
			{
			foreach ((array)$result['third_party'] as $key => $third_party)
				{
				set_cookies($third_party['set_cookie']);
				unset($result['third_party'][$key]['set_cookie']);
				}
			}

		return $result;
*/
		}

	/**
	* Build the my invoices page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @return array 
	*/
	function my_invoices($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the my package details page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $package_id
	* @param integer $category_id
	* @param integer $license_id
	* @param integer $max_rows
	* @param string $licensing_search
	* @param string $dl_list
	* @return array 
	*/
	function my_package_details($api_handler, $api_key, $mod, $task, $debug, $session_id, $package_id, $category_id, $license_id, $max_rows, $licensing_search, $dl_list)
		{
		$data=array(
				'session_id' => $session_id,
				'package_id' => $package_id,
				'category_id' => $category_id,
				'license_id' => $license_id,
				'max_rows' => $max_rows,
				'licensing_search' => $licensing_search,
				'dl_list' => $dl_list,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Reissue a license.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $license_id
	* @return array 
	*/
	function reissue_license($api_handler, $api_key, $mod, $task, $debug, $session_id, $license_id)
		{
		$data=array(
				'session_id' => $session_id,
				'license_id' => $license_id,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Suspend a license.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param integer $license_id
	* @param string $suspend_license
	* @return array 
	*/
	function suspend_license($api_handler, $api_key, $mod, $task, $debug, $session_id, $license_id, $suspend_license)
		{
		$data=array(
				'session_id' => $session_id,
				'license_id' => $license_id,
				'suspend_license' => $suspend_license,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the my packages page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @return array 
	*/
	function my_packages($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the my files page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @return array 
	*/
	function my_files($api_handler, $api_key, $mod, $task, $debug, $session_id)
		{
		$data=array('session_id' => $session_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}


	/**
	* Build the my files page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $session_id $session['session_id']
	* @param string $alias
	* @return array 
	*/
	function download_file_attachment($api_handler, $api_key, $mod, $task, $debug, $session_id, $alias)
		{
		$data=array('session_id' => $session_id, 'alias' => $alias);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the mass mail opt-out page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param integer $id
	* @return array 
	*/
	function opt_out($api_handler, $api_key, $mod, $task, $debug, $id)
		{
		$data=array('id' => $id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the public announcements page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function public_announcements($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Build the register page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function register($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Register a new user.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $email
	* @param string $first_name
	* @param string $last_name
	* @param string $username
	* @param string $password
	* @return array 
	*/
	function register_new_user($api_handler, $api_key, $mod, $task, $debug, $email, $first_name, $last_name, $username, $password)
		{
		$data=array(
				'email' => $email,
				'first_name' => $first_name,
				'last_name' => $last_name,
				'username' => $username,
				'password' => $password,
				);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}
	}
?>