<?php if (!defined('SAFE')) { die('invalid'); }

// query the API
$request=api_customer_area::public_announcements(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'public_announcements', 
		false // set to true for debug 
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf']; // pr($conf['site']);
$announcements=$request['announcements'];
unset($request);

$pagination=paging::compile($announcements, $conf['pages'], $conf['rows']); // pr($pagination);
if ($pagination)
	{
	$announcements=$pagination['data'];
	$pagination=$pagination['pagination'];
	}


$breadcrumb=' &raquo; '._w('announcements');


$link=href('public_announcements', array('rss' => 'y'));
$rss="<div id='rss'><a href=''><img src='templates/{$conf['template']}/images/icons/rss.gif' /></a> <a class='rss_link' href='{$link}'>RSS Feed</a></div>";

if (x('id'))
	{
	foreach((array)$announcements as $announcement)
		{
		if ($announcement['id']==x('id'))
			{
			$max=75;
			$title=strip_tags($announcement['title']);
			if (strlen($title)>$max) { $title=substr($title, 0, $max).' ...'; }

			$go_back=href('public_announcements');
			$breadcrumb=" &raquo; <a href='{$go_back}'>"._w('announcements')."</a> &raquo; {$title}";
			break;
			}
		}
	}

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare($data)
	{ 
	$buffer=array();

	// add the uid
	$buffer['id']=$data['id'];

	$title=$data['title'];
	$buffer['title_standalone']=$buffer['title_rss']=$title;
	$link=href('public_announcements', array('id' => $buffer['id']));
	$title="<a href='{$link}'>{$title}</a>";
	$buffer['title']=$title;

	$announcement_raw=strip_tags($data['announcement']);
	$announcement=strip_tags($data['announcement'], '<a>');

	$max=450;
	if (strlen($announcement_raw)>$max)
		{
		$paragraphs=explode("\n", $announcement);
		$announcement=$paragraphs[0].' ...';
		}

	$buffer['announcement']=$announcement;
	$buffer['announcement_full']=nl2br($data['announcement']);

	$buffer['status']=$data['status'];
	$buffer['created_rss']=date('D, d M Y 00:00:00', $data['created_rss']);
	$buffer['created']=date(config('date_format'), $data['created']);

	return $buffer;
	}