<?php if (!defined('SAFE')) { die('invalid'); }

// query the API
$request=api_customer_area::my_invoices(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'my_invoices', 
		false, // set to true for debug 
		$session['session_id']
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$due_invoices=$request['invoices']['due'];
$paid_invoices=$request['invoices']['paid'];

// sort pagination
$pagination=paging::compile($due_invoices, $conf['pages'], $conf['rows'], 'due'); // pr($pagination);
if ($pagination)
	{
	$due_invoices=$pagination['data'];
	$due_invoice_pagination=$pagination['pagination'];
	}

// sort pagination
$pagination=paging::compile($paid_invoices, $conf['pages'], $conf['rows'], 'paid'); // pr($pagination);
if ($pagination)
	{
	$paid_invoices=$pagination['data'];
	$paid_invoice_pagination=$pagination['pagination'];
	}

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare_invoices($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';


	// add the uid
	$buffer['invoice_id']=$data['invoice_id'];
	$buffer['total']=$data['total_display'];

	$buffer['created']=date(config('date_format'), $data['created']);
	$buffer['due_date']=date(config('date_format'), $data['due_date']);
	$buffer['status']=$data['status'];

	$link=href('invoice', array('id' => $data['token']));
	$buffer['view']="<a href='{$link}' target='_blank'>"._w('view_invoice').'</a>';

	$link=href('invoice', array('id' => $data['token'], 'download_pdf' => 'y'));
	$buffer['view_pdf']="<a href='{$link}' target='_blank'>"._w('Download PDF').'</a>';

	return $buffer;
	}

$breadcrumb=' &raquo; '._w('my_invoices');