<?PHP if (!defined('SAFE')) { die('invalid'); }

// query the API
$request=api_customer_area::register(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'register', 
		false // set to true for debug 
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$create_customer_account=($request['conf']['create_customer_account']=='Yes')?true:false;
$third_party=$request['third_party']; 
$recaptcha=$request['recaptcha'];
unset($request);

// reCAPTCHA integration!
if (!empty($recaptcha))
	{
	require_once('includes/classes/reCAPTCHA/recaptchalib.php');
	$publickey=$recaptcha['public_key'];
	}

$errors=array();
if ($_POST)
	{ 
	if ($create_customer_account&&!$_POST['business_name']) { $errors[]=_e('error_business_name'); }
	if (!$_POST['first_name']) { $errors[]=_e('error_first_name'); }
	if (!$_POST['last_name']) { $errors[]=_e('error_last_name'); }
	if (!$_POST['email']) { $errors[]=_e('error_email'); }
	if (!$_POST['username']) { $errors[]=_e('error_username'); }
	if (!$_POST['password']) { $errors[]=_e('error_password'); }
	if (!$_POST['verify_password']) { $errors[]=_e('error_verify_password'); }
	if ($_POST['password']&&$_POST['verify_password']&&$_POST['password']!=$_POST['verify_password']) { $errors[]=_e('error_passwords_do_not_match'); }

	if (!empty($recaptcha))
		{
		$privatekey = $recaptcha['private_key'];
		$resp = recaptcha_check_answer ($privatekey,
										$_SERVER["REMOTE_ADDR"],
										$_POST["recaptcha_challenge_field"],
										$_POST["recaptcha_response_field"]);

		if (!$resp->is_valid) { $errors[]=_e('error_recaptcha'); }
		}

	if (empty($errors))
		{
		$request=api_customer_area::register_new_user(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'register', 
				false, // set to true for debug 
				$_POST['email'],
				$_POST['first_name'],
				$_POST['last_name'],
				$_POST['username'],
				$_POST['password']
				); 

		// use it if you need it
		$third_party=$request['third_party'];

		if (!empty($request['errors']))
			{
			$errors=array_merge($errors, $request['errors']);
			}

		if (empty($errors))
			{
			$request=api_customer_area::login(
					$conf['api_handler'], 
					$conf['api_key'], 
					'customer_areas', 
					'login', 
					false, // set to true for debug 
					$_POST['email'],
					$_POST['password'],
					capture_remote()
					); 

			if (empty($request['errors']))
				{
				process_loginshare($third_party);

				$link=href('dashboard');
				set_cookie('customer_session', $request['session_id'], time()+2538000);
				die(header("Location: {$link}"));
				}
			else { $errors=$request['errors']; }
			}
		}
	}

$breadcrumb=' &raquo; '._e('register');
?>