<?PHP if (!defined('SAFE')) { die('invalid'); }


// query the API
$request=api_customer_area::my_packages(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'my_packages', 
		false, // set to true for debug 
		$session['session_id']
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$conf['rows']=(x('max_rows'))?x('max_rows'):$conf['rows'];
$packages=$request['packages'];
unset($request);

// sort pagination
$pagination=paging::compile($packages, $conf['pages'], $conf['rows'], 'packages'); // pr($pagination);
if ($pagination)
	{
	$packages=$pagination['data'];
	$pagination_package=$pagination['pagination'];
	}

/* My Packages *********************************************************************************/

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare_packages($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	$buffer['id']=$data['id'];
	$buffer['package_name']=$data['package_name'];
	$buffer['status']=$data['status'];

	$buffer['created']=(is_numeric($data['created']))?date(config('date_format'), $data['created']):'-';

	$href=array('package_id' => $data['id'], 'tab' => 'downloads');
	$link=href('my_package_details', $href);
	$buffer['downloads']="<a href='{$link}'>"._e('downloads').'</a>';

	$href=array('package_id' => $data['id'], 'tab' => 'licenses');
	$link=href('my_package_details', $href);
	$buffer['licenses']="<a href='{$link}'>"._e('licenses').'</a>';
	
	$href=array('package_id' => $data['id'], 'tab' => 'addon_packages');
	$link=href('my_package_details', $href);
	$buffer['addon_packages']="<a href='{$link}'>"._e('Addons').'</a>';

	$href=array('package_id' => $data['id'], 'tab' => 'support_packages');
	$link=href('my_package_details', $href);
	$buffer['support_packages']="<a href='{$link}'>"._e('support_packages').'</a>';

	$href=array('package_id' => $data['id'], 'tab' => 'package');
	$link=href('my_package_details', $href);
	$buffer['summary']="<a href='{$link}'>"._e('summary').'</a>';

	return $buffer;
	}

$breadcrumb=' &raquo; '._e('my_packages');
?>