<?PHP if (!defined('SAFE')) { die('invalid'); }

if (!x('package_id')) { die(header('Location: '.href('my_packages'))); }

// query the API
$errors=$data=array();
$request=api_customer_area::my_package_details(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'my_package_details', 
		false, // set to true for debug 
		$session['session_id'],
		x('package_id'),
		(x('category_id')?x('category_id'):0),
		(x('license_id')?x('license_id'):0),
		(x('max_rows')?x('max_rows'):0),
		(x('licensing_search')?x('licensing_search'):0)
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$conf['rows']=($request['max_rows'])?$request['max_rows']:$conf['rows'];
$licenses=$request['licenses']; // pr($licenses);
$license=$request['license']; // pr($license);
$downloads=$request['downloads'];
$categories=$request['categories'];
$media=$request['media']; //  pr($media);
$breadcrumb_media=$request['breadcrumb_media']; // pr($breadcrumb_media);
$download_packages=$request['download_packages'];
$support_packages=$request['support_packages'];
$addon_packages=$request['addon_packages'];
if ($request['package']['package_type']!='Addon' && $conf['site']['order_form_url']) 
	{
	$addon_purchase_link="{$conf['site']['order_form_url']}/".href('addon', array('parent_package_id' => x('package_id')));
	}
$download_expiration=$request['download_expiration'];
$enable_downloads=$request['enable_downloads']; // pr($enable_downloads);
$renewal_options=$request['renewal_options']; // pr($renewal_options);
$limit_downloads=$request['after_expiration']; 
$package=$request['package']; // pr($package);
$order=$package['order'];
$suspend_licenses=$request['suspend_licenses']; // pr($suspend_licenses);
if (!$package) { die(header('Location: '.href('my_packages'))); }
$hosting=$request['hosting']; // pr($hosting);
$domains=$request['domains']; // pr($hosting);
unset($request);

$pagination=paging::compile($licenses, $conf['pages'], $conf['rows'], 'licenses'); // pr($pagination);
if ($pagination)
	{
	$licenses=$pagination['data'];
	$pagination_license=$pagination['pagination'];
	}

$link=href('my_package_details', array('current_page'=>1, 'tab'=>x('tab'), 'package_id'=>x('package_id'), 'max_rows'=>5));
$clear_all_filters_licensing="<a href='{$link}'>"._e('clear_all_filters')."</a>";

/* Auto-complete search *********************************************************************************/

$licensing_ac_search=href('my_package_details', array('current_page'=>1, 'tab'=>'licenses', 'package_id'=>x('package_id'), 'licensing_ac_search'=>'y'));
if (x('licensing_ac_search'))
	{
	// search items
	echo "<ul>\n";

	$buffer='';
	foreach ($licenses as $match)
		{
		$link=href('my_package_details', array('package_id'=>x('package_id'), 'license_id'=>$match['id'], 'tab'=>'licenses'));
		$buffer.="<li><a href='{$link}'>{$match['license_key']}</a></li>";
		}

	echo ($buffer)?$buffer:'<li>'._e('no_matches_found...').'</li>';
	die('</ul>');
	}


/* Downloads *********************************************************************************/

// format a breadcrumb
$breadcrumb_media=($breadcrumb_media)?"<div id='downloads_breadcrumb'>{$breadcrumb_media}</div>":'';

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_download_categories($data)
	{ 
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$link=href('my_package_details', array('package_id' => x('package_id'), 'category_id' => $data['id'], 'tab' => 'downloads'));
	$icon="<img src='templates/".config('template')."/images/icons/{$data['icon']}' class='icon' />";
	$buffer['name']="{$icon} <a href='{$link}'>{$data['name']}</a>";

	$buffer['created']=date(config('date_format'), $data['created']);

	return $buffer;
	}

/**
* Process code for presentation
* 
* @param array $data
* @param integer $key
* @param string $order_form_url
* @return array
*/
function prepare_product($data, $order_form_url)
	{
	$buffer=array();
	$buffer['id']=$data['product']['id'];
	$buffer['link']="{$order_form_url}/".href('product', array('product_id'=> $data['product']['id'], 'package_id' => x('package_id')));
	$buffer['name']=$data['product']['name'];
	$buffer['long_description']=nl2br($data['product']['long_description']);
	$buffer['short_description']=nl2br($data['product']['short_description']);
	$buffer['icon']="<img src='templates/".config('template')."/images/icons/add.gif' class='icon' />";

	return $buffer;
	}

/**
* Process code for presentation
* 
* @param array $data
* @param boolean $enable_downloads
* @return array
*/
function prepare_downloads($data, $enable_downloads, $limit_downloads)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$icon="<img src='templates/".config('template')."/images/icons/shape_square_go.gif' class='icon' />";
	$buffer['name']="{$icon} ".($data['name']?$data['name']:$data['filename']);

	if ($enable_downloads||!$enable_downloads&&$limit_downloads&&$limit_downloads>$data['created'])
		{
		$link=href('download_secure', array('package_id' => x('package_id'), 'file_id' => $data['alias']));
		$buffer['name']="{$icon} <a href='{$link}'>".($data['name']?$data['name']:$data['filename'])."</a>";
		}

	$download_logs='';
	if (is_array($data['download_logs'])&&!empty($data['download_logs']))
		{
		foreach ($data['download_logs'] as $log)
			{
			if ($download_logs) { $download_logs.='<br />'; }
			$download_logs.=($download_log_count+=1).'. ';
			$download_logs.=("{$log['name']} - ".date(config('date_format').' '.config('time_format'), $log['created']));
			}
		}
	else { $download_logs=_e('no_download_logs_found'); }
	$buffer['download_logs']=$download_logs;
	$buffer['id']=uid('x');

	$buffer['created']=date(config('date_format'), $data['created']);

	return $buffer;
	}


/* Support Packages *********************************************************************************/

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_support_packages($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$buffer['name']=$data['name'];

	$buffer['term']=(strtolower($data['expires'])=='never')?_e('never'):"{$data['term_int']} {$data['term_str']}";

	$buffer['created']=date(config('date_format'), $data['created']);

	$buffer['expires']=_e('never');
	if (is_numeric($data['expires']))
		{
		$buffer['expires']=date(config('date_format'), $data['expires']);
		}

	return $buffer;
	}


/* My Download Packages *********************************************************************************/

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_download_packages($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$buffer['name']=$data['name'];

	$buffer['term']=(strtolower($data['expires'])=='never')?_e('never'):"{$data['term_int']} {$data['term_str']}";

	$buffer['package']=$data['package_name'];

	$buffer['created']=date(config('date_format'), $data['created']);

	$buffer['expires']=_e('never');
	if (strtolower($data['expires'])!='never'&&is_numeric($data['expires']))
		{
		$buffer['expires']=date(config('date_format'), $data['expires']);
		}

	return $buffer;
	}


/* My Licenses *********************************************************************************/


/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_licenses($data, $suspend_licenses)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$buffer['license_key']=$data['license_key'];
	$buffer['status']=$data['status'];
	if ($suspend_licenses=='Yes'||$data['licensing_type']['client_reissues']=='yes'&&strtolower($data['status'])=='active')
		{
		$buffer['status']=$data['status'].' '.license_status_links($data, $suspend_licenses);
		}

	$buffer['created']=date(config('date_format'), $data['created']);

	// the edit details page
	$link=href('my_package_details', array('license_id' => $data['id'], 'package_id' => x('package_id'), 'tab' => 'licenses'));
	$buffer['view']="<a href='{$link}'>"._e('view_licenses').'</a>';

	return $buffer;
	}

/**
* Licnese status changes
* 
* @param array $license
* @param string $suspend_licenses
* @param boolean $use_license_id
* @return array
*/
function license_status_links($license, $suspend_licenses, $use_license_id=true)
	{
	$license_reissues=$license_status_change='';
	if ($license['licensing_type']['client_reissues']=='yes'&&strtolower($license['status'])=='active')
		{
		$link=array('tab' => 'licenses', 'package_id' => x('package_id'), 'reissue_license' => 'y');
		if ($use_license_id) { $link['license_id']=$license['id']; }
		$link=href('my_package_details', $link);
		$license_status_change="<a href='{$link}'>"._e('reissue_license')."</a>";
		}

	if ($suspend_licenses=='Yes')
		{
		if ($license_status_change) { $license_status_change.=", "; }

		$suspend=((strtolower($license['status'])=='suspended')?'activate':'suspend');
		$link=array('tab' => 'licenses', 'package_id' => x('package_id'), 'suspend_license' => $suspend);
		if ($use_license_id) { $link['license_id']=$license['id']; }
		$link=href('my_package_details', $link);
		$license_status_change.="<a href='{$link}'>".((strtolower($license['status'])=='suspended')?_e('unsuspend_license'):_e('suspend_license'))."</a>";
		}
	return ($license_status_change)?" ( {$license_status_change} )":'';
	}

if ($_GET['tab']=='licenses'&&$_GET['reissue_license']=='y'&&strtolower($license['status'])=='active')
	{
	$request=api_customer_area::reissue_license(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'reissue_license', 
			false, // set to true for debug 
			$session['session_id'],
			$_GET['license_id']
			); 

	if (empty($request['errors']))
		{
		$errors[]=_e('license_reissued_successfully');
		$errors['success']='y';

		$license['status']='Reissued';
		unset($license_reissues);
		}
	else { $errors=$request['errors']; }
	}

if ($_GET['tab']=='licenses'&&$_GET['suspend_license'])
	{
	$request=api_customer_area::suspend_license(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'suspend_license', 
			false, // set to true for debug 
			$session['session_id'],
			$_GET['license_id'],
			$_GET['suspend_license']
			); 

	if (empty($request['errors']))
		{
		$errors[]=_e(($_GET['suspend_license']=='activate')?'license_activated_successfully':'license_suspended_successfully');
		$errors['success']='y';

		$license['status']=($_GET['suspend_license']=='activate')?'Active':'Suspended';
		unset($license_reissues);
		}
	else { $errors=$request['errors']; }
	}

// get the specific license
if ($license)
	{
	function do_show_details($instance, $valid_access_types)
		{
		foreach ((array)$valid_access_types as $type)
			{
			if (is_array($instance[$type])&&!empty($instance[$type]))
				{
				return true;
				}
			}

		return false;
		}

	$license_reissues=license_status_links($license, $suspend_licenses);

	$license_expires=(strtolower($license['expires'])=='never')?'Never':@date(config('date_format'), $license['expires']);

	/* Download a local key *********************************************************************************/

	if ($_GET['download_local_key']&&$license['local_key'])
		{
		header("Pragma: public");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Cache-Control: private", false);
		header("Content-Type: text/plain");
		header("Content-Disposition: attachment; filename=\"key.php\";");
		header("Content-Transfer-Encoding: quoted-printable");
		header("Content-Length: ".@filesize($license['local_key']));
		die($license['local_key']); 
		}

	$local_key_link=href('my_package_details', array('license_id' => x('license_id'), 'package_id' => x('package_id'), 'download_local_key' => 'y', 'tab' => 'licenses'));
	}

/* My Addon Packages *********************************************************************************/

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare_addon_packages($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	$buffer['id']=$data['id'];
	$buffer['package_name']=$data['package_name'];
	$buffer['status']=$data['status'];

	$buffer['created']=(is_numeric($data['created']))?date(config('date_format'), $data['created']):'-';

	$href=array('package_id' => $data['id'], 'tab' => 'downloads');
	$link=href('my_package_details', $href);
	$buffer['downloads']="<a href='{$link}'>"._e('downloads').'</a>';

	$href=array('package_id' => $data['id'], 'tab' => 'licenses');
	$link=href('my_package_details', $href);
	$buffer['licenses']="<a href='{$link}'>"._e('licenses').'</a>';

	$href=array('package_id' => $data['id'], 'tab' => 'support_packages');
	$link=href('my_package_details', $href);
	$buffer['support_packages']="<a href='{$link}'>"._e('support_packages').'</a>';

	$href=array('package_id' => $data['id'], 'tab' => 'package');
	$link=href('my_package_details', $href);
	$buffer['summary']="<a href='{$link}'>"._e('summary').'</a>';

	return $buffer;
	}


/* Web Hosting *********************************************************************************/

$account=array();
if ($account_id=x('account_id'))
	{
	foreach ($hosting as $k => $v) 
		{ 
		if ($v['id']==$account_id) 
			{ 
			$account=$v; 
			break; 
			} 
		}
	}

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_hosting($data)
	{
	$buffer=array();
	$buffer['id']=$data['id'];
	$buffer['domain']=$data['domain']['domain'];
	$buffer['plan']=$data['attr']['name'];
	$buffer['status']=$data['status'];
	$buffer['created']=date(config('date_format'), $data['created']);

	$href=array('package_id' => x('package_id'), 'account_id' => $data['id'], 'tab' => 'hosting');
	$link=href('my_package_details', $href);
	$buffer['summary']="<a href='{$link}'>"._e('summary').'</a>';

	return $buffer;
	}


/* Domains *********************************************************************************/

/**
* Process code for presentation
* 
* @param array $data
* @return array
*/
function prepare_domains($data)
	{
	$buffer=array();

	$buffer['id']=$data['id'];
	$buffer['domain']=$data['domain'];
	$buffer['years']=$data['years'];
	$buffer['last_renewal']=($data['last_renew'])?date(config('date_format'), $data['last_renew']):_e('Never');
	$buffer['next_renewal']=($data['next_renew'])?date(config('date_format'), $data['next_renew']):_e('Never');
	$buffer['created']=date(config('date_format'), $data['created']);

	return $buffer;
	}

/* Package Details *********************************************************************************/

$invoice_statuses=array('First Invoice' => _e('first_invoice'), 'Active' => _e('active'), 'Complete' => _e('completed'));

$breadcrumb=" &raquo; <a href='".href('my_packages')."'>"._e('my_packages')."</a> &raquo; {$package['package_name']}";
?>