<?PHP if (!defined('SAFE')) { die('invalid'); }

$errors=array();

// query the API
$request=api_customer_area::my_account(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'my_account', 
		false, // set to true for debug 
		$session['session_id']
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$security_questions=$conf['site']['security_questions'];
$company=$request['company']; // pr($company);
$contacts=$request['contacts']; //  pr($contacts);
$countries=$request['countries'];
$countries=$request['countries'];
$insert_js=$request['js_country_with_states_string'];
$states=$request['states'];
$addresses=$request['addresses'];
$enable_vat=$request['enable_vat'];
$vat_number_shop=$request['conf']['vat_number'];
$vat_label=$request['conf']['vat_label'];
$vat_base_country=$request['conf']['vat_base_country'];
unset($request);



/* Addresses *********************************************************************************/

$insert_js='';


// delete an addresss
if ($_GET['tab']=='addresses'&&$_GET['delete_address'])
	{
	$request=api_customer_area::delete_address(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'delete_address', 
			false, // set to true for debug 
			$session['session_id'],
			$_GET['delete_address']
			); 

	if (empty($request['errors']))
		{
		$errors[]=_e('address_deleted_successfully');
		$errors['success']='y';

		// pull in the new data
		$request=api_customer_area::my_account(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'my_account', 
				false, // set to true for debug 
				$session['session_id']
				); 

		$addresses=$request['addresses'];
		}
	else { $errors=$request['errors']; }
	}

if ($_POST['tab']=='addresses'&&$_POST['add_address'])
	{
	if (!$_POST['address']) { $errors[]=_e('error_address'); }
	if (!$_POST['city']) { $errors[]=_e('error_city'); }
	if ($_POST['sop']=='province'&&!$_POST['province']) { $errors[]=_e('error_province'); }
	if ($_POST['sop']=='state'&&!$_POST['state_id']) { $errors[]=_e('error_state'); }
	if (!$_POST['postal_code']) { $errors[]=_e('error_postal_code'); }

	if (empty($errors))
		{
		$request=api_customer_area::add_address(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'add_address', 
				false, // set to true for debug 
				$session['session_id'],
				$_POST['contact_type'],
				$_POST['business_name'],
				$_POST['address'],
				$_POST['city'],
				$_POST['country_id'],
				$_POST['state_id'],
				$_POST['province'],
				$_POST['postal_code'],
				$_POST['phone']
				); 

		if (empty($request['errors']))
			{
			$errors[]=_e('address_added_successfully');
			$errors['success']='y';
			unset($_POST['contact_type'], $_POST['business_name'], $_POST['address'], $_POST['city'], $_POST['country_id'], $_POST['state_id'], $_POST['province'], $_POST['postal_code'], $_POST['phone']);
			}
		else { $errors=$request['errors']; }
		}
	}

if ($_POST['tab']=='addresses'&&$_POST['save_address_changes'])
	{
	if (!$_POST['address']) { $errors[]=_e('error_address'); }
	if (!$_POST['city']) { $errors[]=_e('error_city'); }
	if ($_POST['sop']=='province'&&!$_POST['province']) { $errors[]=_e('error_province'); }
	if ($_POST['sop']=='state'&&!$_POST['state_id']) { $errors[]=_e('error_state'); }
	if (!$_POST['postal_code']) { $errors[]=_e('error_postal_code'); }

	if (empty($errors))
		{
		$request=api_customer_area::update_address(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'update_address', 
				false, // set to true for debug 
				$session['session_id'],
				$_POST['address_id'],
				$_POST['contact_type'],
				$_POST['business_name'],
				$_POST['address'],
				$_POST['city'],
				$_POST['country_id'],
				$_POST['state_id'],
				$_POST['province'],
				$_POST['postal_code'],
				$_POST['phone']
				); 

		if (empty($request['errors']))
			{
			$errors[]=_e('address_updated_successfully');
			$errors['success']='y';
			}
		else { $errors=$request['errors']; }
		}
	}

// sort pagination
$pagination=paging::compile($addresses, $conf['pages'], $conf['rows']); // pr($pagination);
if ($pagination)
	{
	$addresses=$pagination['data'];
	$address_pagination=$pagination['pagination'];
	}

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$buffer['id']=$data['id'];
	$buffer['contact_type']=ucwords($data['contact_type']);
	$buffer['address']=$data['address'];
	$buffer['city']=$data['city'];

	$link=href('my_account', array('id' => x('id'), 'address_id' => $data['id'], 'tab' => 'addresses'));
	$buffer['manage']="<a href='{$link}'>"._e('manage').'</a>';

	// the delete button and actions
	$js="javascript:prompt_decision('my_account', '&id=".x('id')."&tab=addresses&delete_address={$data['id']}', '"._e('sure_you_want_to_delete_address')."');";
	$buffer['delete']="<a href='#' onclick=\"{$js}\">"._e('delete').'</a>';

	return $buffer;
	}

if (x('address_id'))
	{
	foreach ($addresses as $unique)
		{
		if ($unique['id']==x('address_id'))
			{
			$address=$unique;
			break;
			}
		}
	}


/* Contacts *********************************************************************************/


// Delete a contact
if ($_GET['tab']=='contacts'&&$_GET['delete_contact'])
	{
	$request=api_customer_area::delete_contact(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'delete_contact', 
			false, // set to true for debug 
			$session['session_id'],
			$_GET['delete_contact']
			); 

	if (empty($request['errors']))
		{
		$errors[]=_e('contact_deleted_successfully');
		$errors['success']='y';

		// refresh the data
		$request=api_customer_area::my_account(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'my_account', 
				false, // set to true for debug 
				$session['session_id']
				); 

		$contacts=$request['contacts']; //  pr($contacts);
		}
	else { $errors=$request['errors']; }
	}

// sort pagination
$pagination=paging::compile($contacts, $conf['pages'], $conf['rows']); // pr($pagination);
if ($pagination)
	{
	$contacts=$pagination['data'];
	$contact_pagination=$pagination['pagination'];
	}

// edit a contact
if ($_POST['tab']=='contacts'&&$_POST['edit_contact']&&$_POST['contact_id'])
	{
	if (!$_POST['first_name']) { $errors[]=_e('error_first_name'); }
	if (!$_POST['last_name']) { $errors[]=_e('error_last_name'); }
	if (!$_POST['username']) { $errors[]=_e('error_username'); }

	if (empty($errors))
		{
		$request=api_customer_area::update_contact(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'update_contact', 
				false, // set to true for debug 
				$session['session_id'],
				$_POST['contact_id'],
				$_POST['first_name'],
				$_POST['last_name'],
				$_POST['username'],
				$_POST['email'],
				$_POST['password'],
				'y'
				); 

		// use it if you need it
		$third_party=$request['third_party'];

		if (empty($request['errors']))
			{
			$errors[]=_e('account_updated_successfully');
			$errors['success']='y';
			}
		else { $errors=$request['errors']; }
		}
	}

// Add a new contact
if ($_POST['tab']=='contacts'&&$_POST['add_contact'])
	{ 
	if (!$_POST['email']) { $errors[]=_e('error_email'); }
	if (!$_POST['first_name']) { $errors[]=_e('error_first_name'); }
	if (!$_POST['last_name']) { $errors[]=_e('error_last_name'); }
	if (!$_POST['username']) { $errors[]=_e('error_username'); }
	if (!$_POST['password']) { $errors[]=_e('error_password'); }

	if (empty($errors))
		{
		$request=api_customer_area::add_contact(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'add_contact', 
				false, // set to true for debug 
				$session['session_id'],
				$_POST['first_name'],
				$_POST['last_name'],
				$_POST['username'],
				$_POST['email'],
				$_POST['password']
				); 

		// use it if you need it
		$third_party=$request['third_party'];

		if (empty($request['errors']))
			{
			$errors[]=_e('contact_added_successfully');
			$errors['success']='y';
			unset($_POST['first_name'], $_POST['last_name'], $_POST['username'], $_POST['email'], $_POST['password']);
			}
		else { $errors=$request['errors']; }
		}
	}


// get the contact data to edit
if (x('tab')=='contacts'&&x('contact_id'))
	{
	$request=api_customer_area::get_contact(
			$conf['api_handler'], 
			$conf['api_key'], 
			'customer_areas', 
			'get_contact', 
			false, // set to true for debug 
			$session['session_id'],
			x('contact_id')
			); 

	if (!empty($request['errors']))
		{
		$errors=$request['errors'];
		unset($_POST['contact_id'], $_GET['contact_id']);
		}
	else {  $contact=$request['contact']; }
	}

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare_contacts($data)
	{ 
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$buffer['id']=$data['id'];
	$buffer['first_name']=$data['first_name'];
	$buffer['last_name']=$data['last_name'];
	$buffer['email']=$data['email'];
	$buffer['status']=ucfirst($data['status']);
	$buffer['status']=($primary_user_id==$data['id'])?"{$buffer['status']} ("._e('is_primary').")":$buffer['status'];

	$link=href('my_account', array('contact_id' => $data['id'], 'tab' => 'contacts', 'edit_contact' => 'y'));
	$buffer['manage']="<a href='{$link}'>"._e('manage').'</a>';

	// the delete button and actions
	$js="javascript:prompt_decision('my_account', '&tab=contacts&delete_contact={$data['id']}', '"._e('sure_you_want_to_delete_contact')."');";
	$buffer['delete']="<a href='#' onclick=\"{$js}\">"._e('delete').'</a>';

	return $buffer;
	}




/* Change Password, Security Question, Edit my Info *********************************************************************************/

// Change the users password
if ($_POST['tab']=='change_password'&&$_POST['change_password'])
	{ 
	if (!$_POST['current_password']) { $errors[]=_e('error_current_password'); }
	if (!$_POST['new_password']) { $errors[]=_e('error_new_password'); }
	if (!$_POST['verify_new_password']) { $errors[]=_e('error_verify_new_password'); }
	if ($_POST['new_password']&&$_POST['verify_new_password'])
		{
		if ($_POST['new_password']!=$_POST['verify_new_password'])
			{
			$errors[]=_e('error_passwords_do_not_match');
			}
		}

	if (empty($errors))
		{
		$request=api_customer_area::change_password(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'change_password', 
				false, // set to true for debug 
				$session['session_id'],
				$_POST['current_password'],
				$_POST['new_password']
				); 

		// use it if you need it
		$third_party=$request['third_party'];

		if (empty($request['errors']))
			{
			$errors[]=_e('password_updated_successfully');
			$errors['success']='y';
			}
		else { $errors=$request['errors']; }
		}
	}

// Change the security question
else if ($_POST['tab']=='security_question'&&$_POST['change_security_question'])
	{ 
	if (!$_POST['answer']) { $errors[]=_e('error_answer'); }

	if (empty($errors))
		{
		$request=api_customer_area::change_security_question(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'change_security_question', 
				false, // set to true for debug 
				$session['session_id'],
				$_POST['answer'],
				$_POST['question']
				); 

		if (empty($request['errors']))
			{
			$errors[]=_e('security_question_updated_successfully');
			$errors['success']='y';
			unset($_POST['question'], $_POST['answer']);
			}
		else { $errors=$request['errors']; }
		}
	}

// update the user information
else if ($_POST['tab']=='my_info'&&$_POST['update_my_info'])
	{ 
	if (!$_POST['first_name']) { $errors[]=_e('error_first_name'); }
	if (!$_POST['last_name']) { $errors[]=_e('error_last_name'); }
	//if (!$_POST['username']) { $errors[]=_e('error_username'); }

	if (empty($errors))
		{
		$request=api_customer_area::update_my_info(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'my_account', 
				false, // set to true for debug 
				$session['session_id'],
				$_POST['first_name'],
				$_POST['last_name'],
				false,
				'y',
				$_POST['vat_number']
				); 

		// use it if you need it
		$third_party=$request['third_party'];

		if (empty($request['errors']))
			{
			$errors[]=_e('account_updated_successfully');
			$errors['success']='y';

			// Refresh the session
			$request=api_customer_area::process_session(
					$conf['api_handler'], 
					$conf['api_key'], 
					'customer_areas', 
					'process_session', 
					false, // set to true for debug 
					$_COOKIE['customer_session']
					); 

			$session=$request['session'];
			}
		else { $errors=$request['errors']; }
		}
	}


/* General *********************************************************************************/

$breadcrumb=' &raquo; '._e('my_account');
?>