<?PHP if (!defined('SAFE')) { die('invalid'); }


// query the API
$request=api_customer_area::downloads(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'downloads', 
		false, // set to true for debug 
		(x('category_id')?x('category_id'):0)
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$categories=array();
foreach ($request['categories'] as $key => $val) 
	{
	if ($val['status']!='Private') 
		{
		$categories[$key]=$val;
		}
	}

$media=$request['media']; //  pr($media);
$breadcrumb_media=$request['breadcrumb_media']; // pr($breadcrumb_media);
unset($request);

// format a breadcrumb
$breadcrumb_media=($breadcrumb_media)?"<div id='downloads_breadcrumb'>{$breadcrumb_media}</div>":'';

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare_download_categories($data)
	{ 
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$link=href('downloads', array('category_id' => $data['id']));
	$icon="<img src='templates/".config('template')."/images/icons/{$data['icon']}' class='icon' />";
	$buffer['name']="{$icon} <a href='{$link}'>{$data['name']}</a>";

	$buffer['description']=$data['description'];

	$buffer['created']=date(config('date_format'), $data['created']);

	return $buffer;
	}

/**
* Process code for presentation
* 
* @param array $record
* @return array
*/
function prepare_downloads($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	// add the uid
	$icon="<img src='templates/".config('template')."/images/icons/shape_square_go.gif' class='icon' />";
	$link=href('download', array('file_id' => $data['alias']));
	$buffer['name']="{$icon} <a href='{$link}'>".($data['name']?$data['name']:$data['filename'])."</a>";

	$buffer['created']=date(config('date_format'), $data['created']);

	return $buffer;
	}

$breadcrumb=' &raquo; '._e('public_downloads');
?>