<?PHP if (!defined('SAFE')) { die('invalid'); }

// query the API
$request=api_customer_area::contact(
		$conf['api_handler'], 
		$conf['api_key'], 
		'customer_areas', 
		'contact', 
		false // set to true for debug 
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
$department=$request['department'];
$recaptcha=$request['recaptcha'];
unset($requst);

// reCAPTCHA integration!
if (!empty($recaptcha))
	{
	require_once('includes/classes/reCAPTCHA/recaptchalib.php');
	$publickey=$recaptcha['public_key'];
	}

$errors=array();
if ($_POST)
	{
	if (!$_POST['first_name']) { $errors[]=_e('error_first_name'); }
	if (!$_POST['last_name']) { $errors[]=_e('error_last_name'); }
	if (!$_POST['email']) { $errors[]=_e('error_email'); }
	if (!$_POST['subject']) { $errors[]=_e('error_subject'); }
	if (!$_POST['message']) { $errors[]=_e('error_message'); }

	if (!empty($recaptcha))
		{
		$privatekey = $recaptcha['private_key'];
		$resp = recaptcha_check_answer ($privatekey,
										$_SERVER["REMOTE_ADDR"],
										$_POST["recaptcha_challenge_field"],
										$_POST["recaptcha_response_field"]);

		if (!$resp->is_valid) { $errors[]=_e('error_recaptcha'); }
		}

	if (empty($errors))
		{ 
		$request=api_customer_area::contact_form_send(
				$conf['api_handler'], 
				$conf['api_key'], 
				'customer_areas', 
				'contact_form_send', 
				false, // set to true for debug 
				$_POST['first_name'],
				$_POST['last_name'],
				$_POST['email'],
				$_POST['subject'],
				$_POST['message']
				);

		if (empty($request['errors']))
			{
			$errors[]=_e('message_mailed_successfully');
			$errors['success']='y';
			unset(
				$_POST['first_name'], 
				$_POST['last_name'], 
				$_POST['email'], 
				$_POST['subject'], 
				$_POST['message']
				);
			}
		else { $errors=$request['errors']; }
		}
	}

$breadcrumb=' &raquo; '._e('contact_us');
?>