// -----------------------------------------------------------------------------------
//
//  Lightbox-for-JetPhoto v1.0
//
//	Lightbox-Compatible Library for JetPhoto web galleries
//
//	http://www.jetphotosoft.com
//	Licensed under the Creative Commons Attribution 2.5 License - http://creativecommons.org/licenses/by/2.5/
//
//  by JetPhoto software team - Zhuwei Cao, Robin Zhang
//  based on Lightbox v2.0.2 
//
// -----------------------------------------------------------------------------------
//
//	Lightbox v2.02
//	by Lokesh Dhakar - http://www.huddletogether.com
//	3/31/06
//
//	For more information on this script, visit:
//	http://huddletogether.com/projects/lightbox2/
//
//	Licensed under the Creative Commons Attribution 2.5 License - http://creativecommons.org/licenses/by/2.5/
//	
//	Credit also due to those who have helped, inspired, and made their code available to the public.
//	Including: Scott Upton(uptonic.com), Peter-Paul Koch(quirksmode.org), Thomas Fuchs(mir.aculo.us), and others.
//
//
// -----------------------------------------------------------------------------------
/*

	Table of Contents
	-----------------
	Configuration
	Global Variables

	Extending Built-in Objects	
	- Object.extend(Element)
	- Array.prototype.removeDuplicates()
	- Array.prototype.empty()

	Lightbox Class Declaration
	- initialize()
	- start()
	- changeImage()
	- resizeImageContainer()
	- showImage()
    - showVideo()
    - showPanorama()
    - updateDetails()
	- updateNav()
	- enableKeyboardNav()
	- disableKeyboardNav()
	- keyboardAction()
	- preloadNeighborImages()
	- end()
	
	Miscellaneous Functions
	- getPageScroll()
	- getPageSize()
	- getKey()
	- listenKey()
	- showSelectBoxes()
	- hideSelectBoxes()
	- pause()
	- initLightbox()
	
	Function Calls
	- addLoadEvent(initLightbox)
	
*/
// -----------------------------------------------------------------------------------

//
//	Configuration
//
var fileLoadingImage = "images/featured/icons/loading.gif";		
var fileBottomNavCloseImage = "images/featured/icons/closelabel.gif";
var resizeSpeed = 7;	// controls the speed of the image resizing (1=slowest and 10=fastest)

var borderSize = 10;	//if you adjust the padding in the CSS, you will need to update this variable

// -----------------------------------------------------------------------------------

//
//	Global Variables
//

/*** code added for jetphoto ***/

var isIE = (navigator.appVersion.indexOf("MSIE") != -1) ? true : false;
var isWin = (navigator.appVersion.toLowerCase().indexOf("win") != -1) ? true : false;
var isOpera = (navigator.userAgent.indexOf("Opera") != -1) ? true : false;
var isAppleIOS = (navigator.userAgent.indexOf("iPad") != -1 || navigator.userAgent.indexOf("iPhone") != -1 || navigator.userAgent.indexOf("iPod") != -1) ? true : false;

/****** end of code added ******/

var imageArray = new Array;
var activeImage;

var TYPE_IMAGE = 1;
var TYPE_PANORAMA = 2;
var TYPE_VIDEO = 3;

var activeType = TYPE_IMAGE;

var videoNavTimerId = null;

var lastX = 0;

if(resizeSpeed > 10){ resizeSpeed = 10;}
if(resizeSpeed < 1){ resizeSpeed = 1;}
resizeDuration = (11 - resizeSpeed) * 0.15;

// -----------------------------------------------------------------------------------

//
//	Additional methods for Element added by SU, Couloir
//	- further additions by Lokesh Dhakar (huddletogether.com)
//
Object.extend(Element, {
	getWidth: function(element) {
	   	element = $(element);
	   	return element.offsetWidth; 
	},
	setWidth: function(element,w) {
	   	element = $(element);
    	element.style.width = w +"px";
	},
	setHeight: function(element,h) {
   		element = $(element);
    	element.style.height = h +"px";
	},
	setTop: function(element,t) {
	   	element = $(element);
    	element.style.top = t +"px";
	},
	setSrc: function(element,src) {
    	element = $(element);
    	element.src = src; 
	},
	setHref: function(element,href) {
    	element = $(element);
    	element.href = href; 
	},
	setInnerHTML: function(element,content) {
		element = $(element);
		element.innerHTML = content;
	}
});

// -----------------------------------------------------------------------------------

//
//	Extending built-in Array object
//	- array.removeDuplicates()
//	- array.empty()
//
Array.prototype.removeDuplicates = function () {
	for(i = 1; i < this.length; i++){
		if(this[i][0] == this[i-1][0]){
			this.splice(i,1);
		}
	}
}

// -----------------------------------------------------------------------------------

Array.prototype.empty = function () {
	for(i = 0; i <= this.length; i++){
		this.shift();
	}
}

// -----------------------------------------------------------------------------------

//
//	Lightbox Class Declaration
//	- initialize()
//	- start()
//	- changeImage()
//	- resizeImageContainer()
//	- showImage()
//	- updateDetails()
//	- updateNav()
//	- enableKeyboardNav()
//	- disableKeyboardNav()
//	- keyboardNavAction()
//	- preloadNeighborImages()
//	- end()
//
//	Structuring of code inspired by Scott Upton (http://www.uptonic.com/)
//
var Lightbox = Class.create();

Lightbox.prototype = {
	
	// initialize()
	// Constructor runs on completion of the DOM loading. Loops through anchor tags looking for 
	// 'lightbox' references and applies onclick events to appropriate links. The 2nd section of
	// the function inserts html at the bottom of the page which is used to display the shadow 
	// overlay and the image container.
	//
	initialize: function() {
        
		if (!document.getElementsByTagName){ return; }
		var anchors = document.getElementsByTagName('a');

		// loop through all anchor tags
		for (var i=0; i<anchors.length; i++){
			var anchor = anchors[i];
			
			var relAttribute = String(anchor.getAttribute('rel'));
			
			// use the string.match() method to catch 'lightbox' references in the rel attribute
			if (anchor.getAttribute('href') && (relAttribute.toLowerCase().match('lightbox'))){
				anchor.onclick = function () {myLightbox.start(this); return false;}
			}
		}

		// The rest of this code inserts html at the bottom of the page that looks similar to this:
		//
		//	<div id="overlay"></div>
		//	<div id="lightbox">
		//		<div id="outerImageContainer">
		//			<div id="imageContainer">
		//				<img id="lightboxImage">
        /*** code added for jetphoto ***/
        //				<div id="lightboxVideo"></div>
		//				<div style="" id="hoverNavPrev"><img id="hoverNavPrevImage" src="../../featured_gallery/js/images/prevlabel.gif"></div>
		//				<div style="" id="hoverNavNext"><img id="hoverNavNextImage" src="../../featured_gallery/js/images/nextlabel.gif"></div>
        //				<div id="lightboxPanorama"><image id="panoramaImage"></div>
		/****** end of code added ******/
		//				<div style="" id="hoverNav">
		//					<a href="#" id="prevLink"></a>
		//					<a href="#" id="nextLink"></a>
		//				</div>
		//				<div id="loading">
		//					<a href="#" id="loadingLink">
		//						<img src="../../featured_gallery/js/images/loading.gif">
		//					</a>
		//				</div>
		//			</div>
		//		</div>
		//		<div id="imageDataContainer">
		//			<div id="imageData">
		//				<div id="imageDetails">
		//					<span id="caption"></span>
		//					<span id="numberDisplay"></span>
		//				</div>
		//				<div id="bottomNav">
		//					<a href="#" id="bottomNavClose">
		//						<img src="../../featured_gallery/js/images/close.gif">
		//					</a>
		//				</div>
		//			</div>
		//		</div>
		//	</div>


		var objBody = document.getElementsByTagName("body").item(0);
		
		var objOverlay = document.createElement("div");
		objOverlay.setAttribute('id','overlay');
		objOverlay.style.display = 'none';
		objOverlay.onclick = function() { myLightbox.end(); return false; }
		objBody.appendChild(objOverlay);
		
		var objLightbox = document.createElement("div");
		objLightbox.setAttribute('id','lightbox');
		objLightbox.style.display = 'none';
		objBody.appendChild(objLightbox);
	
		var objOuterImageContainer = document.createElement("div");
		objOuterImageContainer.setAttribute('id','outerImageContainer');
		objLightbox.appendChild(objOuterImageContainer);

		var objImageContainer = document.createElement("div");
		objImageContainer.setAttribute('id','imageContainer');
		objOuterImageContainer.appendChild(objImageContainer);
	
		
		var objLightboxImage = document.createElement("img");
		objLightboxImage.setAttribute('id','lightboxImage');
		objImageContainer.appendChild(objLightboxImage);
        
        /*** code added for jetphoto ***/
        var objLightboxPanorama = document.createElement("div");
		objLightboxPanorama.setAttribute('id','lightboxPanorama');
		objImageContainer.appendChild(objLightboxPanorama);
		
		var objPanoramaImage = document.createElement("img");
		objPanoramaImage.setAttribute('id','panoramaImage');
		objLightboxPanorama.appendChild(objPanoramaImage);
		
		
		var objHoverNavPrev = document.createElement("div");
		objHoverNavPrev.setAttribute('id','hoverNavPrev');
		objImageContainer.appendChild(objHoverNavPrev);
		objHoverNavPrev.onclick = function() { myLightbox.changeImage(activeImage - 1); return false; }
		
		var objHoverNavPrevImage = document.createElement("img");
		objHoverNavPrevImage.setAttribute('id','hoverNavPrevImage');
		objHoverNavPrevImage.setAttribute('src','images/featured/icons/prevlabel.gif');
		objHoverNavPrev.appendChild(objHoverNavPrevImage);
		
		var objHoverNavNext = document.createElement("div");
		objHoverNavNext.setAttribute('id','hoverNavNext');
		objImageContainer.appendChild(objHoverNavNext);
		objHoverNavNext.onclick = function() { myLightbox.changeImage(activeImage + 1); return false; }
		
		var objHoverNavNextImage = document.createElement("img");
		objHoverNavNextImage.setAttribute('id','hoverNavNextImage');
		objHoverNavNextImage.setAttribute('src','images/featured/icons/nextlabel.gif');
		objHoverNavNext.appendChild(objHoverNavNextImage);
		
		
		var objLightboxVideo = document.createElement("div");
		objLightboxVideo.setAttribute('id','lightboxVideo');
		objImageContainer.appendChild(objLightboxVideo);
        
        /****** end of code added ******/
        
		var objHoverNav = document.createElement("div");
		objHoverNav.setAttribute('id','hoverNav');
		objImageContainer.appendChild(objHoverNav);
	
		var objPrevLink = document.createElement("a");
		objPrevLink.setAttribute('id','prevLink');
		objPrevLink.setAttribute('href','#');
		objHoverNav.appendChild(objPrevLink);
		
		var objNextLink = document.createElement("a");
		objNextLink.setAttribute('id','nextLink');
		objNextLink.setAttribute('href','#');
		objHoverNav.appendChild(objNextLink);
	
		var objLoading = document.createElement("div");
		objLoading.setAttribute('id','loading');
		objImageContainer.appendChild(objLoading);
	
		var objLoadingLink = document.createElement("a");
		objLoadingLink.setAttribute('id','loadingLink');
		objLoadingLink.setAttribute('href','#');
		objLoadingLink.onclick = function() { myLightbox.end(); return false; }
		objLoading.appendChild(objLoadingLink);
	
		var objLoadingImage = document.createElement("img");
		objLoadingImage.setAttribute('src', fileLoadingImage);
		objLoadingLink.appendChild(objLoadingImage);

		var objImageDataContainer = document.createElement("div");
		objImageDataContainer.setAttribute('id','imageDataContainer');
		objImageDataContainer.className = 'clearfix';
		objLightbox.appendChild(objImageDataContainer);

		var objImageData = document.createElement("div");
		objImageData.setAttribute('id','imageData');
		objImageDataContainer.appendChild(objImageData);
	
		var objImageDetails = document.createElement("div");
		objImageDetails.setAttribute('id','imageDetails');
		objImageData.appendChild(objImageDetails);
	
		var objCaption = document.createElement("span");
		objCaption.setAttribute('id','caption');
		objImageDetails.appendChild(objCaption);
	
		var objNumberDisplay = document.createElement("span");
		objNumberDisplay.setAttribute('id','numberDisplay');
		objImageDetails.appendChild(objNumberDisplay);
		
		var objBottomNav = document.createElement("div");
		objBottomNav.setAttribute('id','bottomNav');
		objImageData.appendChild(objBottomNav);
	
		var objBottomNavCloseLink = document.createElement("a");
		objBottomNavCloseLink.setAttribute('id','bottomNavClose');
		objBottomNavCloseLink.setAttribute('href','#');
		objBottomNavCloseLink.onclick = function() { myLightbox.end(); return false; }
		objBottomNav.appendChild(objBottomNavCloseLink);
	
		var objBottomNavCloseImage = document.createElement("img");
		objBottomNavCloseImage.setAttribute('src', fileBottomNavCloseImage);
		objBottomNavCloseLink.appendChild(objBottomNavCloseImage);
	},
	
	//
	//	start()
	//	Display overlay and lightbox. If image is part of a set, add siblings to imageArray.
	//
	start: function(imageLink) {
        
        hideSelectBoxes();

		// stretch overlay to fill page and fade in
		var arrayPageSize = getPageSize();
		Element.setHeight('overlay', arrayPageSize[1]);
		new Effect.Appear('overlay', { duration: 0.2, from: 0.0, to: 0.8 });

		imageArray = [];
		imageNum = 0;		

		if (!document.getElementsByTagName){ return; }
		var anchors = document.getElementsByTagName('a');
    
		// if image is NOT part of a set..
		if((imageLink.getAttribute('rel') == 'lightbox')){
			// add single image to imageArray
            //imageArray.push(new Array(imageLink.getAttribute('href'),imageLink.getAttribute('title'));
            /*** code added for jetphoto ***/
			imageArray.push(new Array(imageLink.getAttribute('href'),imageLink.getAttribute('title'),imageLink.getAttribute('panorama'),imageLink.getAttribute('video'),imageLink.getAttribute('infourl')));
            /****** end of code added ******/			
		} else {
		// if image is part of a set..

			// loop through anchors, find other images in set, and add them to imageArray
			for (var i=0; i<anchors.length; i++){
				var anchor = anchors[i];
				if (anchor.getAttribute('href') && (anchor.getAttribute('rel') == imageLink.getAttribute('rel'))){
                    //imageArray.push(new Array(anchor.getAttribute('href'),anchor.getAttribute('title'))
                    /*** code added for jetphoto ***/
					imageArray.push(new Array(anchor.getAttribute('href'),anchor.getAttribute('title'),anchor.getAttribute('panorama'),anchor.getAttribute('video'),anchor.getAttribute('infourl')));
                    /****** end of code added ******/
				}
			}
			imageArray.removeDuplicates();
			while(imageArray[imageNum][0] != imageLink.getAttribute('href')) { imageNum++;}
		}

		// calculate top offset for the lightbox and display 
		var arrayPageSize = getPageSize();
		var arrayPageScroll = getPageScroll();
		var lightboxTop = arrayPageScroll[1] + (arrayPageSize[3] / 15);

		Element.setTop('lightbox', lightboxTop);
		Element.show('lightbox');
		
		this.changeImage(imageNum);
        
	},

	//
	//	changeImage()
	//	Hide most elements and preload image in preparation for resizing image container.
	//
	changeImage: function(imageNum) {	
		/*** code added for jetphoto ***/
		this.removeVideoContent();
		/****** end of code added ******/	
		activeImage = imageNum;	// update global var
        
		// hide elements during transition
		Element.show('loading');
		Element.hide('lightboxImage');
		Element.hide('hoverNav');
		Element.hide('prevLink');
		Element.hide('nextLink');
		Element.hide('imageDataContainer');
		Element.hide('numberDisplay');	
		Element.hide('lightboxVideo');
		Element.hide('hoverNavPrev');
		Element.hide('hoverNavNext');
		
        Element.hide('lightboxPanorama');
		
		imgPreloader = new Image();
		
        // once image is preloaded, resize image container
		imgPreloader.onload=function(){
			/*** code added for jetphoto ***/
			activeType = TYPE_IMAGE;
			if(imageArray[activeImage][2] && imageArray[activeImage][2] == 1) {
				activeType = TYPE_PANORAMA;
				var pWidth = imgPreloader.width;
				var pHeight =  imgPreloader.height;
				if(imgPreloader.width >= document.body.clientWidth - 100) {
					pWidth = document.body.clientWidth - 100;
				}
				Element.setSrc('panoramaImage', imageArray[activeImage][0]);
				Element.setWidth('lightboxPanorama',pWidth);
				Element.setHeight('lightboxPanorama',pHeight);
				$("panoramaImage").style.marginLeft = "0px"; 
				myLightbox.resizeImageContainer(pWidth,pHeight);
			} else if(imageArray[activeImage][3]){
				activeType = TYPE_VIDEO;
				myLightbox.createVideoContent(imageArray[activeImage][0], imageArray[activeImage][3],imgPreloader.width, imgPreloader.height);
				myLightbox.resizeImageContainer(imgPreloader.width, imgPreloader.height);
			} else {
				
				Element.setSrc('lightboxImage', imageArray[activeImage][0]);
				myLightbox.resizeImageContainer(imgPreloader.width, imgPreloader.height);
			
			//	myLightbox.resizeImageContainer(imgPreloader.width, imgPreloader.height);
			}
				
			/****** end of code added ******/
	
	
		}
		imgPreloader.src = imageArray[activeImage][0];
	},

	//
	//	resizeImageContainer()
	//
	resizeImageContainer: function( imgWidth, imgHeight) {

		// get current height and width
		this.wCur = Element.getWidth('outerImageContainer');
		this.hCur = Element.getHeight('outerImageContainer');
		
		// scalars based on change from old to new
		this.xScale = ((imgWidth  + (borderSize * 2)) / this.wCur) * 100;
		this.yScale = ((imgHeight  + (borderSize * 2)) / this.hCur) * 100;

		// calculate size difference between new and old image, and resize if necessary
		wDiff = (this.wCur - borderSize * 2) - imgWidth;
		hDiff = (this.hCur - borderSize * 2) - imgHeight;
		
		if(!( hDiff == 0)){ new Effect.Scale('outerImageContainer', this.yScale, {scaleX: false, duration: resizeDuration, queue: 'front'}); }
		if(!( wDiff == 0)){ new Effect.Scale('outerImageContainer', this.xScale, {scaleY: false, delay: resizeDuration, duration: resizeDuration}); }

		// if new and old image are same size and no scaling transition is necessary, 
		// do a quick pause to prevent image flicker.
		if((hDiff == 0) && (wDiff == 0)){
			if (navigator.appVersion.indexOf("MSIE")!=-1){ pause(250); } else { pause(100);} 
		}

		Element.setHeight('prevLink', imgHeight);
		Element.setHeight('nextLink', imgHeight);
		Element.setWidth( 'imageDataContainer', imgWidth + (borderSize * 2));

	//	this.showImage();
        /*** code added for jetphoto ***/
		
        switch(activeType) {
            case TYPE_IMAGE:
                this.showImage();
                break;
            case TYPE_PANORAMA:
	//			Element.setWidth('lightboxPanorama',wDiff);
	//			Element.setHeight('lightboxPanorama',hDiff);
                this.showPanorama();
                break;
            case TYPE_VIDEO:
                this.showVideo();
                break;
        }
        /****** end of code added ******/
    
	},
	
	//
	//	showImage()
	//	Display image and begin preloading neighbors.
	//
	showImage: function(){
        /*** code added for jetphoto ***/
        Element.hide('lightboxVideo');
        Element.hide('lightboxPanorama');
        /****** end of code added ******/
		Element.hide('loading');
		new Effect.Appear('lightboxImage', { duration: 0.5, queue: 'end', afterFinish: function(){	myLightbox.updateDetails(); } });
		this.preloadNeighborImages();
	},
    
    /*** code added for jetphoto ***/
    showVideo:  function() {
        Element.hide('loading');
        Element.hide('lightboxImage');
        Element.hide('lightboxPanorama');
        new Effect.Appear('lightboxVideo', { duration: 0.5, queue: 'end', afterFinish: function(){	myLightbox.updateDetails(); } });
        this.preloadNeighborImages();
		
	
    },
    showPanorama: function() {
        Element.hide('loading');
        Element.hide('lightboxImage');
        Element.hide('lightboxVideo');
        new Effect.Appear('lightboxPanorama', { duration: 0.5, queue: 'end', afterFinish: function(){	myLightbox.updateDetails(); } });
        this.preloadNeighborImages();	
    },
    
    createVideoContent: function(strImage, strVideo, width, height) {
        
		var jvplayer = document.getElementById("lightboxVideo");
//		jvplayer.style.width = width+"px";
//		jvplayer.style.height = height+"px";
				
		var jvplayerHTML = "";
		if (isAppleIOS) {
			
			// HTML5 video player for iOS
			jvplayerHTML =	
				"<video src='"+strVideo+"' poster='"+strImage+"' width='"+width+"' height='"+height+"' controls></video>";
			
		} else if (isIE && isWin && !isOpera) {
		
			// Flash video player (object)
			jvplayerHTML =  
				"<object classid='clsid:d27cdb6e-ae6d-11cf-96b8-444553540000' codebase='http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0' width='"+width+"' height='"+height+"' id='jvplayer' align='middle'>" +
				"<param name='allowScriptAccess' value='sameDomain' />" +
				"<param name='allowFullScreen' value='true' />" +
				"<param name='wmode' value='opaque' />" +
				"<param name='movie' value='../../featured_gallery/js/jvplayer.swf?thumbnail="+strImage+"&video="+strVideo+"' />" +
				"<param name='quality' value='high' />" +
				"<param name='bgcolor' value='#000000' />" +
				"</object>";
		
		} else {
		
			// Flash video player (embed)
			jvplayerHTML =  
				"<embed src='../../featured_gallery/js/jvplayer.swf?thumbnail="+strImage+"&video="+strVideo+"' quality='high' bgcolor='#000000'  wmode='transparent' width='"+width+"' height='"+height+"' name='jvplayer' align='middle' allowScriptAccess='sameDomain' allowFullScreen='true' type='application/x-shockwave-flash' pluginspage='http://www.macromedia.com/go/getflashplayer' />";
		}
		
		var jvplayer_ = document.createElement("div");
		jvplayer_.setAttribute("id","div_jvplayer_");
		jvplayer_.innerHTML = jvplayerHTML;
		jvplayer.appendChild(jvplayer_);
    },
    
    removeVideoContent: function() {
		
		 Element.hide('lightboxVideo');
		var jvplayer = document.getElementById("lightboxVideo");
		while ( jvplayer.hasChildNodes()) jvplayer.removeChild(jvplayer.lastChild);
    },   
    
    /****** end of code added ******/
					
    
	//
	//	updateDetails()
	//	Display caption, image number, and bottom nav.
	//
	updateDetails: function() {

        var strCaption = imageArray[activeImage][1];
        var infoURL = "";
        if(imageArray[activeImage][4]) {
            infoURL = "<a href='"+imageArray[activeImage][4]+"' target='_blank'><img src='images/featured/icons/visitarrow.gif' alt='Visit Pop-up' id='infoArrow'/></a> ";
        }
		Element.show('caption');
		Element.setInnerHTML( 'caption', infoURL && strCaption ? infoURL + '<br/><br/>' +strCaption : infoURL + strCaption);
		
		// if image is part of set display 'Image x of x' 
		if(imageArray.length > 1){
			Element.show('numberDisplay');
			
			var strType = "Pop-up ";
			switch(activeType) {
				case TYPE_IMAGE:
					strType = "Pop-up ";;
					break;
				case TYPE_PANORAMA:
					strType = "Panorama ";
					break;
				case TYPE_VIDEO:
					strType = "Video ";
					break;
			}
			
			
			Element.setInnerHTML( 'numberDisplay', (infoURL ? '' : strType + eval(activeImage + 1) + " of " + imageArray.length));
		}

		new Effect.Parallel(
			[ new Effect.SlideDown( 'imageDataContainer', { sync: true, duration: resizeDuration + 0.25, from: 0.0, to: 1.0 }), 
			  new Effect.Appear('imageDataContainer', { sync: true, duration: 1.0 }) ], 
			{ duration: 0.65, afterFinish: function() { myLightbox.updateNav();} } 
		);
	},

	//
	//	updateNav()
	//	Display appropriate previous and next hover navigation.
	//
	updateNav: function() {
		
		/*** code updated for jetphoto ***/
		
		Element.hide('hoverNavPrev');
		Element.hide('hoverNavNext');
		Element.hide('hoverNav');	
		document.onmousemove = null;
		if(isAppleIOS) {
			document.ontouchmove = null;
			document.ontouchstart = null;
			document.ontouchend = null;
		}
		if(activeType == TYPE_IMAGE || activeType == TYPE_PANORAMA) {
			if(!isAppleIOS || activeType != TYPE_PANORAMA) {
				Element.show('hoverNav');	
				// if not first image in set, display prev image button
				if(activeImage != 0){
					Element.show('prevLink');
					document.getElementById('prevLink').onclick = function() {
						myLightbox.changeImage(activeImage - 1); return false;
					}
				}
		
				// if not last image in set, display next image button
				if(activeImage != (imageArray.length - 1)){
					Element.show('nextLink');
					document.getElementById('nextLink').onclick = function() {
						myLightbox.changeImage(activeImage + 1); return false;
					}
				}
			}
			
			if( activeType == TYPE_PANORAMA) {
				
				var lightboxPanorama = document.getElementById("lightboxPanorama");
				var panoramaImage = document.getElementById("panoramaImage");
								
				if(!isAppleIOS) {
					document.onmousemove = function(e) {

						e = e || window.event;
						
						var act_width = lightboxPanorama.clientWidth;//document.body.clientWidth - 150;
						var act_left = (document.body.clientWidth - lightboxPanorama.clientWidth) / 2;
						
						if (act_width > 0) {
					
							var x = e.clientX;
							if (x < act_left) x = act_left;
							if (x > act_left + act_width) x = act_left + act_width;
		
							var inner_left = (lightboxPanorama.clientWidth - panoramaImage.clientWidth) * (x - act_left) / act_width;
							panoramaImage.style.marginLeft = Math.ceil(inner_left) + "px"; 					
						}
						
					}
				} else {
					document.ontouchmove = function(e) {
						if(e.touches.length == 1){
							var touch = e.touches[0];
							if(lastX == 0)  {
								lastX = touch.pageX;
								return;
							}
							
							var currentLeft = parseFloat(panoramaImage.style.marginLeft.replace("px",""));
							var moveToX = (currentLeft - (lastX - touch.pageX));
							if(moveToX > 0) {
								return;
							}
							
							if(moveToX < (panoramaImage.clientWidth - lightboxPanorama.clientWidth) * -1) {
								return;
							}
							
							panoramaImage.style.marginLeft = moveToX + "px";
							lastX = touch.pageX;
						}
					}
					
					document.ontouchstart = function(e) {
							lastX = 0;
					}
					document.ontouchend = function(e) {
							lastX = 0;
					}
				}
			
			}
			
		} else {
			if( activeType == TYPE_VIDEO) {
				if(!isAppleIOS) {	
					document.onmousemove = function(e) {
						var lightboxVideo = $("lightboxVideo");
						Element.hide('hoverNavNext');
						Element.hide('hoverNavPrev');
						e = e || window.event;
						var act_left = (document.body.clientWidth - lightboxVideo.clientWidth) / 2;
						var x = e.clientX;
						if(activeImage != 0){
							if (x >= act_left && x <  (lightboxVideo.clientWidth / 2 + act_left))
								Element.show('hoverNavPrev');
						}
						if(activeImage != (imageArray.length - 1)){
							if (x >= (lightboxVideo.clientWidth / 2 + act_left) && x <=  (lightboxVideo.clientWidth + act_left))
								Element.show('hoverNavNext');
						}
						if(videoNavTimerId) {
							videoNavTimerId = clearTimeout(videoNavTimerId);
						}
						videoNavTimerId = setTimeout(myLightbox.hideVideoNav, 2000);
					}
				}
			}
			
		}
		
		this.enableKeyboardNav();
		/****** end of code added ******/
		
	},
	hideVideoNav : function() {
		Element.hide('hoverNavPrev');
		Element.hide('hoverNavNext');
	},
	//
	//	enableKeyboardNav()
	//
	enableKeyboardNav: function() {
		document.onkeydown = this.keyboardAction; 
	},

	//
	//	disableKeyboardNav()
	//
	disableKeyboardNav: function() {
		document.onkeydown = '';
	},

	//
	//	keyboardAction()
	//
	keyboardAction: function(e) {
		if (e == null) { // ie
			keycode = event.keyCode;
		} else { // mozilla
			keycode = e.which;
		}

		key = String.fromCharCode(keycode).toLowerCase();
		
		if((key == 'x') || (key == 'o') || (key == 'c')){	// close lightbox
			myLightbox.end();
		} else if(key == 'p'){	// display previous image
			if(activeImage != 0){
				myLightbox.disableKeyboardNav();
				myLightbox.changeImage(activeImage - 1);
			}
		} else if(key == 'n'){	// display next image
			if(activeImage != (imageArray.length - 1)){
				myLightbox.disableKeyboardNav();
				myLightbox.changeImage(activeImage + 1);
			}
		}


	},

	//
	//	preloadNeighborImages()
	//	Preload previous and next images.
	//
	preloadNeighborImages: function(){

		if((imageArray.length - 1) > activeImage){
			preloadNextImage = new Image();
			preloadNextImage.src = imageArray[activeImage + 1][0];
		}
		if(activeImage > 0){
			preloadPrevImage = new Image();
			preloadPrevImage.src = imageArray[activeImage - 1][0];
		}
	
	},

	//
	//	end()
	//
	end: function() {
		/*** code added for jetphoto ***/
		this.removeVideoContent();
		if(isAppleIOS) {
			document.ontouchmove = null;
			document.ontouchstart = null;
			document.ontouchend = null;
		}
		this.hideVideoNav();
		
		var objCoverflow = document.getElementById('coverflow');
		if(objCoverflow) objCoverflow.style.visibility="visible";
	
		/****** end of code added ******/
		this.disableKeyboardNav();
		Element.hide('lightbox');
		new Effect.Fade('overlay', { duration: 0.2});
		showSelectBoxes();	
		
		
	}
}

// -----------------------------------------------------------------------------------

//
// getPageScroll()
// Returns array with x,y page scroll values.
// Core code from - quirksmode.org
//
function getPageScroll(){

	var yScroll;

	if (self.pageYOffset) {
		yScroll = self.pageYOffset;
	} else if (document.documentElement && document.documentElement.scrollTop){	 // Explorer 6 Strict
		yScroll = document.documentElement.scrollTop;
	} else if (document.body) {// all other Explorers
		yScroll = document.body.scrollTop;
	}

	arrayPageScroll = new Array('',yScroll) 
	return arrayPageScroll;
}

// -----------------------------------------------------------------------------------

//
// getPageSize()
// Returns array with page width, height and window width, height
// Core code from - quirksmode.org
// Edit for Firefox by pHaez
//
function getPageSize(){
	
	var xScroll, yScroll;
	
	if (window.innerHeight && window.scrollMaxY) {	
		xScroll = document.body.scrollWidth;
		yScroll = window.innerHeight + window.scrollMaxY;
	} else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
		xScroll = document.body.scrollWidth;
		yScroll = document.body.scrollHeight;
	} else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
		xScroll = document.body.offsetWidth;
		yScroll = document.body.offsetHeight;
	}
	
	var windowWidth, windowHeight;
	if (self.innerHeight) {	// all except Explorer
		windowWidth = self.innerWidth;
		windowHeight = self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
		windowWidth = document.documentElement.clientWidth;
		windowHeight = document.documentElement.clientHeight;
	} else if (document.body) { // other Explorers
		windowWidth = document.body.clientWidth;
		windowHeight = document.body.clientHeight;
	}	
	
	// for small pages with total height less then height of the viewport
	if(yScroll < windowHeight){
		pageHeight = windowHeight;
	} else { 
		pageHeight = yScroll;
	}

	// for small pages with total width less then width of the viewport
	if(xScroll < windowWidth){	
		pageWidth = windowWidth;
	} else {
		pageWidth = xScroll;
	}


	arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight) 
	return arrayPageSize;
}

// -----------------------------------------------------------------------------------

//
// getKey(key)
// Gets keycode. If 'x' is pressed then it hides the lightbox.
//
function getKey(e){
	if (e == null) { // ie
		keycode = event.keyCode;
	} else { // mozilla
		keycode = e.which;
	}
	key = String.fromCharCode(keycode).toLowerCase();
	
	if(key == 'x'){
	}
}

// -----------------------------------------------------------------------------------

//
// listenKey()
//
function listenKey () {	document.onkeypress = getKey; }
	
// ---------------------------------------------------

function showSelectBoxes(){
	selects = document.getElementsByTagName("select");
	for (i = 0; i != selects.length; i++) {
		selects[i].style.visibility = "visible";
	}
}

// ---------------------------------------------------

function hideSelectBoxes(){
	selects = document.getElementsByTagName("select");
	for (i = 0; i != selects.length; i++) {
		selects[i].style.visibility = "hidden";
	}
}

// ---------------------------------------------------

//
// pause(numberMillis)
// Pauses code execution for specified time. Uses busy code, not good.
// Code from http://www.faqts.com/knowledge_base/view.phtml/aid/1602
//
function pause(numberMillis) {
	var now = new Date();
	var exitTime = now.getTime() + numberMillis;
	while (true) {
		now = new Date();
		if (now.getTime() > exitTime)
			return;
	}
}
