<?php
//This script is for use by Geodesic Support Team.
//force removal of phpMyAdmin folder (handy when server permissions make the normal cleanup routine go all wonky)

function rmdirr($dirname)
{
    // Sanity check
    if (!file_exists($dirname)) {
        return false;
    }
 
    // Simple delete for a file
    if (is_file($dirname) || is_link($dirname)) {
        return unlink($dirname);
    }
 
    // Loop through the folder
    $dir = dir($dirname);
    while (false !== $entry = $dir->read()) {
        // Skip pointers
        if ($entry == '.' || $entry == '..') {
            continue;
        }
 
        // Recurse
        rmdirr($dirname . DIRECTORY_SEPARATOR . $entry);
    }
 
    // Clean up
    $dir->close();
    return rmdir($dirname);
}

//uncomment to use
//$foo = rmdirr('phpMyAdmin');

var_dump($foo);
if(!$foo) echo 'you probably forgot to uncomment the directory name in this file!';
