<?php 

//This script is for use by Geodesic Support Team.

//Moving the PHP 5 zip method to it's own file, so it doesn't cause syntax errors on older
//PHP 4 installations

function zip5 ($sources, $destination)
{
	//this could easily error, especially where there is a lot to do and a crappy server to do it on 
	ini_set('display_errors','stdout');
	//no limits!!!
	set_time_limit(0);
	if (!is_array($sources)) {
		$sources = array($sources);
	}
	
	$startingSourceFolder = dirname(dirname(__FILE__));
	$startingSourceFolder = rtrim($startingSourceFolder,'/').'/';
	
	if (!$sources) {
		$sources = array_diff(scandir($startingSourceFolder), array ('.','..','geo_support_tools','user_images'));
		msg("Found the following to zip up:<pre>".print_r($sources,1)."</pre>");
	}
	
	$zip = new ZipArchive;
	
	if (!$zip->open($destination, ZIPARCHIVE::CREATE)) {
		return false;
	}
	//make it start one up...
	$startingSourceFolder = dirname(dirname(__FILE__));
	$startingSourceFolder = rtrim($startingSourceFolder,'/').'/';
	
	foreach ($sources as $entry) {
		$from = $startingSourceFolder.$entry;
		if (is_dir($from)) {
			//add empty folder
			$folderName = str_replace($startingSourceFolder, '', rtrim($from, '/') . '/');
			if ($folderName!='/') {
				$zip->addEmptyDir($folderName);
			}
			//nifty trick to easily recurse into files/folders
			$files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($from), RecursiveIteratorIterator::SELF_FIRST);
			foreach ($files as $file) {
				if (is_dir($file)) {
					$zip->addEmptyDir(str_replace($startingSourceFolder, '', rtrim($file, '/').'/'));
				} else if (is_file($file)) {
					$zip->addFile($file, str_replace($startingSourceFolder,'',$file));
				}
			}
		} else if (file_exists($from)) {
			//add zipped file
			$zip->addFile($from, str_replace($startingSourceFolder,'',$from));
		}
	}
	return $zip->close();
}