<?php
//geo_diagnostic_tool.php
/**
 * Use this tool to diagnose problems with Geodesic Databases
 */

//so that inputs are not filtered.
define('IN_ADMIN',1);

/**
 * This function will hash and compare the username/password that is typed by the user
 * with the hashed values defined in the function
 *
 * @param md5hash $un username typed by user
 * @param md5hash $pw password typed by user
 * @return boolean true=success|false=failure
 */
function authenticate($un,$pw)
{
	//these variables must be hashed prior to being assigned
	$username = 'a494323fb7aa06bc868aa33d46bc6588';
	$password = '5b4b82e40b81416debfa9e1438e4cbc3';
	if ($un!=$username || $pw!=$password) {
		$_SESSION['loginError'] = '<p>Login information is incorrect</p>';
		return false;
	}
	else
		return true;
}
####################################################################################

/**
 * This function simply displays the HTML login form.
 * If an error was generated by a bad login, an error message stored the
 * session labeled $_SESSION['loginError'] will be displayed.
 *
 */
function loginForm()
{
	$GLOBALS['body'] = "
	<form action=geodiagnostic.php? method=post>
	<table width='100%' border='0' cellspacing='0' cellpadding='0' height='100%'>
	  <tr align='center'>
	    <td>
	      <table width='350' border='3' cellspacing='0' cellpadding='1' bordercolor='#71B8FF' background='admin/admin_images/admin_login_page_bg.gif'>
	        <tr valign='top'>
	          <td>
	            <table width='100%' border='0' cellspacing='0' cellpadding='0'>
	              <tr valign='top'>
	                <td height='44' colspan='2'>
	                  <table width='100%' border='0' cellspacing='0' cellpadding='0'>
	                    <tr>
	                      <td align='center' class='large_font'>
	                      	Diagnostic Tool
	                      </td>
	                    </tr>
	                  </table>
	                </td>
	              </tr>
	              <tr align='center'>
	                <td height='35' class=diagnostic_login5 align='right' width='50%'>Username:</td><td class=diagnostic_login5 align='left'><input type=text name=b[username] size=20 /></td>
	              </tr>
	              <tr align='center'>
	                <td height='35' class=diagnostic_login5 align='right'>Password:</td><td class=diagnostic_login5 align='left'><input type=password name=b[password] size=20 /></td>
	              </tr>
	              <tr align='center'>
	                <td class=diagnostic_login6 colspan='2'>".@$_SESSION['loginError']."&nbsp;</td>
	              </tr>
	              <tr align='center'>
	                <td height='55' colspan='2'><input type=submit name='submit' value='Submit' /></td>
	              </tr>
	                <td height='53' colspan='2'>
	                  <table width='100%' border='0' cellspacing='0' cellpadding='0'>
	                    <tr>
	                    	<td background='admin/admin_images/admin_login_bot2.gif' valign='middle' class='very_small_font_light' height='70'>
	                    		Copyright 2006.
                          <a class='diagnostic_links' href='http://www.geodesicsolutions.com' target=new>Geodesic Solutions, LLC.</a><br/>
                          All Rights Reserved.
                      	</td>
	                    </tr>
	                  </table>
	                </td>
	              </tr>
	            </table>
	          </td>
	        </tr>
	      </table>
	    </td>
	  </tr>
	</table>
	</form>
	</body>
	</html>";
} //end of function loginForm
####################################################################################

/**
 * This function displays the basic HTML page including the header and opening/closing body tags
 *
 */
function display_page()
{
	$pageData = "
		<html>
			<head>
				<title>Diagnostic Tool</title>
				<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />
				<style type='text/css'>
					<!--
					.title { font-family: Arial, Helvetica, sans-serif; font-size: 36pt; font-style: normal; font-weight: bold; color: #000066; text-decoration: none; }
					.large_font { font-family: Arial, Helvetica, sans-serif; font-size: 14pt; font-style: normal; font-weight: bold; color: #000066; text-decoration: none; }
					.diagnostic_login2 { font-family: Arial, Helvetica, sans-serif; font-size: 12pt; font-style: normal; font-weight: bold; color: #000066; text-decoration: none; }
					.diagnostic_login3 { font-family: Arial, Helvetica, sans-serif; font-size: 12pt; font-style: normal; font-weight: bold; color: #000066; text-decoration: none; }
					.very_small_font_light { font-family: Arial, Helvetica, sans-serif; font-size: 8pt; font-style: normal; font-weight: bold; color: #ffffff; text-decoration: none; }
					.diagnostic_login5 { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: bold; color: #007CF9; text-decoration: none; }
					.diagnostic_login6 { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: bold; color: #ff0000; text-decoration: none; }
					.very_small_font { font-family: Arial, Helvetica, sans-serif; font-size: 8pt; font-style: normal; font-weight: bold; color: #000066; text-decoration: none; }
					.diagnostic_links { font-family: Arial, Helvetica, sans-serif; font-size: 8pt; font-style: normal; font-weight: bold; color: #ffffff; text-decoration: underline; }
					.small_error_font { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; color: #ff0000; text-decoration: none; }
					a { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; color: #000066; text-decoration: underline; }
					a.error { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; color: #ff0000; text-decoration: none; }
					a:hover { text-decoration: underline; }
					td { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; color: #000000; text-decoration: none; }
					.error { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; color: #ff0000; text-decoration: none; }
					.table { display:table; border:1px solid #000000; }
					.row_header { display:table-row; border:1px solid #000000; background-color: #dddddd; }
					.row { display:table-row; border:1px solid #000000; }
					.cell { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; text-align:center; vertical-align:middle; padding:3px; display:table-cell; border:1px solid #000000; }
					-->
				</style>";
		if ($_SESSION['showToolTips'])
				$pageData .= "<script type='text/javascript' src='overlib.js'><!-- overLIB (c) Erik Bosrup --></script>";
		$pageData .=
				"<script type='text/javascript'>
				function getCatNameDesc(cat_id,lang_id)
				{
					name = prompt('Enter a name for this category.','');
					description = prompt('Enter a description for this category.','');
					query = 'INSERT INTO geodesic_classifieds_categories_languages (category_id,language_id,category_name,description) VALUES (\"'+cat_id+'\",\"'+lang_id+'\",\"'+name+'\",\"'+description+'\");';
					ans = confirm('Are you sure you want to run the following query?\\n'+query);
					query = '\"'+query+';';
					if (ans)
						window.location = 'geodiagnostic.php?a=9&b='+encodeURIComponent(query);
				}
				</script>
			</head>
			<body bgcolor='#FFFFFF'>";
		if ($_SESSION['showToolTips'])
				$pageData .= "<div id='overDiv' style='position:absolute; visibility:hidden; z-index:1000;'></div>";
		$pageData .= $GLOBALS['body']."
				<table>
					<tr>
						<td>
							<a href=geodiagnostic.php?a=logout>
								log out
							</a>
						</td>
					</tr>
					<tr>
						<td>
							<a href=geodiagnostic.php>
								HOME
							</a>
						</td>
					</tr>
				</table>
			</body>
		</html>";
		echo $pageData;
}//end of function diagnostic_footer
####################################################################################

function displayQueryForm($msg='')
{
	$GLOBALS['body'] .= "
		<table>
			<tr>
				<td class=title align=center>
					Query Tool
				</td>
			</tr>";
	if (strlen($msg)>0) {
		$GLOBALS['body'] .= "
			<tr>
				<td class=error>
					$msg
				</td>
			</tr>";
	}
	$GLOBALS['body'] .= "
		<tr>
				<td>
					<form onsubmit=\"return confirm('Are you sure you want to run the following query?\\n'+getElementById('query').value)\" action=./geodiagnostic.php?a=1 method=post>
						<textarea id=query name=b cols=50 rows=5></textarea><br/>
						<input type=submit name='Submit Query' />
					</form>
		</table>";
} //end of function displayQueryForm
####################################################################################

function get_current_languages_array(&$db)
{
	//get current languages
	$sql_query = "select * from geodesic_pages_languages";
	$language_result =  $db->Execute($sql_query);
	if (!$language_result)
	{
	 	$GLOBALS['body'] .= "no languages in database<br/>\n";
	 	exit;
	}
	elseif ($language_result->RecordCount() > 0)
	{
		$language_details = array();
		while ($show_language = $language_result->FetchRow())
		{
			$language_details[$show_language["language_id"]]["language"] = $show_language["language"];
			$language_details[$show_language["language_id"]]["browser_label"] = $show_language["browser_label"];
			$language_details[$show_language["language_id"]]["default_language"] = $show_language["default_language"];
			$language_details[$show_language["language_id"]]["active"] = $show_language["active"];
		}
	}
	return $language_details;
} //function get_current_languages_array
####################################################################################

function remove_extraneous_group_affiliate_languages($db)
{
	$sql_query = "select * from geodesic_pages_templates_affiliates order by group_id";
	$affiliates_result =  $db->Execute($sql_query);
	if (!$affiliates_result)
	{
		$GLOBALS['body'] .= "no groups<br/>\n";
		die('<span class=small_error_font>'.mysql_error().'</span>');
	}
	elseif ($affiliates_result->RecordCount() > 0)
	{
		$language_existing = array();

		$GLOBALS['body'] .= "<table><tr><td>group affiliate language text</td></tr>";
		while ($show_affiliates = $affiliates_result->FetchRow())
		{
			$sql_query = "select * from geodesic_pages_languages where language_id = ".$show_affiliates["language_id"];
			$language_result =  $db->Execute($sql_query);
			if (!$language_result)
			{
			 	$GLOBALS['body'] .= "no languages in database<br/>\n";
			 	exit;
			}
			elseif ($language_result->RecordCount() > 0)
			{
				//$show_affiliates["language_id"]
				$show_language = $language_result->FetchRow();
				$GLOBALS['body'] .= "<tr><td>".$show_language["language"]." exists (".$show_affiliates["group_id"].")";
				//check if language already exists
				if ($language_existing[$show_affiliates["group_id"]][$show_affiliates["language_id"]] == 1)
				{
					$GLOBALS['body'] .= "<font color=#990000> is a duplicate ";
					$sql_query = "delete from geodesic_pages_templates_affiliates where language_id = ".$show_affiliates["language_id"]." and group_id = ".$show_affiliates["group_id"]." limit 1";
					//$GLOBALS['body'] .= " - ".$sql_query."<br/>";
					$remove_result =  $db->Execute($sql_query);
					if (!$remove_result)
					{
						$GLOBALS['body'] .= " - error removing language_id (".$show_affiliates["language_id"].") and group_id(".$show_affiliates["group_id"].")</font><br/>";
					}
					else
					{
						$GLOBALS['body'] .= " - removed language_id (".$show_affiliates["language_id"].") and group_id(".$show_affiliates["group_id"].")</font><br/>";
						$GLOBALS['body'] .= $sql_query."<br/>";
					}

				}
				$language_existing[$show_affiliates["group_id"]][$show_affiliates["language_id"]] = 1;
				$GLOBALS['body'] .= "</td></tr>";
			}
			else
			{
				$GLOBALS['body'] .= "<tr><td>".$show_language["language"]."(".$show_affiliates["language_id"].") for group(".$show_affiliates["group_id"].") <font color=#990000>does NOT exist";
				//remove the extraneous affiliate group language
				$sql_query = "delete from geodesic_pages_templates_affiliates where language_id = ".$show_affiliates["language_id"]." and group_id = ".$show_affiliates["group_id"]." limit 1";
				//$GLOBALS['body'] .= " - ".$sql_query."<br/>";
				$remove_result =  $db->Execute($sql_query);
				if (!$remove_result)
				{
					$GLOBALS['body'] .= "<font color=#990000>error removing language_id (".$show_affiliates["language_id"].") and group_id(".$show_affiliates["group_id"].")</font><br/>";
				}
				else
				{
					$GLOBALS['body'] .= "<font color=#009900>removed language_id (".$show_affiliates["language_id"].") and group_id(".$show_affiliates["group_id"].")</font> - ";
					$GLOBALS['body'] .= $sql_query."<br/>";
				}

				$GLOBALS['body'] .= "</font></td></tr>";

			}
		}
	}
	else
	{
		$GLOBALS['body'] .= "no affilliate templates attached<br/>\n";
	}
} // end of function remove_extraneous_group_affiliate_languages
####################################################################################

function test_and_display_group_info(&$db)
{
	$sql_query = "select * from geodesic_groups";
	$result = $db->Execute($sql_query);
	if (!$result)
	{
		$GLOBALS['body'] .= "no groups<br/>\n";
		die('<span class=small_error_font>'.mysql_error().'</span>');

	}
	elseif ($result->RecordCount() > 0)
	{
		$language_details = get_current_languages_array($db);
		while ($show_group = $result->FetchRow())
		{
			$GLOBALS['body'] .= "
				<p>
					<table cellspacing=2 cellpadding=1 border=1>
						<tr>
							<td colspan=2><br/>Group ".$show_group["name"]."</td>
						</tr>
						<tr>
							<td>group_id</td>
							<td>".$show_group["group_id"]."</td>
						</tr>
						<tr>
							<td>description</td>
							<td>".$show_group["description"]."</td>
						</tr>
						<tr>
							<td>default_group</td>
							<td>".$show_group["default_group"]."</td>
						</tr>
						<tr>
							<td>price_plan_id</td>
							<td>".$show_group["price_plan_id"]."</td>
						</tr>
						<tr>
							<td>auction_price_plan_id</td>
							<td>".$show_group["auction_price_plan_id"]."</td>
						</tr>
						<tr>
							<td>registration_code</td>
							<td>".$show_group["registration_code"]."&nbsp;</td>
						</tr>
						<tr>
							<td>group_expires_into</td>
							<td>".$show_group["group_expires_into"]."</td>
						</tr>
						<tr>
							<td>affiliate</td>
							<td>".$show_group["affiliate"]."</td>
						</tr>
						<tr>
							<td>price plans attached</td>
							<td>";
			$sql_query = "select * from geodesic_groups";
			$price_plan_result =  $db->Execute($sql_query);
			if (!$price_plan_result)
			{
				$GLOBALS['body'] .= "no groups<br/>\n";
				die('<span class=small_error_font>'.mysql_error().'</span>');

			}
			elseif ($price_plan_result->RecordCount() > 0)
			{
				while ($show_price_plan = $price_plan_result->FetchRow())
				{
					$GLOBALS['body'] .= $show_price_plan["name"]."(".$show_price_plan["applies_to"]." - ";
					if ($show_price_plan["applies_to"] == 1)
						$GLOBALS['body'] .= "classified";
					else
						$GLOBALS['body'] .= "auction";
					$GLOBALS['body'] .= ") - ".$show_price_plan["price_plan_id"]."(price_plan_id) - ".$show_price_plan["auction_price_plan_id"]." (auction_price_plan_id)<br/>";
				}
			}
			else
			{
				$GLOBALS['body'] .= "no attached price plans<br/>\n";
			}
			$GLOBALS['body'] .= "
							</td>
						</tr>
						<tr>
							<td colspan=2>
								<table>
									<tr>
										<td colspan=2>templates affiliates</td>
									</tr>";
			$sql_query = "select * from geodesic_pages_templates_affiliates where group_id = ".$show_group["group_id"];
			$languages_result =  $db->Execute($sql_query);
			if (!$languages_result)
			{
				$GLOBALS['body'] .= "no groups<br/>\n";
				die('<span class=small_error_font>'.mysql_error().'</span>');

			}
			elseif ($languages_result->RecordCount())
			{
				$language_count = $languages_result->RecordCount();
				$all_languages = array();
				while ($show_language = $languages_result->FetchRow())
				{
					$all_languages[$show_language["language_id"]] = $show_language["language"];
					//echo "adding: ".$show_language["language_id"]." - ".$show_language["language"]." to all_languages<bR>\n";
				}
				//echo $language_count." is the total count of languages<BR>\n";
			}
			else
			{
				echo "there are no languages in the languages table<bR>\n";
				exit;
			}

			$sql_query = "select * from geodesic_pages_templates_affiliates where group_id = ".$show_group["group_id"];
			$affiliates_result =  $db->Execute($sql_query);
			if (!$affiliates_result)
			{
				$GLOBALS['body'] .= "no groups<br/>\n";
				die('<span class=small_error_font>'.mysql_error().'</span>');

			}
			elseif ($affiliates_result->RecordCount() > 0)
			{
				$total_languages_represented= array();
				while ($show_affiliates = $affiliates_result->FetchRow())
				{

					$GLOBALS['body'] .= "
									<tr>
										<td>";
					if (strlen(trim($language_details[$show_affiliates["language_id"]]["language"])) == 0)
						$GLOBALS['body'] .= "<font color=#990000>";
					else
						$GLOBALS['body'] .= "<font color=#009900>";
					$GLOBALS['body'] .= "affiliate templates for the ".$language_details[$show_affiliates["language_id"]]["language"]." language(".$show_affiliates["language_id"].")<br/>";
					$GLOBALS['body'] .= $show_affiliates["template_id"]."(template_id)<br/>";
					$GLOBALS['body'] .= $show_affiliates["secondary_template_id"]."(secondary_template_id)<br/>";
					$GLOBALS['body'] .= $show_affiliates["ad_display_template_id"]."(ad_display_template_id)<br/>";
					$GLOBALS['body'] .= $show_affiliates["extra_question_template_id"]."(extra_question_template_id)<br/>";
					$GLOBALS['body'] .= $show_affiliates["checkbox_question_template_id"]."(checkbox_question_template_id)<br/>";
					$GLOBALS['body'] .= $show_affiliates["auctions_display_template_id"]."(auctions_display_template_id)<br/>";
					$GLOBALS['body'] .= $show_affiliates["auctions_extra_question_template_id"]."(auctions_extra_question_template_id)<br/>";
					$GLOBALS['body'] .= $show_affiliates["auctions_checkbox_question_template_id"]."(auctions_checkbox_question_template_id)<br/><br/>";
					$GLOBALS['body'] .= "</font></td></tr>";
					array_push($total_languages_represented,$show_affiliates["language_id"]);
					//echo "adding ".$show_affiliates["language_id"]." language_id to total_languages_represented<BR>\n";
				}
				if (count($total_languages_represented) != $language_count)
				{
					reset($total_languages_represented);
					///echo count($total_languages_represented)." is the count of \$total_languages_represented<Br>\n";
					//foreach ($total_languages_represented as $key => $value)
					///	echo $key." is the key to: ".$value." in total_languages_represented<Br>\n";
					reset($all_languages);
					foreach ($all_languages as $key => $value)
					{
						//echo $key." is to ".$value."<br>\n";
						if (!in_array($key,$total_languages_represented))
						{

							$GLOBALS['body'] .= "<font color=#990000>This user group is missing the ".$value." language within it affilates templates table<br>";
							$GLOBALS['body'] .= "<a href=geodiagnostic.php?a=13&b=".$show_group["group_id"]."&c=".$key.">click here to add an affiliate language for the ".$show_group["name"]." user user and the ".$value." language</a><br></font>";
						}
					}
				}
			}
			else
			{
				$GLOBALS['body'] .= "no affilliate templates attached<br/>\n";
			}
			$GLOBALS['body'] .= "</table></td></tr><tr><td colspan=2><a href=geodiagnostic.php?a=5>fix extraneous affiliate template/group references</a></td></tr></table></p>\n";

		}

	}

} //end of function test_and_display_group_info
####################################################################################

/**
 * This function inserts a missing database reference within the geodesic_pages_templates_affiliates
 * database table.  For each language and each group there should be a reference.  Each group should
 * have a record in the geodesic_pages_templates_affiliates database table for each language.
 *
 * @param ADODB object $db
 * @param  user group id
 * @param   language id
 * @return  true or false on success
 */

function insert_language_group_affiliate_record($db, $user_group_id=0,$language_id=0)
{
	if (($user_group_id) && ($language_id))
	{
		//check to see if the user group and language id combination are not already in the
		//geodesic_pages_templates_affiliates database table
		//if it already exists do not insert another one
		$sql_query = "select * from geodesic_pages_templates_affiliates where group_id = ".$user_group_id." and language_id = ".$language_id;
		$language_to_group_result =  $db->Execute($sql_query);
		if (!$language_to_group_result)
		{
			$GLOBALS['body'] .= "no groups<br/>\n";
			die('<span class=small_error_font>'.mysql_error().'</span>');
		}
		elseif ($language_to_group_result->RecordCount() == 0)
		{
			//get a default setting for the new one
			$sql_query = "select * from geodesic_pages_templates_affiliates where group_id = ".$user_group_id." limit 1";
			$default_result =  $db->Execute($sql_query);
			if (!$default_result)
			{
				$GLOBALS['body'] .= "no groups<br/>\n";
				die('<span class=small_error_font>'.mysql_error().'</span>');
			}
			elseif ($default_result->RecordCount() == 1)
			{
				$show_default = $default_result->FetchRow();
				$template_id = $show_default["template_id"];
				$secondary_template_id = $show_default["secondary_template_id"];
				$ad_display_template_id  = $show_default["ad_display_template_id"];
				$extra_question_template_id = $show_default["extra_question_template_id"];
				$checkbox_question_template_id = $show_default["checkbox_question_template_id"];
				$auctions_display_template_id = $show_default["auctions_display_template_id"];
				$auctions_extra_question_template_id = $show_default["auctions_extra_question_template_id"];
				$auctions_checkbox_question_template_id = $show_default["auctions_checkbox_question_template_id"];
			}
			else
			{
				//there is no default to pull from
				$template_id = 0;
				$secondary_template_id = 0;
				$ad_display_template_id  = 0;
				$extra_question_template_id = 0;
				$checkbox_question_template_id = 0;
				$auctions_display_template_id = 0;
				$auctions_extra_question_template_id = 0;
				$auctions_checkbox_question_template_id = 0;

			}
			$sql_query = "insert into geodesic_pages_templates_affiliates
			(template_id,secondary_template_id,ad_display_template_id,extra_question_template_id,checkbox_question_template_id,auctions_display_template_id,auctions_extra_question_template_id,auctions_checkbox_question_template_id)
			values
			(".$template_id.",".$secondary_template_id.",".$ad_display_template_id.",".$extra_question_template_id.",".$checkbox_question_template_id.",".$auctions_display_template_id.",".$auctions_extra_question_template_id.",".$auctions_checkbox_question_template_id.")";
			$insert_result =  $db->Execute($sql_query);
			if (!$insert_result)
			{
				echo $sql_query."<br>";
				echo $db->ErrorMsg()."<bR>\n";
				return false;
			}

			$GLOBALS['body'] .= "<font color=#009900>the user group(".$user_group_id.") and language(".$language_id.") combination has been added to the geodesic_pages_templates_affiliates database table</font>\n";
			return true;
		}
		else
		{
			$GLOBALS['body'] .= "<font color=#990000>the user group(".$user_group_id.") and language(".$language_id.") combination already exists in the geodesic_pages_templates_affiliates database table</font>\n";
			return false;
		}


	}
} //end of function insert_language_group_affiliate_record

//####################################################################################

/**
 * This funcion returns all languages and their corresponding language id.
 *
 * @param ADODB object $db
 * @return array $languages
 */
function getLanguages($db)
{
	$query = "SELECT language_id,language FROM geodesic_pages_languages";
	$result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
	$languages = array();
	while($language = $result->FetchRow())
		array_push($languages,$language);
	return $languages;
}
####################################################################################

/**
 * This function returns all category ids and their corresponding parent id
 *
 * @param ADODB object $db
 * @return array $categories
 */
function getCategories($db)
{
	$query = "SELECT category_id,parent_id FROM geodesic_categories ORDER BY category_id ASC";
	$result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
	$categories = array();
	while($category = $result->FetchRow())
		array_push($categories,$category);
	return $categories;
}
####################################################################################

/**
 * This function returns the language specific name of a category based on the parameters listed
 * It returns an array if there is more than one, otherwise it returns the name as a string
 *
 * @param ADODB object $db
 * @param integer $category_id
 * @param integer $language_id
 * @return array=more than 1|string=only one category_name
 */
function getCategoryName($db,$category_id,$language_id)
{
	$js_event = '';
	$query = "SELECT category_name,category_id FROM geodesic_classifieds_categories_languages
		WHERE category_id = '$category_id' AND language_id = '$language_id'";
	$result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
	if ($result->RecordCount()==0) {
		if ($_SESSION['showToolTips']) {
			$js_msg = "Click to insert a <b>category_name</b> and <b>description</b> with a <nobr><b>category_id = $category_id</b></nobr> and a <nobr><b>language_id = $language_id</b></nobr> into the <b>geodesic_classifieds_categories_languages</b> table.";
			$js_event = "onmouseover=\"return overlib('$js_msg');\" onmouseout='return nd();'";
		}
		$name = "<a href='javascript:void(0);' class='error'
			onclick='getCatNameDesc($category_id,$language_id);' ".$js_event.">X</a>";
		return $name;
	} elseif ($result->RecordCount()==1) {
		$category = $result->FetchRow();
		return stripslashes(urldecode($category['category_name']));
	} else {
		//more than one name for this combination of language/category ids
		$names = array();
		while($category = $result->FetchRow()) {
			$catName = trim(stripslashes(urldecode($category['category_name'])));
			if ($_SESSION['showToolTips']) {
				$js_msg = "This category name <nobr><b>$catName</b></nobr> has a language_id and category_id in common with another category name.<br/>Click to delete from <b>geodesic_classifieds_categories_languages.</b>";
				$js_event = "onmouseover=\"return overlib('$js_msg');\" onmouseout='return nd();'";
			}
			$delete_query = "DELETE FROM geodesic_classifieds_categories_languages WHERE category_id=\\\"$category_id\\\" AND language_id=\\\"$language_id\\\" AND category_name=\\\"".$category['category_name']."\\\" LIMIT 1";
			$confirm_msg = "\"Are you sure you want to run the following query?\\n".$delete_query."\"";
			array_push($names,"<a href=\"geodiagnostic.php?a=9&b='".rawurlencode($delete_query)."'\" class='error'
				onclick='return confirm($confirm_msg)' ".$js_event.">$catName</a>");
		}
		return $names;
	}
}
####################################################################################

/**
 * This function returns the name(s) of categories that have non-existent $fields
 * It returns an array if there is more than one, otherwise it returns the name as a string
 *
 * @param ADODB object $db
 * @param string $field language_id|category_id
 * @param string $in_statement contains all existing $fields
 * @return array=more than 1|string=only one category_name($field)
 */
function getBadCatNames($db,$field,$in_statement)
{
	$js_event = '';
	$query = "SELECT category_name,$field FROM geodesic_classifieds_categories_languages
		WHERE $field NOT $in_statement";
	$result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
	if ($result->RecordCount()==0) {
		return 'NONE';
	} elseif ($result->RecordCount()==1) {
		$category = $result->FetchRow();
		$catName = trim(stripslashes(urldecode($category['category_name'])));
		if ($_SESSION['showToolTips']) {
			$js_msg = "This category name <b>$catName</b> has a <nobr><b>$field</b> = <b>$category[$field]</b></nobr> that does not exist.<br/>Click to delete from <b>geodesic_classifieds_categories_languages.</b>";
			$js_event = "onmouseover=\"return overlib('$js_msg');\" onmouseout='return nd();'";
		}
		$delete_query = "DELETE FROM geodesic_classifieds_categories_languages WHERE $field=\\\"".$category[$field]."\\\" AND category_name=\\\"".$category['category_name']."\\\" LIMIT 1";
		$confirm_msg = "\"Are you sure you want to run the following query?\\n".$delete_query."\"";
		$name = "<a href=\"geodiagnostic.php?a=9&b='".rawurlencode($delete_query)."'\" class='error'
			onclick='return confirm($confirm_msg)' ".$js_event.">$catName&nbsp;(".$category[$field].")</a>";
		return $name;
	} else {
		//more than one name for this combination of language/category ids
		$names = array();
		while($category = $result->FetchRow()) {
			$catName = trim(stripslashes(urldecode($category['category_name'])));
			if ($_SESSION['showToolTips']) {
				$js_msg = "This category name <b>$catName</b> has a <nobr><b>$field</b> = <b>$category[$field]</b></nobr> that does not exist.<br/>Click to delete from <b>geodesic_classifieds_categories_languages.</b>";
				$js_event = "onmouseover=\"return overlib('$js_msg');\" onmouseout='return nd();'";
			}
			$delete_query = "DELETE FROM geodesic_classifieds_categories_languages WHERE $field=\\\"".$category[$field]."\\\" AND category_name=\\\"".$category['category_name']."\\\" LIMIT 1";
			$confirm_msg = "\"Are you sure you want to run the following query?\\n".$delete_query."\"";
			array_push($names,"<a href=\"geodiagnostic.php?a=9&b='".rawurlencode($delete_query)."'\" class='error'
				onclick='return confirm($confirm_msg)' ".$js_event.">$catName&nbsp;(".$category[$field].")</a>");
		}
		return $names;
	}
}
####################################################################################

/**
 * This function returns all category ids that have non-existing parent ids
 * It returns an array if there is more than one, otherwise it returns the name as a string
 *
 * @param ADODB object $db
 * @param string $in_statement contains all existing category_ids
 * @return array=more than 1|string=only one category_name(parent_id)
 */
function getBadCatIds($db,$in_statement)
{
	$js_event = '';
	$query = "SELECT category_id,parent_id FROM geodesic_categories
		WHERE parent_id NOT $in_statement AND parent_id != 0";
	$result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
	if ($result->RecordCount()==0) {
		return 'NONE';
	} elseif ($result->RecordCount()==1) {
		$category = $result->FetchRow();
		if ($_SESSION['showToolTips']) {
			$js_msg = "This category id <b>".stripslashes(urldecode($category['category_id']))."</b> has a non-existent parent_id <b>".$category['parent_id']."</b>.<br/>Click to delete from <b>geodesic_categories</b>.";
			$js_event = "onmouseover=\"return overlib('$js_msg');\" onmouseout='return nd();'";
		}
		$delete_query = "DELETE FROM geodesic_categories WHERE category_id=\\\"".$category['category_id']."\\\" AND parent_id=\\\"".$category['parent_id']."\\\" LIMIT 1";
		$confirm_msg = "\"Are you sure you want to run the following query?\\n".$delete_query."\"";
		$name = "<a href=\"geodiagnostic.php?a=9&b='".rawurlencode($delete_query)."'\" class='error'
			onclick='return confirm($confirm_msg)' ".$js_event.">".stripslashes(urldecode($category['category_id']))."&nbsp;(".$category['parent_id'].")</a>";
		return $name;
	} else {
		//more than one category_id w/ non-existent parent_id
		$names = array();
		while($category = $result->FetchRow()) {
			if ($_SESSION['showToolTips']) {
				$js_msg = "This category id <b>".stripslashes(urldecode($category['category_id']))."</b> has a non-existent parent_id <b>".$category['parent_id']."</b>.<br/>Click to delete from <b>geodesic_categories</b>.";
				$js_event = "onmouseover=\"return overlib('$js_msg');\" onmouseout='return nd();'";
			}
			$delete_query = "DELETE FROM geodesic_categories WHERE category_id=\\\"".$category['category_id']."\\\" AND parent_id=\\\"".$category['parent_id']."\\\" LIMIT 1";
			$confirm_msg = "\"Are you sure you want to run the following query?\\n".$delete_query."\"";
			array_push($names,"<a href=\"geodiagnostic.php?a=9&b='".rawurlencode($delete_query)."'\" class='error'
				onclick='return confirm($confirm_msg)' ".$js_event.">".stripslashes(urldecode($category['category_id']))."&nbsp;(".$category['parent_id'].")</a>");
		}
		return $names;
	}
}
####################################################################################

/**
 * Enter description here...
 *
 * @param ADODB object $db
 */
function examine_categories($db)
{
	$categories = getCategories($db);
	$languages = getLanguages($db);
	$GLOBALS['body'] .= "
		Comparing the following tables:
		<ul>
			<li>geodesic_categories (rows - listed in left column)</li>
			<li>geodesic_pages_languages (columns - listed in top row)</li>
			<li>geodesic_classifieds_categories_languages (cells)</li>
		</ul>
		<b>
			An '<span class=small_error_font>X</span>' represents no category name with corresponding language_id and category_id.<br/>
			Duplicate names also show up in <span class=small_error_font>red</span>.
		</b>
		<table>
			<tr>
				<td style='width:50%'>
					<table border=1>
						<tr>
							<td style='background-color:#009999;color:#ffffff'>
								<nobr><b>language (id) &rarr;</b></nobr><br/>
								<nobr><b>category id &darr;</b></nobr>
							</td>";
	$inLanguages = "IN (";
	$inCategories = "IN (";
	foreach ($languages as $language)	{
		$inLanguages .= $language['language_id'].",";
		$GLOBALS['body'] .= "
							<td align=center>
								<nobr>
									<b>".$language['language']."&nbsp;(".$language['language_id'].")</b>
								</nobr>
							</td>";
	}
	$GLOBALS['body'] .= "
						</tr>";
	foreach ($categories as $category) {
		$inCategories .= $category['category_id'].",";
		$GLOBALS['body'] .= "
						<tr>
							<td align=center>
								<nobr>
									<b>".$category['category_id']."</b>
								</nobr>
							</td>";
		foreach ($languages as $language) {
			$name = getCategoryName($db,$category['category_id'],$language['language_id']);
			$GLOBALS['body'] .= "
							<td align=center>
								<nobr>";
			if (is_array($name)) {
				foreach ($name as $value)
					$GLOBALS['body'] .= $value.'<br/>';
			} else {
				$GLOBALS['body'] .= $name;
			}
			$GLOBALS['body'] .= "
								</nobr>
							</td>";
		}
		$GLOBALS['body'] .= "
						</tr>";
	}
	$inLanguages = substr($inLanguages,0,-1).")";
	$inCategories = substr($inCategories,0,-1).")";
	$catNamesWithBadLangIds = getBadCatNames($db,'language_id',$inLanguages);
	$catNamesWithBadCatIds = getBadCatNames($db,'category_id',$inCategories);
	$catIdsWithBadParentIds = getBadCatIds($db,$inCategories);
	$GLOBALS['body'] .= "
					</table>
				</td>
				<td style='width:50%;vertical-align:top'>
					<table style='width:100%' border=1>
						<tr>
							<td colspan=100%>
								This table displays bad entries within the <b>geodesic_classifieds_categories_languages</b> table.<br/>
								NOTE: Non-existent Id (language or category) is in parenthesis
							</td>
						<tr>
							<td align=center style='width:50%;vertical-align:top'>
								<nobr>
									Category Name (Bad Language Id)
								</nobr>
							</td>
							<td align=center style='width:50%;vertical-align:top'>
								<nobr>
									Category Name (Bad Category Id)
								</nobr>
							</td>
						</tr>
						<tr>
							<td align=center style='width:50%;vertical-align:top'>
								<nobr>";
		if (is_array($catNamesWithBadLangIds)) {
			foreach ($catNamesWithBadLangIds as $value) {
				$GLOBALS['body'] .= $value.'<br/>';
			}
		} else {
			$GLOBALS['body'] .= $catNamesWithBadLangIds;
		}
		$GLOBALS['body'] .= "
								</nobr>
							</td>
							<td align=center style='width:50%;vertical-align:top'>
								<nobr>";
		if (is_array($catNamesWithBadCatIds)) {
			foreach ($catNamesWithBadCatIds as $value) {
				$GLOBALS['body'] .= $value.'<br/>';
			}
		} else {
			$GLOBALS['body'] .= $catNamesWithBadCatIds;
		}
		$GLOBALS['body'] .= "
								</nobr>
							</td>
						</tr>
					</table>
				</td>
				<td style='width:50%;vertical-align:top'>
					<table style='width:100%' border=1>
						<tr>
							<td colspan=100%>
								This table displays bad entries within the <b>geodesic_categories</b> table.<br/>
								NOTE: Non-existent parent id is in parenthesis
							</td>
						<tr>
							<td align=center>
								<nobr>
									Category Id (Bad Parent Id)
								</nobr>
							</td>
						</tr>
						<tr>
							<td align=center style='vertical-align:top'>
								<nobr>";
		if (is_array($catIdsWithBadParentIds)) {
			foreach ($catIdsWithBadParentIds as $value) {
				$GLOBALS['body'] .= $value.'<br/>';
			}
		} else {
			$GLOBALS['body'] .= $catIdsWithBadParentIds;
		}
		$GLOBALS['body'] .= "
								</nobr>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>";
}
####################################################################################

/**
 * This function selects an $element(s) from a $table using a $where_clause (if provided)
 * and returns the result of the query as an array of $returnElements
 *
 * @param ADODB object $db
 * @param string $element
 * @param string $table
 * @param string $key
 * @param integer $value
 * @return array $elements
 */
function getElementArray($db,$elements,$table,$where_clause='')
{
  $element = (is_array($elements)) ? implode($elements,',') : $elements;

  $query = "SELECT $element FROM $table $where_clause";
  $result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
  if ($result->RecordCount()<=0) {
    if (is_array($elements)) {
      foreach ($elements as $value) {
        $returnElements[$value][] = '<span class=error>NONE</span>';
      }
    }
    else {
      $returnElements[] = '<span class=error>NONE</span>';
    }
  }
  else {
    while ($oneRecord = $result->FetchRow()) {
      if (is_array($elements)) {
        foreach ($elements as $value) {
          $returnElements[$value][] = $oneRecord[$value];
        }
      }
      else {
        $returnElements[] = $oneRecord[$elements];
      }
    }
  }
  return $returnElements;
}
####################################################################################

/**
 * NOTE: GP = geodesic_pages, GPL = geodesic_pages_languages
 * GPM = geodesic_pages_messages, GPML = geodesic_pages_messages_languages
 *
 * Finds message_ids and bad text_ids that do not fit the following criteria:
 *
 * 1) message_id in GPM does not map to a text_id in GPML
 * 2) page_id in GPM or GPML does not exist in GP
 * 3) language_id in GPML does not exist in GPL
 *
 * The function then places both sets of ids into one array, removes duplicate values
 * and returns the array.
 *
 * @param ADODB object $db
 * @param array $msgIDs
 * @param array $textIDs
 * @param array $pageIDs
 * @param array $langIDs
 * @return array $allBadIDs
 */
function getBadIDs($db,$msgIDs,$textIDs,$pageIDs,$langIDs)
{
  $in_msgIDs = 'IN ('.implode($msgIDs,',').')';
  $in_txtIDs = 'IN ('.implode($textIDs,',').')';
  $in_pageIDs = 'IN ('.implode($pageIDs,',').')';
  $in_langIDs = 'IN ('.implode($langIDs,',').')';

  //find bad message_id(s)
  $where_clause = "WHERE message_id NOT $in_txtIDs
    OR page_id NOT $in_pageIDs";
  $badMsgIDs = getElementArray($db,'message_id','geodesic_pages_messages',$where_clause);

  //find bad text_id(s)
  $where_clause = "WHERE text_id NOT $in_msgIDs
    OR page_id NOT $in_pageIDs
    OR language_id NOT $in_langIDs";
  $badTextIDs = getElementArray($db,'text_id','geodesic_pages_messages_languages',$where_clause);

  //put them all together and remove repeats
  $allBadIDs = array_unique(array_merge($badMsgIDs,$badTextIDs));
  return $allBadIDs;
}
####################################################################################
/**
 * Displays bad text_ids and message_ids along with their page_ids and the language_id that
 * goes with it's text_id
 *
 * @param ADODB object $db
 */
function examine_text($db)
{
  $msgIDs = getElementArray($db,'message_id','geodesic_pages_messages');
  $textIDs = getElementArray($db,'text_id','geodesic_pages_messages_languages');
  $pageIDs = getElementArray($db,'page_id','geodesic_pages');
  $languages = getLanguages($db);
  foreach ($languages as $lang) {
    $langIDs[] = $lang['language_id'];
  }
  //get bad message_id(s) and bad text_id(s) and put them in one unique array
  $allBadIDs = getBadIDs($db,$msgIDs,$textIDs,$pageIDs,$langIDs);

  $GLOBALS['body'] .= "
    Examining <b>geodesic_pages_messages</b> and <b>geodesic_pages_messages_languages</b> for anomalies<br/>
    <b>NOTE:</b>&nbsp;&nbsp;Currently this tool will NOT find the following:<br/>
    <ul>
      <li>non-matching page_ids for a message_id-text_id match</li>
      <li>combinations of text_id, page_id, and language_id that occur more than once in GPML</li>
      <li>duplicate language_ids for the same text_id,page_id combination in GPML</li>
    </ul>
    Items in <font color=red>red</font> indicate an error.
    <br/><br/>
    ";
  if (isset($allBadIDs)) {
    $GLOBALS['body'] .= "
      <div class=table>
        <div class=row_header>
          <div class=cell>GPM.message_id</div>
          <div class=cell style='border-right:2px solid #000000;'>GPM.page_id</div>
          <div class=cell style='border-left:2px solid #000000;'>GPML.text_id</div>
          <div class=cell>GPML.page_id</div>
          <div class=cell>GPML.language_id</div>
        </div>";
    foreach ($allBadIDs as $badID) {
      //get and organize the message data
      $elements = array ('message_id','page_id');
      $msg = getElementArray($db,$elements,'geodesic_pages_messages','WHERE message_id='.$badID);
      $currentMsgIDs = implode($msg['message_id'],'<br/>');
      $msgPageIDs = implode($msg['page_id'],'<br/>');
      $badMsgPageIDs = array_diff($msg['page_id'],$pageIDs);
      if (isset($badMsgPageIDs)) {
        foreach ($badMsgPageIDs as $badMsgPageID) {
          $errorText = "<span class=error>$badMsgPageID</span>";
          $msgPageIDs = str_replace($badMsgPageID,$errorText,$msgPageIDs);
        }
      }

      //get and organize the text data
      $elements = array ('text_id','page_id','language_id');
      $txt = getElementArray($db,$elements,'geodesic_pages_messages_languages','WHERE text_id='.$badID);
      $currentTxtIDs = implode($txt['text_id'],'<br/>');
      $txtPageIDs = implode($txt['page_id'],'<br/>');
      $txtLangIDs = implode($txt['language_id'],'<br/>');
      $badTxtPageIDs = array_diff($txt['page_id'],$pageIDs);
      if (isset($badTxtPageIDs)) {
        foreach ($badTxtPageIDs as $badTxtPageID) {
          $errorText = "<span class=error>$badTxtPageID</span>";
          $txtPageIDs = str_replace($badTxtPageID,$errorText,$txtPageIDs);
        }
      }
      $badTxtLangIDs = array_diff($txt['language_id'],$langIDs);
      if (isset($badTxtLangIDs)) {
        foreach ($badTxtLangIDs as $badTxtLangID) {
          $errorText = "<span class=error>$badTxtLangID</span>";
          $txtLangIDs = str_replace($badTxtLangID,$errorText,$txtLangIDs);
        }
      }

      $GLOBALS['body'] .= "
        <div class=row>
          <div class=cell>$currentMsgIDs</div>
          <div class=cell style='border-right:2px solid #000000;'>$msgPageIDs</div>
          <div class=cell style='border-left:2px solid #000000;'>$currentTxtIDs</div>
          <div class=cell>$txtPageIDs</div>
          <div class=cell>$txtLangIDs</div>
        </div>";
    }

    //close the table
    $GLOBALS['body'] .= "
      </div>";
  }
}
####################################################################################

function test_authorizenet($db)
{
	$sql_query = "select * from geodesic_cc_authorizenet";
	$authorize_result = $db->Execute($sql_query);
	if (!$authorize_result)
	{
		echo "authorize.net table does not exist<Br>\n";
		exit;
	}
	elseif ($authorize_result->RecordCount() == 1)
	{
		$show=$authorize_result->FetchRow();
		$username = $show["merchant_login"];
		$password = $show["merchant_password"];
		$trans_key = $show["transaction_key"];

		//echo $username." is username<Br>\n";
		//echo $password." is the password<BR>\n";
		//echo $trans_key." is the transaction key<BR>\n";

		srand((double)microtime()*1000000);

		$cc_url = "x_First_Name=Joe&x_Last_Name=Mama&x_Company=Geodesic+Solutions&x_Address=address+&x_City=city&x_State=state&x_Country=country&x_Zip=zipcode&x_Phone=phone&x_Email=geoclassifieds%40geodesicsolutions.com&x_Customer_Organization_Type=B&x_Type=AUTH_CAPTURE&x_Description=classified+ad+placement&x_Version=3.1&x_Method=CC&x_PO_Num=";
		$x_PO_Num = rand(1000000,9999999);
		$cc_url .= $x_PO_Num;
		$cc_url .= "&x_Invoice_Num=";
		$x_Invoice_Num = rand(1000000,9999999);
		$cc_url .= $x_Invoice_Num;
		$cc_url .= "&x_Customer_IP=".$_SERVER["REMOTE_ADDR"]."&x_Tran_Key=".$trans_key."&x_Amount=";
		$x_Amount = rand(1,20);
		$cc_url .= $x_Amount;
		$cc_url .= "&x_Login=".$username."&x_Password=".$password."&x_Cust_ID=1&x_Card_Num=4007000000027&x_Exp_Date=0110";

		$ch = curl_init();
		//echo "CURLOPT_VERBOSE is set to 1(yes to display debugging information)<br><br>";
		//curl_setopt ($ch, CURLOPT_VERBOSE, 1);
		curl_setopt($ch, CURLOPT_REFERER, $_SERVER["SERVER_NAME"].$_SERVER["SCRIPT_NAME"]);
		curl_setopt($ch, CURLOPT_URL, "https://secure.authorize.net/gateway/transact.dll");
		curl_setopt ($ch, CURLOPT_POST, 1);
		curl_setopt ($ch, CURLOPT_POSTFIELDS, $cc_url);
		curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);

		/* this is for godaddy
		this may need to be worked into the base code0
		curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, TRUE);
		curl_setopt ($ch, CURLOPT_PROXYTYPE, "CURLPROXY_HTTP");
		curl_setopt ($ch, CURLOPT_PROXY, "http://64.202.165.130:3128");
		curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		*/

		//curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, 0);

		$authorizenet_result = curl_exec ($ch);

		curl_close ($ch);

		if ($authorizenet_result)
		{
			echo "THIS IS THE RAW CURL OUTPUT<BR>".$authorizenet_result."<BR><BR>\n";
			echo strlen($authorizenet_result)." is the string length of the data returned from curl<BR>\n";
		}
		else
		{
			echo "There is no result returned...<BR>\n";
			echo strlen($authorizenet_result)." is the string length of the data returned from curl<BR>\n";
			exit;
		}


		$resultarray = explode("|", $authorizenet_result);

		if (count($resultarray) > 0)
		{
			$resultFields = Array(
						"x_response_code",
						"x_response_subcode",
						"x_response_reason_code",
						"x_response_reason_text",
						"x_auth_code",
						"x_avs_code",
						"x_trans_id",
						"x_invoice_num",
						"x_description",
						"x_amount",
						"x_method",
						"x_type",
						"x_cust_id",
						"x_first_name",
						"x_last_name",
						"x_company",
						"x_address",
						"x_city",
						"x_state",
						"x_zip",
						"x_country",
						"x_phone",
						"x_fax",
						"x_email",
						"x_ship_to_first_name",
						"x_ship_to_last_name",
						"x_ship_to_company",
						"x_ship_to_address",
						"x_ship_to_city",
						"x_ship_to_state",
						"x_ship_to_zip",
						"x_ship_to_country",
						"x_tax",
						"x_duty",
						"x_freight",
						"x_tax_exempt",
						"x_po_num",
						"x_md5_hash");

			reset($resultarray);
			foreach ($resultarray as $key => $value)
			{
				$this->transaction_results[$resultFields[$key]] = $value;
				$temp .= $resultFields[$key]." = ".$value."<br>";
			}
			echo "THIS IS THE CLEANED UP OUTPUT OF AUTHORIZENET<Br>".$temp."<bR>";
		}
		else
		{
			echo "nothing returned from authorize.net<BR>\n";
		}
	}
	else
	{
		echo "nothing in the authorize.net table<BR>\n";
		exit;
	}
} //end of function test_authorizenet

####################################################################################

function getAdminLogin($db)
{
	$error = 0;
	$username = '';
	$password = '';
	//get admin username
	$sql_query = "select * from geodesic_classifieds_logins where id = 1";
	$result = $db->Execute($sql_query);
	//$GLOBALS['body'] .= $sql_query."<br/>\n";
	if (!$result)
	{
		$sql_query2 = "select * from geodesic_logins where id = 1";
		$new_result = $db->Execute($sql_query2);
		//$GLOBALS['body'] .= $sql_query."<br/>\n";
		if (!$new_result)
		{
			$sql_query = "select * from geodesic_auctions_logins where id = 1";
			$auction_result = $db->Execute($sql_query);
			//$GLOBALS['body'] .= $sql_query."<br/>\n";
			if (!$auction_result)
			{
				$GLOBALS['body'] .= '<br/>'.$db->ErrorMsg()."<br/>\n";
				$GLOBALS['body'] .= "failed 1<br/>\n";
			}
			elseif ($auction_result->RecordCount() == 1)
			{
				$show_new = $auction_result->FetchRow();
				$GLOBALS['body'] .= "<b>".$show_new['username']."</b> is the username<br/>\n";
				$GLOBALS['body'] .= "<b>".$show_new['password']."</b> is the password<br/>\n";
				$username = $show_new['username'];
				$password = $show_new['password'];
			}
		}
		elseif ($new_result->RecordCount() == 1)
		{
			$show_new = $new_result->FetchRow();
			$GLOBALS['body'] .= "<b>".$show_new['username']."</b> is the username<br/>\n";
			$GLOBALS['body'] .= "<b>".$show_new['password']."</b> is the password<br/>\n";
			$username = $show_new['username'];
			$password = $show_new['password'];
		}
		else
		{
			$GLOBALS['body'] .= "failed 2<br/>";
			$error++;
		}
	}
	elseif ($result->RecordCount() == 1)
	{
		$show = $result->FetchRow();
		$GLOBALS['body'] .= "<b>".$show['username']."</b> is the username<br/>\n";
		$GLOBALS['body'] .= "<b>".$show['password']."</b> is the password<br/>\n";
		$username = $show['username'];
		$password = $show['password'];
	}
	else
	{
		$GLOBALS['body'] .= "failed 2<br/>";
		$error++;
	}
	if (!$error && strlen($username)>0 && strlen($password)>0)
		$GLOBALS['body'] .= "
			<form action='../admin/index.php' method=post>
				<input type=hidden name=b[username] value='".$username."' />
				<input type=hidden name=b[password] value='".$password."' />
				<input type=submit value='Click to login in' />
			</form>
			";
}
####################################################################################

/**
 * Enter description here...
 *
 * @param ADODB object $db
 * @param string|array $dataSource
 */
function cc_initiate_paypal_pro($db,$dataSource='')
{
  if (strlen($dataSource)<=0) {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
    display_page();
    exit;
  }

  require_once '../Services/PayPal.php';
  require_once '../Services/PayPal/Profile/Handler/Array.php';
  require_once '../Services/PayPal/Profile/API.php';

  $certpass = '';//NOT USED BY PAYPAL AT THIS TIME
  $subject = null;//THIRD PARTY

  if ($dataSource=='geoTestData') {

    //MERCHANT DATA
    $environment = 'Sandbox';
    $apiusername = 'receiver_api1.geodesicsolutions.com';
    $apipassword = 'receiverreceiver';
    if (strpos(dirname(__FILE__),'/') !== FALSE)
    	$certfile = dirname(__FILE__)."/Services/PayPal/cert/geo_cert_key_pem.txt";
    else
    	$certfile = dirname(__FILE__)."\Services\PayPal\cert\geo_cert_key_pem.txt";
    $currencyID = 'USD';
    $charset = 'iso-8859-1';

    //USER DATA
    $userFirstName = 'John';
    $userLastName = 'Smith';
    $userAddress = '123 Main St.';
    $userCity = 'SomeCity';
    $userState = 'TX';
    $userZip = '12345';
    $userCountry = 'US';
    $cc_type = 'Visa';
    $cc_number = '4971517491601381';
    $cvv2_code = '000';
    $cc_exp_month = '01';
    $cc_exp_year = '2007';
    $total = '100.00';
  }
  elseif (is_array($dataSource)) {

    //MERCHANT DATA
    $environment = $dataSource['environment'];
    $apiusername = $dataSource['apiusername'];
    $apipassword = $dataSource['apipassword'];
    $certfile = $dataSource['certfile'];
    $currencyID = $dataSource['currencyID'];
    $charset = $dataSource['charset'];

    //USER DATA
    $userFirstName = $dataSource['firstname'];
    $userLastName = $dataSource['lastname'];
    $userAddress = $dataSource['address'];
    $userCity = $dataSource['city'];
    $userState = $dataSource['state'];
    $userZip = $dataSource['zip'];
    $userCountry = $dataSource['country'];
    $cc_type = $dataSource['cc_type'];
    $cc_number = $dataSource['cc_number'];
    $cvv2_code = $dataSource['cvv2'];
    $cc_exp_month = $dataSource['month'];
    $cc_exp_year = $dataSource['year'];
    $total = $dataSource['total'];
  }
  else {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
    display_page();
    exit;
  }

  $ipAddress = Site::getip();

  //*****************************************************************************
  //SELLER'S DATA
  $handler =& ProfileHandler_Array::getInstance(array(
  	'username' => $apiusername,
  	'certificateFile' => $certfile,
  	'subject' => $subject,
  	'environment' => $environment));
  if (Services_PayPal::isError($handler))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($handler);
  	display_page();
  	exit;
  }
  $profile =& APIProfile::getInstance($apiusername, $handler);
  if (Services_PayPal::isError($profile))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($profile);
  	display_page();
  	exit;
  }
  $profile->setAPIPassword($apipassword);
  $caller =& Services_PayPal::getCallerServices($profile);

  //PROXY SERVER SETTINGS - SET THE PROXY URL AND UNCOMMENT
  //$caller->setOpt('curl', CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
  //$caller->setOpt('curl', CURLOPT_PROXY, 'http://11.11.11.11:1111');
  //MAY OR MAY NOT BE NEEDED - CHOOSE TRUE OR FALSE AND SET THE 'time' BEFORE UNCOMMENTING
  //$caller->setOpt('curl', CURLOPT_SSL_VERIFYPEER, TRUE/FALSE);
  //$caller->setOpt('curl', CURLOPT_TIMEOUT, time);

  if (Services_PayPal::isError($caller))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($caller);
  	display_page();
  	exit;
  }
  $Address =& Services_PayPal::getType('AddressType');
  if (Services_PayPal::isError($Address))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($Address);
  	display_page();
  	exit;
  }

  //*****************************************************************************
  //BUYER'S DATA
  $OrderTotal =& Services_PayPal::getType('BasicAmountType');
  if (Services_PayPal::isError($OrderTotal))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($OrderTotal);
  	display_page();
  	exit;
  }
  $OrderTotal->setattr('currencyID', $currencyID);
  $OrderTotal->setval($total, $charset);
  $PaymentDetails =& Services_PayPal::getType('PaymentDetailsType');
  if (Services_PayPal::isError($PaymentDetails))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($PaymentDetails);
  	display_page();
  	exit;
  }
  $PaymentDetails->setOrderTotal($OrderTotal);
  $PayerName =& Services_PayPal::getType('PersonNameType');
  if (Services_PayPal::isError($PayerName))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($PayerName);
  	display_page();
  	exit;
  }
  $PayerName->setLastName($userLastName, $charset);
  $PayerName->setFirstName($userFirstName, $charset);
  $CardOwner =& Services_PayPal::getType('PayerInfoType');
  if (Services_PayPal::isError($CardOwner))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($CardOwner);
  	display_page();
  	exit;
  }
  $Address->setPostalCode($userZip, $charset);
  $Address->setCountry($userCountry, $charset);
  $Address->setStateOrProvince($userState, $charset);
  $Address->setCityName($userCity, $charset);
  $Address->setStreet1($userAddress, $charset);
  $CardOwner->setAddress($Address);
  $CardOwner->setPayerCountry($userCountry, $charset);
  $CardOwner->setPayerName($PayerName);

  $CreditCard =& Services_PayPal::getType('CreditCardDetailsType');
  if (Services_PayPal::isError($CreditCard))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($CreditCard);
  	display_page();
  	exit;
  }
  $CreditCard->setCreditCardType($cc_type);
  $CreditCard->setCardOwner($CardOwner);
  $CreditCard->setExpYear($cc_exp_year, $charset);
  $CreditCard->setExpMonth($cc_exp_month, $charset);
  $CreditCard->setCreditCardNumber($cc_number, $charset);
  $CreditCard->setCVV2($cvv2_code, $charset);

  //******************************************************************************
  //PROCESS DATA
  $DoDirectPaymentRequestDetails =& Services_PayPal::getType('DoDirectPaymentRequestDetailsType');
  if (Services_PayPal::isError($DoDirectPaymentRequestDetails))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($DoDirectPaymentRequestDetails);
  	display_page();
  	exit;
  }
  $DoDirectPaymentRequestDetails->setIPAddress($ipAddress, $charset);
  $DoDirectPaymentRequestDetails->setCreditCard($CreditCard);
  $DoDirectPaymentRequestDetails->setPaymentDetails($PaymentDetails);
  $DoDirectPaymentRequestDetails->setPaymentAction('Sale', $charset);
  $DoDirectPayment =& Services_PayPal::getType('DoDirectPaymentRequestType');
  if (Services_PayPal::isError($DoDirectPayment))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($DoDirectPayment);
  	display_page();
  	exit;
  }
  $DoDirectPayment->setDoDirectPaymentRequestDetails($DoDirectPaymentRequestDetails);
  $response = $caller->DoDirectPayment($DoDirectPayment);
  if (Services_PayPal::isError($response))
  {
    $GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	$GLOBALS['body'] .= Site::expand_array($DoDirectPayment);
  	display_page();
  	exit;
  }
  

	//show info used
	//MERCHANT DATA
	$GLOBALS['body'] .= "<div>###########   MERCHANT DATA THAT WAS SENT  ###########</div>";
  $GLOBALS['body'] .= "<div>PayPal API Username: <span style='color:blue'>".$apiusername."</span></div>";
	$GLOBALS['body'] .= "<div>PayPal API Password: <span style='color:blue'>".$apipassword."</span></div>";
	$GLOBALS['body'] .= "<div>Path to Certificate: <span style='color:blue'>".$certfile."</span></div>";
  $GLOBALS['body'] .= "<div>Environment: <span style='color:blue'>".$environment."</span></div>"; 
  $GLOBALS['body'] .= "<div>PayPal Currency Code: <span style='color:blue'>".$currencyID."</span></div>"; 
  $GLOBALS['body'] .= "<div>Character Set: <span style='color:blue'>".$charset."</span></div>"; 
  
  //USER DATA
	$GLOBALS['body'] .= "<div>###########   CUSTOMER DATA THAT WAS SENT   ###########</div>";
	$GLOBALS['body'] .= "<div>First Name: <span style='color:blue'>".$userFirstName."</span></div>";
	$GLOBALS['body'] .= "<div>Last Name: <span style='color:blue'>".$userLastName."</span></div>";
	$GLOBALS['body'] .= "<div>Address: <span style='color:blue'>".$userAddress."</span></div>";
	$GLOBALS['body'] .= "<div>City: <span style='color:blue'>".$userCity."</span></div>";
	$GLOBALS['body'] .= "<div>State: <span style='color:blue'>".$userState."</span></div>";
	$GLOBALS['body'] .= "<div>Zip: <span style='color:blue'>".$userZip."</span></div>";
	$GLOBALS['body'] .= "<div>Country: <span style='color:blue'>".$userCountry."</span></div>";
	$GLOBALS['body'] .= "<div>Credit Card Type: <span style='color:blue'>".$cc_type."</span></div>";
	$GLOBALS['body'] .= "<div>Credit Card #: <span style='color:blue'>".$cc_number."</span></div>";
	$GLOBALS['body'] .= "<div>Card Verification #: <span style='color:blue'>".$cvv2_code."</span></div>";
	$GLOBALS['body'] .= "<div>Expiration Date (M/Y): <span style='color:blue'>".$cc_exp_month." / ".$cc_exp_year."</span></div>";
	$GLOBALS['body'] .= "<div>Total Charged: <span style='color:blue'>".$total."</span></div>";
  
  
  //SUCCESSFUL CONNECTION
  $GLOBALS['body'] .= "<div style='color:green'>SUCCESSFUL CONNECTION TO PAYPAL!!!</div>";
  
  if ($response->Ack == 'Success') {
    $GLOBALS['body'] .= "<div>Response: <span style='color:green'>".$response->Ack."</span></div>";
  }
  elseif ($response->Ack == 'Failure') {
    $GLOBALS['body'] .= "<div>Response: <span class=error>".$response->Ack."</span><br/>";
    $GLOBALS['body'] .= "Reason: ".$response->Errors->LongMessage."</div>";
  }
  else {
    //SHOW EVERYTHING
    $GLOBALS['body'] .= Site::expand_array($response);
  }
}
####################################################################################

/**
 * Gets the merchant's API info for PayPal Pro
 *
 * @param ADODB object $db
 * @return array $merchantData
 */
function getPayPalMerchantInfo($db)
{
  $query = "SELECT * FROM geodesic_cc_paypal";
  $cc_table_result = $db->Execute($query);
  if (!$cc_table_result) {
  	$GLOBALS['body'] .= '<div class=error>UNSUCCESSFUL CONNECTION<br/>ERROR ON LINE '.__LINE__.'</div>';
  	display_page();
  	exit;
  }
  $show_cc_paypal = $cc_table_result->FetchRow();
  $merchantData = array (
    'apiusername' => $show_cc_paypal["api_username"],
    'apipassword' => $show_cc_paypal["api_password"],
    'certfile' => $show_cc_paypal["certfile"],
    'currencyID' => $show_cc_paypal["currency_id"],
    'charset' => $show_cc_paypal["charset"]);
  return $merchantData;
}
####################################################################################

function inputPayPalTestForm($db)
{
  $merchantData = getPayPalMerchantInfo($db);
  $currencyDropDown = "
    <select name=b[currencyID]>
			<option value='AUD' ".(($merchantData['currencyID']=='AUD')?"selected":"").">AUD - Australian Dollar</option>
			<option value='CAD' ".(($merchantData['currencyID']=='CAD')?"selected":"").">CAD - Canadian Dollar</option>
			<option value='EUR' ".(($merchantData['currencyID']=='EUR')?"selected":"").">EUR - Euro</option>
			<option value='GBP' ".(($merchantData['currencyID']=='GBP')?"selected":"").">GBP - Pound Sterling</option>
			<option value='JPY' ".(($merchantData['currencyID']=='JPY')?"selected":"").">JPY - Japanese Yen</option>
			<option value='USD' ".(($merchantData['currencyID']=='USD')?"selected":"").">USD - U.S. Dollar</option>
		</select>";

  $charsetDropDown = "
    <select name=b[charset]>
			<option value='us-ascii' ".(($merchantData['charset']=='us-ascii')?"selected":"").">US-ASCII</option>
			<option value='utf-8' ".(($merchantData['charset']=='utf-8')?"selected":"").">UTF-8</option>
			<option value='iso-8859-1' ".(($merchantData['charset']=='iso-8859-1')?"selected":"").">ISO-8859-1</option>
		</select>";
  $countryDropDown = "
    <select name=b[country]>
      <option value='AI'>Anguilla AI</option><option value='AR'>Argentina AR</option><option value='AU'>Australia AU</option>
      <option value='AT'>Austria AT</option><option value='BE'>Belgium BE</option><option value='BR'>Brazil BR</option>
      <option value='CA'>Canada CA</option><option value='CL'>Chile CL</option><option value='CN'>China CN</option>
      <option value='CR'>Costa Rica CR</option><option value='DK'>Denmark DK</option><option value='DO'>Dominican Republic DO</option>
      <option value='EC'>Ecuador EC</option><option value='FI'>Finland FI</option><option value='FR'>France FR</option>
      <option value='DE'>Germany DE</option><option value='GR'>Greece GR</option><option value='HK'>Hong Kong HK</option>
      <option value='IS'>Iceland IS</option><option value='IN'>India IN</option><option value='IE'>Ireland IE</option>
      <option value='IL'>Israel IL</option><option value='IT'>Italy IT</option><option value='JM'>Jamaica JM</option>
      <option value='JP'>Japan JP</option><option value='LU'>Luxembourg LU</option><option value='MY'>Malaysia MY</option>
      <option value='MX'>Mexico MX</option><option value='MC'>Monaco MC</option><option value='NL'>Netherlands NL</option>
      <option value='NZ'>New Zealand NZ</option><option value='NO'>Norway NO</option><option value='PT'>Portugal PT</option>
      <option value='SG'>Singapore SG</option><option value='KR'>South Korea KR</option><option value='ES'>Spain ES</option>
      <option value='SE'>Sweden SE</option><option value='CH'>Switzerland CH</option><option value='TH'>Thailand TH</option>
      <option value='TW'>Taiwan TW</option><option value='TR'>Turkey TR</option><option value='GB'>United Kingdom GB</option>
      <option value='US' selected>United States US</option><option value='UY'>Uruguay UY</option><option value='VE'>Venezuela VE</option>
    </select>";
  $ccTypeDropDown = "
    <select name=b[cc_type]>
			<option value='Visa' selected>Visa</option>
			<option value='MasterCard'>MasterCard</option>
			<option value='Amex'>American Express</option>
			<option value='Discover'>Discover</option>
		</select>";

  $GLOBALS['body'] .= "
    <div class=title>
      PayPal Pro Test Utility
    </div>
    <form action=geodiagnostic.php?a=11 method=post>
      <div class=large_font>
        Enter Merchant Information Below<br/>
        <span class=very_small_font>Prepopulated data is what is in the merchant's database and is also what will normally be submitted to PayPal Pro.<br>
        Submitting this form will NOT change the merchant's database.</span>
      </div>
      <div style='float:left'><input type=radio name=b[environment] value='live' checked='checked' /></div><div>live</div>
      <div style='float:left'><input type=radio name=b[environment] value='sandbox'/></div><div>sandbox</div>
      <div style='float:left'>PayPal API Username:&nbsp;</div><div><input type=text size=30 name=b[apiusername] value='".$merchantData['apiusername']."' /></div>
      <div style='float:left'>PayPal API Password:&nbsp;</div><div><input type=password size=30 name=b[apipassword] value='".$merchantData['apipassword']."' /></div>
      <div style='float:left'>Path to Certificate:&nbsp;</div><div><input type=text size=80 name=b[certfile] value='".$merchantData['certfile']."' /></div>
      <div class=very_small_font style='float:left'><i>Path to this directory</i>:&nbsp;</div><div class=very_small_font><b>".dirname(__FILE__)."</b></div>
      <div style='float:left'>PayPal Currency Code:&nbsp;</div><div>$currencyDropDown</div>
      <div style='float:left'>Character Set:&nbsp;</div><div>$charsetDropDown</div>
      <br/>
      <div class=large_font>
        Enter Credit Card User Data Below<br/>
        <span class=very_small_font>Data below will normally come from the user's registered data in geodesic_userdata
      </div>
      <div style='float:left'>First Name:&nbsp;</div><div><input type=text name=b[firstname] value='' /></div>
      <div style='float:left'>Last Name:&nbsp;</div><div><input type=text name=b[lastname] value='' /></div>
      <div style='float:left'>Address:&nbsp;</div><div><input type=text name=b[address] value='' /></div>
      <div style='float:left'>City:&nbsp;</div><div><input type=text name=b[city] value='' /></div>
      <div style='float:left'>State:&nbsp;</div><div><input type=text name=b[state] value='' /></div>
      <div style='float:left'>Zip:&nbsp;</div><div><input type=text name=b[zip] value='' /></div>
      <div style='float:left'>Country:&nbsp;</div><div>$countryDropDown</div>
      <div style='float:left'>Credit Card Type:&nbsp;</div><div>$ccTypeDropDown</div>
      <div style='float:left'>Credit Card #:&nbsp;</div><div><input type=text name=b[cc_number] value='' /></div>
      <div style='float:left'>Card Verification #:&nbsp;</div><div><input maxlength=4 size=4 type=text name=b[cvv2] value='' /></div>
      <div style='float:left'>Expiration Date (M/Y):&nbsp;</div><div><input maxlength=2 size=2 type=text name=b[month] value='' />/<input type=text maxlength=4 size=4 name=b[year] value='2006' /></div>
      <div style='float:left'>Total Amount to Charge:&nbsp;</div><div><input type=text name=b[total] value='' /> (currency type selected above)</div>
      <div><input type=submit name='submit' value='Connect to PayPal Pro USING DATA ABOVE' /></div>
    </form>
    <form action=geodiagnostic.php?a=11&b=geoTestData method=post>
      <div><input type=submit name='submit' value='Connect to PayPal Pro USING GEODESIC TEST DATA' /></div>
    <form>";
}

function checkForProxy() {
	$proxyChecks = array(
		"HTTP_X_FORWARDED_FOR",
		"HTTP_X_FORWARDED_HOST",
		"HTTP_X_FORWARDED_SERVER",
		"HTTP_VIA"
	);

	$header = array();
	foreach($_SERVER as $header => $value) {
		if(in_array($header, $proxyChecks)) {
			$headers[$header] = $value;
		}
	}

	if(count($headers)) {
		echo "
			<strong>Proxy detected!</strong><br />
			<strong>Original IP:</strong> ".($headers['HTTP_X_FORWARDED_FOR'] ? $headers['HTTP_X_FORWARDED_FOR'] : "Unknown")."<br />
			<strong>Via</strong>: ".($headers['HTTP_VIA'] ? $headers['HTTP_VIA'] : "Unknown")."<br />";
			if(stristr(@$headers['HTTP_VIA'], "squid"))
				echo "<strong>Probably using Squid</strong><br />";
	} else
		echo "<strong>No proxy detected</strong><br />";

	echo "
		<strong>Public IP:</strong> ".$_SERVER['REMOTE_ADDR']."<br />
		<em>This tool is unable to detect transparent/anonymous proxies</em><br />";
}
####################################################################################

/**
 * Function that checks for requirements needed by the PayPal Websites Payment Pro
 * 
 * @return String Returns string of HTML that displays the results of the test.
 */
function display_cc_paypal_pro_requirment_check(){
	
	$results = array();
	
	//These are the pass or fail messages to display.
	$pass="\n".'<li><span style="color:green;">PASSED</span>';
	$fail = "\n".'<li><span style="color:red;">FAILED</span>';
	
	//Check that perl compatible regular expression extension is installed
	@ preg_match('[est]', 'This is a simple Test', $regtest);
	
	if ($regtest[0]=='est'){
		$results[0.5]=true;
	}
	//Check for cURL
	if (@ function_exists('curl_version') ){ 
		$results[1]=true;
	}
	//check for openSSL
	if (@ function_exists ('openssl_sign')){
		$results[1.5] = true;
	}
	//Check for main PEAR libraries
	if (@ include_once ('PEAR.php')){ 
		$results[2]=true;
		//check for Net_URL
		if (@ include_once ('Net/URL.php')){ @
			$results[3]=true;
		}
		//check for Net_Socket
		if (@ include_once ('Net/Socket.php')){ @
			$results[4]=true;
		}
		//check for HTTP_Request
		if (@ include_once ('HTTP/Request.php')){ @
			$results[5]=true;
		}
		//Check for Log
		if (@ include_once ('Log.php')){ @
			$results[6]=true;
		}
	}
	
	//Now output the results in a nice way.
	
	$return_string = "Checking requirements for PayPal Pro:";
	$return_string .= "<ul>";
	
	//check regular expression extension
	if ($results[0.5]){
		$return_string .= $pass;
	} else {
		$return_string .= $fail;
	}
	$return_string .= ' -- PHP Perl Compatible Regular Expressions extension for PHP 4.3.0+ and higher</li>';
	
	if ($results[1]){ 
		$return_string .= $pass;
	} else {
		$return_string .= $fail;
	}
	
	$return_string .= "\n -- PHP cURL extension for PHP 4.3.0+ and higher with SSL support</li>";
	
	//openssl test
	if ($results[1.5]){
		$return_string .= $pass;
	}
	else {
		$return_string .= $fail;
	}
	$return_string .= ' -- PHP OpenSSL extension for PHP 4.3.0+ and higher (for digital certificate transcoding)</li>';
	
	//test for pear libraries
	$return_string .= "</ul>Needed PEAR Packages:";
	$return_string .= "<ul>";
	
	if ($results[2]){
		$return_string .= $pass;
	} else {
		$return_string .= $fail;
	}
	$return_string .= " -- Main PEAR Library</li>";
	//check rest of pear stuff here
	
	//check net_URL
	if ($results[3]){
		$return_string .= $pass;
	} else {
		$return_string .= $fail;
	}
	$return_string .= " -- PEAR Net_URL</li>";
	
	//check net_socket
	if ($results[4]){
		$return_string .= $pass;
	} else {
		$return_string .= $fail;
	}
	$return_string .= " -- PEAR Net_Socket</li>";
	
	//check HTTP_Request
	if ($results[5]){
		$return_string .= $pass;
	} else {
		$return_string .= $fail;
	}
	$return_string .= " -- PEAR HTTP_Request</li>";
	
	//check Log
	if ($results[6]){
		$return_string .= $pass;
	} else {
		$return_string .= $fail;
	}
	$return_string .= " -- PEAR Log</li></ul>";
	
	return $return_string;
	
} //End of function display_cc_paypal_pro_requirment_check

####################################################################################
####################################################################################

session_start();
$maxTime = '3600';
if (!isset($_SESSION['time'])) $_SESSION['time']=time();
if ((time()-$_SESSION['time']) > $maxTime) {
	//IT'S BEEN TOO LONG, SO LOG USER OUT
	unset($_SESSION['loggedIn']);
	unset($_SESSION['time']);
}
$_SESSION['debug']=0;
$_SESSION['showToolTips']=(file_exists('overlib.js'))?1:0;

include('../config.php');
if (file_exists('../classes/ADODB.inc.php'))
  include_once('../classes/ADODB.inc.php');
elseif (file_exists('../classes/adodb.inc.php'))
  include_once('../classes/adodb.inc.php');
include_once('../classes/site_class.php');

$db = &ADONewConnection('mysql');

if($persistent_connections)
{
	//$GLOBALS['body'] .= ' Persistent Connection <br/>';
	if (!$db->PConnect($db_host, $db_username, $db_password, $database))
	{
		$GLOBALS['body'] = 'could not connect to database';
		if ($get_execution_time) get_end_time($starttime);
		exit;
	}
}
else
{
	//$GLOBALS['body'] .= ' No Persistent Connection <br/>';
	//$GLOBALS['body'] .= $db_host.' is db_host<br/>\n';
	//$GLOBALS['body'] .= $db_username.' is db_username<br/>\n';
	//$GLOBALS['body'] .= $db_password.' is db_password<br/>\n';
	//$GLOBALS['body'] .= $database.' is database<br/>\n';
	//$GLOBALS['body'] .= $db.' is db<br/>\n';
	if (!$db->Connect($db_host, $db_username, $db_password, $database))
	{
		$GLOBALS['body'] = 'could not connect to database';
		if ($get_execution_time) get_end_time($starttime);
		exit;
	}
}
if (!isset($_SESSION['loggedIn'])) {
	IF ($_SESSION['debug']) ECHO "<br/>LINE - ".__LINE__;
	$authorized = false;
	if (isset($_REQUEST['b'])) {
		unset($_SESSION['loginError']);
		$md5UserName = (strlen($_REQUEST['b']['username'])>0) ? md5($_REQUEST['b']['username']) : 0;
		$md5PassWord = (strlen($_REQUEST['b']['password'])>0) ? md5($_REQUEST['b']['password']) : 0;
		$authorized = authenticate($md5UserName,$md5PassWord);
	}
	if (!$authorized) {
		loginForm();
		display_page();
		exit;
	} else {
		$_SESSION['loggedIn'] = true;
		$_SESSION['time'] = time();
	}
}

switch ($_REQUEST['a'])
{
	case 1:
		$msg = '';
		if (strlen($_REQUEST['b'])>0) {
			$query = stripslashes(rawurldecode($_REQUEST['b']));
			$result = $db->Execute($query);
			if ($db->ErrorMsg()) {
				$msg = "You had an error in your query.<br/>Error message - ".$db->ErrorMsg();
			} else {
				$msg = "Query Successful !!!<br/>
					Number or rows affected - ".$db->Affected_Rows();
			}
		}
		displayQueryForm($msg);
		break;

	case 2:
		//show/test group info
		test_and_display_group_info($db);
		break;

	case 3:
		getAdminLogin($db);
		break;

	case 4:
		//display config.php information
		$GLOBALS['body'] .= "<table><tr><td colspan=2>config.php information</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$db_host: </td><td>".$db_host."</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$db_username: </td><td>".$db_username."</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$db_password: </td><td>".$db_password."</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$database: </td><td>".$database."</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$api_db_host: </td><td>".$api_db_host."</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$api_db_username: </td><td>".$api_db_username."</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$api_db_password: </td><td>".$api_db_password."</td></tr>";
		$GLOBALS['body'] .= "<tr><td>\$api_database: </td><td>".$api_database."</td></tr>";
		$GLOBALS['body'] .= "</table>";
		break;

	case 5:
		remove_extraneous_group_affiliate_languages($db);
		break;

	case 6:
		phpinfo();
		break;

	case 7:
		//increase paypal account value to accomodate paypal invoice id
		if ($_REQUEST['paypal_id'] && is_numeric($_REQUEST['paypal_id']))
		{
			$insert_paypal_id = $_REQUEST['paypal_id'];
		}
		else
		{
			$insert_paypal_id = 25000000;
		}
		$sql_query = "insert into geodesic_paypal_transactions (transaction_id) values (".$insert_paypal_id.")";
		$result = &$db->Execute($sql_query);
		if (!$result)
		{
			$GLOBALS['body'] .= "error inserting<br/>\n";
			$GLOBALS['body'] .= $sql_query."<br/>\n";
			$GLOBALS['body'] .= '<br/>'.$db->ErrorMsg()."<br/>\n";
		}
		else
		{
			$GLOBALS['body'] .= "paypal transaction id updated<br/>\n";
		}
		break;

	case 8:
		$sql_query = "select * geodesic_classifieds_configuration";
		$result = &$db->Execute($sql_query);
		if (!$result)
		{
			$GLOBALS['body'] .= " error in getting configuration data<br/>\n";
		}
		else
		{
			$configuration_data = $result->FetchRow();
			$GLOBALS['body'] .= "
				<table>
					<tr>
						<td>site_url:</td>
						<td>".$configuration_data['site_url']."</td>
					</tr>
				</table>";
		}
		break;

	case 9:
	  //CATEGORY ANALYSIS
		if (strlen($_REQUEST['b'])>0) {
			$query = substr(stripslashes(rawurldecode($_REQUEST['b'])),1,-1);
			$result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
		}
		examine_categories($db);
		break;

	case 10:
	  //TEXT ANALYSIS
		if (strlen($_REQUEST['b'])>0) {
			$query = substr(stripslashes(rawurldecode($_REQUEST['b'])),1,-1);
			$result = $db->Execute($query) or die('Error on line - '.__LINE__.'<br/>'.$query);
		}
		examine_text($db);
		break;

	case 11:
		$GLOBALS['body'].= display_cc_paypal_pro_requirment_check();
	    if (isset($_REQUEST['b']))
	      	cc_initiate_paypal_pro($db,$_REQUEST['b']);
	    else 
	    	inputPayPalTestForm($db);
		break;
		
	case 12:
		test_authorizenet($db);
		break;

	case 13:
		if (insert_language_group_affiliate_record($db,$_REQUEST["b"],$_REQUEST["c"]))
			test_and_display_group_info($db);
		else
			echo "<font color=#990000>there was an error inserting the group affiliate entryB<r>\n";
    	break;

	case 14:
		checkForProxy();
    	break;

	case 'logout':
		//LOG OUT
		unset($_SESSION['loggedIn']);
		header("Location: ".$_SERVER["PHP_SELF"]);
		break;

	default:
		IF ($_SESSION['debug']) ECHO "<br/>LINE - ".__LINE__;
		//display the home page
		$GLOBALS['body'] .= "<table style='width:100%'>";
		$GLOBALS['body'] .= "<tr><td colspan=100% align=center class=title>Diagnostic Tool Home</td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=1>Run queries</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=2>Show groups</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=3>Get admin login</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=4>Display config.php info</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=6>PHP info</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=7>Reset Paypal id</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=9>Examine categories</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=10>Examine text</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=11>Test PayPal Pro</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=12>Test Authorize.net connection</a></td></tr>";
		$GLOBALS['body'] .= "<tr><td><a href=geodiagnostic.php?a=14>Check for proxy server</a></td></tr>";
		$GLOBALS['body'] .= "</table>\n";
		break;

} //end of switch ($a)


display_page();
exit;
?>
