﻿
class bubblemonkey.utility.DrawShapes {
	
	/** empty constructor
	*	since this class only contain static functions, it should not be instantiated
	*/
	public function DrawShapes() {
		trace ("DrawRect is a static class and should not be instantiated");
	}
	
	/** draws rectangle
	*	input parameters:
	*	mc:MovieClip - container movieclip where you want the rectangle to be created in
	*	rWidth:Number, rHeight:Number - dimensions (width and height respectively) of the proposed rectangle
	* 	rColor:Number - the color of the proposed rectangle in hexadecimal code
	*	rAlpha:Number - (0 - 100) the transparency of the proposed rectangle
	*/
	public static function draw_rectangle(mc:MovieClip, rWidth:Number, rHeight:Number, rColor:Number, rAlpha:Number):Void {
		mc.clear();
		mc.beginFill(rColor, rAlpha);
		mc.moveTo(0, 0);
		mc.lineTo(rWidth, 0);
		mc.lineTo(rWidth, rHeight);
		mc.lineTo(0, rHeight);
		mc.endFill();
	}
	
	/** draws squares
	*	input parameters:
	*	mc:MovieClip - container movieclip where you want the square to be created in
	*	side:Number - length of the side of the square
	* 	sColor:Number - the color of the proposed square in hexadecimal code
	*	rAlpha:Number - (0 - 100) the transparency of the proposed square
	*/
	public static function draw_square(mc:MovieClip, side:Number, sColor:Number, sAlpha:Number) {
		mc.clear();
		mc.beginFill(sColor, sAlpha);
		mc.moveTo(0, 0);
		mc.lineTo(side, 0);
		mc.lineTo(side, side);
		mc.lineTo(0, side);
		mc.endFill();
	}
	
	/** draws triangles
	*	input parameters:
	*	mc:MovieClip - container movieclip where you want the square to be created in
	*	side:Number - length of the side of the square
	* 	sColor:Number - the color of the proposed square in hexadecimal code
	*	rAlpha:Number - (0 - 100) the transparency of the proposed square
	*/
	public static function draw_inverted_isosceles_triangle(mc:MovieClip, side:Number, sColor:Number, sAlpha:Number) {
		mc.clear();
		mc.beginFill(sColor, sAlpha);
		mc.moveTo(0, 0);
		mc.lineTo(side, 0);
		mc.lineTo(side/2, side);
		mc.lineTo(0, 0);
		mc.endFill();
	}
	
	/** draws circles
	*/
	public static function draw_circle(mc:MovieClip, r:Number, x:Number, y:Number, fill:Number) {
		var styleMaker:Number = 22.5;
		mc.moveTo(x + r, y);
		mc.beginFill(fill);
		var style:Number = Math.tan(styleMaker * Math.PI / 180);
		for (var angle:Number = 45; angle <= 360; angle += 45){
			var endX:Number = r * Math.cos(angle * Math.PI / 180);
			var endY:Number = r * Math.sin(angle * Math.PI / 180);
			var cX:Number = endX + r * style * Math.cos((angle - 90) * Math.PI / 180);
			var cY:Number = endY + r * style * Math.sin((angle - 90) * Math.PI / 180);
			mc.curveTo(cX + x, cY + y, endX + x, endY + y);
		}
	}
}
