CREATE TABLE geodesic_classifieds_filters (
	filter_id int(11) NOT NULL auto_increment,
	parent_id int(11) NOT NULL default '0',
	filter_level int(11) NOT NULL default '0',
	filter_name tinytext NOT NULL,
	display_order int(11) NOT NULL default '0',
	in_statement mediumtext NOT NULL,
	UNIQUE KEY filter_id (filter_id)
) TYPE=MyISAM;

CREATE TABLE geodesic_classifieds_filters_languages (
	filter_id int(11) NOT NULL default '0',
	filter_name tinytext NOT NULL,
	language_id int(11) NOT NULL default '0'
) TYPE=MyISAM;

CREATE TABLE geodesic_cc_twocheckout (
	sid varchar(25) NOT NULL default '',
	demo_mode int(11) NOT NULL default '0'
) TYPE=MyISAM;

CREATE TABLE geodesic_cc_twocheckout_transactions (
	transaction_id int(11) NOT NULL auto_increment,
	userID tinytext NOT NULL,
	order_number varchar(50) NOT NULL default '',
	card_holder_name tinytext NOT NULL,
	street_address tinytext NOT NULL,
	city tinytext NOT NULL,
	state tinytext NOT NULL,
	zip tinytext NOT NULL,
	country tinytext NOT NULL,
	email tinytext NOT NULL,
	phone tinytext NOT NULL,
	merchant_order_id int(11) NOT NULL default '0',
	credit_card_processed tinytext NOT NULL,
	tax double(10,2) NOT NULL default '0.00',
	total double(10,2) NOT NULL default '0.00',
	ship_name tinytext NOT NULL,
	ship_street_address tinytext NOT NULL,
	ship_city tinytext NOT NULL,
	ship_state tinytext NOT NULL,
	ship_country tinytext NOT NULL,
	ship_zip tinytext NOT NULL,
	product_id int(11) NOT NULL default '0',
	quantity int(11) NOT NULL default '0',
	merchant_product_id int(11) NOT NULL default '0',
	product_description tinytext NOT NULL,
	renew int(11) NOT NULL default '0',
	renewal_length int(11) NOT NULL default '0',
	subscription_renewal int(11) NOT NULL default '0',
	bolding int(11) NOT NULL default '0',
	better_placement int(11) NOT NULL default '0',
	featured_ad int(11) NOT NULL default '0',
	attention_getter int(11) NOT NULL default '0',
	attention_getter_choice int(11) NOT NULL default '0',
	use_credit_for_renewal int(11) NOT NULL default '0',
	ad_placement int(11) NOT NULL default '0',
	KEY transacation_id (transaction_id)
) TYPE=MyISAM;

ALTER TABLE `geodesic_pages` ADD `module_display_auction_id` INT NOT NULL;
ALTER TABLE `geodesic_pages` ADD `module_display_number_bids` INT NOT NULL;
ALTER TABLE `geodesic_pages` ADD `module_display_time_left` INT NOT NULL;

INSERT INTO geodesic_credit_card_choices VALUES (2, 0, '2 Checkout', 'This allows the use of the 2Checkout.com payment gateway', 'geodesic_cc_twocheckout', 'geodesic_cc_twocheckout_transactions', 'cc_initiate_2checkout.php', 'cc_process_2checkout.php', 'admin_cc_2checkout.php');

ALTER TABLE `geodesic_classifieds_sell_session` ADD `renew_upgrade` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_sell_session` ADD `ad_renewal` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_sell_session` ADD `bolding_upgrade` INT NOT NULL, ADD `better_placement_upgrade` INT NOT NULL, ADD `featured_ad_upgrade` INT NOT NULL, ADD `attention_getter_upgrade` INT NOT NULL, ADD `attention_getter_choice_upgrade` INT NOT NULL;

ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `renewal_length` INT NOT NULL;

ALTER TABLE `geodesic_worldpay_transactions` ADD `renewal_length` INT NOT NULL;

ALTER TABLE `geodesic_paypal_transactions` ADD `renewal_length` INT NOT NULL;
ALTER TABLE `geodesic_paypal_transactions` ADD `renewal_choice` INT NOT NULL;
ALTER TABLE `geodesic_paypal_transactions` ADD `ad_placement` INT NOT NULL;
ALTER TABLE `geodesic_paypal_transactions` ADD `transaction_id` INT NOT NULL FIRST;
ALTER TABLE `geodesic_paypal_transactions` ADD `renew` INT NOT NULL AFTER `verify_sign`;

ALTER TABLE `geodesic_classifieds_sell_session_questions` ADD `display_order` INT NOT NULL;

ALTER TABLE `geodesic_pages_templates_affiliates` ADD `extra_question_template_id` INT NOT NULL, ADD `checkbox_question_template_id` INT NOT NULL;

ALTER TABLE geodesic_classifieds_ads_extra ADD display_order INT not null;

ALTER TABLE geodesic_classifieds_ad_configuration ADD photo_quality INT not null;

ALTER TABLE `geodesic_classifieds_groups` ADD `sponsored_by_code` MEDIUMTEXT NOT NULL AFTER `place_an_ad_splash_code`;

ALTER TABLE `geodesic_classifieds_configuration` ADD `image_link_destination_type` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `maximum_full_image_height` INT NOT NULL, ADD `maximum_full_image_width` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_categories_languages` ADD `ad_detail_print_friendly_template` INT NOT NULL AFTER `ad_detail_full_image_display_template_id`;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `ad_detail_print_friendly_template` INT NOT NULL AFTER `full_size_image_template`;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `number_of_photos_in_detail` INT NOT NULL AFTER `maximum_photos`;

ALTER TABLE `geodesic_pages` ADD `module_number_of_columns` INT NOT NULL;

ALTER TABLE `geodesic_pages` ADD `module_display_filter_in_row` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `optional_1_filter_association` INT NOT NULL, ADD `optional_2_filter_association` INT NOT NULL, ADD `optional_3_filter_association` INT NOT NULL, ADD `optional_4_filter_association` INT NOT NULL, ADD `optional_5_filter_association` INT NOT NULL, ADD `optional_6_filter_association` INT NOT NULL, ADD `optional_7_filter_association` INT NOT NULL, ADD `optional_8_filter_association` INT NOT NULL, ADD `optional_9_filter_association` INT NOT NULL, ADD `optional_10_filter_association` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `optional_11_filter_association` INT NOT NULL, ADD `optional_12_filter_association` INT NOT NULL, ADD `optional_13_filter_association` INT NOT NULL, ADD `optional_14_filter_association` INT NOT NULL, ADD `optional_15_filter_association` INT NOT NULL, ADD `optional_16_filter_association` INT NOT NULL, ADD `optional_17_filter_association` INT NOT NULL, ADD `optional_18_filter_association` INT NOT NULL, ADD `optional_19_filter_association` INT NOT NULL, ADD `optional_20_filter_association` INT NOT NULL;

ALTER TABLE `geodesic_registration_configuration` ADD `registration_optional_1_filter_association` INT NOT NULL, ADD `registration_optional_2_filter_association` INT NOT NULL, ADD `registration_optional_3_filter_association` INT NOT NULL, ADD `registration_optional_4_filter_association` INT NOT NULL, ADD `registration_optional_5_filter_association` INT NOT NULL, ADD `registration_optional_6_filter_association` INT NOT NULL, ADD `registration_optional_7_filter_association` INT NOT NULL, ADD `registration_optional_8_filter_association` INT NOT NULL, ADD `registration_optional_9_filter_association` INT NOT NULL, ADD `registration_optional_10_filter_association` INT NOT NULL;
ALTER TABLE `geodesic_registration_configuration` ADD `registration_optional_11_filter_association` INT NOT NULL, ADD `registration_optional_12_filter_association` INT NOT NULL, ADD `registration_optional_13_filter_association` INT NOT NULL, ADD `registration_optional_14_filter_association` INT NOT NULL, ADD `registration_optional_15_filter_association` INT NOT NULL, ADD `registration_optional_16_filter_association` INT NOT NULL, ADD `registration_optional_17_filter_association` INT NOT NULL, ADD `registration_optional_18_filter_association` INT NOT NULL, ADD `registration_optional_19_filter_association` INT NOT NULL, ADD `registration_optional_20_filter_association` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `use_filters` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_registration_session` ADD `filter_id` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_userdata` ADD `filter_id` INT NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `filter_id` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `filter_id` INT NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `filter_id` INT NOT NULL ;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `maximum_top_image_width` INT NOT NULL AFTER `maximum_image_height`, ADD `maximum_top_image_height` INT NOT NULL AFTER `maximum_top_image_width`;
ALTER TABLE `geodesic_classifieds_configuration` ADD `display_category_tree` INT DEFAULT '1' NOT NULL, ADD `display_category_navigation` INT DEFAULT '1' NOT NULL;

ALTER TABLE `geodesic_pages` ADD `use_category_cache` INT DEFAULT '1' NOT NULL, ADD `cache_expire` INT DEFAULT '1' NOT NULL, ADD `category_cache` MEDIUMTEXT NOT NULL;

ALTER TABLE `geodesic_pages` ADD `number_of_browsing_columns` INT NOT NULL;

ALTER TABLE `geodesic_pages` ADD `display_category_count` INT NOT NULL, ADD `display_category_description` INT NOT NULL;

ALTER TABLE `geodesic_pages` ADD `display_no_subcategory_message` INT NOT NULL;

ALTER TABLE `geodesic_pages` ADD `display_category_image` INT NOT NULL;

ALTER TABLE `geodesic_pages` ADD `display_unselected_subfilters` INT NOT NULL;
ALTER TABLE `geodesic_pages` ADD `module_display_title` INT NOT NULL AFTER `module_display_username`;
ALTER TABLE `geodesic_pages` ADD `module_display_contact` INT NOT NULL AFTER `module_display_title`;
ALTER TABLE `geodesic_pages` ADD `module_display_phone1` INT NOT NULL AFTER `module_display_contact`;
ALTER TABLE `geodesic_pages` ADD `module_display_phone2` INT NOT NULL AFTER `module_display_phone1`;
ALTER TABLE `geodesic_pages` ADD `module_display_address` INT NOT NULL AFTER `module_display_phone2`;
ALTER TABLE `geodesic_pages` ADD `module_use_image` INT NOT NULL AFTER `module_display_name`;
ALTER TABLE `geodesic_pages` ADD `module_display_classified_id` INT NOT NULL AFTER `module_use_image`;
ALTER TABLE `geodesic_pages` ADD `module_thumb_width` INT NOT NULL AFTER `module_display_classified_id`;
ALTER TABLE `geodesic_pages` ADD `module_thumb_height` INT NOT NULL AFTER `module_thumb_width`;
ALTER TABLE `geodesic_pages` ADD `module_display_attention_getter` INT NOT NULL AFTER `module_thumb_height`;
ALTER TABLE `geodesic_pages` ADD `php_code` MEDIUMTEXT NOT NULL;
ALTER TABLE `geodesic_pages` ADD `display_empty_message` MEDIUMTEXT NOT NULL;
ALTER TABLE `geodesic_pages` ADD `module_display_optional_field_11` INT NOT NULL AFTER `module_display_optional_field_10`, ADD `module_display_optional_field_12` INT NOT NULL AFTER `module_display_optional_field_11`, ADD `module_display_optional_field_13` INT NOT NULL AFTER `module_display_optional_field_12`, ADD `module_display_optional_field_14` INT NOT NULL AFTER `module_display_optional_field_13`, ADD `module_display_optional_field_15` INT NOT NULL AFTER `module_display_optional_field_14`, ADD `module_display_optional_field_16` INT NOT NULL AFTER `module_display_optional_field_15`, ADD `module_display_optional_field_17` INT NOT NULL AFTER `module_display_optional_field_16`, ADD `module_display_optional_field_18` INT NOT NULL AFTER `module_display_optional_field_17`, ADD `module_display_optional_field_19` INT NOT NULL AFTER `module_display_optional_field_18`, ADD `module_display_optional_field_20` INT NOT NULL AFTER `module_display_optional_field_19`;
ALTER TABLE `geodesic_pages` ADD `module_category_level_to_display` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_pages` ADD `module_category` INT DEFAULT '0' NOT NULL;
ALTER TABLE geodesic_pages_fonts ADD text_vertical_align varchar(20) NOT NULL;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `sign_maximum_image_width` INT NOT NULL, ADD `sign_maximum_image_height` INT NOT NULL, ADD `flyer_maximum_image_width` INT NOT NULL, ADD `flyer_maximum_image_height` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_email_option_field` INT NOT NULL, ADD `use_email_override` INT NOT NULL, ADD `use_phone_1_option_field` INT NOT NULL, ADD `allow_phone_1_override` INT NOT NULL, ADD `use_phone_2_option_field` INT NOT NULL, ADD `allow_phone_2_override` INT NOT NULL, ADD `use_fax_field_option` INT NOT NULL, ADD `allow_fax_override` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `publically_expose_email` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `editable_price_field` INT NOT NULL, ADD `editable_zip_field` INT NOT NULL, ADD `editable_city_field` INT NOT NULL, ADD `editable_state_field` INT NOT NULL, ADD `editable_country_field` INT NOT NULL, ADD `editable_title_field` INT NOT NULL, ADD `editable_description_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_1_field_editable` INT NOT NULL, ADD `optional_2_field_editable` INT NOT NULL, ADD `optional_3_field_editable` INT NOT NULL, ADD `optional_4_field_editable` INT NOT NULL, ADD `optional_5_field_editable` INT NOT NULL, ADD `optional_6_field_editable` INT NOT NULL, ADD `optional_7_field_editable` INT NOT NULL, ADD `optional_8_field_editable` INT NOT NULL, ADD `optional_9_field_editable` INT NOT NULL, ADD `optional_10_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `editable_category_specific` INT NOT NULL, ADD `display_business_type` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_mapping_address_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_mapping_city_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_mapping_state_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_mapping_country_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_mapping_zip_field` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_sell_session` ADD `mapping_address` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `mapping_city` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `mapping_state` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `mapping_country` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `mapping_zip` TINYTEXT  NOT NULL;

ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_11` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_12` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_13` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_14` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_15` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_16` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_17` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_18` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_19` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `optional_field_20` TINYTEXT  NOT NULL;

ALTER TABLE `geodesic_classifieds` ADD `mapping_address` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `mapping_city` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `mapping_state` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `mapping_country` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `mapping_zip` TINYTEXT  NOT NULL;

ALTER TABLE `geodesic_classifieds` ADD `optional_field_11` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_12` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_13` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_14` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_15` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_16` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_17` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_18` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_19` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `optional_field_20` TINYTEXT  NOT NULL;

ALTER TABLE `geodesic_confirm` ADD `mapping_address` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `mapping_city` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `mapping_state` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `mapping_country` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `mapping_zip` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_11` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_12` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_13` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_14` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_15` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_16` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_17` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_18` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_19` TINYTEXT  NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `optional_field_20` TINYTEXT  NOT NULL;

ALTER TABLE `geodesic_classifieds_categories` ADD `use_mapping_address_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `use_mapping_city_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `use_mapping_state_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `use_mapping_country_field` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `use_mapping_zip_field` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_categories` ADD `display_business_type` INT NOT NULL AFTER `use_site_default`
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `display_business_type` INT NOT NULL AFTER `maximum_full_image_width`;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `length_of_description` INT NOT NULL AFTER `maximum_description_length`;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_11_length` INT NOT NULL, ADD `optional_11_other_box` INT NOT NULL, ADD `optional_11_field_type` INT NOT NULL, ADD `optional_11_number_only` INT NOT NULL, ADD `optional_11_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_12_length` INT NOT NULL, ADD `optional_12_other_box` INT NOT NULL, ADD `optional_12_field_type` INT NOT NULL, ADD `optional_12_number_only` INT NOT NULL, ADD `optional_12_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_13_length` INT NOT NULL, ADD `optional_13_other_box` INT NOT NULL, ADD `optional_13_field_type` INT NOT NULL, ADD `optional_13_number_only` INT NOT NULL, ADD `optional_13_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_14_length` INT NOT NULL, ADD `optional_14_other_box` INT NOT NULL, ADD `optional_14_field_type` INT NOT NULL, ADD `optional_14_number_only` INT NOT NULL, ADD `optional_14_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_15_length` INT NOT NULL, ADD `optional_15_other_box` INT NOT NULL, ADD `optional_15_field_type` INT NOT NULL, ADD `optional_15_number_only` INT NOT NULL, ADD `optional_15_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_16_length` INT NOT NULL, ADD `optional_16_other_box` INT NOT NULL, ADD `optional_16_field_type` INT NOT NULL, ADD `optional_16_number_only` INT NOT NULL, ADD `optional_16_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_17_length` INT NOT NULL, ADD `optional_17_other_box` INT NOT NULL, ADD `optional_17_field_type` INT NOT NULL, ADD `optional_17_number_only` INT NOT NULL, ADD `optional_17_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_18_length` INT NOT NULL, ADD `optional_18_other_box` INT NOT NULL, ADD `optional_18_field_type` INT NOT NULL, ADD `optional_18_number_only` INT NOT NULL, ADD `optional_18_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_19_length` INT NOT NULL, ADD `optional_19_other_box` INT NOT NULL, ADD `optional_19_field_type` INT NOT NULL, ADD `optional_19_number_only` INT NOT NULL, ADD `optional_19_field_editable` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `optional_20_length` INT NOT NULL, ADD `optional_20_other_box` INT NOT NULL, ADD `optional_20_field_type` INT NOT NULL, ADD `optional_20_number_only` INT NOT NULL, ADD `optional_20_field_editable` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_11` INT NOT NULL, ADD `use_optional_field_11` INT NOT NULL, ADD `display_optional_field_11` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_12` INT NOT NULL, ADD `use_optional_field_12` INT NOT NULL, ADD `display_optional_field_12` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_13` INT NOT NULL, ADD `use_optional_field_13` INT NOT NULL, ADD `display_optional_field_13` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_14` INT NOT NULL, ADD `use_optional_field_14` INT NOT NULL, ADD `display_optional_field_14` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_15` INT NOT NULL, ADD `use_optional_field_15` INT NOT NULL, ADD `display_optional_field_15` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_16` INT NOT NULL, ADD `use_optional_field_16` INT NOT NULL, ADD `display_optional_field_16` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_17` INT NOT NULL, ADD `use_optional_field_17` INT NOT NULL, ADD `display_optional_field_17` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_18` INT NOT NULL, ADD `use_optional_field_18` INT NOT NULL, ADD `display_optional_field_18` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_19` INT NOT NULL, ADD `use_optional_field_19` INT NOT NULL, ADD `display_optional_field_19` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `require_optional_field_20` INT NOT NULL, ADD `use_optional_field_20` INT NOT NULL, ADD `display_optional_field_20` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_categories` ADD `in_statement` MEDIUMTEXT NOT NULL, ADD `use_site_default` INT NOT NULL, ADD `display_business_type` INT NOT NULL, ADD `display_photo_icon` INT NOT NULL, ADD `display_price` INT NOT NULL, ADD `use_price_field` INT NOT NULL, ADD `display_browsing_zip_field` INT NOT NULL, ADD `use_zip_field` INT NOT NULL, ADD `display_browsing_city_field` INT NOT NULL, ADD `use_city_field` INT NOT NULL, ADD `display_browsing_state_field` INT NOT NULL, ADD `use_state_field` INT NOT NULL, ADD `display_browsing_country_field` INT NOT NULL, ADD `use_country_field` INT NOT NULL, ADD `display_entry_date` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `use_email_option_field` INT NOT NULL, ADD `use_email_override` INT NOT NULL, ADD `publically_expose_email` INT NOT NULL, ADD `use_phone_1_option_field` INT NOT NULL, ADD `allow_phone_1_override` INT NOT NULL, ADD `use_phone_2_option_field` INT NOT NULL, ADD `allow_phone_2_override` INT NOT NULL, ADD `use_fax_field_option` INT NOT NULL, ADD `allow_fax_override` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `use_optional_field_1` INT NOT NULL, ADD `display_optional_field_1` INT NOT NULL, ADD `use_optional_field_2` INT NOT NULL, ADD `display_optional_field_2` INT NOT NULL, ADD `use_optional_field_3` INT NOT NULL, ADD `display_optional_field_3` INT NOT NULL, ADD `use_optional_field_4` INT NOT NULL, ADD `display_optional_field_4` INT NOT NULL, ADD `use_optional_field_5` INT NOT NULL, ADD `display_optional_field_5` INT NOT NULL, ADD `use_optional_field_6` INT NOT NULL, ADD `display_optional_field_6` INT NOT NULL, ADD `use_optional_field_7` INT NOT NULL, ADD `display_optional_field_7` INT NOT NULL, ADD `use_optional_field_8` INT NOT NULL, ADD `display_optional_field_8` INT NOT NULL, ADD `use_optional_field_9` INT NOT NULL, ADD `display_optional_field_9` INT NOT NULL, ADD `use_optional_field_10` INT NOT NULL, ADD `display_optional_field_10` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `use_optional_field_11` INT NOT NULL, ADD `display_optional_field_11` INT NOT NULL, ADD `use_optional_field_12` INT NOT NULL, ADD `display_optional_field_12` INT NOT NULL, ADD `use_optional_field_13` INT NOT NULL, ADD `display_optional_field_13` INT NOT NULL, ADD `use_optional_field_14` INT NOT NULL, ADD `display_optional_field_14` INT NOT NULL, ADD `use_optional_field_15` INT NOT NULL, ADD `display_optional_field_15` INT NOT NULL, ADD `use_optional_field_16` INT NOT NULL, ADD `display_optional_field_16` INT NOT NULL, ADD `use_optional_field_17` INT NOT NULL, ADD `display_optional_field_17` INT NOT NULL, ADD `use_optional_field_18` INT NOT NULL, ADD `display_optional_field_18` INT NOT NULL, ADD `use_optional_field_19` INT NOT NULL, ADD `display_optional_field_19` INT NOT NULL, ADD `use_optional_field_20` INT NOT NULL, ADD `display_optional_field_20` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_categories_languages` ADD `ad_detail_display_template_id` INT NOT NULL AFTER `ad_display_template_id`, ADD `ad_detail_extra_display_template_id` INT NOT NULL AFTER `ad_detail_display_template_id`, ADD `ad_detail_checkbox_display_template_id` INT NOT NULL AFTER `ad_detail_extra_display_template_id`, ADD `ad_detail_full_image_display_template_id` INT NOT NULL AFTER `ad_detail_checkbox_display_template_id`, ADD `ad_detail_print_friendly_template` INT NOT NULL AFTER `ad_detail_full_image_display_template_id`;
ALTER TABLE `geodesic_classifieds_categories_languages` ADD `newest_category_cache` MEDIUMTEXT NOT NULL, ADD `newest_cache_expire` INT NOT NULL, ADD `featured_pic_category_cache` MEDIUMTEXT NOT NULL, ADD `featured_pic_cache_expire` INT NOT NULL, ADD `featured_text_category_cache` MEDIUMTEXT NOT NULL, ADD `featured_text_cache_expire` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_categories_languages` ADD `seller_category_cache` MEDIUMTEXT NOT NULL, ADD `seller_cache_expire` INT NOT NULL, ADD `ad_detail_extra_display_template` INT NOT NULL, ADD `ad_detail_checkbox_display_template` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_userdata` ADD `expose_email` INT NOT NULL, ADD `expose_company_name` INT NOT NULL, ADD `expose_firstname` INT NOT NULL, ADD `expose_lastname` INT NOT NULL, ADD `expose_address` INT NOT NULL, ADD `expose_city` INT NOT NULL, ADD `expose_state` INT NOT NULL, ADD `expose_country` INT NOT NULL, ADD `expose_zip` INT NOT NULL, ADD `expose_phone` INT NOT NULL, ADD `expose_phone2` INT NOT NULL, ADD `expose_fax` INT NOT NULL, ADD `expose_url` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_userdata` ADD `expose_optional_1` INT NOT NULL, ADD `expose_optional_2` INT NOT NULL, ADD `expose_optional_3` INT NOT NULL, ADD `expose_optional_4` INT NOT NULL, ADD `expose_optional_5` INT NOT NULL, ADD `expose_optional_6` INT NOT NULL, ADD `expose_optional_7` INT NOT NULL, ADD `expose_optional_8` INT NOT NULL, ADD `expose_optional_9` INT NOT NULL, ADD `expose_optional_10` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_sell_session` ADD `use_credit_for_renewal` INT NOT NULL;

UPDATE `geodesic_pages` SET `name` = 'Choose A Category/Price Plan Choices',`description` = 'This page allows the user placing a new ad to choose the category their ad will be placed in.  If a ad splash page is set the current users group the splash page will be displayed within this page with a link back to the same page to choose a category. Also, the page for the price plan choices page if this is being used in price plan management.' WHERE `page_id` = '8' LIMIT 1 ;

INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (88, 0, 'link to search (category dynamic)', 'This creates a category specific dynamic link to the search facility.', 'If you do not want a category dynamic search link just create a link within your template to you top classifieds file with \"?a=19\" at the end of it...like:<Br><br>\r\nclassifieds.php?a=19<br><br>\r\nThis is a site wide search link.', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_search_link.php', '<SEARCH_LINK>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (89, 0, 'featured ad pic module display', 'This displays a module of the featured ads by thumbnail picture only', '', 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_1.php', '<MODULE_FEATURED_PIC_1>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (90, 0, 'featured ad pic module display 2', 'This displays a module of the featured ads by thumbnail picture only', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_2.php', '<MODULE_FEATURED_PIC_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (91, 0, 'filter dropdown display 1', 'This displays the array of filter dropdowns built through the filter administration.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_filters_1.php', '<<FILTER_DISPLAY_1>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, '', 0, 0, 0, 0, 0, 1);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (92, 3, 'Registration Filter Selection Page', 'This page allows the user to select the filter settings they will use.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (93, 11, 'Edit Filters Page', 'This page allows the user to edit their filters.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (94, 0, 'Classified Category Navigation', 'Displays the category navigation links to the current category.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_category_navigation_1.php', '<CLASSIFIED_NAVIGATION_1>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 3, 1, 1, 0, 1, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (95, 0, 'Classified Category Navigation 2', 'Displays the category navigation links to the current category.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_category_navigation_2.php', '<CLASSIFIED_NAVIGATION_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 5, 1, 1, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (96, 0, 'Classified Category Navigation 3', 'Displays the category navigation links to the current category.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_category_navigation_3.php', '<CLASSIFIED_NAVIGATION_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 3, 1, 1, 0, 1, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (97, 0, 'Category Tree Navigation 1', 'Displays the category tree navigation links based on the current category.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_category_tree_1.php', '<CATEGORY_TREE_1>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (98, 0, 'Category Tree Navigation 2', 'Displays the category tree navigation links based on the current category.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_category_tree_2.php', '<CATEGORY_TREE_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (99, 0, 'Category Tree Navigation 3', 'Displays the category tree navigation links based on the current category.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_category_tree_3.php', '<CATEGORY_TREE_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (100, 0, 'Main Classified Category Navigation 1', 'Displays the main category navigation links (not subcategories).', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_main_category_navigation_1.php', '<MAIN_CLASSIFIED_NAVIGATION_1>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 3, 1, 1, 0, 1, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (101, 0, 'filter dropdown display 2', 'This displays the array of filter dropdowns built through the filter administration.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_filters_2.php', '<<FILTER_DISPLAY_2>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, '', 0, 0, 0, 0, 0, 1);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters) VALUES (102, 0, 'featured ad pic module display 3', 'This displays a module of the featured ads by thumbnail picture only', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_3.php', '<MODULE_FEATURED_PIC_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (103, 0, 'PHP Code Module 1', 'Insert your own php to be executed within this module', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_php_1.php', '<MODULE_PHP_INSERT_1>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (104, 0, 'PHP Code Module 2', 'Insert your own php to be executed within this module', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_php_2.php', '<MODULE_PHP_INSERT_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (105, 0, 'PHP Code Module 3', 'Insert your own php to be executed within this module', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_php_3.php', '<MODULE_PHP_INSERT_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, use_category_cache, cache_expire, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image) VALUES (106, 0, 'Search Module 1', 'This displays a search box with category dropdown.', '', 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 20, 'module_display_search_box_1.php', '<MODULE_SEARCH_BOX_1>', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 1, 1, '', 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, use_category_cache, cache_expire, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image) VALUES (107, 11, 'Renew Subscription Form', 'This displays the form to allow the user to renew their subscription without placing an ad.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, use_category_cache, cache_expire, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image) VALUES (108, 11, 'Renew Subscription Final Approval Form', 'This displays the transaction totals to approve a subscription renewal without placing an ad.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, use_category_cache, cache_expire, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image) VALUES (109, 11, 'Renew Subscription Success Page', 'This displays the user successfull/unsuccessful attempt to renew their subscription without placing an ad.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (110, 0, 'PHP Code Module 4', 'Insert your own php to be executed within this module', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_php_4.php', '<MODULE_PHP_INSERT_4>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (111, 0, 'PHP Code Module 5', 'Insert your own php to be executed within this module', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_php_5.php', '<MODULE_PHP_INSERT_5>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (112, 0, 'PHP Code Module 6', 'Insert your own php to be executed within this module', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_php_6.php', '<MODULE_PHP_INSERT_6>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (113, 1, 'Browse Sellers', 'This page allows you to browse sellers by category', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code) VALUES (114, 0, 'Category Level Navigation 1', 'Insert your own php to be executed within this module', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_category_level_navigation_1.php', '<MAIN_CLASSIFIED_LEVEL_NAVIGATION_1>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '');

CREATE TABLE geodesic_classifieds_price_increments (
	price_plan_id int(11) NOT NULL default '0',
	category_id int(11) NOT NULL default '0',
	low double(16,2) default NULL,
	high double(16,2) default NULL,
	charge double(16,2) default NULL,
	renewal_charge double(16,2) NOT NULL default '0.00'
) TYPE=MyISAM;

CREATE TABLE geodesic_price_plan_ad_lengths (
	length_id int(11) NOT NULL auto_increment,
	price_plan_id int(11) NOT NULL default '0',
	category_id int(11) NOT NULL default '0',
	length_of_ad int(11) NOT NULL default '0',
	display_length_of_ad tinytext NOT NULL,
	length_charge double(5,2) NOT NULL default '0.00',
	renewal_charge double(5,2) NOT NULL default '0.00',
	UNIQUE KEY length_id (length_id)
) TYPE=MyISAM;

CREATE TABLE geodesic_currency_types (
	type_id int(11) NOT NULL auto_increment,
	type_name tinytext NOT NULL,
	precurrency tinytext NOT NULL,
	postcurrency tinytext NOT NULL,
	display_order int(11) NOT NULL default '0',
	UNIQUE KEY type_id (type_id),
	KEY type_id_2 (type_id)
) TYPE=MyISAM;

ALTER TABLE `geodesic_confirm` ADD `optional_field_1` TINYTEXT NOT NULL, ADD `optional_field_2` TINYTEXT NOT NULL, ADD `optional_field_3` TINYTEXT NOT NULL, ADD `optional_field_4` TINYTEXT NOT NULL, ADD `optional_field_5` TINYTEXT NOT NULL, ADD `optional_field_6` TINYTEXT NOT NULL, ADD `optional_field_7` TINYTEXT NOT NULL, ADD `optional_field_8` TINYTEXT NOT NULL, ADD `optional_field_9` TINYTEXT NOT NULL, ADD `optional_field_10` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `email2` TINYTEXT NOT NULL AFTER `email`;
ALTER TABLE `geodesic_classifieds_userdata` ADD `affiliate_html` MEDIUMTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_userdata_history` ADD `affiliate_html` MEDIUMTEXT NOT NULL;

ALTER TABLE `geodesic_cc_authorizenet` ADD `transaction_key` VARCHAR(50) NOT NULL, ADD `currency_code` VARCHAR(10) NOT NULL, ADD `merchant_password` TINYTEXT NOT NULL, ADD `merchant_type` INT NOT NULL, ADD `connection_type` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_expired` ADD `precurrency` VARCHAR(50) NOT NULL AFTER `date`, ADD `price` INT NOT NULL AFTER `precurrency`, ADD `postcurrency` VARCHAR(50) NOT NULL AFTER `price`;
ALTER TABLE `geodesic_classifieds_expired` ADD `attention_getter` INT NOT NULL AFTER `featured_ad`;
ALTER TABLE `geodesic_classifieds_expired` ADD `business_type` INT NOT NULL, ADD `optional_field_1` TINYTEXT NOT NULL, ADD `optional_field_2` TINYTEXT NOT NULL, ADD `optional_field_3` TINYTEXT NOT NULL, ADD `optional_field_4` TINYTEXT NOT NULL, ADD `optional_field_5` TINYTEXT NOT NULL, ADD `optional_field_6` TINYTEXT NOT NULL, ADD `optional_field_7` TINYTEXT NOT NULL, ADD `optional_field_8` TINYTEXT NOT NULL, ADD `optional_field_9` TINYTEXT NOT NULL, ADD `optional_field_10` TINYTEXT NOT NULL, ADD `email` TINYTEXT NOT NULL, ADD `phone` TINYTEXT NOT NULL, ADD `phone2` TINYTEXT NOT NULL, ADD `fax` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_expired` ADD `optional_field_11` TINYTEXT NOT NULL, ADD `optional_field_12` TINYTEXT NOT NULL, ADD `optional_field_13` TINYTEXT NOT NULL, ADD `optional_field_14` TINYTEXT NOT NULL, ADD `optional_field_15` TINYTEXT NOT NULL, ADD `optional_field_16` TINYTEXT NOT NULL, ADD `optional_field_17` TINYTEXT NOT NULL, ADD `optional_field_18` TINYTEXT NOT NULL, ADD `optional_field_19` TINYTEXT NOT NULL, ADD `optional_field_20` TINYTEXT NOT NULL;


ALTER TABLE `geodesic_classifieds_price_plans` ADD `charge_per_ad_type` INT NOT NULL AFTER `price_plan_id`;
ALTER TABLE `geodesic_classifieds_price_plans` ADD `instant_cash_renewals` INT DEFAULT '0' NOT NULL, ADD `instant_money_order_renewals` INT DEFAULT '0' NOT NULL, ADD `instant_check_renewals` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_price_plans_categories` ADD `charge_per_ad_type` INT NOT NULL AFTER `category_id`;
ALTER TABLE `geodesic_classifieds_price_plans` ADD `allow_credits_for_renewals` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_sell_session` ADD `currency_type` INT NOT NULL AFTER `price`;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `email_option` TINYTEXT NOT NULL AFTER `optional_field_10`, ADD `expose_email` INT NOT NULL AFTER `email_option`, ADD `phone_1_option` TINYTEXT NOT NULL AFTER `expose_email`, ADD `phone_2_option` TINYTEXT NOT NULL AFTER `phone_1_option`, ADD `fax_option` TINYTEXT NOT NULL AFTER `phone_2_option`;

ALTER TABLE `geodesic_classifieds` ADD `renewal_payment_expected` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `renewal_payment_expected_by` INT NOT NULL;
ALTER TABLE `geodesic_classifieds` ADD `renewal_length` INT NOT NULL, ADD `renewal_featured_ad` INT NOT NULL, ADD `renewal_bolding` INT NOT NULL, ADD `renewal_better_placement` INT NOT NULL, ADD `renewal_attention_getter` INT NOT NULL, ADD `renewal_attention_getter_choice` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `admin_approves_all_ads` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `use_rte` INT NOT NULL;

ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `use_credit_for_renewal` INT NOT NULL;
ALTER TABLE `geodesic_worldpay_transactions` ADD `use_credit_for_renewal` INT NOT NULL;
ALTER TABLE `geodesic_paypal_transactions` ADD `use_credit_for_renewal` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_registration_session` ADD `registration_code` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_confirm` ADD `registration_code` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `subscription_expire_period_notice` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_user_subscriptions` ADD `notice_sent` INT NOT NULL;
ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `subscription_renewal` INT NOT NULL;
ALTER TABLE `geodesic_paypal_transactions` ADD `subscription_renewal` INT NOT NULL;
ALTER TABLE `geodesic_worldpay_transactions` ADD `subscription_renewal` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `email_configuration_type` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `levels_of_categories_displayed` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `home_template` INT(11) NOT NULL;

CREATE TABLE geodesic_classifieds_user_subscriptions_holds (
	renewal_id int(11) NOT NULL auto_increment,
	userID int(11) NOT NULL default '0',
	subscription_choice int(11) NOT NULL default '0',
	date int(11) NOT NULL default '0',
	PRIMARY KEY  (renewal_id)
) TYPE=MyISAM;

ALTER TABLE `geodesic_classifieds_user_credits` CHANGE `credit_count` `credit_count` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` CHANGE `thumbnail_max_height` `thumbnail_max_height` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` CHANGE `thumbnail_max_width` `thumbnail_max_width` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds` ADD `featured_ad_upgrade` INT NOT NULL, ADD `bolding_upgrade` INT NOT NULL, ADD `better_placement_upgrade` INT NOT NULL, ADD `attention_getter_upgrade` INT NOT NULL, ADD `attention_getter_choice_upgrade` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `use_zip_distance_calculator` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds` CHANGE `price` `price` DECIMAL ( 10, 2 ) DEFAULT '0.00' NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `price` `price` DECIMAL( 10, 2 ) DEFAULT '0.00' NOT NULL;

ALTER TABLE `geodesic_classifieds` ADD `subscription_choice` INT DEFAULT '0' NOT NULL;

UPDATE geodesic_pages_fonts set element = 'login_register_logout_link' where element_id = 527;
UPDATE geodesic_pages_fonts set element = 'login_register_login_link' where element_id = 525;
UPDATE geodesic_pages_fonts set element = 'login_register_my_account_link' where element_id = 526;
UPDATE geodesic_pages_fonts set element = 'login_register_register_link' where element_id = 524;

ALTER TABLE `geodesic_classifieds_configuration` ADD `use_search_form` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `voting_system` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `number_of_vote_comments_to_display` INT NOT NULL;

INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (116, 1, 'Ad Voting Form', 'This page displays the form allowing the user to vote on a form.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (115, 1, 'Ad Voting Comments View', 'This page displays the comments that users have left about an ad.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (117, 0, 'featured ad pic module display 1 - level 2', 'This displays a module of the featured ads by thumbnail picture only - level 2 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_1_level_2.php', '<MODULE_FEATURED_PIC_1_LEVEL_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (118, 0, 'featured ad pic module display 2 - level 2', 'This displays a module of the featured ads by thumbnail picture only - level 2 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_2_level_2.php', '<MODULE_FEATURED_PIC_2_LEVEL_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (119, 0, 'featured ad pic module display 1 - level 3', 'This displays a module of the featured ads by thumbnail picture only - level 3 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_1_level_3.php', '<MODULE_FEATURED_PIC_1_LEVEL_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (120, 0, 'featured ad pic module display 2 - level 3', 'This displays a module of the featured ads by thumbnail picture only - level 3 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_2_level_3.php', '<MODULE_FEATURED_PIC_2_LEVEL_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (121, 0, 'featured ad pic module display 1 - level 4', 'This displays a module of the featured ads by thumbnail picture only - level 4 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_1_level_4.php', '<MODULE_FEATURED_PIC_1_LEVEL_4>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (122, 0, 'featured ad pic module display 2 - level 4', 'This displays a module of the featured ads by thumbnail picture only - level 4 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_2_level_4.php', '<MODULE_FEATURED_PIC_2_LEVEL_4>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (123, 0, 'featured ad pic module display 1 - level 5', 'This displays a module of the featured ads by thumbnail picture only - level 5 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_1_level_5.php', '<MODULE_FEATURED_PIC_1_LEVEL_5>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (124, 0, 'featured ad pic module display 2 - level 5', 'This displays a module of the featured ads by thumbnail picture only - level 5 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_pic_2_level_5.php', '<MODULE_FEATURED_PIC_2_LEVEL_5>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (125, 0, 'featured ad module display 1 - level 2', 'This displays a module of the featured ads - level 2 featured ads', '', 0, 1, 2, 1, 0, 1, 0, 0, 0, 0, 0, 0, 'module_featured_ads_1_level_2.php', '<MODULE_FEATURED_1_LEVEL_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (126, 0, 'featured ad module display 2 - level 2', 'This displays a module of the featured ads - level 2 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_2_level_2.php', '<MODULE_FEATURED_2_LEVEL_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (127, 0, 'featured ad module display 1 - level 3', 'This displays a module of the featured ads - level 3 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_1_level_3.php', '<MODULE_FEATURED_1_LEVEL_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (128, 0, 'featured ad module display 2 - level 3', 'This displays a module of the featured ads - level 3 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_2_level_3.php', '<MODULE_FEATURED_2_LEVEL_3>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (129, 0, 'featured ad module display 1 - level 4', 'This displays a module of the featured ads - level 4 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_1_level_4.php', '<MODULE_FEATURED_1_LEVEL_4>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (130, 0, 'featured ad module display 2 - level 4', 'This displays a module of the featured ads - level 4 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_2_level_4.php', '<MODULE_FEATURED_2_LEVEL_4>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (131, 0, 'featured ad module display 1 - level 5', 'This displays a module of the featured ads - level 5 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_1_level_5.php', '<MODULE_FEATURED_1_LEVEL_5>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (132, 0, 'featured ad module display 2 - level 5', 'This displays a module of the featured ads - level 5 featured ads', '', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_2_level_5.php', '<MODULE_FEATURED_2_LEVEL_5>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 75, 75, 0, 5, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '0', 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('133', '0', 'Browsing Zip Filter', 'While browsing a user can limit the ads displayed to a certain zip and distance radius.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_zip_filters.php', '<MODULE_ZIP_FILTER_1>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('134', '0', 'Browsing State Filter', 'While browsing this module filters out ads that do not match the chosen state a user chooses to view from the dropdown menu', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_state_filters.php', '<MODULE_STATE_FILTER_1>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('135', '12', 'Extra Page 1', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('136', '12', 'Extra Page 2', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('137', '12', 'Extra Page 3', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('138', '12', 'Extra Page 4', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('139', '12', 'Extra Page 5', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('140', '12', 'Extra Page 6', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('141', '12', 'Extra Page 7', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('142', '12', 'Extra Page 8', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('143', '12', 'Extra Page 9', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('144', '12', 'Extra Page 10', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('145', '12', 'Extra Page 11', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('146', '12', 'Extra Page 12', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('147', '12', 'Extra Page 13', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('148', '12', 'Extra Page 14', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('149', '12', 'Extra Page 15', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('150', '12', 'Extra Page 16', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('151', '12', 'Extra Page 17', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('152', '12', 'Extra Page 18', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('153', '12', 'Extra Page 19', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`) VALUES ('154', '12', 'Extra Page 20', '', 'This is a extra page that will allow you to display pages of your own creation within the framework of the Geoclassifieds system. This allows you to take advantage of the module and template functionality available within the classifieds system.', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '');


ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `featured_ad`, ADD `featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2`, ADD `featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3`, ADD `featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4`;
ALTER TABLE `geodesic_cc_twocheckout_transactions` ADD `featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `featured_ad`, ADD `featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2`, ADD `featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3`, ADD `featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4`;
ALTER TABLE `geodesic_paypal_transactions` ADD `featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `featured_ad`, ADD `featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2`, ADD `featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3`, ADD `featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4`;
ALTER TABLE `geodesic_worldpay_transactions` ADD `featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `featured_ad`, ADD `featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2`, ADD `featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3`, ADD `featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4`;

ALTER TABLE `geodesic_classifieds_configuration` ADD `use_featured_feature_2` INT DEFAULT '0' NOT NULL AFTER `use_featured_feature`, ADD `use_featured_feature_3` INT DEFAULT '0' NOT NULL AFTER `use_featured_feature_2`, ADD `use_featured_feature_4` INT DEFAULT '0' NOT NULL AFTER `use_featured_feature_3`, ADD `use_featured_feature_5` INT DEFAULT '0' NOT NULL AFTER `use_featured_feature_4`;
ALTER TABLE `geodesic_classifieds` ADD `featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `featured_ad`, ADD `featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2`, ADD `featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3`, ADD `featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4`;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `featured_ad`, ADD `featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2`, ADD `featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3`, ADD `featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4`;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `featured_ad_2_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_upgrade`, ADD `featured_ad_3_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2_upgrade`, ADD `featured_ad_4_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3_upgrade`, ADD `featured_ad_5_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4_upgrade`;
ALTER TABLE `geodesic_classifieds` ADD `renewal_featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `renewal_featured_ad`, ADD `renewal_featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `renewal_featured_ad_2`, ADD `renewal_featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `renewal_featured_ad_3`, ADD `renewal_featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `renewal_featured_ad_4`;

ALTER TABLE `geodesic_classifieds_price_plans` ADD `featured_ad_price_2` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price`, ADD `featured_ad_price_3` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price_2`, ADD `featured_ad_price_4` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price_3`, ADD `featured_ad_price_5` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price_4`;
ALTER TABLE `geodesic_classifieds_price_plans_categories` ADD `featured_ad_price_2` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price`, ADD `featured_ad_price_3` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price_2`, ADD `featured_ad_price_4` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price_3`, ADD `featured_ad_price_5` DOUBLE(5,2) DEFAULT '0.00' NOT NULL AFTER `featured_ad_price_4`;

ALTER TABLE `geodesic_classifieds_configuration` ADD `order_choose_category_by_alpha` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `popup_while_browsing` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `popup_while_browsing_width` INT DEFAULT '0' NOT NULL, ADD `popup_while_browsing_height` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_file_types` ADD `icon_to_use` TINYTEXT NOT NULL AFTER `accept`;
ALTER TABLE `geodesic_classifieds_file_types` ADD `extension` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_images_urls` ADD `filesize` INT NOT NULL, ADD `filesize_displayed` VARCHAR(20) NOT NULL, ADD `icon` TINYTEXT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `paypal_currency_rate` DOUBLE(5,4) NOT NULL AFTER `paypal_id`;
ALTER TABLE `geodesic_classifieds_configuration` ADD `paypal_currency` VARCHAR(15) NOT NULL AFTER `paypal_currency_rate`;
ALTER TABLE `geodesic_classifieds_sell_question_choices` CHANGE `display_order` `display_order` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `paypal_image_url` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `paypal_item_label` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `admin_email_bcc` TINYTEXT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `use_api` INT default '0' NOT NULL;

CREATE TABLE geodesic_classifieds_discount_codes (
	discount_id int(11) NOT NULL auto_increment,
	name tinytext NOT NULL,
	description tinytext NOT NULL,
	discount_code tinytext NOT NULL,
	discount_percentage double(5,2) NOT NULL default '0.00',
	active int(11) NOT NULL default '0',
	PRIMARY KEY  (discount_id)
) TYPE=MyISAM;


ALTER TABLE `geodesic_classifieds` ADD `discount_id` INT DEFAULT '0' NOT NULL, ADD `discount_amount` DOUBLE(7,2) DEFAULT '0' NOT NULL, ADD `discount_percentage` DOUBLE(7,2) DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `discount_code` VARCHAR(25) NOT NULL;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `imagecreatetruecolor_switch` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds` ADD `featured_ad_2_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_upgrade`, ADD `featured_ad_3_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2_upgrade`, ADD `featured_ad_4_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3_upgrade`, ADD `featured_ad_5_upgrade` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4_upgrade`;
ALTER TABLE `geodesic_classifieds` ADD `renewal_subtotal` DOUBLE(7,2) DEFAULT '0' NOT NULL, ADD `renewal_tax` DOUBLE(7,2) DEFAULT '0' NOT NULL, ADD `renewal_total` DOUBLE(7,2) DEFAULT '0' NOT NULL;

INSERT INTO geodesic_pages_sections (section_id, name, description, parent_section, display_order) VALUES (12, 'Extra Blank Pages', 'This section contains the blank pages you can use for site supporting documents but still take advantage of module placement', 0, 6);
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `title_length` INT DEFAULT '50' NOT NULL, ADD `price_length` INT DEFAULT '12' NOT NULL, ADD `city_length` INT DEFAULT '20' NOT NULL, ADD `zip_length` INT DEFAULT '10' NOT NULL, ADD `phone_1_length` INT DEFAULT '12' NOT NULL, ADD `phone_2_length` INT DEFAULT '12' NOT NULL, ADD `fax_length` INT DEFAULT '12' NOT NULL;

ALTER TABLE `geodesic_classifieds_discount_codes` ADD `discount_email` TINYTEXT NOT NULL;

ALTER TABLE `geodesic_registration_configuration` ADD `firstname_maxlength` INT DEFAULT '50', ADD `lastname_maxlength` INT  DEFAULT '50';
ALTER TABLE `geodesic_registration_configuration` ADD `company_name_maxlength` INT  DEFAULT '50';
ALTER TABLE `geodesic_registration_configuration` ADD `address_maxlength` INT  DEFAULT '50';
ALTER TABLE `geodesic_registration_configuration` ADD `address_2_maxlength` INT  DEFAULT '50', ADD `phone_maxlength` INT  DEFAULT '50', ADD `phone_2_maxlength` INT  DEFAULT '50', ADD `fax_maxlength` INT  DEFAULT '50';
ALTER TABLE `geodesic_registration_configuration` ADD `city_maxlength` INT  DEFAULT '50', ADD `zip_maxlength` INT  DEFAULT '50', ADD `url_maxlength` INT  DEFAULT '50', ADD `optional_1_maxlength` INT  DEFAULT '50', ADD `optional_2_maxlength` INT  DEFAULT '50';
ALTER TABLE `geodesic_registration_configuration` ADD `optional_3_maxlength` INT  DEFAULT '50', ADD `optional_4_maxlength` INT  DEFAULT '50', ADD `optional_5_maxlength` INT  DEFAULT '50', ADD `optional_6_maxlength` INT  DEFAULT '50', ADD `optional_7_maxlength` INT  DEFAULT '50', ADD `optional_8_maxlength` INT  DEFAULT '50', ADD `optional_9_maxlength` INT  DEFAULT '50', ADD `optional_10_maxlength` INT  DEFAULT '50';
ALTER TABLE `geodesic_classifieds_configuration` ADD `seller_contact` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_categories` ADD `display_ad_description` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `display_ad_description_where` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `display_all_of_description` INT DEFAULT '0' NOT NULL;
ALTER TABLE `geodesic_classifieds_categories` ADD `length_of_description` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `email_header_break` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_cc_twocheckout` ADD `account_type` INT NOT NULL;

ALTER TABLE `geodesic_pages_fonts` ADD `text_transform` VARCHAR(20) NOT NULL;

ALTER TABLE `geodesic_classifieds_discount_codes` ADD `userID` INT NOT NULL AFTER `active`;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `popup_image_template_id` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `popup_image_extra_width` INT NOT NULL, ADD `popup_image_extra_height` INT NOT NULL;

ALTER TABLE `geodesic_cc_linkpoint_transactions` ADD `r_authresponse` TINYTEXT NOT NULL AFTER `r_tax`, ADD `r_csp` TINYTEXT NOT NULL AFTER `r_authresponse`, ADD `r_vpasresponse` TINYTEXT NOT NULL AFTER `r_csp`;

ALTER TABLE `geodesic_classifieds_configuration` ADD `admin_email_edit` INT DEFAULT '0' NOT NULL;

INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category) VALUES (157, 1, 'Popup Image Box', 'This is the popup page displayed with the full size image within it.  This can be turned on and off within ad configuration', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0);

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`) VALUES ('158', '0', 'Fixed Category Navigation 1', 'Displays the subcategories to a chosen category. The subcategories displayed is fixed and displays the same subcategories where ever it is used.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_subcategory_navigation_1.php', '<SUBCATEGORY_NAVIGATION_1>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '', '0', '0');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`) VALUES ('159', '0', 'Fixed Category Navigation 2', 'Displays the subcategories to a chosen category. The subcategories displayed is fixed and displays the same subcategories where ever it is used.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_subcategory_navigation_2.php', '<SUBCATEGORY_NAVIGATION_2>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '', '0', '0');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`) VALUES ('160', '0', 'Fixed Category Navigation 3', 'Displays the subcategories to a chosen category. The subcategories displayed is fixed and displays the same subcategories where ever it is used.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_subcategory_navigation_3.php', '<SUBCATEGORY_NAVIGATION_3>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '', '0', '0');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`) VALUES ('161', '0', 'Fixed Category Navigation 4', 'Displays the subcategories to a chosen category. The subcategories displayed is fixed and displays the same subcategories where ever it is used.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_subcategory_navigation_4.php', '<SUBCATEGORY_NAVIGATION_4>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '', '0', '0');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`) VALUES ('162', '0', 'Fixed Category Navigation 5', 'Displays the subcategories to a chosen category. The subcategories displayed is fixed and displays the same subcategories where ever it is used.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_subcategory_navigation_5.php', '<SUBCATEGORY_NAVIGATION_5>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '', '0', '0');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`) VALUES ('163', '0', 'Fixed Category Navigation 6', 'Displays the subcategories to a chosen category. The subcategories displayed is fixed and displays the same subcategories where ever it is used.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_subcategory_navigation_6.php', '<SUBCATEGORY_NAVIGATION_6>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '', '0', '0');
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`) VALUES ('164', '0', 'Fixed Category Navigation 7', 'Displays the subcategories to a chosen category. The subcategories displayed is fixed and displays the same subcategories where ever it is used.', '', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'module_display_subcategory_navigation_7.php', '<SUBCATEGORY_NAVIGATION_7>', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '0', '0', '', '', '0', '0');

ALTER TABLE `geodesic_classifieds_configuration` ADD `category_new_ad_limit` INT NOT NULL, ADD `category_new_ad_image` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_pages` ADD `module_display_new_ad_icon` INT NOT NULL;

ALTER TABLE `geodesic_classifieds` ADD `url_link_1` TINYTEXT NOT NULL, ADD `url_link_2` TINYTEXT NOT NULL, ADD `url_link_3` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_expired` ADD `url_link_1` TINYTEXT NOT NULL, ADD `url_link_2` TINYTEXT NOT NULL, ADD `url_link_3` TINYTEXT NOT NULL;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `url_link_1` TINYTEXT NOT NULL, ADD `url_link_2` TINYTEXT NOT NULL, ADD `url_link_3` TINYTEXT NOT NULL;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_url_link_1` INT NOT NULL, ADD `editable_url_link_1` INT NOT NULL, ADD `url_link_1_length` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_url_link_2` INT NOT NULL, ADD `editable_url_link_2` INT NOT NULL, ADD `url_link_2_length` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `use_url_link_3` INT NOT NULL, ADD `editable_url_link_3` INT NOT NULL, ADD `url_link_3_length` INT NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `use_url_link_1` INT DEFAULT '0' NOT NULL, ADD `require_url_link_1` INT DEFAULT '0' NOT NULL, ADD `use_url_link_2` INT DEFAULT '0' NOT NULL, ADD `require_url_link_2` INT DEFAULT '0' NOT NULL, ADD `use_url_link_3` INT DEFAULT '0' NOT NULL, ADD `require_url_link_3` INT DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_categories` ADD `use_url_link_1` INT NOT NULL , ADD `use_url_link_2` INT NOT NULL , ADD `use_url_link_3` INT NOT NULL ;


CREATE TABLE `geodesic_email_domains` (
`serial_id` MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`domain` tinytext NOT NULL );

ALTER TABLE `geodesic_classifieds_logins` CHANGE `password` `password` VARCHAR(64) NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `password_key` VARCHAR(32) NOT NULL;

INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (165, 0, 'Display Logged In/Out HTML - 4', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_4.php', '<<LOGGED_IN_OUT_HTML_4>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (166, 0, 'Display Logged In/Out HTML - 5', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_5.php', '<<LOGGED_IN_OUT_HTML_5>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (167, 0, 'Display Logged In/Out HTML - 6', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_6.php', '<<LOGGED_IN_OUT_HTML_6>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (170, 0, 'Total Live Users', 'This module will display the number of users that are currently live on the site.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_total_live_users.php', '<MODULE_TOTAL_LIVE_USERS>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (169, 0, 'Total Number of registered users', 'This module displays the total number of registered users.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_total_registered_users.php', '<MODULE_TOTAL_REGISTERED_USERS>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (171, 0, 'Title Module', 'Displays the Title', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_title_ads.php', '<MODULE_TITLE>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (172, 0, 'Hottest Ads Module', 'Displays the ads that have been viewed the most', '', 0, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_hottest_ads.php', '<MODULE_HOTTEST_ADS>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);

ALTER TABLE `geodesic_classifieds_configuration` ADD `use_css` INT(11) DEFAULT '1' NOT NULL;

CREATE TABLE `geodesic_group_attached_price_plans` (
	`group_id` int(11) NOT NULL default '0',
	`price_plan_id` int(11) NOT NULL default '0',
	`name` tinytext NOT NULL,
	`description` tinytext NOT NULL
) TYPE=MyISAM;

ALTER TABLE `geodesic_classifieds_user_subscriptions` ADD `price_plan_id` INT NOT NULL AFTER `subscription_id` ;

ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `price_plan_id` INT NOT NULL ;
ALTER TABLE `geodesic_cc_linkpoint_transactions` ADD `price_plan_id` INT NOT NULL ;
ALTER TABLE `geodesic_cc_bitel_transactions` ADD `price_plan_id` INT NOT NULL ;
ALTER TABLE `geodesic_cc_twocheckout_transactions` ADD `price_plan_id` INT NOT NULL ;
ALTER TABLE `geodesic_paypal_transactions` ADD `price_plan_id` INT NOT NULL ;
ALTER TABLE `geodesic_worldpay_transactions` ADD `price_plan_id` INT NOT NULL ;

INSERT INTO geodesic_classifieds_html_allowed VALUES (59, 'DIV', 0, 1, '', 1, 1);

ALTER TABLE `geodesic_classifieds` ADD `price_plan_id` INT NOT NULL ;

ALTER TABLE `geodesic_classifieds_configuration` ADD `user_set_hold_email` INT( 11 ) DEFAULT '0' NOT NULL;

INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (155, 0, 'Category Specific Featured Ad Module 1', 'This module display featured ads from a specific category.', '', 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 'module_featured_ads_from_category_1.php', '<FEATURED_CATEGORY_1>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 50, 50, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 196, 0);
INSERT INTO geodesic_pages (page_id, section_id, name, description, special_instructions, internal_template, module, module_number_of_ads_to_display, module_display_header_row, module_display_business_type, module_display_photo_icon, module_display_ad_description, module_display_ad_description_where, module_display_price, module_display_entry_date, display_all_of_description, length_of_description, module_file_name, module_replace_tag, module_display_username, module_display_title, module_display_contact, module_display_phone1, module_display_phone2, module_display_address, module_display_optional_field_1, module_display_optional_field_2, module_display_optional_field_3, module_display_optional_field_4, module_display_optional_field_5, module_display_optional_field_6, module_display_optional_field_7, module_display_optional_field_8, module_display_optional_field_9, module_display_optional_field_10, module_display_optional_field_11, module_display_optional_field_12, module_display_optional_field_13, module_display_optional_field_14, module_display_optional_field_15, module_display_optional_field_16, module_display_optional_field_17, module_display_optional_field_18, module_display_optional_field_19, module_display_optional_field_20, module_display_city, module_display_state, module_display_country, module_display_zip, module_logged_in_html, module_logged_out_html, module_display_name, module_use_image, module_display_classified_id, module_thumb_width, module_thumb_height, module_display_attention_getter, module_number_of_columns, module_display_filter_in_row, cache_expire, use_category_cache, category_cache, number_of_browsing_columns, display_category_count, display_category_description, display_no_subcategory_message, display_category_image, display_unselected_subfilters, php_code, display_empty_message, module_category_level_to_display, module_category, module_display_new_ad_icon) VALUES (156, 0, 'Category Specific Featured Ad Module 2', 'This module display featured ads from a specific category.', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_featured_ads_from_category_2.php', '<FEATURED_CATEGORY_2>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);

ALTER TABLE `geodesic_cc_internetsecure` CHANGE `returnurl` `language` TINYTEXT NOT NULL;

ALTER TABLE `geodesic_pages_modules` ADD `time` INT( 11 ) NOT NULL ;

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (173, 11, 'Add to Account Balance Form', 'This page is the first step in the process to allow the client add money to their account balance.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (174, 11, 'Add to Account Balance Approval Page', 'This page is the second step in the process to allow the client add money to their account balance.  The client is able to approve the amount of the transaction before they are sent to the prospective payment handler', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (175, 11, 'Add to Account Balance Success/Failure', 'This page is the last step in the process to allow the client add money to their account balance.  This page tells the client the success or failure of the attempt to add funds to their account.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);

ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_cc_bitel_transactions` ADD `account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_cc_internetsecure_transactions` ADD `account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_cc_linkpoint_transactions` ADD `account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_cc_twocheckout_transactions` ADD `account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_paypal_transactions` ADD `account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_worldpay_transactions` ADD `account_balance` INT NOT NULL ;

ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `pay_invoice` INT NOT NULL ;
ALTER TABLE `geodesic_cc_bitel_transactions` ADD `pay_invoice` INT NOT NULL ;
ALTER TABLE `geodesic_cc_internetsecure_transactions` ADD `pay_invoice` INT NOT NULL ;
ALTER TABLE `geodesic_cc_linkpoint_transactions` ADD `pay_invoice` INT NOT NULL ;
ALTER TABLE `geodesic_cc_twocheckout_transactions` ADD `pay_invoice` INT NOT NULL ;
ALTER TABLE `geodesic_paypal_transactions` ADD `pay_invoice` INT NOT NULL ;
ALTER TABLE `geodesic_worldpay_transactions` ADD `pay_invoice` INT NOT NULL ;

ALTER TABLE `geodesic_classifieds_price_plans` ADD `use_featured_ads` INT(11) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_2` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_3` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_4` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_5` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_bolding` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_better_placement` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_attention_getters` INT( 11 ) DEFAULT '1' NOT NULL;

ALTER TABLE `geodesic_classifieds` ADD `print_title` TINYTEXT NOT NULL , ADD `print_description` MEDIUMTEXT NOT NULL , ADD `print` INT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `print` INT NOT NULL , ADD `print_title` TINYTEXT NOT NULL , ADD `print_description` MEDIUMTEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `print_web_approved` INT NOT NULL ;

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (176, 2, 'Print/Web Choice Form', 'This page allows the user to choose to place their ad within the classified system, print or both.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_1` `optional_field_1` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_2` `optional_field_2` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_3` `optional_field_3` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_4` `optional_field_4` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_5` `optional_field_5` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_6` `optional_field_6` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_7` `optional_field_7` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_8` `optional_field_8` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_9` `optional_field_9` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_10` `optional_field_10` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_11` `optional_field_11` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_12` `optional_field_12` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_13` `optional_field_13` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_14` `optional_field_14` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_15` `optional_field_15` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_16` `optional_field_16` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_17` `optional_field_17` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_18` `optional_field_18` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_19` `optional_field_19` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds` CHANGE `optional_field_20` `optional_field_20` TEXT NOT NULL ;

ALTER TABLE `geodesic_classifieds_ads_extra` CHANGE `value` `value` TEXT NOT NULL ;

ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_1` `optional_field_1` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_2` `optional_field_2` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_3` `optional_field_3` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_4` `optional_field_4` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_5` `optional_field_5` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_6` `optional_field_6` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_7` `optional_field_7` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_8` `optional_field_8` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_9` `optional_field_9` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_10` `optional_field_10` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_11` `optional_field_11` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_12` `optional_field_12` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_13` `optional_field_13` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_14` `optional_field_14` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_15` `optional_field_15` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_16` `optional_field_16` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_17` `optional_field_17` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_18` `optional_field_18` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_19` `optional_field_19` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_expired` CHANGE `optional_field_20` `optional_field_20` TEXT NOT NULL ;

ALTER TABLE `geodesic_classifieds_sell_session_questions` CHANGE `question_value` `question_value` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session_questions` CHANGE `question_value_other` `question_value_other` TEXT NOT NULL ;

ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_1` `optional_field_1` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_2` `optional_field_2` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_3` `optional_field_3` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_4` `optional_field_4` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_5` `optional_field_5` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_6` `optional_field_6` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_7` `optional_field_7` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_8` `optional_field_8` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_9` `optional_field_9` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_10` `optional_field_10` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_11` `optional_field_11` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_12` `optional_field_12` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_13` `optional_field_13` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_14` `optional_field_14` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_15` `optional_field_15` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_16` `optional_field_16` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_17` `optional_field_17` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_18` `optional_field_18` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_19` `optional_field_19` TEXT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` CHANGE `optional_field_20` `optional_field_20` TEXT NOT NULL ;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `print_title_length` INT default '100' NOT NULL ;

ALTER TABLE `geodesic_classifieds_configuration` ADD `maximum_print_description_length` INT default '1000' NOT NULL ;

ALTER TABLE `geodesic_classifieds_price_plans_categories` ADD `use_featured_ads` INT( 11 ) NOT NULL , ADD `use_featured_ads_level_2` INT( 11 ) NOT NULL , ADD `use_featured_ads_level_3` INT( 11 ) NOT NULL , ADD `use_featured_ads_level_4` INT( 11 ) NOT NULL , ADD `use_featured_ads_level_5` INT( 11 ) NOT NULL , ADD `use_bolding` INT( 11 ) NOT NULL , ADD `use_better_placement` INT( 11 ) NOT NULL , ADD `use_attention_getters` INT( 11 ) NOT NULL;

ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `textarea_wrap` TINYINT DEFAULT '0' NOT NULL ;

DELETE FROM `geodesic_pages_fonts` WHERE `element_id` = '101667' LIMIT 1;
DELETE FROM `geodesic_pages_fonts` WHERE `element_id` = '101666' LIMIT 1;

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (177, 4, 'Admin Invoice Email', 'This contains all of the text used within the email sent to a user that you invoice.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
ALTER TABLE `geodesic_classifieds_configuration` ADD `invoice_cutoff` INT NOT NULL ;

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (178, 11, 'Pay Invoice Balance Form', 'This page is the first step in the process to allow the client pay for an invoice.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (179, 11, 'Pay Invoice Approval Page', 'This page is the second step in the process to allow the client to pay for an invoice.  The client is able to approve the invoice payment transaction before they are sent to the prospective payment handler', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (180, 11, 'Pay Invoice Success/Failure', 'This page is the last step in the process to allow the client pay for an invoice.  This page tells the client the success or failure of the attempt to pay for their invoice.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (181, 11, 'Invoices Paid', 'This page displays all of the clients paid invoices.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (182, 11, 'Invoices Unpaid', 'This page displays all of the clients unpaid invoices and provides a link allowing the client to pay each invoice.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (183, 11, 'Invoice Detail', 'This page displays the details of a clients invoice whether paid or unpaid.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (173, 11, 'Add to Account Balance Form', 'This page is the first step in the process to allow the client add money to their account balance.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (174, 11, 'Add to Account Balance Approval Page', 'This page is the second step in the process to allow the client add money to their account balance.  The client is able to approve the amount of the transaction before they are sent to the prospective payment handler', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`) VALUES (175, 11, 'Add to Account Balance Success/Failure', 'This page is the last step in the process to allow the client add money to their account balance.  This page tells the client the success or failure of the attempt to add funds to their account.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0);

ALTER TABLE `geodesic_classifieds_states` ADD `display_order` INT( 11 ) NOT NULL ;
ALTER TABLE `geodesic_classifieds_countries` ADD `display_order` INT( 11) NOT NULL ;

ALTER TABLE `geodesic_classifieds_price_plans_categories` ADD `use_featured_ads` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_2` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_3` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_4` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_featured_ads_level_5` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_bolding` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_better_placement` INT( 11 ) DEFAULT '1' NOT NULL , ADD `use_attention_getters` INT( 11 ) DEFAULT '1' NOT NULL;

ALTER TABLE `geodesic_classifieds_userdata` ADD `account_balance` DOUBLE( 7, 2 ) DEFAULT '0' NOT NULL ;
ALTER TABLE `geodesic_classifieds_configuration` ADD `use_account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_classifieds_sell_session` ADD `account_balance` INT NOT NULL ;
ALTER TABLE `geodesic_classifieds_configuration` ADD `positive_balances_only` INT DEFAULT '1' NOT NULL ;

ALTER TABLE `geodesic_classifieds_sell_session` ADD `pay_invoice` INT DEFAULT '0' NOT NULL AFTER `account_balance` ;

CREATE TABLE `geodesic_balance_transactions` (
	`transaction_id` int(11) NOT NULL auto_increment,
	`userID` int(11) NOT NULL default '0',
	`ad_id` int(11) NOT NULL default '0',
	`auction_id` int(11) NOT NULL default '0',
	`renewal` int(11) NOT NULL default '0',
	`bolding` int(11) NOT NULL default '0',
	`better_placement` int(11) NOT NULL default '0',
	`featured_ad` int(11) NOT NULL default '0',
	`featured_ad_2` int(11) NOT NULL default '0',
	`featured_ad_3` int(11) NOT NULL default '0',
	`featured_ad_4` int(11) NOT NULL default '0',
	`featured_ad_5` int(11) NOT NULL default '0',
	`attention_getter` int(11) NOT NULL default '0',
	`amount` double(7,2) NOT NULL default '0.00',
	`date` int(11) NOT NULL default '0',
	`approved` int(11) NOT NULL default '0',
	`payment_type` int(11) NOT NULL default '0',
	`cc_transaction_id` int(11) NOT NULL default '0',
	`invoice_id` int(11) NOT NULL default '0',
	UNIQUE KEY `transaction_id` (`transaction_id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

ALTER TABLE `geodesic_balance_transactions` ADD `ad_id` INT DEFAULT '0' NOT NULL AFTER `userID` ;
ALTER TABLE `geodesic_balance_transactions` ADD `auction_id` INT DEFAULT '0' NOT NULL AFTER `ad_id` ;
ALTER TABLE `geodesic_balance_transactions` ADD `renewal` INT DEFAULT '0' NOT NULL AFTER `auction_id` ;
ALTER TABLE `geodesic_balance_transactions` ADD `bolding` INT DEFAULT '0' NOT NULL AFTER `renewal` ;
ALTER TABLE `geodesic_balance_transactions` ADD `better_placement` INT DEFAULT '0' NOT NULL AFTER `bolding` ;
ALTER TABLE `geodesic_balance_transactions` ADD `featured_ad` INT DEFAULT '0' NOT NULL AFTER `better_placement` ;
ALTER TABLE `geodesic_balance_transactions` ADD `featured_ad_2` INT DEFAULT '0' NOT NULL AFTER `featured_ad` ;
ALTER TABLE `geodesic_balance_transactions` ADD `featured_ad_3` INT DEFAULT '0' NOT NULL AFTER `featured_ad_2` ;
ALTER TABLE `geodesic_balance_transactions` ADD `featured_ad_4` INT DEFAULT '0' NOT NULL AFTER `featured_ad_3` ;
ALTER TABLE `geodesic_balance_transactions` ADD `featured_ad_5` INT DEFAULT '0' NOT NULL AFTER `featured_ad_4` ;
ALTER TABLE `geodesic_balance_transactions` ADD `attention_getter` INT DEFAULT '0' NOT NULL AFTER `featured_ad_5` ;

CREATE TABLE `geodesic_invoices` (
	`invoice_id` int(11) NOT NULL auto_increment,
	`userID` int(11) NOT NULL default '0',
	`invoice_date` int(11) NOT NULL default '0',
	`date_paid` int(11) NOT NULL default '0',
	`payment_note` mediumtext NOT NULL,
	UNIQUE KEY `invoice_id` (`invoice_id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `geodesic_classifieds_payment_choices` ( `payment_choice_id` , `name` , `explanation` , `accepted` , `type` )
	VALUES ('7', 'Site Balance', 'This payment type comes in two configurations.  Both allow the user to pay for ad placement out of an account balance.  One configuration forces the client to keep a positive balance to pay for their ads.  The other configuration allows the client to add ad placement charges to his balance and then pay for those charges through an invoice system.', '0', '7');

ALTER TABLE `geodesic_classifieds_configuration` ADD `no_image_url` TINYTEXT NOT NULL ;

ALTER TABLE `geodesic_pages` ADD `photo_or_icon` INT( 11 ) DEFAULT '2' NOT NULL ;

ALTER TABLE `geodesic_classifieds_configuration` ADD `display_ad_title` INT( 11 ) DEFAULT '1' NOT NULL ;
ALTER TABLE `geodesic_classifieds_categories` ADD `display_ad_title` INT( 11 ) DEFAULT '1' NOT NULL ;

CREATE TABLE `geodesic_pages_modules_sections` (
	`section_id` int(11) NOT NULL auto_increment,
	`name` tinytext NOT NULL,
	`description` tinytext NOT NULL,
	`parent_section` int(11) NOT NULL default '0',
	`display_order` tinyint(4) NOT NULL default '0',
	UNIQUE KEY `section_id` (`section_id`),
	KEY `section_id_2` (`section_id`)
) TYPE=MyISAM;

INSERT INTO `geodesic_pages_modules_sections` VALUES (1, 'Browsing Modules', 'Modules that are designed to configure browsing characteristics of your site.', 0, 5);
INSERT INTO `geodesic_pages_modules_sections` VALUES (2, 'Featured Ad Modules', 'Modules that are designed to configure display and browsing with respect to featured ads.', 0, 10);
INSERT INTO `geodesic_pages_modules_sections` VALUES (3, 'Newest Ad Modules', 'Modules that are designed to configure display and browsing with respect to newest ads.', 0, 15);
INSERT INTO `geodesic_pages_modules_sections` VALUES (4, 'HTML Modules', 'Modules designed for html display and consolidation on your site.', 0, 20);
INSERT INTO `geodesic_pages_modules_sections` VALUES (5, 'PHP Modules', 'Modules designed for php use on your site.', 0, 25);
INSERT INTO `geodesic_pages_modules_sections` VALUES (6, 'Miscellaneous Modules', 'Modules of various characteristics for use on your site.', 0, 30);
INSERT INTO `geodesic_pages_modules_sections` VALUES (7, 'Miscellaneous Ad Display Modules', 'Modules of various characteristics related to ads display for use on your site.', 0, 35);
INSERT INTO `geodesic_pages_modules_sections` VALUES (8, 'Browsing Filter Modules', 'Modules designed to filter browsing results.', 1, 5);
INSERT INTO `geodesic_pages_modules_sections` VALUES (9, 'Category Navigation', 'Modules designed to display category navigation in different manners.', 1, 10);
INSERT INTO `geodesic_pages_modules_sections` VALUES (10, 'Category Tree Display Modules', 'Modules to be used for the display of the category tree structure.', 1, 15);
INSERT INTO `geodesic_pages_modules_sections` VALUES (11, 'Link Modules', 'Modules use to display links to various features/functions of the software.', 1, 20);
INSERT INTO `geodesic_pages_modules_sections` VALUES (12, 'Featured Ad Modules - Level 1', 'Modules for displaying featured ads on your site. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ', 2, 5);
INSERT INTO `geodesic_pages_modules_sections` VALUES (13, 'Featured Ad Modules - Level 2', 'Modules for displaying featured ads on your site that are of a level status 2 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ', 2, 10);
INSERT INTO `geodesic_pages_modules_sections` VALUES (14, 'Featured Ad Modules - Level 3', 'Modules for displaying featured ads on your site that are of a level status 3 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ', 2, 15);
INSERT INTO `geodesic_pages_modules_sections` VALUES (15, 'Featured Ad Modules - Level 4', 'Modules for displaying featured ads on your site that are of a level status 4 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ', 2, 20);
INSERT INTO `geodesic_pages_modules_sections` VALUES (16, 'Featured Ad Modules - Level 5', 'Modules for displaying featured ads on your site that are of a level status 2 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ', 2, 25);


ALTER TABLE `geodesic_pages` ADD `module_type` INT DEFAULT '0' NOT NULL ;


UPDATE `geodesic_pages` SET `module_type` = '8' WHERE `page_id` = '134' LIMIT 1 ;
UPDATE `geodesic_pages` SET `description` = 'While browsing a user can limit the ads displayed to a certain zip and distance radius. THIS MODULE REQUIRES THE ZIP SEARCH ADD-ON.',`module_type` = '8' WHERE `page_id` = '133' LIMIT 1 ;
UPDATE `geodesic_pages` SET `description` = 'Displays the category navigation links to the subcategories below the current page. Ex: Displays the second level categories if placed on the home page.' WHERE `page_id` = '114' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '94' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '95' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '96' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '114' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '100' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '158' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '159' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '160' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '161' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '162' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '163' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '9' WHERE `page_id` = '164' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '10' WHERE `page_id` = '97' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '10' WHERE `page_id` = '98' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '10' WHERE `page_id` = '99' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '11' WHERE `page_id` = '66' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '11' WHERE `page_id` = '67' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '11' WHERE `page_id` = '68' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '11' WHERE `page_id` = '78' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '11' WHERE `page_id` = '79' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '11' WHERE `page_id` = '80' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '11' WHERE `page_id` = '88' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '3' WHERE `page_id` = '60' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '3' WHERE `page_id` = '61' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '5' WHERE `page_id` = '103' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '5' WHERE `page_id` = '104' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '5' WHERE `page_id` = '105' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '5' WHERE `page_id` = '110' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '5' WHERE `page_id` = '111' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '5' WHERE `page_id` = '112' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '4' WHERE `page_id` = '75' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '4' WHERE `page_id` = '76' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '4' WHERE `page_id` = '77' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '4' WHERE `page_id` = '165' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '4' WHERE `page_id` = '166' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '4' WHERE `page_id` = '167' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '7' WHERE `page_id` = '172' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '54' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '53' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '106' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '91' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '101' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '171' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '170' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '6' WHERE `page_id` = '169' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '155' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '156' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '89' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '90' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '102' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '46' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '47' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '48' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '49' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '12' WHERE `page_id` = '50' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '13' WHERE `page_id` = '117' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '13' WHERE `page_id` = '118' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '13' WHERE `page_id` = '125' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '13' WHERE `page_id` = '126' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '14' WHERE `page_id` = '119' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '14' WHERE `page_id` = '120' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '14' WHERE `page_id` = '127' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '14' WHERE `page_id` = '128' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '15' WHERE `page_id` = '121' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '15' WHERE `page_id` = '122' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '15' WHERE `page_id` = '129' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '15' WHERE `page_id` = '130' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '16' WHERE `page_id` = '123' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '16' WHERE `page_id` = '124' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '16' WHERE `page_id` = '131' LIMIT 1 ;
UPDATE `geodesic_pages` SET `module_type` = '16' WHERE `page_id` = '132' LIMIT 1 ;


UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module 1 - Specific Category Only' WHERE `page_id` = '155' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module 2 - Specific Category Only' WHERE `page_id` = '156' LIMIT 1 ;
UPDATE `geodesic_pages` SET `description` = 'This module displays featured Ads from a set category on your site. You can use this module at any location of your site and the Ads will always be pulled from the category set in this module.' WHERE `page_id` = '155' LIMIT 1 ;
UPDATE `geodesic_pages` SET `description` = 'This module displays featured Ads from a set category on your site. You can use this module at any location of your site and the Ads will always be pulled from the category set in this module.' WHERE `page_id` = '156' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 1' WHERE `page_id` = '46' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 3' WHERE `page_id` = '48' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 4' WHERE `page_id` = '49' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 5' WHERE `page_id` = '50' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 2 - All Categories' WHERE `page_id` = '47' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 1' WHERE `page_id` = '89' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 2' WHERE `page_id` = '90' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 3' WHERE `page_id` = '102' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 1' WHERE `page_id` = '117' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 2' WHERE `page_id` = '118' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 1' WHERE `page_id` = '119' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 2' WHERE `page_id` = '120' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 1' WHERE `page_id` = '121' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 2' WHERE `page_id` = '122' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 1' WHERE `page_id` = '123' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - Pic Display - 2' WHERE `page_id` = '124' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 1' WHERE `page_id` = '125' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 2' WHERE `page_id` = '126' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 1' WHERE `page_id` = '127' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 2' WHERE `page_id` = '128' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 1' WHERE `page_id` = '129' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 2' WHERE `page_id` = '130' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 1' WHERE `page_id` = '131' LIMIT 1 ;
UPDATE `geodesic_pages` SET `name` = 'Featured Ad Module - 2' WHERE `page_id` = '132' LIMIT 1 ;

UPDATE `geodesic_pages_modules_sections` SET `description` = 'Modules for displaying featured ads on your site. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ' WHERE `section_id` = '12' LIMIT 1 ;
UPDATE `geodesic_pages_modules_sections` SET `description` = 'Modules for displaying featured ads on your site that are of a level status 2 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ' WHERE `section_id` = '13' LIMIT 1 ;
UPDATE `geodesic_pages_modules_sections` SET `description` = 'Modules for displaying featured ads on your site that are of a level status 3 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ' WHERE `section_id` = '14' LIMIT 1 ;
UPDATE `geodesic_pages_modules_sections` SET `description` = 'Modules for displaying featured ads on your site that are of a level status 4 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ' WHERE `section_id` = '15' LIMIT 1 ;
UPDATE `geodesic_pages_modules_sections` SET `description` = 'Modules for displaying featured ads on your site that are of a level status 2 only. NOTE: If you are not using different levels of featured ads then by default all ads placed are Level 1. ' WHERE `section_id` = '16' LIMIT 1 ;

INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (184, 11, 'Balance Transaction List Display', 'This page allow the client to display their past balance transactions for review.', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (185, 0, 'Display Logged In/Out HTML - 8', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_8.php', '<<LOGGED_IN_OUT_HTML_8>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (186, 0, 'Display Logged In/Out HTML - 9', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_9.php', '<<LOGGED_IN_OUT_HTML_9>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (187, 0, 'Display Logged In/Out HTML - 10', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_10.php', '<<LOGGED_IN_OUT_HTML_10>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (188, 0, 'Display Logged In/Out HTML - 11', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_11.php', '<<LOGGED_IN_OUT_HTML_11>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (189, 0, 'Display Logged In/Out HTML - 12', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_12.php', '<<LOGGED_IN_OUT_HTML_12>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (190, 0, 'Display Logged In/Out HTML - 13', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_13.php', '<<LOGGED_IN_OUT_HTML_13>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (191, 0, 'Display Logged In/Out HTML - 14', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_14.php', '<<LOGGED_IN_OUT_HTML_14>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (192, 0, 'Display Logged In/Out HTML - 15', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_15.php', '<<LOGGED_IN_OUT_HTML_15>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (193, 0, 'Display Logged In/Out HTML - 16', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_16.php', '<<LOGGED_IN_OUT_HTML_16>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (194, 0, 'Display Logged In/Out HTML - 17', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_17.php', '<<LOGGED_IN_OUT_HTML_17>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (195, 0, 'Display Logged In/Out HTML - 18', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_18.php', '<<LOGGED_IN_OUT_HTML_18>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (196, 0, 'Display Logged In/Out HTML - 19', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_19.php', '<<LOGGED_IN_OUT_HTML_19>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (197, 0, 'Display Logged In/Out HTML - 20', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_20.php', '<<LOGGED_IN_OUT_HTML_20>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);
INSERT INTO `geodesic_pages` (`page_id`, `section_id`, `name`, `description`, `special_instructions`, `internal_template`, `module`, `module_number_of_ads_to_display`, `module_display_header_row`, `module_display_business_type`, `module_display_photo_icon`, `module_display_ad_description`, `module_display_ad_description_where`, `module_display_price`, `module_display_entry_date`, `display_all_of_description`, `length_of_description`, `module_file_name`, `module_replace_tag`, `module_display_username`, `module_display_title`, `module_display_contact`, `module_display_phone1`, `module_display_phone2`, `module_display_address`, `module_display_optional_field_1`, `module_display_optional_field_2`, `module_display_optional_field_3`, `module_display_optional_field_4`, `module_display_optional_field_5`, `module_display_optional_field_6`, `module_display_optional_field_7`, `module_display_optional_field_8`, `module_display_optional_field_9`, `module_display_optional_field_10`, `module_display_optional_field_11`, `module_display_optional_field_12`, `module_display_optional_field_13`, `module_display_optional_field_14`, `module_display_optional_field_15`, `module_display_optional_field_16`, `module_display_optional_field_17`, `module_display_optional_field_18`, `module_display_optional_field_19`, `module_display_optional_field_20`, `module_display_city`, `module_display_state`, `module_display_country`, `module_display_zip`, `module_logged_in_html`, `module_logged_out_html`, `module_display_name`, `module_use_image`, `module_display_classified_id`, `module_thumb_width`, `module_thumb_height`, `module_display_attention_getter`, `module_number_of_columns`, `module_display_filter_in_row`, `cache_expire`, `use_category_cache`, `category_cache`, `number_of_browsing_columns`, `display_category_count`, `display_category_description`, `display_no_subcategory_message`, `display_category_image`, `display_unselected_subfilters`, `php_code`, `display_empty_message`, `module_category_level_to_display`, `module_category`, `module_display_new_ad_icon`, `photo_or_icon`, `module_type`, `module_display_auction_id`, `module_display_number_bids`, `module_display_time_left`) VALUES (198, 0, 'Display Logged In/Out HTML - 7', 'This module will display logged in HTML when the user is logged in and different HTML when the user is logged out.  ', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'module_display_login_logout_html_7.php', '<<LOGGED_IN_OUT_HTML_7>>', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 4, 0, 0, 0);

DROP TABLE `geodesic_version`;
DROP TABLE `geodesic_classifieds_version`;

CREATE TABLE `geodesic_version` (
	`db_version` TINYTEXT NOT NULL
);


ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `title_module_text` TEXT NOT NULL ;

DELETE FROM `geodesic_pages_fonts` WHERE `element_id` = '306' LIMIT 1;
UPDATE `geodesic_pages_messages` SET `name` = 'Address+Field+Label', `description` = 'Label+text+for+address' WHERE `message_id` = '644' LIMIT 1 ;
DELETE FROM `geodesic_pages_fonts` WHERE `element_id` = '392' LIMIT 1;

UPDATE `geodesic_pages_messages` SET `name` = 'category+tree+prefix' WHERE `message_id` = '680' LIMIT 1;
ALTER TABLE `geodesic_classifieds_configuration` ADD `send_admin_placement_email` INT DEFAULT '0' NOT NULL ;

ALTER TABLE `geodesic_auctions_ad_configuration` ADD `title_module_text` TEXT NOT NULL ;

ALTER TABLE `geodesic_templates` ADD `last_template` LONGTEXT NOT NULL;

DELETE FROM `geodesic_pages_messages_languages` WHERE `page_id` = '26' AND `text_id` = '368';
DELETE FROM `geodesic_pages_messages` WHERE `message_id` = '368' LIMIT 1;

DELETE FROM `geodesic_pages_messages` WHERE `message_id` = '367' LIMIT 1;
DELETE FROM `geodesic_pages_messages_languages` WHERE `page_id` = '26' AND `text_id` = '367';

ALTER TABLE `geodesic_classifieds_categories` rename `geodesic_categories`;
ALTER TABLE `geodesic_sessions` ADD `auction_session` VARCHAR( 32 ) NOT NULL AFTER `classified_session`;
ALTER TABLE `geodesic_classifieds_choices` RENAME `geodesic_choices`;
ALTER TABLE `geodesic_classifieds_file_types` RENAME `geodesic_file_types`;
ALTER TABLE `geodesic_classifieds_groups` RENAME `geodesic_groups`;
ALTER TABLE `geodesic_classifieds_html_allowed` RENAME `geodesic_html_allowed`;
ALTER TABLE `geodesic_classifieds_logins` RENAME `geodesic_logins`;
ALTER TABLE `geodesic_classifieds_payment_choices` RENAME `geodesic_payment_choices`;
ALTER TABLE `geodesic_classifieds_registration_question_choices` RENAME `geodesic_registration_question_choices`;
ALTER TABLE `geodesic_classifieds_registration_question_types` RENAME `geodesic_registration_question_types`;
ALTER TABLE `geodesic_classifieds_states` RENAME `geodesic_states`;
ALTER TABLE `geodesic_classifieds_countries` RENAME `geodesic_countries`;
ALTER TABLE `geodesic_classifieds_user_communications` RENAME `geodesic_user_communications`;
ALTER TABLE `geodesic_classifieds_userdata` RENAME `geodesic_userdata`;
ALTER TABLE `geodesic_classifieds_userdata_history` RENAME `geodesic_userdata_history`;
ALTER TABLE `geodesic_classifieds_user_groups_price_plans` RENAME `geodesic_user_groups_price_plans`;
ALTER TABLE `geodesic_classifieds_registration_session` RENAME `geodesic_registration_session`;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `lead_picture_width` INT NOT NULL ;
ALTER TABLE `geodesic_classifieds_ad_configuration` ADD `lead_picture_height` INT NOT NULL ;
UPDATE `geodesic_pages_messages_languages` SET `text_id` = '2632' WHERE `page_id` = '11' AND `text_id` = '2633' AND `language_id` = '1' LIMIT 1 ;
ALTER TABLE `geodesic_classifieds_ad_filter` RENAME `geodesic_ad_filter` ;
ALTER TABLE `geodesic_classifieds_ad_filter_categories` RENAME `geodesic_ad_filter_categories` ;

ALTER TABLE `geodesic_pages_messages` ADD `classauctions` INT DEFAULT '0' NOT NULL ;
ALTER TABLE `geodesic_classifieds_favorites` ADD `auction_id` INT DEFAULT '0' NOT NULL ;
ALTER TABLE `geodesic_classifieds_favorites` RENAME `geodesic_favorites` ;

ALTER TABLE `geodesic_group_attached_price_plans` ADD `auction_price_plan_id` INT DEFAULT '0' NOT NULL AFTER `price_plan_id` ;

ALTER TABLE `geodesic_classifieds_price_plans` ADD `num_free_pics` INT( 11) NOT NULL;

ALTER TABLE `geodesic_user_groups_price_plans` ADD `auction_price_plan_id` INT DEFAULT '0' NOT NULL ;


DELETE FROM `geodesic_pages_fonts` WHERE `element_id` = '460' LIMIT 1;
ALTER TABLE `geodesic_cc_authorizenet_transactions` ADD `auction_id` INT NOT NULL ;
ALTER TABLE `geodesic_cc_linkpoint_transactions` ADD `auction_id` INT NOT NULL ;
ALTER TABLE `geodesic_cc_bitel_transactions` ADD `auction_id` INT NOT NULL ;
ALTER TABLE `geodesic_cc_twocheckout_transactions` ADD `auction_id` INT NOT NULL ;
ALTER TABLE `geodesic_paypal_transactions` ADD `auction_id` INT NOT NULL ;
ALTER TABLE `geodesic_worldpay_transactions` ADD `auction_id` INT NOT NULL ;

ALTER TABLE `geodesic_sessions` ADD `auction_session` VARCHAR( 32 ) NOT NULL AFTER `classified_session` ;

ALTER TABLE `geodesic_registration_session` CHANGE `optional_field_1` `optional_field_1` TEXT NOT NULL , CHANGE `optional_field_2` `optional_field_2` TEXT NOT NULL , CHANGE `optional_field_3` `optional_field_3` TEXT NOT NULL , CHANGE `optional_field_4` `optional_field_4` TEXT NOT NULL , CHANGE `optional_field_5` `optional_field_5` TEXT NOT NULL , CHANGE `optional_field_6` `optional_field_6` TEXT NOT NULL , CHANGE `optional_field_7` `optional_field_7` TEXT NOT NULL , CHANGE `optional_field_8` `optional_field_8` TEXT NOT NULL , CHANGE `optional_field_9` `optional_field_9` TEXT NOT NULL , CHANGE `optional_field_10` `optional_field_10` TEXT NOT NULL;
ALTER TABLE `geodesic_userdata` CHANGE `optional_field_1` `optional_field_1` TEXT NOT NULL , CHANGE `optional_field_2` `optional_field_2` TEXT NOT NULL , CHANGE `optional_field_3` `optional_field_3` TEXT NOT NULL , CHANGE `optional_field_4` `optional_field_4` TEXT NOT NULL , CHANGE `optional_field_5` `optional_field_5` TEXT NOT NULL , CHANGE `optional_field_6` `optional_field_6` TEXT NOT NULL , CHANGE `optional_field_7` `optional_field_7` TEXT NOT NULL , CHANGE `optional_field_8` `optional_field_8` TEXT NOT NULL , CHANGE `optional_field_9` `optional_field_9` TEXT NOT NULL , CHANGE `optional_field_10` `optional_field_10` TEXT NOT NULL;
ALTER TABLE `geodesic_registration_question_types` CHANGE `type_id` `type_id` INT( 11 ) DEFAULT '2' NOT NULL AUTO_INCREMENT;

UPDATE geodesic_pages_messages_languages SET page_id = '22' WHERE text_id = 3206;

ALTER TABLE `geodesic_classifieds_configuration` ADD `site_balance_override` INT DEFAULT '0' NOT NULL ;
ALTER TABLE `geodesic_payment_choices` CHANGE `explanation` `explanation` MEDIUMTEXT NOT NULL;
ALTER TABLE `geodesic_pages_messages` CHANGE `display_order` `display_order` INT( 11 ) DEFAULT '0' NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `idevaffiliate` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `idev_renewal` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `idev_upgrade` INT NOT NULL;
ALTER TABLE `geodesic_classifieds_configuration` ADD `idev_path` VARCHAR(128) NOT NULL;

ALTER TABLE `geodesic_classifieds_configuration` ADD `sell_category_column_count` INT NOT NULL ;
ALTER TABLE `geodesic_classifieds_configuration` ADD `levels_of_categories_displayed_admin` INT DEFAULT '5' NOT NULL ;

ALTER TABLE `geodesic_balance_transactions` ADD `subscription_renewal` INT DEFAULT '0' NOT NULL ;

DELETE FROM `geodesic_pages_fonts` WHERE `element_id` = 891 ;
DELETE FROM `geodesic_pages_fonts` WHERE `element_id` = 892 ;


UPDATE `geodesic_pages_fonts` SET `element` = 'submit', `name` = 'submit button' WHERE `element_id` = 269 LIMIT 1 ;

update `geodesic_pages` set `special_instructions` = \"Below are the fields that can be placed within this page.<br>
&lt;&lt;TITLE&gt;&gt;<br>
&lt;&lt;FIELD_1_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_1&gt;&gt;<br>
&lt;&lt;FIELD_2_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_2&gt;&gt;<br>
&lt;&lt;FIELD_3_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_3&gt;&gt;<br>
&lt;&lt;FIELD_4_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_4&gt;&gt;<br>
&lt;&lt;FIELD_5_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_5&gt;&gt;<br>
&lt;&lt;FIELD_6_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_6&gt;&gt;<br>
&lt;&lt;FIELD_7_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_7&gt;&gt;<br>
&lt;&lt;FIELD_8_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_8&gt;&gt;<br>
&lt;&lt;FIELD_9_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_9&gt;&gt;<br>
&lt;&lt;FIELD_10_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_10&gt;&gt;<br>
&lt;&lt;FIELD_11_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_11&gt;&gt;<br>
&lt;&lt;FIELD_12_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_12&gt;&gt;<br>
&lt;&lt;FIELD_13_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_13&gt;&gt;<br>
&lt;&lt;FIELD_14_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_14&gt;&gt;<br>
&lt;&lt;FIELD_15_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_15&gt;&gt;<br>
&lt;&lt;FIELD_16_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_16&gt;&gt;<br>
&lt;&lt;FIELD_17_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_17&gt;&gt;<br>
&lt;&lt;FIELD_18_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_18&gt;&gt;<br>
&lt;&lt;FIELD_19_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_19&gt;&gt;<br>
&lt;&lt;FIELD_20_LABEL&gt;&gt;<br>
&lt;&lt;FIELD_20&gt;&gt;<br>
&lt;&lt;CLASSIFIED_ID_LABEL&gt;&gt;<Br>
&lt;&lt;CLASSIFIED_ID&gt;&gt;<br>
&lt;&lt;VIEWED_COUNT_LABEL&gt;&gt;<br>
&lt;&lt;VIEWED_COUNT&gt;&gt;<br>
&lt;&lt;SELLER_LABEL&gt;&gt;<br>
&lt;&lt;SELLER&gt;&gt;<br>
&lt;&lt;DATE_STARTED_LABEL&gt;&gt;<br>
&lt;&lt;DATE_STARTED&gt;&gt;<br>
&lt;&lt;LOCATION_LABEL&gt;&gt;<br>
&lt;&lt;LOCATION&gt;&gt;<br>
&lt;&lt;EXTRA_QUESTION_BLOCK&gt;&gt;<br>
&lt;&lt;EXTRA_CHECKBOX_BLOCK&gt;&gt;<br>
&lt;&lt;DESCRIPTION_LABEL&gt;&gt;<br>
&lt;&lt;DESCRIPTION&gt;&gt;<br>
&lt;&lt;PRICE_LABEL&gt;&gt;<br>
&lt;&lt;PRICE&gt;&gt;<br>
&lt;&lt;IMAGE_BLOCK&gt;&gt;<br>
&lt;&lt;CATEGORY_TREE&gt;&gt;<br>
&lt;&lt;BACK_TO_CURRENT_AD_LINK&gt;&gt;\" where page_id = 69;

UPDATE `geodesic_pages` SET `display_unselected_subfilters` = '1' WHERE `page_id` = '91' OR `page_id` = '101';

ALTER TABLE `geodesic_auctions_configuration` ADD `admin_approves_all_registration` INT( 11 ) NOT NULL AFTER `use_email_verification_at_registration` ;
ALTER TABLE `geodesic_classifieds_configuration` ADD `admin_approves_all_registration` INT( 11 ) NOT NULL AFTER `use_email_verification_at_registration` ;

ALTER TABLE `geodesic_classifieds_configuration` CHANGE `length_of_description` `length_of_description` INT( 11 ) NOT NULL DEFAULT '0';

INSERT INTO `geodesic_html_allowed` VALUES (60, 'P', 0, 1, '', 1, 0);