<?php
//get_image.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 18872              $ ##
## File last change date:       ##
##  $Date:: 2010-01-21 13:59:#$ ##
##                              ##
##################################


require_once 'app_top.main.php';

if (!isset($_REQUEST["id"]) || !(int)$_REQUEST['id']) {
	//invalid or no image specified
	require GEO_BASE_DIR . 'app_bottom.php';
	exit;
}

$sql = "SELECT maximum_full_image_height, maximum_full_image_width
	FROM geodesic_classifieds_ad_configuration";
$ad_configuration = $db->GetRow($sql);

if ($ad_configuration === false) {
	//failsave, shouldn't get here..
	echo $sql."<bR>\n";
	require GEO_BASE_DIR . 'app_bottom.php';
	exit;
}
if (!$ad_configuration) {
	//failsafe, shouldn't get here either...
	echo 'DB Error, no settings.';
	require GEO_BASE_DIR . 'app_bottom.php';
	exit;
}

$sql = "SELECT * FROM ".geoTables::images_urls_table." WHERE `image_id` = ?";

$show_image = $db->GetRow($sql, array((int)$_REQUEST["id"]));

if (!$show_image || strlen(trim($show_image['image_url'])) == 0) {
	//invalid image requested, just show a blank page.
	//echo "DB Error, invalid image.  Error # ".__line__;
	require GEO_BASE_DIR . 'app_bottom.php';
	exit;
}

if ($debug_popup) {
	echo $image_width." is image width before<br>\n";
	echo $image_height." is image height before<br>\n";
	echo $ad_configuration["maximum_full_image_width"]." is MAXIMUM_FULL_IMAGE_WIDTH<br>\n";
	echo $ad_configuration["maximum_full_image_height"]." is MAXIMUM_FULL_IMAGE_HEIGHT<br>\n";
	echo $show_image["original_image_width"]." is ORIGINAL_IMAGE_WIDTH<br>\n";
}

//get the prev and next text, which happens to be on page 157
$messages = $db->get_text(true, 157);

$tpl = new geoTemplate('system','other');

$dimensions = geoImage::getScaledSize($show_image["original_image_width"], $show_image["original_image_height"], $ad_configuration["maximum_full_image_width"], $ad_configuration["maximum_full_image_height"]);
$image_width = $dimensions['width'];
$image_height = $dimensions['height'];
if ($show_image['icon']) {
	$tpl->url = $show_image['image_url'];
	$show_image["image_url"] = geoTemplate::getUrl('',$show_image['icon']);
	$tpl->is_icon = true;
}

$tpl->display_image = geoImage::display_image( $show_image["image_url"], $image_width, $image_height, $show_image['mime_type']);
$tpl->display_image_text = $show_image['image_text'];
$tpl->imageId = (int)$show_image['image_id'];//give it something unique for ID's

//in case template needs to know
$tpl->maxWidth = $ad_configuration['maximum_full_image_width'];
$tpl->maxHeight = $ad_configuration['maximum_full_image_height'];

//Get all images, we'll need this for accurate image #
if ($show_image['classified_id']) {
	$sql = "SELECT * FROM `geodesic_classifieds_images_urls` WHERE
			`classified_id` = ?
			ORDER BY `display_order` ASC";
	$allImages = $db->GetAll($sql, array($show_image['classified_id']));
} else {
	//can't get all associated images if no listing ID
	$allImages = array($show_image);
}
$tpl->imageCount = count($allImages);

$prev = $thisPrev = $next = $thisCount = $imageNum = 0;
foreach ($allImages as $thisImage) {
	$thisCount++;
	if ($thisImage['image_id'] == $show_image['image_id']) {
		//this is the one
		$prev = $thisPrev;
		$imageNum = $thisCount;
	} else if ($imageNum) {
		//this is the "next" image
		$next = $thisImage['image_id'];
		break;
	}
	$thisPrev = $thisImage['image_id'];
}
$tpl->previous_image_id = $prev;
$tpl->next_image_id = $next;
$tpl->imageNum = $imageNum;
$tpl->imageData = $show_image;
if ($prev || $next) {
	$tpl->playing = $playing = (!isset($_GET['play']) || (isset($_GET['play']) && $_GET['play']))? true : false;
	$tpl->paused = (!$playing);
	if (!$next) {
		//get the first image ID
		
		$tpl->first_image_id = (int)$allImages[0]['image_id'];
	} else {
		//no use to get the first image ID
		$tpl->first_image_id = 0;
	}
} else {
	//can neither pause or play, there is no more things to go through
	$tpl->playing = $tpl->paused = false;
	$tpl->first_image_id = 0;
	$tpl->imageCount = 1;
}
$tpl->useSlideshow = $db->get_site_setting('useSlideshow');
$tpl->startSlideshow = $db->get_site_setting('startSlideshow');

$tpl->setLanguage($db->getLanguage());

echo $tpl->fetch('lightbox_slideshow.tpl');


require GEO_BASE_DIR . 'app_bottom.php';
exit;
