<?php 
//user_management_ad_filters.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 19640              $ ##
## File last change date:       ##
##  $Date:: 2010-04-23 13:08:#$ ##
##                              ##
##################################

class User_management_ad_filters extends geoSite
{
	var $debug_filters = 0;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_all_ad_filters()
	{
		if (!geoSession::getInstance()->getUserID()) {
			return false;
		}
		$this->page_id = 27;
		$msgs = $this->db->get_text(true, $this->page_id);
		$tpl = new geoTemplate('system', 'user_management');
		$tpl->helpLink = $this->display_help_link(376);
				
		$sql = "select * from ".geoTables::ad_filter_table." where user_id = ".geoSession::getInstance()->getUserID()." order by date_started desc";
		$result = $this->db->Execute($sql);
		if (!$result) {
			$this->site_error($this->db->ErrorMsg());
			return false;
		} elseif ($result->RecordCount() > 0) {
			
			$tpl->table_description = $msgs[375];
			$tpl->showFilters = true;

			$filters = array();
			for ($i = 0; $show = $result->FetchNextObject(); $i++)
			{
				$filters[$i]['css'] = $css_tag;
				if (!$show->CATEGORY_ID) {
					$category_name = $msgs[2313];
				} else {
					$name = geoCategory::getName($show->CATEGORY_ID);
					$category_name = $name->CATEGORY_NAME;
				}
				$filters[$i]['category_name'] = $category_name;
				if ($show->SUB_CATEGORY_CHECK) {
					$filters[$i]['sub_cat_check'] = true;
				}
				$filters[$i]['search_terms'] = $show->SEARCH_TERMS;
				$filters[$i]['date'] = date($this->db->get_site_setting('entry_date_configuration'),$show->DATE_STARTED);
				$filters[$i]['link'] = $this->db->get_site_setting('classifieds_file_name')."?a=4&amp;b=9&amp;c=2&amp;d=".$show->FILTER_ID;
			}
			$tpl->filters = $filters;
			$tpl->addRemoveFilterLink2 = $this->db->get_site_setting('classifieds_file_name')."?a=4&amp;b=9&amp;c=3";
		} else {
			//there are no ad filters for this user
			$tpl->table_description = $msgs[377];
			$tpl->showFilters = false;
		}

		$tpl->addRemoveFilterLink = $this->db->get_site_setting('classifieds_file_name')."?a=4&amp;b=9&amp;c=1";
		$tpl->userManagementHomeLink = $this->db->get_site_setting('classifieds_file_name')."?a=4";
		
		$this->body = $tpl->fetch('ad_filters/display_all_filters.tpl');
		$this->display_page();
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function delete_ad_filter($db,$filter_id=0)
	{
		if (geoSession::getInstance()->getUserID())
		{
			if ($filter_id)
			{
				$sql = "delete from ".geoTables::ad_filter_table." where filter_id = ".$filter_id;
				$result = $this->db->Execute($sql);
				if ($this->debug_filters) echo $sql."<br />\n";
				if (!$result)
				{
					if ($this->debug_filters) echo $sql."<br />\n";
					$this->site_error($this->db->ErrorMsg());
					return false;
				}

				$sql = "delete from ".geoTables::ad_filter_categories_table." where filter_id = ".$filter_id;
				$result = $this->db->Execute($sql);
				if ($this->debug_filters) echo $sql."<br />\n";
				if (!$result)
				{
					if ($this->debug_filters) echo $sql."<br />\n";
					$this->site_error($this->db->ErrorMsg());
					return false;
				}
				return true;
			}
			else
			{
				//no filter id
				$this->error_message = $this->data_missing_error_message;
				return false;
			}
		}
		else
			return false;
	} //end of function delete_ad_filter

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function add_new_filter_form()
	{
		$this->page_id = 28;
		$this->get_text();
		if(!geoSession::getInstance()->getUserID()) {
			return false;
		}
		$tpl_vars = array();
		$tpl_vars['formTarget'] = $this->db->get_site_setting('classifieds_file_name')."?a=4&amp;b=9&amp;c=4";
		$tpl_vars['categoryDDL'] = $this->get_category_dropdown("d[category_id]",0,0,0,$this->messages[500244],2);
		$tpl_vars['userManagementHomeLink'] = $this->db->get_site_setting('classifieds_file_name')."?a=4";
		
		$view = geoView::getInstance();
		$view->setBodyTpl('ad_filters/add_filter_form.tpl','','user_management')
			->setBodyVar($tpl_vars);
		$this->display_page();
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function insert_new_filter($db,$filter_info=0)
	{
		$userId = (int)$this->userid;
		if (!$userId){
			return false;
		}
		
		if (!$filter_info) {
			//no filter_info
			$this->error_message = $this->data_missing_error_message;
			return false;
		}
		
		$current_time = geoUtil::time();
		$search_terms_array = explode(",",$filter_info["search_terms"]);

		foreach ($search_terms_array as $value) {
			$sql = "insert into ".geoTables::ad_filter_table."
				(user_id,search_terms,date_started,category_id,sub_category_check)
				values
				(".geoSession::getInstance()->getUserID().",\"".$value."\",".$current_time.",".intval($filter_info["category_id"]).",".intval($filter_info["subcategories_also"]).")";
			$insert_filter_result = $this->db->Execute($sql);
			if (!$insert_filter_result) {
				$this->error_message = $this->internal_error_message;
				return false;
			}

			$filter_id = $this->db->Insert_ID();

			$sql = "insert into ".geoTables::ad_filter_categories_table."
				(filter_id, category_id)
				values
				(".$filter_id.",".intval($filter_info["category_id"]).")";
			$insert_category_result = $this->db->Execute($sql);
			if (!$insert_category_result) {
				$this->error_message = $this->internal_error_message;
				return false;
			}

			if ($filter_info["subcategories_also"] == 1 && $filter_info["category_id"] > 0) {
				//get subcategories and insert them into the db
				$this->get_all_subcategories_for_dropdown($filter_info["category_id"],1);

				//use class variable to insert category_ids
				reset($this->category_dropdown_id_array);
				//make sure the same subcategory is not added multiple times.
				$already_added_cat = array();
				foreach ($this->category_dropdown_id_array as $cat_value) {
					if (in_array($cat_value, $already_added_cat)) {
						//already added for this category.
						continue;
					}
					$already_added_cat [] = $cat_value;
					$sql = "insert into ".geoTables::ad_filter_categories_table."
						(filter_id, category_id)
						values
						(".$filter_id.",".$cat_value.")";
					$result = $this->db->Execute($sql);
					if (!$result) {
						$this->error_message = $this->internal_error_message;
						return false;
					}
				}
			}
		}
		return true;
	} //end of function add_new_filter

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function clear_ad_filters()
	{
		if (geoSession::getInstance()->getUserID())
		{
			$sql = "select * from ".geoTables::ad_filter_table." where user_id = ".geoSession::getInstance()->getUserID();
			$filter_result = $this->db->Execute($sql);
			if ($this->debug_filters) echo $sql."<br />\n";
			if (!$filter_result)
			{
				if ($this->debug_filters) echo $sql."<br />\n";
				$this->error_message = $this->internal_error_message;
				return false;
			}
			elseif ($filter_result->RecordCount() > 0)
			{
				while ($show = $filter_result->FetchNextObject())
				{
					$sql = "delete from ".geoTables::ad_filter_categories_table." where filter_id = ".$show->FILTER_ID;
					$result = $this->db->Execute($sql);
					if ($this->debug_filters) echo $sql."<br />\n";
					if (!$result)
					{
						if ($this->debug_filters) echo $sql."<br />\n";
						$this->error_message = $this->internal_error_message;
						return false;
					}
				}
			}

			$sql = "delete from ".geoTables::ad_filter_table." where user_id = ".geoSession::getInstance()->getUserID();
			$result = $this->db->Execute($sql);
			if ($this->debug_filters) echo $sql."<br />\n";
			if (!$result)
			{
				if ($this->debug_filters) echo $sql."<br />\n";
				$this->error_message = $this->internal_error_message;
				return false;
			}
			return true;
		}
		else
			return false;

	} //end of function clear_ad_filters

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	public function check_ad_filters ($listing_id=0)
	{
		$listing_id = intval($listing_id);
		if (!$listing_id) {
			$this->error_message = $this->data_missing_error_message;
			return false;
		}
		
		$listing = geoListing::getListing($listing_id);
		
		if ($listing->live != 1) {
			return true;
		}
		
		$sql = "SELECT * FROM ".geoTables::ad_filter_categories_table." c, ".geoTables::ad_filter_table." f
			WHERE f.filter_id = c.filter_id AND (c.`category_id` = {$listing->category} OR c.`category_id` = 0)
				AND `user_id` != ?";
		$filter_category_result = $this->db->Execute($sql, array($listing->seller));
		
		if (!$filter_category_result) {
			if ($this->debug_filters) echo $sql."<br />\n";
			$this->error_message = $this->internal_error_message;
			return false;
		}
		if ($filter_category_result->RecordCount() == 0) {
			//no e-mails to send
			return true;
		}
		
		$this->page_id = 29;
		$this->get_text();
		$to_search = "$listing->search_text $listing->title $listing->description $listing->location_city $listing->location_state {$listing->location_country}";
		if (geoPC::is_ent()) {
			for ($i = 1; $i <= 20; $i++) {
				$field = "optional_field_$i";
				$to_search .= " ".$listing->$field;
			}
		}
		//decode everything
		$to_search = geoString::fromDB($to_search);
		
		//array of already matched users, so they don't get e-mailed multiple times.
		$matched_users = array();
		while ($show_filter_term = $filter_category_result->FetchRow()) {
			$term_list_to_search_with = array();
			if (in_array($show_filter_term['user_id'], $matched_users)) {
				//continue on, we're already e-mailing this user
				continue;
			}
			if ($listing->seller == $show_filter_term['user_id']) {
				//same user as who made the listing, don't need to send to themself
				//although this should not happen as we check for it in SQL query
				continue;
			}
			
			$term_to_search_with = trim(geoString::fromDB($show_filter_term['search_terms']));

			if($term_to_search_with) {
				if (stripos($term_to_search_with,",") !== false) {
					//break into multiple searches on a comma
					$term_list_to_search_with = explode(",",$term_to_search_with);
				} else {
					//no commas in search_terms -- only one search to do
					$term_list_to_search_with = array($term_to_search_with);
				}
				
				$foundSearchTerm = false;
					foreach ($term_list_to_search_with as $current_item_to_search_with) {
						
						if(stripos($to_search, $current_item_to_search_with) !== false) {
							//found it.
							$foundSearchTerm = true;
						}
					}
				
				if (!$foundSearchTerm) {
					//did not find any of the terms this user is looking for. go on to the next one.
					continue;
				}
			} else {
				//no search terms on this filter. send an email for any category matches.
			}
													
			//remember that user has been notified once already
			$matched_users[] = $show_filter_term['user_id'];
			
			$user = geoUser::getUser($show_filter_term['user_id']);
			if (!$user) {
				//sanity check, could not get user info
				continue;
			}
			$email_address = $user->email;
			
			//send a message to this user
			$message["message"] = $this->messages[1319]."\n\n";
			$message["message"] .= $this->messages[1320]." ".date($this->db->get_site_setting('entry_date_configuration'),$show_filter_term['date_started'])."\n";
			$message["message"] .= $this->messages[1321]." ".$show_filter_term['search_terms']."\n\n";
			$message["message"] .= $this->messages[1322]."\n\n";
			$message["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$listing_id."\n\n";
			
			$message["subject"] = $this->messages[1318];

			geoEmail::sendMail($email_address, $message["subject"], $message["message"]);

			if ($user->communication_type != 1) {
				//save the communication within the communication queue also
				$sql = "INSERT INTO ".geoTables::user_communications_table."
					(message_to,message_from_non_user,regarding_ad,date_sent,message)
					values
					(".$show_filter_term['user_id'].",'',".$listing_id.",".geoUtil::time().",?)";
				$save_communication_result = $this->db->Execute($sql, array(geoString::toDB($message['message'])));
				
				if (!$save_communication_result) {
					trigger_error('ERROR SQL: Error writing message to db');
					return false;
				}
			}
		}
		return true;
	} //end of function check_ad_filters
}