<?php
//Singleton.class.php
/**
 * Singleton method to make sure duplicate objects do not happen.  Note that a
 * lot of the System classes have their own getInstance() methods that should
 * be used (if they exist) instead of using the Singleton class.
 * 
 * @package System
 * @since Forever
 */

/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 16055              $ ##
## File last change date:       ##
##  $Date:: 2009-04-01 14:12:#$ ##
##                              ##
##################################

/**
 * Singleton method class
 * 
 * @package System
 */
class Singleton {
	private static $registry = array();
	
	/**
	 * Get instance of class name
	 *
	 * @param string $class
	 * @return Object
	 */
	public static function getInstance ($class){
		if ($class=='ADONewConnection'){
			$class='DataAccess';
		}
		if ($class == 'DataAccess'){
			return DataAccess::getInstance();
		}
		if ($class == 'Session') {
			return geoSession::getInstance();
		}
		if ($class == 'product_configuration') {
			//for old addons, compatibility
			return geoPC::getInstance();
		}
		if (!isset(self::$registry[$class]) || !is_object(self::$registry[$class])){
			//special case, check to see if the class wants a new one of it made automatically.
			if (defined($class.'_no_new_instance')){
				return null;
			}
			if (class_exists($class)){
				self::$registry[$class] = new $class;
			} 
//un-comment following block for trace stack to figure out what is calling invalid class name.			
/*
			else {
				throw new Exception('Error: Class does not exist: '.$class);
				//return false;
			} */
		}
		return self::$registry[$class];
	}
	
	/**
	 * Sees if the given class name is already instantiated.
	 *
	 * @param string $class
	 * @return boolean
	 */
	public static function isInstance($class){
		if ($class=='ADONewConnection')
			$class='DataAccess';
		return (isset(self::$registry[$class])&&is_object(self::$registry[$class]));
	}
	
	/**
	 * Only used internally.
	 *
	 * @param string $action
	 * @param string $class
	 * @param mixed $vars
	 * @return mixed
	 * @access private
	 */
	public static function instanceTools($action, $class, $vars){
		
		switch ($action) {
			case 'new_subscription':
				return self::getSubscriptionInstance($class,$vars[0]);
			case 'new':
				//create a new instance if there is none already, or return the already existing instance.
				
				return self::getInstance($class);
				break;
			case 'new_force':
				//force a new instance, do not listen to no_new_instance
				//create a new instance if there is none already, or return the already existing instance.
				if (!isset(self::$registry[$class]) || !is_object(self::$registry[$class])){
					self::$registry[$class] = new $class;
				}
				return self::$registry[$class];
				break;
			case 'new_db':
				//create a new instance, and pass 1 variable to that instance.
				return self::getInstance('DataAccess');
				break;
			case 'is_created':
				//return true if the object exists, false otherwise.
				return self::isInstance($class);
				break;
			default:
				//must be one of those new_with_#_var things...
				if(!isset(self::$registry[$class]) || !is_object(self::$registry[$class])){
					//$paramstring = '$'.implode(', $',$vars);
					
					foreach ($vars as $key => $value){
						$paramstring[] = '$vars['.$key.']';
					}
					$paramstring = implode(', ',$paramstring);
					//I wonder if this will work...
					eval ( 'Singleton::$registry["'.$class.'"] = new '.$class.' ('.$paramstring.');');
			
				}
				return self::$registry[$class];
				break;
		}
	}
}
