<?php
//Pagination.class.php
/**
 * Holds the geoPagination class.  For displaying page number links and stuff.
 * 
 * @package System
 * @since Version 4.0.0
 */
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 18279              $ ##
## File last change date:       ##
##  $Date:: 2009-12-03 10:30:#$ ##
##                              ##
##################################


/**
 * Utility functions useful for generating pagination of a results page
 * such as when browing ads or searching
 * 
 * @package System
 * @since Version 4.0.0
 */
class geoPagination {
				
	/**
	 * Gets the pagination in an HTML string
	 *
	 * @param int $totalPages The total number of pages of results
	 * @param int $currentPage Page the user is currently viewing
	 * @param String $link Base URL of all pagination links
	 * @param String $css CSS class to apply to all pagination items
	 * @param String $postLink string appended to the end of each pagination URL. Useful if the page number needs to go somewhere in the middle
	 * @return String pagination links, in HTML
	 */
	public static function getHTML($totalPages, $currentPage=1, $link, $css='', $postLink='')
	{
		$tpl = new geoTemplate('system', 'classes');
		$tpl->url = $link;
		$tpl->postUrl = $postLink;
		$tpl->css = $css;
		$tpl->currentPage = $currentPage;
		
		$tpl->previousPage = ($currentPage != 1) ? ($currentPage-1) : false;
		$tpl->nextPage = ($currentPage != $totalPages) ? ($currentPage+1) : false;
		
		$ranges['small']['low'] = $currentPage - 3;
		$ranges['small']['high'] = $currentPage + 3;
		$ranges['middle']['low'] = $currentPage - 30;
		$ranges['middle']['high'] = $currentPage + 30;
		$ranges['high']['low'] = $currentPage - 300;
		$ranges['high']['high'] = $currentPage + 300;
		
		$links = array();
		// always show a link to the first page, current page, and last page
		$links[] = 1;
		$links = self::addIfUnique($currentPage, $links);
		$links = self::addIfUnique($totalPages, $links);
		
		for($i = 2; $i <= $totalPages; $i++) {
			if ($i % 100 == 0 && $i >= $ranges['high']['low'] && $i <= $ranges['high']['high']) {
				$links = self::addIfUnique($i, $links);
			} elseif($i % 10 == 0 && $i >= $ranges['middle']['low'] && $i <= $ranges['middle']['high']) {
				$links = self::addIfUnique($i, $links);
			} elseif ($i >= $ranges['small']['low'] && $i <= $ranges['small']['high']) {
				$links = self::addIfUnique($i, $links);
			}
		}
		
		sort($links, SORT_NUMERIC);
		$tpl->links = $links;
		
		return $tpl->fetch('Pagination/pagination.tpl');
	}
	
	/**
	 * Adds a number to an array only if it doesn't already exist in the array
	 *
	 * @param int $add the number to add
	 * @param array $array the original array
	 * @return array the modified array
	 */
	private static function addIfUnique($add, $array)
	{
		if(!in_array($add, $array)) {
			$array[] = $add;
		}
		return $array;
	}
}