<?php
//Category.class.php
/**
 * Holds the geoCategory class.
 * 
 * @package System
 * @since Version 4.0.0
 */
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20350              $ ##
## File last change date:       ##
##  $Date:: 2010-09-15 13:48:#$ ##
##                              ##
##################################

/**
 * Utility class that holds various methods to do stuff with categories in the system.
 * @package System
 * @since Version 4.0.0
 * @todo Clean this class up a bunch and optimize it.
 */
class geoCategory
{
	/**
	 * Gets an instance of the geoCategory class.
	 * @return geoCategory
	 */
	public static function getInstance(){
		return Singleton::getInstance('geoCategory');
	}
	
	private static $_getInfoCache;
	/**
	 * Get basic info about given category.
	 * @param int $category_id
	 * @param int $language_id
	 * @return array
	 */
	public static function getBasicInfo($category_id=0, $language_id = 0)
	{
		$db = DataAccess::getInstance();
		if (!$category_id){
			//TODO: get this text from the DB somewhere...
			return array('category_name' => "Main");
		}
		if (!$language_id){
			$language_id = $db->getLanguage();
		}
		if (isset(self::$_getInfoCache[$category_id][$language_id])){
			return self::$_getInfoCache[$category_id][$language_id];
		}
		
		$sql = "SELECT `category_name`,`category_cache`,`cache_expire`,`description` FROM ".geoTables::categories_languages_table." WHERE `category_id` = ? and language_id = ? LIMIT 1";
		$result = $db->Execute($sql, array($category_id, $language_id));
		if (!$result || $result->RecordCount() == 0)
		{
			trigger_error('ERROR CATEGORY SQL: Cat not found for id: '.$category_id.', Sql: '.$sql.' Error Msg: '.$db->ErrorMsg());
			return false;
		}
		$show = $result->FetchRow();
		$show['category_name'] = geoString::fromDB($show['category_name']);
		$show['description'] = geoString::fromDB($show['description']);
		//save it, so we don't query the db a bunch
		self::$_getInfoCache[$category_id][$language_id] = $show;
		return $show;
	}
	
	/**
	 * Add category data to local cache for use later in same page load.  This
	 * mainly serves to greatly speed up SEO addon when there are a lot of category
	 * links on the page, so it doesn't have to re-look
	 * up data already retrieved.
	 * 
	 * @param array $data The un-filtered results from DB for category.  Must
	 *   contain category_id, language_id, category_name, and description to be
	 *   of any use.
	 * @since Version 5.1.2
	 */
	public static function addCategoryResult ($data)
	{
		$category_id = (int)$data['category_id'];
		$language_id = (int)$data['language_id'];
		
		if ($category_id && $language_id && isset($data['category_name'], $data['description'])) {
			$data['category_name'] = geoString::fromDB($data['category_name']);
			$data['description'] = geoString::fromDB($data['description']);
			self::$_getInfoCache[$category_id][$language_id] = $data;
		}
	}
	
	/**
	 * Allows adding multiple rows at once to local cache for use later.  Basically
	 * just calls self::addCategoryResult() for each item in the array.
	 * 
	 * @param array $data Array of category results
	 * @since Version 5.1.2
	 */
	public static function addCategoryResults ($data)
	{
		foreach ($data as $row) {
			self::addCategoryResult($row);
		}
	}
	
	/**
	 * Gets the name of the given category, already decoded.
	 * 
	 * @param int $category_id
	 * @param bool $justTheName if true, it acts like the method name sounds like,
	 *   returning just the name.
	 * @return string
	 */
	public static function getName($category_id, $justTheName = false)
	{
		//need to clean up a little
		$category_id = intval($category_id);
		if (!$category_id) return 'Main';
		$db = DataAccess::getInstance();
		
		$sql = "select category_name,description from ".geoTables::categories_languages_table." where category_id = ".$category_id." and language_id = ".$db->getLanguage();
		$r = $db->getrow($sql);
		if (!$r) {
			return false;
		}
		if ($justTheName) {
			return geoString::fromDB($r['category_name']);
		}
		$show = new stdClass();
		$show->CATEGORY_NAME = geoString::fromDB($r['category_name']);
		$show->DESCRIPTION = geoString::fromDB($r['description']);
		return $show;
	}
	
	/**
	 * return an array with a random category information
	 *
	 * @return array
	 */
	public static function getRandomBasicInfo()
	{
		$db = DataAccess::getInstance();
		
		$language_id = $db->getLanguage();
		
		$sql = "SELECT `category_id`,`category_name`,`description` FROM ".geoTables::categories_languages_table." WHERE language_id = ?  AND category_id !=? ORDER BY RAND() LIMIT 1";
		$result = $db->GetRow($sql, array($language_id,0));
		if ($result===false)
		{
			trigger_error('ERROR CATEGORY SQL: Cat not found for id: '.$category_id.', Sql: '.$sql.' Error Msg: '.$db->ErrorMsg());
			return false;
		}
		//use array_map, since all fields being returned (well except for the id) need to be geoString::fromDB
		$show = array_map(array('geoString','fromDB'),$result);
		
		//save it, so we don't query the db a bunch
		self::$_getInfoCache[$category_id][$language_id] = $show;
		return $show;	
	}
	
	private static $_getCategoryConfig_cache;
	/**
	 * Gets the categories' info for the given category.
	 * 
	 * @param int $category_id
	 * @return array
	 */
	public static function getCategoryConfig($category_id)
	{
		$db = DataAccess::getInstance();
		$category_id = intval($category_id);
		if (!$category_id){
			return false;
		}
		if (isset(self::$_getCategoryConfig_cache[$category_id])){
			return self::$_getCategoryConfig_cache;
		}
		
		$sql = "SELECT * FROM ".geoTables::categories_table." WHERE `category_id` = {$category_id} LIMIT 1";
		$result = $db->Execute($sql);
		if (!$result){
			trigger_error('ERROR SQL CATEGORY: Sql: '.$sql.' Error Msg: '.$db->ErrorMsg());
		}
		$cfg = $result->FetchRow();
		
		return $cfg;
	}
	
	/**
	 * Sees if the given category has any kids.
	 * @param int $category_id
	 * @return bool
	 */
	public static function hasChildren($category_id)
	{
		//TODO: cache stuff if possible
		//check input
		$category_id = intval($category_id);
		if ($category_id==0){
			return false;
		}
		$db = DataAccess::getInstance();
		$sql = "SELECT `category_id` FROM ".geoTables::categories_table." WHERE `parent_id` = ? LIMIT 1";
		$results = $db->getrow($sql, array($category_name));
		trigger_error('DEBUG CATEGORY: Query: '.$sql.' Has children? result: '.print_r($results,1));
		return (empty($results))? false: true;
	}
	
	
	/**
	 * Not currently used, we plan to move the same named method in site class here,
	 * but it's not done all the way yet.
	 * 
	 * @param $name
	 * @param $category_id
	 * @param $no_main
	 * @param $css_control
	 * @param $all_cat_text
	 * @param $return_type
	 * @param $max_depth
	 * @return unknown_type
	 */
	public static function get_category_dropdown($name,$category_id=0,$no_main=0,$css_control=0,$all_cat_text='',$return_type=1, $max_depth=-1)
	{
		$all_cat_text = (strlen($all_cat_text)>0) ? $all_cat_text : "All Categories";
		$content = "";

		if (!in_array( $name, $this->category_dropdown_settings_array) ||
			!in_array( $max_depth, $this->category_dropdown_settings_array) ||
			!in_array( $no_main, $this->category_dropdown_settings_array) )
		{
			// Empty the arrays if it is new values
			$this->category_dropdown_settings_array = array_slice($this->category_dropdown_settings_array,0,0);
			$this->category_dropdown_name_array = array_slice($this->category_dropdown_name_array,0,0);
			$this->category_dropdown_id_array = array_slice($this->category_dropdown_name_array,0,0);
		}

		if (empty($this->category_dropdown_settings_array))
		{
			// Add settings if array is empty
			array_push($this->category_dropdown_settings_array, $name);
			array_push($this->category_dropdown_settings_array, $no_main);
			array_push($this->category_dropdown_settings_array, $max_depth);
		}


		//echo count($this->category_dropdown_id_array)." is the count of category_dropdown_id_array<br />\n";
		if (!$no_main)
		{
			if (!in_array(0,$this->category_dropdown_id_array) )
			{
				array_push($this->category_dropdown_name_array, $all_cat_text);
				array_push($this->category_dropdown_id_array,0);
			}
		}

		//echo count($this->category_dropdown_id_array)." is the count of category_dropdown_id_array<br />\n";

		if ((count($this->category_dropdown_id_array) == 0) || (count($this->category_dropdown_id_array) == 1))
		{
			//echo "building categories array<br />\n";
			$this->get_all_subcategories_for_dropdown(0,0,$max_depth);
		}
		else
		{
			//echo "resetting categories array<br />\n";
			reset($this->category_dropdown_name_array);
			reset($this->category_dropdown_id_array);
		}

		$tpl = new geoTemplate('system', 'classes');
		$tpl->assign('name', $name);
		$tpl->assign('css', $css_control);
		$options = array();
		foreach($this->category_dropdown_name_array as $key => $value)
		{
			$options[$key]['value'] = $this->category_dropdown_id_array[$key];
			$options[$key]['label'] = geoString::fromDB($value);
			if ($this->category_dropdown_id_array[$key] == $category_id) {
				$options[$key]['selected'] = true;
			}
		}
		$tpl->assign('options', $options);
		$content = $tpl->fetch('Category/category_dropdown.tpl');
		if ($return_type == 2) {
			return $content;
		} else {
			$this->body .= $content;
			return true;
		}


	} //end of function get_category_dropdown
	
	/**
	 * Update the listing count on the given category ID.
	 * @param int $category_id
	 */
	public static function updateListingCount($category_id)
	{
		$category_id = intval($category_id);
		if (!$category_id){
			return false;
		}
		$db = DataAccess::getInstance();
		if(!self::_getTree($category_id) || !is_array(self::$_category_tree_array)){
			//error getting cat tree.
			return false;
		}
		reset (self::$_category_tree_array);
		for ($i = (count(self::$_category_tree_array) - 1); $i >= 0; $i--)
		{
			//display all the categories
			if (!isset(self::$_category_tree_array[$i]) || self::$_category_tree_array[$i]["category_id"] == 0){
				continue;
			}
			
			$sql = "SELECT count(*) AS total FROM ".geoTables::classifieds_table." WHERE `live` = 1 AND `category` ".self::$_category_tree_array[$i]['in_statement']." AND `item_type` = ?";
			$count_result = $db->Execute($sql, array(1));
			
			$sql = "SELECT count(*) AS total FROM ".geoTables::classifieds_table." WHERE `live` = 1 AND `category` ".self::$_category_tree_array[$i]['in_statement']." AND (`item_type` = ? or `item_type` = ?)";
			$auction_count_result = $db->Execute($sql, array(2,4));
			//echo $sql."<br />\n";

			if (!$count_result || !$auction_count_result)
			{
				trigger_error('ERROR SQL: sql: '.$sql.' Error Msg: '.$db->ErrorMsg());
				return false;
			}
			
			$show = $count_result->FetchRow();
			$auction_show = $auction_count_result->FetchRow();

			$sql = "UPDATE ".geoTables::categories_table." SET `category_count` = ?, `auction_category_count` = ? WHERE `category_id` = ? LIMIT 1";
			$update_count_result = $db->Execute($sql, array($show['total'],$auction_show['total'],self::$_category_tree_array[$i]["category_id"]));
			if (!$update_count_result)
			{
				trigger_error('ERROR SQL: sql: '.$sql.' Error Msg: '.$db->ErrorMsg());
				return false;
			}
		}
	}
	
	/**
	 * Gets a tree for the given category.
	 * @param int $category
	 * @return array
	 */
	public static function getTree($category)
	{
		self::_getTree($category);
		return self::$_category_tree_array;
	}
	
	private static $_category_tree_array;
	private static function _getTree($category)
	{
		$db = DataAccess::getInstance();
		
		$category_next = $category;
		self::$_category_tree_array = array();
		
		$get_parent_stmt = $db->Prepare("SELECT c.`parent_id`, c.`in_statement`, l.`category_name` FROM ".geoTables::categories_table." as c, ".geoTables::categories_languages_table." as l WHERE c.`category_id` = l.`category_id` AND c.`category_id` = ? AND l.`language_id` = ".$db->getLanguage()." LIMIT 1");
		
		if (!$get_parent_stmt) {
			trigger_error('ERROR SQL: message: '.$db->ErrorMsg());
			return false;
		}
		$tree = array();
		do {
			$category_result =  $db->Execute($get_parent_stmt, array($category_next));

			if (!$category_result) {
				trigger_error('ERROR SQL: message: '.$db->ErrorMsg());
				return false;
			}
			if ($category_result->RecordCount() == 1) {
				$show = $category_result->FetchRow();
				$tree[] = array(
					'parent_id' => $show['parent_id'],
					'in_statement' => $show['in_statement'],
					'category_name' => geoString::fromDB($show['category_name']),
					'category_id' => $category_next,
				);
				$category_next = $show['parent_id'];
			} else {
				return false;
			}

     	} while ( $show['parent_id'] != 0 );
		
     	if (count($tree) > 0) {
     		//reverse order of tree, or it will be backwards since we started from
     		//the outermost cat and worked our way up.
     		self::$_category_tree_array = array_reverse($tree, true);
     	}
     	
     	return true;
	}
	
	/**
	 * Gets the HTML for new icon if there are new listings and setting is turned on,
	 * otherwise returns empty string.
	 * 
	 * @param int $category_id
	 * @return string
	 */
	public static function new_ad_icon_use($category_id=0)
	{
		$db = DataAccess::getInstance();
		
		if ($db->get_site_setting('category_new_ad_limit') > 0 && $category_id) {
			$messages = $db->get_text(true);
			if (strlen($messages[500794])) {
				$date_limit = (geoUtil::time() - ($db->get_site_setting('category_new_ad_limit') * 3600));
				$db->preload_num_new_ads(geoUtil::time(),$date_limit);
	
				$count = $db->num_new_ads_in_category($category_id,geoUtil::time(),$date_limit);
				if ($count > 0) {
					$tpl = new geoTemplate('system', 'classes');
					return $tpl->fetch('Category/new_ad_image.tpl');
				}
			}
		}
		return '';
	}
	
	/**
	 * Gets the parent category ID for the given category.  If it can't find the
	 * parent, or 0 is specified, will return 0.  This is NOT efficient for running
	 * multiple times for same category, so use once and save info.
	 * 
	 * @param int $categoryId
	 * @return int The parent category ID.
	 * @since Version 5.0.0
	 */
	public static function getParent ($categoryId)
	{
		$categoryId = (int)$categoryId;
		if (!$categoryId) {
			return 0;
		}
		$db = DataAccess::getInstance();
		
		$sql = "SELECT `parent_id` FROM ".geoTables::categories_table." WHERE `category_id`=$categoryId";
		$row = $db->GetRow($sql);
		if ($row && isset($row['parent_id'])) {
			return (int)$row['parent_id'];
		}
		return 0;
	}
	
	/**
	 * Removes a specified category and all sub-categories, and anything "attached".
	 * But it can have the option to "move" listings to the parent instead of
	 * deleted.
	 * 
	 * this does NOT re-count the parent category counts, it is up to calling
	 * caller to do that this is designed to be called multiple times.
	 * 
	 * @param int $categoryId
	 * @param bool|int $moveTo If true, will move all listings in category being
	 *   removed to the parent category.  If an int, will move listings to specified
	 *   value used as category id to move to.
	 * @return bool
	 */
	public static function remove ($categoryId, $moveTo = null)
	{
		$categoryId = (int)$categoryId;
		if (!$categoryId) {
			//can't remove a non-existent category...
			return false;
		}
		$db = DataAccess::getInstance();
		
		if ($moveTo === true) {
			//specified that it should be moved, but not sure where to...
			$sql = "SELECT `parent_id` FROM ".geoTables::categories_table." WHERE `category_id`={$categoryId}";
			$parentId = $db->GetOne($sql);
			if ($parentId === false) {
				//error
				trigger_error('ERROR SQL: Error finding parent cat using sql: '.$sql.', Error: '.$db->ErrorMsg());
				return false;
			}
			$moveTo = (int)$parentId;
			if (!$moveTo || $moveTo == $categoryId) {
				//moving not possible, block removing this category when move
				//is specified but not able to determine where to move to
				trigger_error('ERROR STATS: Problem finding category to move to, can not proceed with category removal.');
				return false;
			}
		}
		//turn moveTo into int after this, we know if it's 0 we're deleting all
		//attached listings, otherwise we're moving attached listings to specified
		//category.
		$moveTo = (int)$moveTo;
		if ($moveTo == $categoryId) {
			//can't move to the same place!
			trigger_error('ERROR STATS: Problem moving listings to category, category from and to cannot be the same!');
			return false;
		}
		//get all sub-categories of this one and remove them
		//This needs to be super efficient, clean up vars after using them, etc.
		
		$sql = "SELECT `category_id` FROM ".geoTables::categories_table." WHERE `parent_id`={$categoryId}";
		$result = $db->Execute($sql);
		if (!$result) {
			//error
			trigger_error('ERROR SQL: Error finding sub-cates using sql: '.$sql.', Error: '.$db->ErrorMsg());
			return false;
		}
		while ($row = $result->FetchRow()) {
			//don't use fancy $db->GetAll() as that loads them all into array at once, which
			//can take a ton more memory for sites with tons of cats.
			$subCat = (int)$row['category_id'];
			if ($subCat && $subCat != $categoryId) {
				$deleteSub = self::remove($subCat, $moveTo);
				if (!$deleteSub) {
					//problem with deleting sub-category, do not proceed
					return false;
				}
			}
		}
		
		//next, remove (or move) all listings in this category.
		if ($moveTo) {
			//"move" all listings to the moveTo location.
			$sql = "UPDATE ".geoTables::classifieds_table." SET `category`={$moveTo} WHERE `category`={$categoryId}";
			$result = $db->Execute($sql);
			if (!$result) {
				//error
				trigger_error('ERROR SQL: Error moving listings to new category using sql: '.$sql.', Error: '.$db->ErrorMsg());
				return false;
			}
		} else {
			//remove all listings in this category
			$sql = "SELECT `id` FROM ".geoTables::classifieds_table." WHERE `category`={$categoryId}";
			$result = $db->Execute($sql);
			if (!$result) {
				//error
				trigger_error('ERROR SQL: Error finding listings in category to remove using sql: '.$sql.', Error: '.$db->ErrorMsg());
				return false;
			}
			while ($row = $result->FetchRow()) {
				$listingId = (int)$row['id'];
				if ($listingId) {
					$deleteListing = geoListing::remove($listingId);
					if (!$deleteListing) {
						//problem removing one of the listings...
						trigger_error('ERROR STATS: Problem removing a listing in a category, stopping removal of the category.');
						return false;
					}
				}
			}
		}
		
		//Need to do something special to find and remove all category filters
		$sql = "SELECT `filter_id` FROM ".geoTables::ad_filter_table."
			WHERE `category_id`={$categoryId}";
		$select_filter_result = $db->Execute($sql);
		if (!$select_filter_result) {
			trigger_error('ERROR SQL: Error during cat removal using sql: '.$sql.', Error: '.$db->ErrorMsg());
			return false;
		}
		while ($row = $select_filter_result->FetchRow()) {
			$sql = "DELETE FROM ".geoTables::ad_filter_categories_table."
				WHERE `filter_id` = ".(int)$row["filter_id"];
			$delete_filter_result = $db->Execute($sql);
			if (!$delete_filter_result) {
				trigger_error('ERROR SQL: Error during cat removal using sql: '.$sql.', Error: '.$db->ErrorMsg());
				return false;
			}
		}
		
		//special to remove languages for category questions
		$sql = "SELECT `question_id` FROM ".geoTables::questions_table."
			WHERE `category_id`={$categoryId}";
		$select_question_result = $db->Execute($sql);
		if (!$select_question_result) {
			trigger_error('ERROR SQL: Error during cat removal using sql: '.$sql.', Error: '.$db->ErrorMsg());
			return false;
		}
		while ($row = $select_question_result->FetchRow()) {
			$sql = "DELETE FROM ".geoTables::questions_languages."
				WHERE `question_id` = ".(int)$row["question_id"];
			$delete_filter_result = $db->Execute($sql);
			if (!$delete_filter_result) {
				trigger_error('ERROR SQL: Error during cat removal using sql: '.$sql.', Error: '.$db->ErrorMsg());
				return false;
			}
		}
		
		//remove "simple" things from categories that don't need anything more
		//than removing entries from the DB based on cat id
		$simpleRemoves = array (
			geoTables::ad_filter_table,//main ad filters page
			geoTables::ad_filter_categories_table,//alt category filters table
			geoTables::price_plans_categories_table,//category price plans
			geoTables::questions_table,//category questions
			geoTables::categories_languages_table,//category languages table
		);
		foreach ($simpleRemoves as $tableName) {
			//delete all entries that match this listing
			$sql = "DELETE FROM {$tableName} WHERE `category_id`={$categoryId}";
			$result = $db->Execute($sql);
			if (!$result) {
				trigger_error('ERROR SQL: Error removing stuff from category, using sql: '.$sql.', Error: '.$db->ErrorMsg());
				return false;
			}
		}
		
		//move order items attached to this category to use cat 0
		$sql = "UPDATE ".geoTables::order_item." SET `category`=0 WHERE `category`={$categoryId}";
		$result = $db->Execute($sql);
		if (!$result) {
			trigger_error('ERROR SQL: Error moving order items to 0 category, using sql: '.$sql.', Error: '.$db->ErrorMsg());
			return false;
		}
		//remove any price plan items
		geoPlanItem::remove(null, $categoryId);
		
		//delete the actual category
		$sql = "DELETE FROM ".geoTables::categories_table." WHERE `category_id`={$categoryId}";
		$result = $db->Execute($sql);
		if (!$result) {
			trigger_error('ERROR SQL: Error removing category, using sql: '.$sql.', Error: '.$db->ErrorMsg());
			return false;
		}
		return true;
	}
}