<?php
//payment_gateways/paymentexpress.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

require_once CLASSES_DIR . PHP5_DIR . 'PaymentGateway.class.php';

include "./classes/paymentexpress_access.inc.php";

# Template payment gateway handler

class paymentexpressPaymentGateway extends geoPaymentGateway{
	/**
	 * Required, the name of this gateway, should be the same as the file name without the .php
	 *
	 * @var string
	 */
	public $name = 'paymentexpress';
	
	/**
	 * Required, Usually the same as the name, this can be used as a means
	 * to warn the admin that they may be using 2 gateways that
	 * are the same type.  Mostly used to distinguish CC payment gateways
	 * (by using type of 'cc'), but can be used for other things as well.
	 *
	 * @var string
	 */
	public $type = 'paymentexpress';
	
	/**
	 * For convenience, should be same as $name
	 *
	 */
	const gateway_name = 'paymentexpress';
	
	/**
	 * Optional.
	 * Used in admin, in paymentGatewayManage::getGatewayTable() which is used in both ajax calls,
	 * and to initially display the gateway page.
	 * 
	 * Expects to return an array:
	 * array (
	 * 	'name' => $gateway->name,
	 * 	'title' => 'What to display in list of gateways',
	 *  'header_html' => 'Will be inserted into the head section of the page.'
	 * )
	 * 
	 * Note: if need extra settings besides just being turned on or not,
	 *  see the method admin_custom_config()
	 * @return array
	 *
	 */
	public static function admin_display_payment_gateways (){
		$return = array (
			'name' => self::gateway_name,
			'title' => 'Payment Express',//how it's displayed in admin
			'header_html' => ""//optional, if specified, 
		);
		
		return $return;
	}
	
	/**
	 * Optional.
	 * Used: in admin, in paymentGatewayManage::cjax_show_save_link(), checked in paymentGatewayManage::getGatewayTable()
	 * 
	 * If this function exists, it will be used to display custom
	 * settings specific for this gateway using ajax.  If the function does not
	 * exist, no settings button will be displayed beside the gateway.
	 *
	 * @return string HTML to display below gateway when user clicked the settings button
	 */
	public function admin_custom_config (){
		
		$tpl = new geoTemplate('admin');
		$tpl->payment_type = self::gateway_name;
		$tpl->assign('commonAdminOptions', $this->_showCommonAdminOptions(false));
		
		$tooltips['user_id'] = geoHTML::showTooltip('User ID', 'UserId of Payment Access User');
		$tooltips['access_key'] = geoHTML::showTooltip('Access Key', 'Your DES Key from DPS');
		$tooltips['mac_key'] = geoHTML::showTooltip('MAC Key', 'Your MAC Key from DPS');
		$tooltips['receipt_email'] = geoHTML::showTooltip('Email Address to Receive Payment Receipt Notifications', 'Email Address of admin who will receive Paymentexpress notification emails');
		$tooltips['currency_codes'] = geoHTML::showTooltip('Currency Codes', 'Possible currencies that Paymentexpress will accept. Choose the currency you accept payments in from this list.');
		$tpl->assign('tooltips', $tooltips);
		
		$values['user_id'] = $this->get('user_id');
		$values['access_key'] = $this->get('access_key');
		$values['mac_key'] = $this->get('mac_key');
		$values['receipt_email'] = $this->get('receipt_email');
		$values['currency_codes'] = $this->get('currency_codes', 'USD');
		$tpl->assign('values', $values);
		
		$tpl->assign('libmcrypt', function_exists('mcrypt_encrypt'));
		
		//set up currency options dropdown
		$currencies = array(
							'CAD' => 'Canadian Dollar',
							'CHF' => 'Swiss Franc',
							'EUR' => 'Euro',
							'FRF' => 'French Franc',
							'GBP' => 'United Kingdom Pound',
							'HKD' => 'Hong Kong Dollar',
							'JPY' => 'Japanese Yen',
							'NZD' => 'New Zealand Dollar',
							'SGD' => 'Singapore Dollar',
							'USD' => 'United States Dollar',
							'ZAR' => 'Rand',
							'AUD' => 'Australian Dollar',
							'WST' => 'Samoan Tala',
							'VUV' => 'Vanuatu Vatu',
							'TOP' => "Tongan Pa'anga",
							'SBD' => 'Solomon Islands Dollar',
							'PGK' => 'Papua New Guinea Kina',
							'MYR' => 'Malaysian Ringgit',
							'KWD' => 'Kuwaiti Dinar',
							'FJD' => 'Fiji Dollar');
		$currencyOptions = '';
		foreach($currencies as $code => $name){
			$currencyOptions .= '<option value='.$code.' '.(($values['currency_codes'] == $code) ? 'selected="selected"' : '').' >'.$name.'</option>\r\n';
		}
		$tpl->assign('currencyOptions', $currencyOptions);
		
		return $tpl->fetch('payment_gateways/paymentexpress.tpl');
	}
	
	/**
	 * Optional.
	 * Used: in admin, in paymentGatewayManage::update_payment_gateways()
	 * 
	 * Use this function to save any additional settings.  Note that this is done IN ADDITION TO the
	 * normal "back-end" stuff such as enabling or disabling the gateway and serializing any changes.  
	 * If this returns false however, that additional stuff will not be done.
	 *
	 * @return boolean True to continue with rest of update stuff, false to prevent saving rest of settings
	 *  for this gateway.
	 */
	public function admin_update_payment_gateways(){
		if (isset($_POST['paymentexpress']) && is_array($_POST['paymentexpress']) && count($_POST['paymentexpress']) > 0){
			$settings = $_POST['paymentexpress'];
			$this->_updateCommonAdminOptions($settings);
			
			$this->set('user_id', $settings['user_id']);
			$this->set('access_key', $settings['access_key']);
			$this->set('mac_key', $settings['mac_key']);
			$this->set('receipt_email', $settings['receipt_email']);
			$this->set('currency_codes', $settings['currency_codes']);
			
			$this->save();
		}
		
		return true;
	}
	
	/**
	 * Optional.
	 * Used: in geoCart::payment_choicesDisplay()
	 * 
	 * Should return an associative array that is structured as follows:
	 * array(
	 * 	'title' => string,
	 * 	'title_extra' => string,
	 * 	'label_name' => string, //needs to be: self::gateway_name,
	 * 	'radio_value' => string, //should be self::gateway_name
	 * 	'help_link' => string, //entire link including a tag and link text, example: $cart->site->display_help_link(3240),
	 * 	'checked' => boolean, //leave false to let system determine if it is checked or not, true to force being checked
	 * 	//Items below will be auto generated if left as empty string.
	 * 	'radio_name' => string,//usually c[self::gateway_name] - this set by system if left as empty string.
	 * 	'choices_box' => string,//use custom stuff for the entire choice box.
	 * 	'help_box' => string,//use custom stuff for help link and box surrounding it.
	 * 	'radio_box' => string,//use custom box for radio
	 * 	'title_box' => string,//use custom box for title
	 * 	'radio_tag' => string//use custom tag for radio tag
	 * )
	 * 
	 * @return array Associative Array as specified above.
	 *
	 */
	public static function geoCart_payment_choicesDisplay(){
		$cart = geoCart::getInstance(); //get cart to use the display_help_link function
		
		$msgs = $cart->db->get_text(true, 10203);
		$return = array(
			//Items that don't auto generate if left blank
			'title' => $msgs[500288],
			'title_extra' => '',//usually make this empty string.
			'label_name' => self::gateway_name,
			'radio_value' => self::gateway_name,//should be same as gateway name
			'help_link' => '',
			'checked' => false,//let system figure out if it is checked or not
			
			//Items below will be auto generated if left blank string.
			'radio_name' => '',//normally you leave all these blank.
			'choices_box' => '',
			'help_box' => '',
			'radio_box' => '',
			'title_box' => '',
			'radio_tag' => '',
		
		);
		return $return;
	}
	
	/**
	 * Optional.
	 * Used: in geoCart::payment_choicesCheckVars()
	 * 
	 * Called no matter what selection is made when selecting payment type, so before doing
	 * any checks you need to make sure the payment type selected (in var $_POST['c']['payment_type'])
	 * matches this payment gateway.  If there are any problems, use $cart->addError() to specify
	 * that it should not go onto the next step, processing the order (aka geoCart_payment_choicesProcess())
	 *
	 */
	public static function geoCart_payment_choicesCheckVars (){
		$cart = geoCart::getInstance();
		
		if (isset($_POST['c']['payment_type']) && $_POST['c']['payment_type'] == self::gateway_name){
			//the selected gateway is this one, so check everything for any errors.

			//nothing to do here yet
		}
	}
	
	/**
	 * Optional.
	 * Used: in geoCart::payment_choicesProcess()
	 * 
	 * This function is where any processing is done, and is also where things like re-directing to an external 
	 * payment site would be done, or updating account balance, etc.
	 * 
	 * Note that this is only called if this payment gateway is the one that was chosen, and there were no errors
	 * generated by geoCart_payment_choicesCheckVars().
	 * 
	 * This is where you would create a transaction that would pay for the order, into the invoice.
	 *
	 */
	public static function geoCart_payment_choicesProcess(){
		$cart = geoCart::getInstance();
		$user_data = $cart->user_data;
		$db = $cart->db;
		$gateway = geoPaymentGateway::getPaymentGateway(self::gateway_name);


		//get invoice on the order
		$invoice = $cart->order->getInvoice();
		$invoice_total = $due = $invoice->getInvoiceTotal();

		if ($due >= 0){
			//DO NOT PROCESS!  Nothing to process, no charge (or returning money?)
			return ;
		}

		//create initial transaction
		try {
			$transaction = new geoTransaction();
			$transaction->setGateway(self::gateway_name);
			$transaction->setUser($cart->user_data['id']);
			$transaction->setStatus(0); //for now, turn off until it comes back fromgateway
			$transaction->setAmount(-1 * $due);//set amount that it affects the invoice
			$transaction->setInvoice($invoice);
	
			//save it so there is an id
			$transaction->save();
		} catch (Exception $e){
			trigger_error('ERROR TRANSACTION CART PAYFLOW_PRO: Exception thrown when attempting to create new transaction.');
			return;
		}
		
		$PxAccess_Url    = "https://www.paymentexpress.com/pxpay/pxpay.aspx";
		$PxAccess_Userid = $gateway->get('user_id');
		$PxAccess_Key    =  $gateway->get('access_key');
		$Mac_Key = $gateway->get('mac_key');
		$currency_type = $gateway->get('currency_codes');
		$transaction_email_address = $gateway->get('receipt_email');
		
		$pxaccess = new PxAccess($PxAccess_Url, $PxAccess_Userid, $PxAccess_Key, $Mac_Key);
  		$request = new PxPayRequest();
  		
  		$http_host   = getenv("HTTP_HOST");
  		$request_uri = getenv("SCRIPT_NAME");
  		$server_url  = "http://$http_host";
  		$returnURL = str_replace($db->get_site_setting("classifieds_file_name"), "transaction_process.php?gateway=paymentexpress",$db->get_site_setting("classifieds_url"));
  		
  		$Quantity = 1;
  		$Address1 = urlencode($user_data['address']." ".$user_data['address_2']);
  		$Address2 = urlencode($user_data['city'])." ".urlencode($user_data['state'])." ".urlencode($user_data['country'])." ".urlencode($user_data['zip']);
  		$AmountInput = $transaction->getAmount();
  		#Set up PxPayRequest Object
  		$request->setAmountInput($AmountInput);
  		$request->setTxnData1($transaction->getDescription());# whatever you want to appear
  		$request->setTxnData2($Address1);		# whatever you want to appear
  		$request->setTxnData3($Address2);		# whatever you want to appear
  		$request->setTxnType("Purchase");
  		$request->setInputCurrency($currency_type);


  		$request->setMerchantReference($transaction->getId()); # fill this with your order number
  		$request->setEmailAddress($transaction_email_address);
  		$request->setUrlFail($returnURL);
  		$request->setUrlSuccess($returnURL);


  		#Call makeResponse of PxAccess object to obtain the 3-DES encrypted payment request
  		$request_string = $pxaccess->makeRequest($request);
  		
  		//set order status to Pending to prep for sending data to gateway
		$cart->order->setStatus('pending');
		
		//stop the cart session
		$cart->removeSession();
		
		require GEO_BASE_DIR . 'app_bottom.php';
		//go to 2checkout to complete
		header("Location: $request_string");
		exit;
	}
	
	/**
	 * Optional.
	 * Used: in geoCart::process_orderDisplay()
	 * 
	 * This is a good place to do things like display a message that the listing has been placed on hold until
	 * payment is received, or place to display other similar messages.
	 * 
	 * Note that there is no process_orderCheckVars() or process_orderProcess() since this page is only meant
	 * for display purposes, for any processing that needs to be done, needs to go in geoCart::payment_choicesProcess()
	 *
	 */
	public static function geoCart_process_orderDisplay(){
		//use to display some success/failure page, if that applies to this type of gateway.
	}
	
	public function transaction_process(){
		
		$gateway = geoPaymentGateway::getPaymentGateway(self::gateway_name);
		
		
		
		$PxAccess_Url    = "https://www.paymentexpress.com/pxpay/pxpay.aspx";
		$PxAccess_Userid = $gateway->get('user_id');
		$PxAccess_Key    =  $gateway->get('access_key');
		$Mac_Key = $gateway->get('mac_key');
		$currency_type = $gateway->get('currency_codes');
		$transaction_email_address = $gateway->get('receipt_email');
		
		$pxaccess = new PxAccess($PxAccess_Url, $PxAccess_Userid, $PxAccess_Key, $Mac_Key);

		$enc_hex = $_REQUEST["result"];
		//getResponse method in PxAccess object returns PxPayResponse object
		//which encapsulates all the response data
		$rsp = $pxaccess->getResponse($enc_hex);
		
		// the following are the fields available in the PxPayResponse object
		$response['success'] = $rsp->getSuccess();   # =1 when request succeeds
		$response['retry'] = $rsp->getRetry();     # =1 when a retry might help
		$response['statusRequired'] = $rsp->getStatusRequired();      # =1 when transaction "lost"
		$response['amountSettlement']  = $rsp->getAmountSettlement();
		$response['authCode'] = $rsp->getAuthCode();  # from bank
		$response['cardName'] = $rsp->getCardName();  # e.g. "Visa"
		$response['dpsTxnRef'] = $rsp->getDpsTxnRef();

		// the following values are returned, but are from the original request
//		$TxnType           = $rsp->getTxnType();
//		$TxnData1          = $rsp->getTxnData1();
//		$TxnData2          = $rsp->getTxnData2();
//		$TxnData3          = $rsp->getTxnData3();
//		$CurrencyInput     = $rsp->getCurrencyInput();
//		$EmailAddress      = $rsp->getEmailAddress();
		$MerchantReference = $rsp->getMerchantReference();
		
		

		$transaction = geoTransaction::getTransaction($MerchantReference);
		$order = $transaction->getInvoice()->getOrder();
		
		//save transaction data
		$transaction->set('paymentexpress_response', $response);
		$transaction->save();
		
		
		if ($rsp->getStatusRequired() == "1") {
			self::_failure($transaction, 0, "PaymentExpress: Connection Error");
		} elseif ($rsp->getSuccess() == "1") {
			self::_success($order, $transaction, $gateway);
		} else {
			self::_failure($transaction, 0, "PaymentExpress: Declined");
		}
	}
}

