<?php
//cash.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 15559              $ ##
## File last change date:       ##
##  $Date:: 2009-01-29 17:34:#$ ##
##                              ##
##################################

require_once CLASSES_DIR . PHP5_DIR . 'PaymentGateway.class.php';

# Cash payment gateway handler

class cashPaymentGateway  extends geoPaymentGateway{
	
	public $name = 'cash';//make it so that name is known.
	const gateway_name = 'cash';
	public $type = 'cash';
	/**
	 * Expects to return an array:
	 * array (
	 * 	'' => ''
	 * )
	 *
	 */
	function admin_display_payment_gateways (){
		$return = array (
			'name' => self::gateway_name,
			'title' => 'Cash',
		);
		
		return $return;
	}
	
	
	public static function geoCart_payment_choicesDisplay(){
		$cart = geoCart::getInstance();
		//TODO: checks for using balance
		
		$msgs = $cart->db->get_text(true, 10203);
		$return = array(
			//Items that don't auto generate if left blank
			'title' => $msgs[500282],
			'title_extra' => '',
			'label_name' => self::gateway_name,
			'radio_value' => self::gateway_name,//should be same as gateway name
			'help_link' => $cart->site->display_help_link(204),
			'checked' => false,
			
			//Items below will be auto generated if left blank string.
			'radio_name' => '',
			'choices_box' => '',
			'help_box' => '',
			'radio_box' => '',
			'title_box' => '',
			'radio_tag' => '',
		
		);
		
		return $return;
	}
	
	
	
	/**
	 * Optional.
	 * Used: in geoCart::payment_choicesProcess()
	 * 
	 * This function is where any processing is done, and is also where things like re-directing to an external 
	 * payment site would be done, or updating account balance, etc.
	 * 
	 * Note that this is only called if this payment gateway is the one that was chosen, and there were no errors
	 * generated by geoCart_payment_choicesCheckVars().
	 * 
	 * This is where you would create a transaction that would pay for the order, into the invoice.
	 *
	 */
	
	public static function geoCart_payment_choicesProcess(){
		$auto_approve = 0;
		trigger_error('DEBUG TRANSACTION: Top of '.self::gateway_name.': Classified_sell_transaction_approved() - processing');
		
		$cart = geoCart::getInstance();

		$gateway = geoPaymentGateway::getPaymentGateway(self::gateway_name);
		
		
		//get invoice on the order
		$invoice = $cart->order->getInvoice();
		$invoice_total = $due = $invoice->getInvoiceTotal();
		
		if ($due >= 0){
			//DO NOT PROCESS!  Nothing to process, no charge (or returning money?)
			return ;
		}
		
		$transaction = new geoTransaction;
		$transaction->setAmount(-1 * $due);//balance out the amount due on invoice
		$transaction->setDate(geoUtil::time());
		$msgs = $cart->db->get_text(true,183);
		$transaction->setDescription($msgs[500582]);
		$transaction->setGateway($gateway);
		$transaction->setInvoice($invoice);
		$transaction->setStatus($auto_approve);//since payment is automatic, do it automatically.
		$transaction->setUser($cart->user_data['id']);
		
		$transaction->save();//save changes
		
		$invoice->addTransaction($transaction);
		if ($auto_approve){
			$cart->order->processStatusChange('active');
		} else {
			//admin needs to approve it
			$cart->order->processStatusChange('pending_admin');
		}
	}

	/**
	 * Optional.
	 * Used: in geoCart::process_orderDisplay()
	 * 
	 * This is a good place to do things like display a message that the listing has been placed on hold until
	 * payment is received, or place to display other similar messages.
	 * 
	 * Note that there is no process_orderCheckVars() or process_orderProcess() since this page is only meant
	 * for display purposes, for any processing that needs to be done, needs to go in geoCart::payment_choicesProcess()
	 *
	 */
	public static function geoCart_process_orderDisplay(){
		$cart = geoCart::getInstance();
		
		self::_successFailurePage(true, $cart->order->getStatus());
		
		//send email to admin if he wants it
		if($cart->db->get_site_setting('user_set_hold_email'))
		{
			//echo $item_sell_class->db->get_site_setting('user_set_hold_email')." is the setting for hold email<br />";
			//echo "email should be sent for ad on hold<br />";
			$subject = "An order been placed!!";
			$message = "Admin,\n\n";
			$message .= "An order has been placed and is on hold because a ".self::gateway_name." type was chosen. See the manage orders section of the admin.\n\n";
			$message .= "Additional orders may be in the unapproved orders section that you were not sent an email. These will be failed auto pay attempts or if you are approving all ads.\n\n";
			$cart->db->sendMail($cart->db->get_site_setting('site_email'),$subject,$message);
		}
		
		//gateway is last thing to be called, so it needs to be the one that clears the session...
		$cart->removeSession();
	}
}