<?php
//order_items/account_tokens.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################


/**
 * Used to purchase tokens, that can be used to pay for listings or extras.
 *
 */
class account_tokensOrderItem extends geoOrderItem {
	private static $_use = 0; //set to 1 to allow purchasing tokens.
	/**
	 * Set this to match the filename and the class name.  If not set here, need to set it in constructor.
	 *
	 * @var string
	 */
	protected $type = "account_tokens";
	const type = 'account_tokens';
	
	/**
	 * Needs to be the order that this item will be processed, only items with process order less than this will have a token applied to it.
	 *
	 * @var int
	 */
	protected $defaultProcessOrder = 15;
	const defaultProcessOrder = 15; //change this to be same # as line above.
	public function displayInAdmin() {
		return false;
	}
	
	public static function geoCart_initSteps(){
		if (!self::$_use){
			return ;
		}
		$cart = geoCart::getInstance();
		
		$cart->addStep('account_tokens:purchase_tokens');
		
		//get steps from children as well.
		$children = geoOrderItem::getChildrenTypes(self::type);
		geoOrderItem::callUpdate('geoCart_initSteps',null,$children);
	}
	
	public static function purchase_tokensCheckVars(){
		
	}
	
	public static function purchase_tokensProcess(){
		
	}
	
	public static function purchase_tokensDisplay(){
		$cart = geoCart::getInstance();
		
		$cart->site->body = "<h1>Purchase tokens!</h1> Not built yet.";
		$cart->site->display_page();
	}
	
	public static function purchase_tokensLabel ()
	{
		return 'Purchase Tokens';
	}
	
	public static function geoCart_initItem_forceOutsideCart() {
		//up for debate, going to say yes for now...
		return true;
	}
	
	public static function getParentTypes(){
		//parent item
		return array();
	}
	
	public function getDisplayDetails ($inCart)
	{
		$msgs = DataAccess::getInstance()->get_text(true, 10202);
		$return = array (
			'css_class' => '',
			'title' => $msgs[500315],
			'canEdit' => true, //allow editing number of tokens to purchase
			'canDelete' => true, //allow removing
			'canPreview' => false, //nothing to preview
			'priceDisplay' => '$5.23USD', //Price as it is displayed
			'cost' => 5.2300, //amount this adds to the total, what getCost returns
			'total' => 5.2300, //amount this AND all children adds to the total (will add to it as we parse the children)
			'children' => array() 	//should be array of child items, with the index
	 								//being the item's ID, and the contents being associative array like
	 								//this one.  If no children, it should be an empty array.  (Careful 
									//not to get into any infinite recursion)
		);
		
		//THIS PART IMPORTANT:  Need to keep this part to make the item able to have children
		
		//go through children...
		$order = $this->getOrder();//get the order
		$items = $order->getItem();//get all the items in the order
		$children = array();
		foreach ($items as $i => $item){
			if (is_object($item) && $item->getType() != $this->getType() && is_object($item->getParent())){
				$p = $item->getParent();//get parent
				if ($p->getId() == $this->getId()){
					//Parent is same as me, so this is a child of mine, add it to the array of children.
					$displayResult = $item->getDisplayDetails($inCart);
					if ($displayResult !== false) {
						//only add if they do not return bool false
						$children[$item->getId()] = $displayResult;
						$return['total'] += $children[$item->getId()]['total']; //add to total we are returning.
					}
				}
			}
		}
		if (count($children)){
			//add children to the array
			$return['children'] = $children;
		}
		return $return;
	}
	
	
	
	/**
	 * Optional.
	 * Used: in geoCart::deleteProcess()
	 * 
	 * The back-end already removes the item, all all children from the cart.  Use this function to do
	 * any additional things needed, such as delete uploaded images, or if you expect that any children
	 * may need to be called, as they will not be auto called from the system.  Can assume
	 * $cart->item is the item that is being deleted, which will be the same type as this is.
	 *
	 */
	public static function geoCart_deleteProcess(){
		$cart = geoCart::getInstance();
		
		//Do this FIRST: Go through any children, and call geoCart_deleteProcess for them...
		$original_id = $cart->item->getId();//need to keep track of what the ID of the item originally being deleted is.
		$items = $cart->order->getItem();
		foreach ($items as $k => $item){
			if (is_object($item) && $item->getId() != $cart->item->getId() && is_object($item->getParent()) && $item->getParent()->getId() == $cart->item->getId()){
				//$item is a child of this item...
				//Set the cart's main item to be $item, so that the deleteProcess gets
				//what it is expecting...
				$cart->initItem($item->getId(),false);
				//now call deleteProcess
				geoOrderItem::callUpdate('geoCart_deleteProcess',null,$item->getType());
			}
		}
		if ($cart->item->getId() != $original_id){
			//change the item back to what it was originally, if it was changed.
			$cart->initItem($original_id);
		}
	}
	
	
	/**
	 * Required by interface.
	 * Used: in geoCart::initSteps()
	 * 
	 * Determine whether or not the other_details step should be added to the steps of adding this item
	 * to the cart.  This should also check any child items if it does not need other_details itself.
	 *
	 * @return boolean True to add other_details to steps, false otherwise.
	 */
	public static function geoCart_initSteps_addOtherDetails(){
		
		
		//need to check children items
		$children = geoOrderItem::getChildrenTypes(self::$type);
		//can call directly, since this function is required by interface.
		if (geoOrderItem::callDisplay('geoCart_initSteps_addOtherDetails',null,'bool_true',$children)){
			//one of the children want to display it, so return true.
			return true;
		}
		return false;
	}
	
	/**
	 * Optional.
	 * Used: in geoCart::cartDisplay()
	 * 
	 * Used only for "parent" items, this should return the text to use for the new button displayed
	 * in the cart view, for instance something like "Add New Classified".
	 *
	 */	
	public static function geoCart_cartDisplay_newButton()
	{
		if (!self::$_use){
			return;
		}
		$msgs = DataAccess::getInstance()->get_text(true, 10202);
		$label = $msgs[500254];
		return $label;
	}
	
	public function geoCart_initItem_new ()
	{
		return self::$_use;
	}
}