<?php
//order_items/_listing_placement_common.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21432              $ ##
## File last change date:       ##
##  $Date:: 2011-05-27 10:29:#$ ##
##                              ##
##################################

require_once CLASSES_DIR . PHP5_DIR . 'OrderItem.class.php';

abstract class _listing_placement_commonOrderItem extends geoOrderItem {
	
	protected static $listing_vars_to_update = array (
		'seller' => 'int',
		//Do NOT auto-update live setting, it will mess things up when changing
		//statuses back and forth.  To change live, alter the listing manually.
		//'live' => 'int',
		'title' => 'toDB',
		'date' => 'int',
		'description' => 'toDB',
		'precurrency' => 'toDB',
		'price' => 'float',
		'postcurrency' => 'toDB',
		'conversion_rate' => 'float',
		'image' => 'int',
		'offsite_videos_purchased' => 'int',
		'category' => 'int',
		'duration' => 'int',
		'location_city' => 'toDB',
		'location_state' => 'toDB',
		'location_country' => 'toDB',
		'location_zip' => 'toDB',
		'ends' => 'int',
		'search_text' => 'toDB',
		'viewed' => 'int',
		'responded' => 'int',
		'forwarded' => 'int',
		'bolding' => 'bool',
		//better placement needs to manually be set, due to "rotation" the value
		//changes over time
		//'better_placement' => 'int',
		'featured_ad' => 'bool',
		'featured_ad_2' => 'toDB',
		'featured_ad_3' => 'toDB',
		'featured_ad_4' => 'toDB',
		'featured_ad_5' => 'toDB',
		'attention_getter' => 'toDB',
		'attention_getter_url' => 'string',
		'expiration_notice' => 'bool',
		'expiration_last_sent' => 'int',
		'sold_displayed' => 'bool',
		'business_type' => 'int',
		'optional_field_1' => 'toDB',
		'optional_field_2' => 'toDB',
		'optional_field_3' => 'toDB',
		'optional_field_4' => 'toDB',
		'optional_field_5' => 'toDB',
		'optional_field_6' => 'toDB',
		'optional_field_7' => 'toDB',
		'optional_field_8' => 'toDB',
		'optional_field_9' => 'toDB',
		'optional_field_10' => 'toDB',
		'one_votes' => 'int',
		'two_votes' => 'int',
		'three_votes' => 'int',
		'vote_total' => 'int',
		'email' => 'toDB',
		'expose_email' => 'bool',
		'phone' => 'toDB',
		'phone2' => 'toDB',
		'fax' => 'toDB',
		'filter_id' => 'int',
		'mapping_address' => 'toDB',
		'mapping_city' => 'toDB',
		'mapping_state' => 'toDB',
		'mapping_country' => 'toDB',
		'mapping_zip' => 'toDB',
		'paypal_id' => 'toDB',
		'renewal_length' => 'int',
		'optional_field_11' => 'toDB',
		'optional_field_12' => 'toDB',
		'optional_field_13' => 'toDB',
		'optional_field_14' => 'toDB',
		'optional_field_15' => 'toDB',
		'optional_field_16' => 'toDB',
		'optional_field_17' => 'toDB',
		'optional_field_18' => 'toDB',
		'optional_field_19' => 'toDB',
		'optional_field_20' => 'toDB',
		'subscription_choice' => 'int',
		'discount_id' => 'int',
		'discount_amount' => 'float',
		'discount_percentage' => 'float',
		'url_link_1' => 'toDB',
		'url_link_2' => 'toDB',
		'url_link_3' => 'toDB',
		'price_plan_id' => 'int',
		'auction_type' => 'int',
		'auction_length' => 'int',
		'quantity' => 'int',
		'final_fee' => 'bool',
		'minimum_bid' => 'float',
		'starting_bid' => 'float',
		'reserve_price' => 'float',
		'buy_now' => 'float',
		'current_bid' => 'float',
		'final_price' => 'float',
		'high_bidder' => 'string',
		'start_time' => 'int',
		'payment_options' => 'string',
		'end_time' => 'int',
		'buy_now_only' => 'bool',
		'item_type' => 'int',
		'storefront_category' => 'int',
		'hide' => 'int',
		'reason_ad_ended' => 'toDB',
		'location_address' => 'toDB',
		'seller_buyer_data' => 'toDB',
		//Like "live" - do not allow changing automatically as it messes things
		//up when old removed order items come into play
		//'order_item_id' => 'int',
	);
	
	protected static $session_to_listing_key_map = array(
		'classified_title' => 'title',
		'classified_length' => 'duration',
		'address' => 'location_address',
		'city' => 'location_city',
		'state' => 'location_state',
		'country' => 'location_country',
		'zip_code' => 'location_zip',
		'email_option' => 'email',
		'phone_1_option' => 'phone',
		'phone_2_option' => 'phone2',
		'fax_option' => 'fax',
		'auction_quantity' => 'quantity',
		'auction_minimum' => array('starting_bid','minimum_bid'),
		'auction_reserve' => 'reserve_price',
		'auction_buy_now' => 'buy_now',
		'sell_type' => 'item_type'
	);
	
	private static $editing;
	private static $isAdmin;
	
	/**
	 * Because of the nature of static functions and abstract classes, for each function that needs to use this
	 * var in the abstract class, the class that extends this class will need to declare the function, and
	 * at the top of the function, set parent::$_type = 'type', then parent::function_name() or something like that.
	 *
	 * @var string
	 */
	protected static $_type;
	
	public $renew_upgrade = 0;
	/**
	 * So we don't have to remember what # is for renewal, and what is for upgrade.
	 * renewal is 1.
	 *
	 */
	const renewal = 1;
	/**
	 * Upgrade is 2
	 *
	 */
	const upgrade = 2;
	
	/**
	 * Can be used by addons to add vars to the array of
	 * listing vars to update, so that if that var exists
	 * in session_variables, it will be populated in the 
	 * geodesic_classifieds table when copying changes over.
	 * 
	 * @param string $key
	 * @param string $filter Either int, float, bool, date, or toDB.  This is
	 *  what type of field it is, which dictates how the var will be cleaned
	 *  prior to being inserted into the listing table.
	 */
	public static function addListingVar ($key, $filter)
	{
		$allowedFilters = array ('int', 'float', 'bool','toDB', 'date');
		$key = trim($key);
		if (in_array($filter, $allowedFilters) && strlen($key)) {
			self::$listing_vars_to_update[$key] = $filter;
		}
	}
	
	public function displayInAdmin() {
		return true;
	}
	/**
	 * Optional
	 * Used: in admin, display items awaiting approval (only for main items, not for sub-items)
	 *
	 * @return array Associative array, in the form array ('type' => string, 'title' => string)
	 */
	public function adminDetails ()
	{
		$session_variables = $this->get('session_variables');
		//die ('session vars: <pre>'.print_r($session_variables,1));
		$title = $session_variables['classified_title'];
		if (strlen($title) > 20) {
			$title = '<span title="'.$title.'">'.geoString::substr($title,0,17).'...'.'</span>';
		}
		//$title = $this->getId() . ' - '.$title;
		
		return array(
			'type' => ucwords(str_replace('_',' ',$this->getType())),
			'title' => $title
		);
	}
	
	public static function geoCart_initSteps($applies_to= null)
	{
		$cart = geoCart::getInstance();
		
		if (geoPC::is_ent()) $cart->addStep(self::$_type . ':splash');
		$choose_plan = self::_choosePricePlan($applies_to, $type);
		
		if (!$choose_plan && $cart->price_plan['price_plan_id'] && is_object($cart->item) && $cart->item->getType() == self::$_type && !$cart->item->getPricePlan()){
			//set price plan to default to keep from looking it up each time
			$cart->item->setPricePlan($cart->price_plan['price_plan_id']);
		} elseif ($choose_plan) {
			$cart->addStep(self::$_type . ':choose_plan');
		}
		$cart->addStep(self::$_type . ':category');
		$cart->addStep(self::$_type . ':details');
		
		//get steps from children as well.
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		
		if (geoOrderItem::callDisplay('addMedia', null, 'bool_true', $children)) {
			$cart->addStep(self::$_type . ':media');
		}
		
		geoOrderItem::callUpdate('geoCart_initSteps',null,$children);
	}
	
	protected static $_choose_price_plan = array();
	protected static function _choosePricePlan($applies_to)
	{
		if (isset(self::$_choose_price_plan[$applies_to])){
			return self::$_choose_price_plan[$applies_to];
		}
		$cart = geoCart::getInstance();
		
		//check to see if we should show price plan choice form
		$sql = "SELECT `price_plan_id` FROM ".geoTables::attached_price_plans." WHERE `group_id` = ".intval($cart->user_data['group_id'])." AND `price_plan_id` > 0 AND `applies_to` = $applies_to";
		$multiple_price_plan_result = $cart->db->Execute($sql);
		if ($multiple_price_plan_result && $multiple_price_plan_result->RecordCount() > 1){
			self::$_choose_price_plan[$applies_to] = 1;
			return true;
		}
		self::$_choose_price_plan[$applies_to] = 0;
		return false;
	}
	
	public static function choose_planCheckVars($applies_to)
	{
		$cart = geoCart::getInstance();
		
		$price_plan = intval((isset($_GET['price_plan']))? $_GET['price_plan']: 0);
		if (!$price_plan){
			$cart->addError();
			return;
		}
		
		//check that price plan exists and attached to this group

		$sql = "SELECT * FROM ".geoTables::attached_price_plans." WHERE `group_id` = ? AND `price_plan_id` = ? AND `applies_to` = $applies_to";
		$check_price_plan_result = $cart->db->Execute($sql, array($cart->user_data['group_id'], $price_plan));
		if (!$check_price_plan_result || $check_price_plan_result->RecordCount() != 1)
		{
			$cart->addError();
			$cart->site->setup_error = $cart->site->messages[453];
			return false;
		}
		
		return true;
	}
	public static function choose_planProcess ()
	{
		$cart = geoCart::getInstance();
		
		//set the price plan, it was already checked by checkVars...
		
		$price_plan = intval((isset($_GET['price_plan']))? $_GET['price_plan']: 0);
		$cart->site->users_price_plan = $cart->site->session_variables['price_plan_id'] = $cart->site->session_variables['users_price_plan'] = $price_plan;
		$cart->item->set('session_variables',$cart->site->session_variables);
		$cart->item->setPricePlan($price_plan);
		$cart->setPricePlan($price_plan,0);
		
		//check to make sure they havn't reached the max allowed for this plan
		self::_checkMaximumListingLimit();
	}
	public static function choose_planDisplay ($applies_to)
	{
		$cart = geoCart::getInstance();
		$cart->site->users_group = $cart->user_data['group_id'];
		$cart->site->sell_type = $applies_to;
		
		$sql = "SELECT * FROM ".geoTables::attached_price_plans." WHERE `group_id` = ? AND `price_plan_id` > 0 AND `applies_to` = $applies_to ORDER BY `name`";
		$attached_result = $cart->db->Execute($sql, array($cart->site->users_group));
		
		if (!$attached_result || $attached_result->RecordCount() == 0)
		{
			$cart->site->setup_error = 1;
			//returned false, just go with default one and skip to next step.
			$current_step = $cart->current_step;
			$cart->current_step = $cart->cart_variables['current_step'] = $cart->getNextStep();
			if ($cart->current_step !== $current_step){
				//made sure we don't do infinite loop
				return $cart->displayStep();
			}
			//should not get here unless weird error.. this just fallback so use doesn't see blank page
			return self::categoryDisplay();
		}
		
		//$this->check_user_subscription();
		//the user does not currently have a subscription...and the price plan has not been set
		$cart->site->page_id = 8;
		$cart->site->get_text();
		
		//$tpl = new geoTemplate('system','order_items');
		$tpl_vars = $cart->getCommonTemplateVars();
		$tpl_vars['msgs'] = $cart->site->messages;
		$tpl_vars['price_plans'] = $attached_result->GetAll();
		$tpl_vars['error_msgs'] = $cart->getErrorMsgs();
		
		geoView::getInstance()->setBodyTpl('shared/choose_price_plan.tpl','','order_items')
			->setBodyVar($tpl_vars);
		
		$cart->site->display_page();
		require GEO_BASE_DIR . 'app_bottom.php';
		exit;
	}
	
	public static function geoCart_initItem_forceOutsideCart(){
		return false;
	}
	
	public function geoCart_initItem_new ($item_type)
	{
		$cart = geoCart::getInstance();
		if (!defined('IN_ADMIN') && geoPC::is_print() && $cart->db->get_site_setting('disableClientPlaceListings')) {
			//oops, not allowed to place listing on client side
			//get text, since text won't be there at this point
			$cart->site->messages = $cart->db->get_text(true, 10202);
			
			$cart->addErrorMsg('no_listings', $cart->site->messages[500895]);
			
			return false;
		}
		//check to make sure max listing count has not been met, adding 1 to the count since the one we are adding right now is not
		//counted yet...  But only check if they do NOT have multiple listings...
		if (!self::_choosePricePlan($item_type) && !self::_checkMaximumListingLimit(1)){
			//oops, they have reached it
			return false;
		}
		
		//make sure they don't have restriction in place
		if (!($cart->user_data['restrictions_bitmask'] & 1)) {
			//not allowed to place a new listing, as per user group restrictions!
			return false;
		}
		
		if (!defined('DID_COPY') && isset($_REQUEST['copy_id']) && $_REQUEST['copy_id']){
			//attempt to copy the listing over
			define('DID_COPY',1);
			trigger_error('DEBUG CART: Copy Listing Here');
			self::_copyListing(intval($_REQUEST['copy_id']), $item_type);
			
			//reset the price plan, to keep it from being set to "old" price plan
			$cart = geoCart::getInstance();
			$setting = ($item_type == 1)? 'price_plan_id':'auction_price_plan_id';
			$this->setPricePlan($cart->user_data[$setting]);
		}
		return true;
	}
	
	public static function geoCart_initSession_new ($call_children = true, $item_type)
	{
		$cart = geoCart::getInstance();
		if (!is_object($cart->item) || $cart->item->getType() != self::$_type){
			//nothin to do here folks...
			return false;
		}
		//this is classifieds
		$cart->site->sell_type = $item_type;
		if ($cart->item->get('session_variables')){
			//get variables from db and save in local variables
			trigger_error('DEBUG CART: Used -- session vars already set.');
			self::set_sell_variables($item_type);
			
			$cart->setPricePlan($cart->item->getPricePlan(), $cart->item->getCategory());
			if ($cart->item->getPricePlan() && !self::_checkMaximumListingLimit()){
				//reached limit of how many listings there can be!
				return false;
			}
			// Set the price plan
			$cart->site->price_plan = $cart->price_plan;
		} else {
			trigger_error('DEBUG CART: brand new -- session vars NOT set.');
			//create new sell session
			//do NOT encode at this time, the data is encoded when going from session
			//to the classifieds table, it is not encoded in the session vars
			$cart->site->session_variables = array (
				'seller' => $cart->user_data['id'],
				'time_started' => geoUtil::time(),
				'phone_1_option' => $cart->user_data['phone'],
				'phone_2_option' => $cart->user_data['phone2'],
				'fax_option' => $cart->user_data['fax'],
				'address' => $cart->user_data['address']. ' '.$cart->user_data['address_2'],
				'city' => $cart->user_data['city'],
				'state' => $cart->user_data['state'],
				'country' => $cart->user_data['country'],
				'zip_code' => $cart->user_data['zip'],
				'url_link_1' => $cart->user_data['url'],
				'mapping_address' => $cart->user_data['address'], //NOT using address2 here, because it doesn't help with mapping
				'mapping_city' => $cart->user_data['city'],
				'mapping_state' => $cart->user_data['state'],
				'mapping_country' => $cart->user_data['country'],
				'mapping_zip' => $cart->user_data['zip'],
				'users_group' => $cart->user_data['group_id']
			);
			

			if ($cart->db->get_site_setting('use_filters') && geoPC::is_ent())
			{
				//set filter
				$cart->site->set_filter_id();

				for($i = 1; $i < 21; $i++)
				{
					if ($cart->db->get_site_setting('optional_'.$i.'_filter_association'))
					{
						$cart->site->session_variables["optional_field_".$i] = $cart->site->get_filter_value(0,$cart->db->get_site_setting('optional_'.$i.'_filter_association'));
					}
				}
			}
			//since this is a new item, do not need to check for max listing limit, as it is done for us in init_itemNew
		}
		
		
		$cart->item->set('session_variables',$cart->site->session_variables);
		trigger_error('DEBUG CART: End of classified: new session');
		if ($call_children){
			$children = geoOrderItem::getChildrenTypes(self::$_type);
			geoOrderItem::callUpdate('geoCart_initSession_new',null,$children);
		}
	}
	
	
	public static function splashCheckVars(){
		
	}
	public static function splashProcess(){
		
	}
	
	public static function splashDisplay()
	{
		$cart = geoCart::getInstance();
		$sql = "SELECT `place_an_ad_splash_code` as `splash` FROM ".geoTables::groups_table." WHERE `group_id` = ? LIMIT 1";
		$result = $cart->db->Execute($sql, array($cart->user_data['group_id']));
		if (!$result || $result->RecordCount() == 0)
		{
			//error getting the splash code
			trigger_error('ERROR SQL CART: Sql: '.$sql.' Error Msg: '.$cart->db->ErrorMsg());
			return false;
		}
		//we only display the splash page once, if at all
		
		$show = $result->FetchRow();
		if (strlen(trim($show['splash'])) > 0)
		{
			//display the splash code
			
			$cart->site->page_id = 8;
			$cart->site->get_text();
			$tpl_vars = $cart->getCommonTemplateVars();
			$tpl_vars['splash']=geoString::fromDB($show['splash']);
			$tpl_vars['next_url']=$cart->getProcessFormUrl();
			$tpl_vars['next_text']=$cart->site->messages[905];
			$tpl_vars['item_name']=$cart->main_type;
			
			geoView::getInstance()->setBodyTpl('shared/display_splash.tpl','','order_items')
				->setBodyVar($tpl_vars);
			
			$cart->site->display_page();
			return;
		}
		//no splash code there-- move on by manually calling the display for 
		//the next step 
		
		$current_step = $cart->current_step;
		$cart->current_step = $cart->cart_variables['step'] = $cart->getNextStep();
		if ($cart->current_step !== $current_step){
			//made sure we don't do infinite loop
			return $cart->displayStep();
		}
	}
	
	
	public static function categoryCheckVars ($listing_types_allowed, $cat_id = 0)
	{
		$cart = geoCart::getInstance();
		
		if (!$cat_id) {
			//check to see if b is a terminal category, or if user selected to use current category
			$cat_id = (isset($_GET['b']))? intval($_GET['b']): 0;
		}
		
		$terminal = ($cat_id && (isset($_REQUEST["c"]) && $_REQUEST["c"] == "terminal" && !$cart->db->get_site_setting('place_ads_only_in_terminal_categories')));
		if (!$cat_id){
			$cart->addError(); //do not allow moving forward without category set.
			return ;
		}
		if (!$terminal){
			//Not terminal by force, See if the category selected was terminal by nature...
			$sql = "SELECT `category_id` FROM ".geoTables::categories_table." WHERE `parent_id`={$cat_id} AND (`listing_types_allowed`=0 OR `listing_types_allowed`=$listing_types_allowed) LIMIT 1";
			$row = $cart->db->getRow($sql);
			if ($row){
				//this category has children, so set it as the parent and don't allow to continue
				$cart->item->set('parent_category',$cat_id);
				$cart->item->set('terminal_category',false);
				$cart->addError();
				return;
			}
		}
		//made it this far, the category wants to be terminal.  Make sure it's a real category.
		$sql = "SELECT `category_id` FROM ".geoTables::categories_table." WHERE `category_id`={$cat_id} AND (`listing_types_allowed`=0 OR `listing_types_allowed`=$listing_types_allowed) LIMIT 1";
		$row = $cart->db->getRow($sql);
		if (!$row){
			//category not found?  set parent cat to 0 and don't allow to continue
			$cart->item->set('parent_category',false);
			$cart->item->set('terminal_category',false);
			$cart->addError();
			return;
		}
		$cart->item->set('terminal_category',$cat_id);
		$cart->item->save();
	}
	public static function categoryProcess()
	{
		$cart = geoCart::getInstance();
		
		//at this point, the setting checker should have set the cat id as a session var.
		$cat_id = $cart->item->get('terminal_category');
		
		//category found, must be allowed to place classified in category, category is valid, and is allowed to have listings in it.
		$cart->item->set('parent_category',false); //unset parent, we don't need it any more.
		$cart->item->set('terminal_category',false);
		
		//set the category in the item.
		$cart->item->setCategory($cat_id); //set the cat ID as a setting on the main item, so that any other items can access it easy.
		//update the price plan
		$cart->setPricePlan($cart->item->getPricePlan(), $cat_id);
		
		$cart->site->terminal_category = $cat_id;
		$cart->site->session_variables['category'] = $cat_id;
		self::saveFormVariables();
	}
	
	public static function categoryDisplay ($listing_types_allowed)
	{
		$cart = geoCart::getInstance();
		
		$cart->site->page_id = 8;
		$cart->site->get_text();
		
		//parent category set by check_vars function
		$parent_category = $cart->item->get('parent_category');
		
		$tpl_vars = $cart->getCommonTemplateVars();
		
		$cat_img = ($cart->db->get_site_setting('display_cat_image_listing_process'))? ', c.category_image': '';
		$order_by = ($cart->db->get_site_setting('order_choose_category_by_alpha'))? "l.category_name":"c.display_order, l.category_name";
		$sql = "SELECT c.category_id, l.category_name{$cat_img}, l.description FROM ".geoTables::categories_table." as c,".geoTables::categories_languages_table." as l WHERE
				`parent_id` = ? AND
				c.category_id = l.category_id AND
				l.language_id = ? AND (c.listing_types_allowed = 0 OR c.listing_types_allowed = $listing_types_allowed)
				ORDER BY $order_by";
		$query_data = array(
			$parent_category,
			$cart->db->getLanguage()				
		);
		$sub_result = $cart->db->Execute($sql, $query_data);
		if (!$sub_result) {
			//echo $sql." is the query<br />\n";
			trigger_error('ERROR SQL CART: Sql: '.$sql.' Error Msg: '.$cart->db->ErrorMsg());
			$cart->site->error_message = $cart->site->messages[57];
			return false;
		}
		
		$categories = $sub_result->GetAll();
		$colspan = $cart->db->get_site_setting('sell_category_column_count');
		if (!$colspan){
			$colspan = 1;
		}
		
		$tpl_vars['title2'] = $cart->site->messages[83];
		$tpl_vars['parent_cat_id'] = $parent_category;
		
		$column_width = floor(100 / $colspan) . '%';
		$tpl_vars['colspan'] = $colspan;
		$tpl_vars['column_width'] = $column_width;
		$tpl_vars['display_cat_image'] = $cart->db->get_site_setting('display_cat_image_listing_process');
		$tpl_vars['display_cat_description'] = $cart->db->get_site_setting('display_cat_description_listing_process');
		$tpl_vars['main_type'] = $cart->main_type;
		$tpl_vars['step'] = $cart->current_step;
		$category_counter = 0;
		
        if ( $cart->db->get_site_setting('cat_alpha_across_columns') ) {
            $tpl_vars['cat_data'] =  $categories;
        } else {
            //Need to re-arrange everything so it's in the different order.

			$categories_x = array_values( $categories ); // convert associative to numeric array
			$num_cols = $cart->db->get_site_setting('sell_category_column_count');
			$k = 0;
			$num_filled = 0;
			$cats = array();

			$num_cells = count ($categories_x);
			$num_rows = (int)($num_cells / $num_cols);
			$num_full_cols = ($num_cells % $num_cols) ? $num_cells % $num_cols : $num_cols;
            if ($num_full_cols != $num_cols)
                $num_rows++;
				for($i = 0; $i < $num_rows; $i++) {
					$k = $i;
					for($j = 0; $j < $num_cols; $j++) {
						if ($k < $num_cells)  {
							$cats[] = $categories_x[$k];
							$num_filled++;
							if ($num_filled >= $num_cells) {
								break 2;
							}
						}
						$k += ($j < $num_full_cols) ? $num_rows : $num_rows-1;
					}
				}
			$tpl_vars['cat_data'] =  $cats;
        }   
		
		
		//specific to when selecting the sub-category, still assign to give ability to still use in
		//template, even though default template only uses these on sub-categories
		$tpl_vars['text1'] = $cart->site->messages[77];
		$tpl_vars['num_cats'] = $sub_result->RecordCount();
		$tpl_vars['text2'] = $cart->site->messages[80];
		if ($parent_category) {
			//specific to only when displaying sub-categories.
			$parent_name = geoCategory::getBasicInfo($parent_category);
			$tpl_vars['help_link'] = $cart->site->display_help_link(85);
			$tpl_vars['desc1'] = $cart->site->messages[79];
			$tpl_vars['parent_cat_name'] = $parent_name['category_name'];
			
			$tpl_vars['desc2'] = $cart->site->messages[78];
			$tpl_vars['listings_only_in_terminal'] = $cart->db->get_site_setting('place_ads_only_in_terminal_categories');
		
			//need to display this category as a choice here
			if (!$cart->db->get_site_setting('place_ads_only_in_terminal_categories')) {
				$tpl_vars['text3'] = $cart->site->messages[82];
			}
		} else {
			//specific to when displaying the main category
			$tpl_vars['help_link'] = $cart->site->display_help_link(84);
			$tpl_vars['desc1'] = $cart->site->messages[76];
			$tpl_vars['desc2'] = '';
			$tpl_vars['listings_only_in_terminal'] = 1;//since main category..
		}
		
		$view = geoView::getInstance();
		
		$tpl_vars['error_msgs'] = $errors = $cart->getErrorMsgs();
		
		return $tpl_vars;
		
		$view->setBodyTpl('shared/category_choose.tpl','','order_items')
			->setBodyVar($tpl_vars);
		
		$cart->site->display_page();
	}
	
	public static function detailsCheckVars ($save_session_vars = true)
	{
		$cart = geoCart::getInstance();
		
		if (!(isset($_REQUEST['b']) && is_array($_REQUEST['b']))){
			//nothing submitted
			trigger_error('DEBUG CART: B not set or not an array, so cannot check vars.');
			$cart->addError();
			return;
		}
		$cart->setPricePlan($cart->item->getPricePlan(),$cart->item->getCategory());
		
		$cart->site->error = 0;
		$cart->site->terminal_category = $cart->item->getCategory();
		$cart->site->get_badword_array();
		$cart->site->get_html_disallowed_array();
		$cart->site->get_form_variables($_REQUEST["b"]);
		
		$cart->site->field_configuration_data = self::getFieldConfig();
		
		//Let order items run their own checkvars here
		geoOrderItem::callUpdate('detailsCheckVars_getMoreDetails', self::$_type, null, true);
		//let "end" also happen
		geoOrderItem::callUpdate('detailsCheckVars_getMoreDetailsEnd', self::$_type, null, true);
		
		//make sure min bid is > 0
		if ($cart->site->session_variables['auction_minimum'] <= 0) {
			$cart->site->session_variables['auction_minimum'] = 0.01;
		}
		$cart->site->check_extra_questions();
		
		//pull business type from userdata
		$cart->site->session_variables['business_type'] = geoUser::getData($cart->order->getBuyer(), 'business_type');
		
		
		
		self::saveFormVariables();
		if (!$cart->site->classified_detail_check(0,$cart->site->terminal_category, ($save_session_vars == 'skipSave')))
		{
			trigger_error('DEBUG CART:classified detail check returned false. errors: <pre>'.print_r($cart->site->field_configuration_data,1).'</pre>');
			$cart->addError();
			//$cart->site->save_form_variables($db);
			//$cart->site->display_classified_detail_form();
		} else {
			trigger_error('DEBUG CART: No errors found, should not be a problem.');
			//save any changes made in detail check
			if ($save_session_vars!='skipSave') {
				$cart->item->set('session_variables',$cart->site->session_variables);
			}
		}
		
		if (geoPC::is_ent() && $cart->site->sell_type == 2){
			//On-Site Payment Types
			geoSellerBuyer::callUpdate('listings_placement_common_detailsCheckVars');
		}
	}
	public static function detailsProcess($noSetCost = false){
		$cart = geoCart::getInstance();
		$cart->setPricePlan($cart->item->getPricePlan(),$cart->item->getCategory());
		if (!$noSetCost) {
			$cart->item->setCost(self::getListingCost());
		}
		if (geoPC::is_ent() && $cart->site->sell_type == 2){
			//On-Site Payment Types
			geoSellerBuyer::callUpdate('listings_placement_common_detailsProcess');
		}
		//Let order items run their own checkvars here
		geoOrderItem::callUpdate('detailsProcess_getMoreDetails', self::$_type, null, true);
		//let "end" also happen
		geoOrderItem::callUpdate('detailsProcess_getMoreDetailsEnd', self::$_type, null, true);
		
		self::saveFormVariables();
		return false;
	}
	
	public static function getFieldConfig ()
	{
		//TODO: Don't get settings not used any more
		$cart = geoCart::getInstance();
		
		$cart->site->site_category = $catId = $cart->item->getCategory();
		$groupId = 0;
		if ($cart->user_data['group_id']) {
			$groupId = (int)$cart->user_data['group_id'];
		}
		
		$cart->site->fields = geoFields::getInstance($groupId, $catId);
		
		$cart->site->category_configuration = $cat = geoCategory::getCategoryConfig($catId);
		$cart->site->get_ad_configuration();
		
		//for easy access to edit switches
		$config = $cart->site->ad_configuration_data;
		
		$field_config = $cart->db->GetRow("SELECT * FROM ".geoTables::ad_configuration_table);
		$site_settings_get = array ('allow_standard', 'allow_dutch', 
			'user_set_auction_start_times','user_set_auction_end_times', 'use_filters');
		
		if (!$cat['use_site_default'] || !geoPC::is_ent()) {
			//echo "using site settings<br />\n use_site_default: {$cat['use_site_default']}";
			
		} else {
			//echo "using category settings<br />\n";
			//$cart->site->field_configuration_data = $cart->site->category_configuration;
			$field_config = array_merge($field_config,$cat);
		}
		if (geoPC::is_ent() && $cart->db->get_site_setting('use_filters')) {
			for ($i = 1; $i <= 20; $i++) {
				$site_settings_get[] = 'optional_'.$i.'_filter_association';
			}
		}
		foreach ($site_settings_get as $setting) {
			$field_config[$setting] = $cart->db->get_site_setting($setting);
		}
		
		return $field_config;
	}
	
	public static function detailsDisplay(){
		$cart = geoCart::getInstance();
		$view = geoView::getInstance();
		
		$cart->site->page_id = 9;
		$cart->site->get_text();
		$cart->site->terminal_category = $cart->item->getCategory();
		
		$cart->setPricePlan($cart->item->getPricePlan(),$cart->item->getCategory());
		
		$field_config = $cart->site->field_configuration_data = self::getFieldConfig();
		$tpl_vars = $cart->getCommonTemplateVars();
		//Do stuff for view class
		//make sure prototype is loaded, a lot of JS on this page relies on it.
		$pre = (defined('IN_ADMIN'))? '../' : '';
		$view->addJScript($pre.geoTemplate::getUrl('js', 'listing_placement.js')); //load js functions for this page
		
		$cart->site->get_currency_info();
		if(self::$_type == 'listing_edit') {
			self::$editing = true;
			self::$isAdmin = $cart->item->get('adminEdit', false);
		}
		
		$tpl_vars['field_config'] = $field_config;
		$fields = geoFields::getInstance($cart->user_data['group_id'], $cart->item->getCategory());
		
		//if using JIT, email is always present and required, regardless of admin settings
		//check here to make sure the field appears -- site_class_temp::classified_detail_check makes it always required
		if ($cart->user_data['id'] == 0 && $cart->db->get_site_setting('jit_registration')) {
			$fields->email->is_enabled = true;
		}
		$tpl_vars['fields'] = $fields;
		
		//add js to top for script that displays num of chars left
		$view->addTop("
<script type='text/javascript'>
	var max_length = {$fields->description->text_length};
</script>");

		$tpl_vars['form_url'] = $cart->getProcessFormUrl();
		
		$tpl_vars['txt2'] = $cart->site->messages[640];
		$tpl_vars['txt3'] = $cart->site->messages[639];
		$tpl_vars['is_ent'] = geoPC::is_ent();
		$tpl_vars['user_data'] = $cart->user_data;
		$errors = $cart->getErrorMsgs();
		$errors = array_merge($errors, $cart->site->error_variables);
		$tpl_vars['error_msgs'] = $errors;
		
		$tpl_vars['category_tree'] = geoCategory::getTree($cart->item->getCategory());
		
		//give info about category
		$tpl_vars['category_data'] = geoCategory::getBasicInfo($cart->item->getCategory());
		
		$tpl_vars['sell_type'] = $cart->site->sell_type;
		$tpl_vars['editCheck'] = self::_editCheck(false);
		$tpl_vars['pricePlan'] = $cart->price_plan;
		$tpl_vars['session_variables'] = $cart->site->session_variables;
		$tpl_vars['use_auto_title'] = ((isset($cart->site->category_configuration['use_auto_title']) && $cart->site->category_configuration['use_auto_title']) || $cart->db->get_site_setting('use_sitewide_auto_title'));
		
		if ($cart->site->sell_type == 1 && self::_editCheck(false)) {
			//classified duration
			if ($cart->price_plan['charge_per_ad_type'] == 2) {
				$tpl_vars['duration_dropdown'] = $cart->site->display_charge_by_duration_dropdown(true);
			} else {
				$tpl_vars['duration_dropdown'] = $cart->site->display_basic_duration_dropdown(true);
			}
		} else {
			$tpl_vars['duration_dropdown'] = '';
		}
		$tpl_vars['use_textarea_in_title'] = $cart->db->get_site_setting('use_textarea_in_title');
		$tpl_vars['display_description_last_in_form'] = $cart->db->get_site_setting('display_description_last_in_form');
		$width = $cart->db->get_site_setting("desc_wysiwyg_width");
		$height = $cart->db->get_site_setting('desc_wysiwyg_height');
		$tpl_vars['desc_wysiwyg_width'] = ($width)? $width : '700';//default to 700px
		$tpl_vars['desc_wysiwyg_height'] = ($height)? $height : '280';//default to 280px
		
		$tpl_vars['use_rte'] = $cart->db->get_site_setting('use_rte');
		
		//signal to use editor, if turned on
		$view->editor = 1;
		
		$textareawrap = (is_object($cart->site->ad_configuration_data)) ? $cart->site->ad_configuration_data->TEXTAREA_WRAP : $cart->site->ad_configuration_data['textarea_wrap'];
		if ($textareawrap) {
			$desc_clean = geoString::specialChars(preg_replace('/<br[\s]*\/?>/i'," \n",$cart->site->session_variables["description"]));
		} else {
			$desc_clean = geoString::specialChars($cart->site->session_variables["description"]);
		}
		$tpl_vars['desc_clean'] = $desc_clean;
		
		if ($fields->tags->is_enabled) {
			//help text for tags
			$tpl_vars['tags_help_link'] = $cart->site->display_help_link(500864);
			
			//force scriptaculous to be turned on, for auto-complete to work
			$view->scriptaculous = 1;
		}
		
		//if editing an auction, find out if we can edit price fields
		$editAuctionPrices = true;
		if (self::$editing && ($cart->site->sell_type == 2 || $cart->site->sell_type == 4)) {
			//find bids
			$sql = "SELECT `auction_id` FROM `geodesic_auctions_bids` WHERE `auction_id` = ".$cart->site->session_variables['listing_id']." LIMIT 1";
			$bidsExist = $cart->db->GetOne($sql);
			
			$listing = geoListing::getListing($cart->site->session_variables['listing_id']);
			
			if($listing->live == 1 && ($bidsExist || !$cart->db->get_site_setting('edit_auction_prices'))) {
				$editAuctionPrices = false;
			}
		}
		$tpl_vars['editAuctionPrices'] = $editAuctionPrices;
		
		$tpl_vars['currency_type'] = $cart->site->session_variables['currency_type'];
		$tpl_vars['currencies'] = $cart->db->GetAll("SELECT `type_id`, `precurrency`, `postcurrency` FROM ".geoTables::currency_types_table." ORDER BY `display_order`");
		
		if (($cart->site->sell_type == 2 || $cart->site->sell_type == 4) && $editAuctionPrices) {
			$tpl_vars['auction_type_help_link'] = $cart->site->display_help_link(200172);
			
			$current_time = geoUtil::time();
			if($cart->db->get_site_setting('user_set_auction_start_times') && self::_editCheck(false)) {
				if ($cart->site->session_variables["start_time"] < $current_time) {
					$current_start_time = $current_time;
				} else {
					$current_start_time = $cart->site->session_variables["start_time"];
				}
				//TODO: Convert this to smarty
				$cart->site->return_value = true;
				$tpl_vars['date_select_start_time'] = $cart->site->get_date_select("b[start_time][start_year]","b[start_time][start_month]","b[start_time][start_day]","b[start_time][start_hour]","b[start_time][start_minute]",$current_start_time);
			}
			
			// auction end time
			if($cart->db->get_site_setting('user_set_auction_end_times') && $cart->price_plan['charge_per_ad_type'] != 2 && self::_editCheck(false)) {
				if ($cart->site->session_variables["end_time"] < $current_time) {
					$current_end_time = $current_time;
				} else {
					$current_end_time = $cart->site->session_variables["end_time"];
				}
				//TODO: Convert this to smarty
				if(is_array($current_end_time)) {
					//need to convert end time from array to ticktime before passing to get_date_select()
					$current_end_time = $cart->site->get_time($current_end_time['end_hour'], $current_end_time['end_minute'], $current_end_time['end_month'],$current_end_time['end_day'],$current_end_time['end_year']); 
				}
				$cart->site->return_value = true;
				$tpl_vars['date_select_end_time'] = $cart->site->get_date_select("b[end_time][end_year]","b[end_time][end_month]","b[end_time][end_day]","b[end_time][end_hour]","b[end_time][end_minute]",$current_end_time,0,0,0,0,0,true);
				
			}
			
			//auction duration
			if(self::_editCheck(false)) {
				trigger_error('DEBUG CART: About to get auction dropdown');
				if ($cart->price_plan['charge_per_ad_type'] == 2){
					$tpl_vars['auction_duration_dropdown'] = $cart->site->display_charge_by_duration_dropdown(true);
				} else {
					$tpl_vars['auction_duration_dropdown'] = $cart->site->display_basic_duration_dropdown(true);
				}
			}
			if (!$cart->price_plan['buy_now_only']){
				//BIDDING
				//WILL ONLY INSERT THIS ONLOAD IF NOTHING IS INSIDE THE BODY TAG
				//need an onload event without using 'onload' so we put onmousemove in body tag instead
				$view->addTop("
<script type='text/javascript'>
	Event.observe(window, 'load', geoListing.check_buy_now_only);
</script>"
				);
				
				$tpl_vars['bno'] = (($cart->price_plan['buy_now_only'] || $cart->site->session_variables['buy_now_only'])&&geoPC::is_ent())? 1 : 0;
				$tpl_vars['is_dutch'] = ($cart->site->session_variables['auction_type']==2) ? 1 : 0;

				//minimum bid
				if (!$cart->site->session_variables['auction_minimum']) {
					$cart->site->session_variables['auction_minimum'] = $tpl_vars['session_variables']['auction_minimum'] = 0.01;
				}
			}
		} // end auctions price edit section
		
		if ($cart->site->sell_type == 2 && geoPC::is_ent()) {
			//On-Site Payment Types
			$tpl_vars['on_site_html'] = geoSellerBuyer::callDisplay('listings_placement_common_detailsDisplay',null,'<br />');
		}
		
		// Off-Site payment types
		if($fields->payment_types->is_enabled) {
			$sql = "SELECT * FROM ".geoTables::auction_payment_types_table." ORDER BY `display_order`";
			$tpl_vars['payment_options'] = $cart->db->GetAll($sql);
			
			if (!is_array($cart->site->session_variables["payment_options"])) {
				$cart->site->session_variables["payment_options"] = $tpl_vars['session_variables']['payment_options'] = explode("||",$cart->site->session_variables["payment_options"]);
			}
		}
		//country
		$tpl_vars['country_html'] = '';
		$region = geoRegion::getInstance();
		if ($fields->country->is_enabled && self::_editCheck($fields->country->can_edit)) {
			$country_data = $cart->site->session_variables["country"];
			
			$region->addRegionName('b[country]','b[state]');
			$tpl_vars['country_html'] .= $region->getRegion($country_data,'b[country]');
		}
		$tpl_vars['country_field_isFancy'] = $region->isFancy();
		
		//state
		if ($fields->state->is_enabled && self::_editCheck($fields->state->can_edit)) {
			$state_data = $cart->site->session_variables["state"];
			
			$region->addRegionName('b[country]','b[state]');
			$tpl_vars['state_html'] = $region->getSubRegion($state_data,'b[state]');
		}

		
		if ( geoPC::is_ent() ) {
			$tpl_vars['add_cost_at_top'] = $cart->db->get_site_setting('add_cost_at_top');
			
			$tpl_vars['opt_field_info'] = array(
			1 => array('label' => $cart->site->messages[909],'error' => $cart->site->messages[910],'or' => $cart->site->messages[133], 'field' => $fields->optional_field_1),
			2 => array('label' => $cart->site->messages[941], 'error' => $cart->site->messages[942], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_2),
			3 => array('label' => $cart->site->messages[943], 'error' => $cart->site->messages[944], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_3),
			4 => array('label' => $cart->site->messages[945], 'error' => $cart->site->messages[946], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_4),
			5 => array('label' => $cart->site->messages[947], 'error' => $cart->site->messages[948], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_5),
			6 => array('label' => $cart->site->messages[949], 'error' => $cart->site->messages[950], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_6),
			7 => array('label' => $cart->site->messages[951], 'error' => $cart->site->messages[952], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_7),
			8 => array('label' => $cart->site->messages[953], 'error' => $cart->site->messages[954], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_8),
			9 => array('label' => $cart->site->messages[955], 'error' => $cart->site->messages[956], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_9),
			10 => array('label' => $cart->site->messages[957], 'error' => $cart->site->messages[958], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_10),
			11 => array('label' => $cart->site->messages[1903], 'error' => $cart->site->messages[1904], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_11),
			12 => array('label' => $cart->site->messages[1905], 'error' => $cart->site->messages[1906], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_12),
			13 => array('label' => $cart->site->messages[1907], 'error' => $cart->site->messages[1908], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_13),
			14 => array('label' => $cart->site->messages[1909], 'error' => $cart->site->messages[1910], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_14),
			15 => array('label' => $cart->site->messages[1911], 'error' => $cart->site->messages[1912], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_15),
			16 => array('label' => $cart->site->messages[1913], 'error' => $cart->site->messages[1914], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_16),
			17 => array('label' => $cart->site->messages[1915], 'error' => $cart->site->messages[1916], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_17),
			18 => array('label' => $cart->site->messages[1917], 'error' => $cart->site->messages[1918], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_18),
			19 => array('label' => $cart->site->messages[1919], 'error' => $cart->site->messages[1920], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_19),
			20 => array('label' => $cart->site->messages[1921], 'error' => $cart->site->messages[1922], 'or' => $cart->site->messages[133], 'field' => $fields->optional_field_20)
			);

			for ($i=1;$i<21;$i++) {
				if (!$errors['optional_field_'.$i]) {
					//no error to show for this field -- clear the tpl var
					$tpl_vars['opt_field_info'][$i]['error'] = '';	
				}
				$tpl_vars['opt_field_info'][$i]['filter_assoc'] = $field_config["optional_".$i."_filter_association"];
				$tpl_vars['opt_field_info'][$i]['value'] = $cart->site->session_variables["optional_field_".$i];
				$tpl_vars['opt_field_info'][$i]['other_box'] = (strpos($tpl_vars['opt_field_info'][$i]['field']->type_data,':use_other')!==false);
				
				
				if($tpl_vars['opt_field_info'][$i]['field']->field_type == 'textarea') {
					//format the textarea to display newlines and things correctly.
					$tpl_vars['opt_field_info'][$i]['value'] = preg_replace('/<br[\s]*\/?>/i'," \n",$tpl_vars['opt_field_info'][$i]['value']);
				}
				
				if ($tpl_vars['opt_field_info'][$i]['field']->field_type == 'dropdown') {
					if (!($field_config['use_filters'] && $field_config['optional_'.$i.'_filter_association'])) {
						//type_data is in form ##:use_other - so inval of it will take off :use_other and just
						//leave the # which is the dropdown type number.
						$type = intval($tpl_vars['opt_field_info'][$i]['field']->type_data);
						$sql = "SELECT * FROM ".geoTables::sell_choices_table." WHERE `type_id` = ".$type." ORDER BY `display_order`,`value`";
						$tpl_vars['optional_types'][$i] = $cart->db->GetAll($sql);
					}
				}
			}
		}
		if (self::_editCheck($field_config['editable_category_specific'])) {
			//get and display category questions
			$cart->site->get_questions($cart->site->terminal_category, $cart->user_data['group_id']);
			$unordered_questions = $cart->site->questions;
			
			//get them to be in order...
			$questions = array();
			foreach ($unordered_questions as $question) {
				$key = $question['question_id'];
				$display_order = $question['display_order'];
				$name = $question['name'];
				$choices = array();
				$help_link = '';
				if (is_numeric($question['choices']) && $question['choices']) {
					$sql = "SELECT * FROM ".geoTables::sell_choices_table." WHERE `type_id` = ? ORDER BY display_order,value";
					$choices = $cart->db->GetAll($sql, array($question['choices']));
				}
				if ($question['choices'] == 'textarea' && $textareawrap) {
					$question_val = (isset($tpl_vars['session_variables']['question_value'][$key]))? $tpl_vars['session_variables']['question_value'][$key]: '';
					$cart->site->session_variables['question_value'][$key] = $tpl_vars['session_variables']['question_value'][$key] = preg_replace('/<br[\s]*\/?>/i'," \n",$question_val);
					//let tpl special char it
				}
				if ($question['explanation']) {
					$help_link = $cart->site->display_help_link(0,0,0,$key);
				}
				$questions[$display_order][] = array (
					'key' => $key,
					'name' => $name,
					'type' => $question['choices'],
					'choices' => $choices,
					'other_box' => $question['other_input'],
					'help' => $help_link
				);
			}
			ksort($questions);
			$tpl_vars['questions'] = $questions;
		}

		//mapping country
		if ($fields->mapping_country->is_enabled && self::_editCheck($fields->mapping_country->can_edit)) {
			$country_data = $cart->site->session_variables["mapping_country"];
			
			$region->addRegionName('b[mapping_country]','b[mapping_state]');
			$tpl_vars['mapping_country_dropdown'] = $region->getRegion($country_data,'b[mapping_country]');
		}
		
		//mapping state
		if ($fields->mapping_state->is_enabled && self::_editCheck($fields->mapping_state->can_edit)) {
			$state_data = $cart->site->session_variables["mapping_state"];
			
			$region->addRegionName('b[mapping_country]','b[mapping_state]');
			$tpl_vars['mapping_state_dropdown'] = $region->getSubRegion($state_data,'b[mapping_state]');
		}
		//allow insert right below description
		$tpl_vars['moreDetails'] = geoOrderItem::callDisplay('detailsDisplay_getMoreDetails', self::$_type, 'array', null, true);
		//insert at end, right before next step and cancel buttons.
		$tpl_vars['moreDetailsEnd'] = geoOrderItem::callDisplay('detailsDisplay_getMoreDetailsEnd', self::$_type, 'array', null, true);
		
		return $tpl_vars;
	}
	
	public static function mediaCheckVars ()
	{
		if (!isset($_POST['media_submit_form'])) {
			//form not submitted, cannot continue process.
			$cart = geoCart::getInstance();
			$cart->addError();
			return;
		}
		
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		geoOrderItem::callUpdate('mediaCheckVars', null, $children);
	}
	
	public static function mediaProcess ()
	{
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		geoOrderItem::callUpdate('mediaProcess', null, $children);
	}
	
	public static function mediaDisplay()
	{
		$cart = geoCart::getInstance();
		
		$cart->site->page_id = 10;
		$cart->site->get_text();
		
		$tpl_vars = $cart->getCommonTemplateVars();
		
		//set all the common vars that media thingies might need to know
		$tpl_vars['main_type'] = $cart->main_type;
		$tpl_vars['error_msgs'] = $cart->getErrorMsgs();
		
		//let all the different media order items do their thing for this step
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		$tpl_vars['mediaTemplates'] = geoOrderItem::callDisplay('mediaDisplay', 'tpl', 'array',$children);
		//die ('tpls: <pre>'.print_r($tpl_vars['mediaTemplates'],1));
		
		geoView::getInstance()->setBodyTpl('shared/media.tpl','','order_items')
			->setBodyVar($tpl_vars);
		$cart->site->display_page();
		return;
		
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		
		geoOrderItem::callUpdate('mediaDisplay',null,$children);
	}
	
	public static function mediaLabel()
	{
		$cart = geoCart::getInstance();
		return $cart->site->messages[500501];
	}
	
	/**
	 * easy way to find out if a field may be edited
	 * 
	 * @return bool true if good to show field, false if not
	 */
	protected static function _editCheck($fieldToCheck)
	{
		if (!self::$editing) {
			return true;
		} else if (self::$isAdmin) {
			return true;
		}
		return $fieldToCheck;
	}
	
	public static function geoCart_other_detailsCheckVars(){
		$cart = geoCart::getInstance();
		if ($cart->main_type != self::$_type){
			//not right type, so not concerned about this one.
			
			return ;
		}
		
		//but children might, get steps from children as well.
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		//echo 'running for type '.self::$_type.'<br />';
		geoOrderItem::callUpdate('geoCart_other_detailsCheckVars',null,$children);
		
		self::saveFormVariables();
	}
	
	public static function geoCart_other_detailsProcess(){
		$cart = geoCart::getInstance();
		if ($cart->main_type != self::$_type){
			//not right type, so not concerned about this one.
			
			return ;
		}
		
		//But children might, get steps from children as well.
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		geoOrderItem::callUpdate('geoCart_other_detailsProcess',null,$children);
		self::saveFormVariables();
	}
	
	/**
	 * Returns data to be displayed on listing cost and features section
	 *
	 * @return array of data that is processed and used to display the listing cost box
	 */
	public static function geoCart_other_detailsDisplay () {
		$cart = geoCart::getInstance();
		
		//See if this is a classified or not (as opposed to auction).
		if ($cart->main_type != self::$_type){
			//not classified, so not concerned about this one.
			
			return ;
		}
		$cart->setPricePlan($cart->item->getPricePlan(),$cart->item->getCategory());
		
		//figure out if we should show this one or not
		if (!$cart->site->debug_show_all_options && ($cart->site->db->get_site_setting('all_ads_are_free')
			|| !($cart->price_plan['type_of_billing'] == 1 || !(geoPC::is_ent() || geoPC::is_premier())))){
			//not not concerned about displaying anything for this one.
			return '';
		}
		
		//this is classified, figure out what to display.
		$tpl = new geoTemplate('system','order_items');
		$return = array (
			'checkbox_name' => 'classified', //no checkbox display
			'title' => 'Classified',
			'display_help_link' => '',//if 0, will display no help icon thingy
			'price_display' => '',
			//templates - over-write mini-template to do things like set margine or something:
			'entire_box' => '',
			'left' => '',
			'right' => '',
			'checkbox' => '',
			'checkbox_hidden' => ''
		);
		
		$return['title'] = ($cart->site->messages[197]);
		$return ['price_display'] = $cart->site->show_money(self::getListingCost(),$cart->site->db->get_site_setting('precurrency'),$cart->site->db->get_site_setting('postcurrency'),1);
		
		$tpl->assign('title',$return['title']);
		$return['left'] = $tpl->fetch('shared/other_details.left.tpl');
		$cart->item->setCost(self::getListingCost());
		return $return;
	}
	
	
	/**
	 * Optional.  Required if in getDisplayDetails() you returned true for the array index of canPreview
	 *
	 */
	public function geoCart_previewDisplay ($sell_type)
	{
		$cart = geoCart::getInstance();
		
		$cart->site->session_id = $cart->item->getId();
		
		if ($cart->item->renew_upgrade != self::upgrade && !$cart->item->get('live')){
			self::_insertListing($cart->item, $sell_type);
		}
		$cart->site->site_category = $cart->item->getCategory();
		//make sure stuff is done
		$items = $cart->order->getItem();
		foreach ($items as $item){
			if (is_object($item) && is_object($item->getParent())){
				$p = $item->getParent();
				if ($p->getId() == $this->getId()){
					//child of mine!
					if (method_exists($item, 'geoCart_previewDisplay')){
						$item->geoCart_previewDisplay();
					}
				}
			}
		}
		
		$cart->site->display_classified($cart->site->classified_id);
	}
	
	public static function geoCart_payment_choicesProcess ($sell_type)
	{
		$cart = geoCart::getInstance();
		
		$items = $cart->order->getItem(self::$_type);
		if (!is_array($items) || !count($items)){
			//no classifieds in order
			return;
		}
		
		foreach ($items as $item){
			if (is_object($item)){
				$cart->initItem($item->getId());
				if ($cart->item->renew_upgrade != self::upgrade && !$cart->item->get('live')){
					self::_insertListing($item, $sell_type);
				}
			}
		}
		//un-do initItem
		$cart->cart_variables['order_item'] = 0;
		$cart->item = null;
		$cart->main_type = $cart->cart_variables['main_type'] = 'cart';
	}
	
	
	public function processStatusChange($newStatus,$sendEmailNotices = true, $updateCategoryCount = false, $skipToParent = false){
		if ($skipToParent) {
			//really just want to skip on to the parent, don't doddle and do normal listing stuff
			return parent::processStatusChange($newStatus,$sendEmailNotices,$updateCategoryCount);
		}
		if ($newStatus == $this->getStatus()){
			return;
		}
		
		$db = DataAccess::getInstance();
		
		trigger_error('DEBUG CART: Top of processStatusChange');
		
		$before = $this->getStatus();
		
		$session_variables = $this->get('session_variables');
				
		$current_time = geoUtil::time();
		//figure out when ad ends
		if($session_variables['end_mode'] == 1) {
			//end time set explicitly
			$ends = $session_variables['ends'];
		} else {
			//end time set by duration
			$duration = intval($session_variables['classified_length']);
			if (!$duration && isset($session_variables['duration'])) {
				$duration = intval($session_variables['duration']);
			}
			$length_of_ad = intval($duration * 86400);
			
			if($session_variables['start_time'] > $current_time) {
				//this is an auction with "start time" set in the future
				//add duration to the actual auction start instead of whenever this happens to go live
				$ends = $session_variables['start_time'] + $length_of_ad;
			} else {
				//just add duration to now, as normal
				$ends = $current_time + $length_of_ad;
			}	
			$session_variables['ends'] = $ends;
		}
		
		
		trigger_error('DEBUG TRANSACTION: classified - length of ad: '.$length_of_ad." current time: ".$current_time);
		$live = ($newStatus == 'active')? 1: 0;
		//use geoListing to set these values, so that the filter check has the correct info later
		$listing = geoListing::getListing($this->get('listing_id'));
		$listing->live = $live;
		$listing->date = $current_time;
		$listing->ends = $ends;
				
		//save the info we just set in session vars
		$session_variables['ends'] = $ends;
		$session_variables['date'] = $current_time;
		//NOTE: we don't save live setting in session vars when placing the listing.
		$this->set('session_variables', $session_variables);
		
		trigger_error('DEBUG CART TRANSACTION: classified:processStatusChange');
		if ($updateCategoryCount) {
			geoCategory::updateListingCount($this->getCategory());
		}
		
		trigger_error('DEBUG CART TRANSACTION: classified:processStatusChange() - after update cat count');
		
		if ($sendEmailNotices && $newStatus == 'active') {
			//Send an e-mail to the user and the admin
			self::_sellSuccessEmail($this->get('listing_id'));
			//also check to see if anybodies filters apply
			include_once(CLASSES_DIR . 'site_class.php');
			include_once(CLASSES_DIR."user_management_ad_filters.php");
			
			$user_management = new User_management_ad_filters(0,$db->getLanguage(),$this->getOrder()->getSeller());
			$user_management->check_ad_filters($this->get('listing_id'));
			trigger_error('DEBUG TRANSACTION: classified:processStatusChange() - after send e-mail');
		}
		parent::processStatusChange($newStatus,$sendEmailNotices,$updateCategoryCount);
		trigger_error('DEBUG CART: Finished processing order item '.$this->getId());
		return;
	}
	
	protected static function getListingCost(){
		$cart = geoCart::getInstance();
		if ($cart->db->get_site_setting('all_ads_are_free')) {
			return 0;
		}
		//make sure price plan is good...
		if (!$cart->price_plan) {
			trigger_error('ERROR: Price plan must be set first');
			return false;
		}
		$cost = 0;
		
		if ($cart->price_plan['type_of_billing'] == 1 || !(geoPC::is_ent() || geoPC::is_premier())) {
			// Fee-based
			
			switch ($cart->price_plan['charge_per_ad_type'])
			{
				case 1: //get the charge based on the price field
					//get all increments where the low value is lower or = to the price, but only take the highest low value
					$sql = "SELECT `charge` FROM ".geoTables::price_plans_increments_table." WHERE
						`price_plan_id` = ? AND `category_id` = ?
						AND `low` <= ?
						 ORDER BY `low` DESC LIMIT 1";
					$query_data = array(
						$cart->site->users_price_plan,
						((isset($cart->price_plan['category_id']) && $cart->price_plan['category_id'])? $cart->price_plan['category_id']: 0),
						$cart->site->session_variables["price"].''								
					);
					
					$increment_result = $cart->db->Execute($sql, $query_data);
					if (!$increment_result || $increment_result->RecordCount() != 1) {
						$cost = $cart->price_plan['charge_per_ad'];
					} else {
						$show_increment = $increment_result->FetchRow();
						$cost = $show_increment['charge'];
					}
					break;

				case 2: //get the charge based on price range charge
					$sql = "SELECT `length_charge` FROM ".geoTables::price_plan_lengths_table."
						WHERE `length_of_ad` = ?
						and `price_plan_id` = ? and `category_id` = ? LIMIT 1";
					$query_data = array(
						$cart->site->session_variables["classified_length"],
						$cart->site->users_price_plan,
						((isset($cart->price_plan['category_id']) && $cart->price_plan['category_id'])? $cart->price_plan['category_id']: 0)
					);

					$length_result = $cart->db->Execute($sql, $query_data);
					if  (!$length_result || $length_result->RecordCount() != 1) {
						$cost = $cart->price_plan['charge_per_ad'];
					} else {
						$show_length_cost = $length_result->FetchRow();
						$cost = $show_length_cost['length_charge'];
					}
					break;

				default:
					$cost = $cart->price_plan['charge_per_ad'];
					break;
			} //end of switch
		}
		
		return $cost;
	}
	
	public static function getFormVariables(){
		$cart = geoCart::getInstance();
		
		$cart->site->session_variables = $cart->item->get('session_variables');
	}
	
	public static function saveFormVariables(){
		$cart = geoCart::getInstance();
		
		$cart->item->set('session_variables', $cart->site->session_variables);
	}
	
	
	public static function set_sell_variables($sell_type)
	{
		//TODO: make it so that everywhere that still uses these old vars no longer uses them, so that this function is no longer needed.
		$cart = geoCart::getInstance();
		
		$session_variables = $cart->site->session_variables = $cart->item->get('session_variables');
		$cart->site->terminal_category = $cart->item->getCategory();
		$cart->site->users_group = $cart->user_data['group_id'];
		$cart->site->users_price_plan = $cart->item->getPricePlan();
		if (!$cart->site->users_price_plan){
			$cart->site->users_price_plan = (isset($cart->site->session_variables['price_plan_id']))? $cart->site->session_variables['price_plan_id']: $cart->user_data['price_plan_id'];
		}
		
		$cart->site->user_currently_subscribed = (isset($session_variables['user_currently_subscribed']))? $session_variables['user_currently_subscribed']: 0;//$show->USER_CURRENTLY_SUBSCRIBED;
		$cart->site->classified_id = (isset($session_variables['classified_id']))? $session_variables['classified_id']: 0;//$show->CLASSIFIED_ID;
		$cart->site->filter_id = (isset($session_variables['filter_id']))? $session_variables['filter_id']: 0;//$show->FILTER_ID;
		$cart->site->sell_type = $cart->site->session_variables['sell_type'] = $sell_type; //$show->TYPE;
		$cart->site->final_fee = (isset($session_variables['final_fee']))? $session_variables['final_fee']: 0;//$show->FINAL_FEE;
		$cart->site->auction_price_plan_id = (isset($session_variables['auction_price_plan_id']))? $session_variables['auction_price_plan_id']: 0;//$show->AUCTION_PRICE_PLAN_ID;
		$cart->site->session_variables = $session_variables;
		//following moved to each different item type		
/*
		$cart->site->session_variables["buy_now_only"]= 0;//classifieds
		//$cart->site->session_variables["buy_now_only"] = (isset($cart->site->session_variables["buy_now_only"]))? $cart->site->session_variables["buy_now_only"]: 0;
		if ($cart->site->session_variables["buy_now_only"]=='on' || $cart->site->session_variables["buy_now_only"]==1){
			$cart->site->session_variables["buy_now_only"] = 1;
		} else {
			$cart->site->session_variables["buy_now_only"] = 0;
		}
		if ($cart->site->session_variables["buy_now_only"])
		{
			$cart->site->session_variables["auction_minimum"] = null;
			$cart->site->session_variables["auction_reserve"] = null;
		}*/
		
		//set all of vars
		
		$cart->site->session_variables['order_item_id'] = $cart->item->getId();
		$cart->item->set('session_variables',$cart->site->session_variables);
	}
	
	protected static function _saveSessionVarsDiff ($item, $new_session_variables)
	{
		if (!is_object($item)) {
			trigger_error('ERROR CART: saveSessionVarsDiff relies on item to be passed, or to be in cart->item, but can\'t get it so returning false.');
			return false;
		}
		//just TEMPORARILY, set status to pending so we can get session vars without this
		$current_status = $item->getStatus();
		if ($current_status == 'active') {
			$item->setStatus('temp_disable');
		}
		//DO get archived one if needed, so that admin can still view info long after listing is archived
		$old_session_variables = self::_getSessionVarsFromListing($item->get('listing_id'), true, true);
		//set status back
		$item->setStatus($current_status);
		
		$diff = array();
		foreach($new_session_variables as $key => $value) {
			if(!isset($old_session_variables[$key]) || $old_session_variables[$key] != $value) {
				$diff[$key] = $value;
			}
		}
		
		if(!$new_session_variables['payment_options'] && $old_session_variables['payment_options']) {
			//special case: explicity set payment options to blank if they've all been removed.
			$diff['payment_options'] = '';
		}
		
		$item->set('session_variables', $diff);
		return $diff;
	}
	
	protected static function _checkMaximumListingLimit($add_to_listing_count = 0)
	{
		$cart = geoCart::getInstance();
		trigger_error('DEBUG CART: Top of checkMaximumListingLImit()');
		
		if(self::isAnonymous()) {
			//anonymous listing not bound to a user, so can't hit a user's limit
			//no need to do the rest of this
			return true;
		}
		
		$cart->site->page_id=8;
		$cart->site->get_text();
		
		//check to see if this user has reached their maximum ad count
		$sql = "SELECT count(*) AS `total_listings` FROM ".geoTables::classifieds_table." WHERE `seller` = ? AND `live` = 1";
		$show_total_ads = $cart->db->GetRow($sql, array($cart->user_data['id']));
		if (!$show_total_ads)
		{
			$cart->site->setup_error = $cart->site->messages[86];
			return false;
		}
		$total_listings = ($show_total_ads['total_listings']);
		//count up any that are in the current cart as well:
		$classifieds = $cart->order->getItem('classified');
		$auctions = $cart->order->getItem('auction');
		$total_listings += (is_array($classifieds))? count($classifieds): 0;
		$total_listings += (is_array($auctions))? count($auctions): 0;
		$renew_upgrades = $cart->order->getItem('listing_renew_upgrade');
		if (is_array($renew_upgrades) && count($renew_upgrades) > 0){
			foreach ($renew_upgrades as $item){
				if (is_object($item)){
					if (!$item->get('live')){
						//renewal or upgrade not currently live, so it is going to be adding 1 to count
						$total_listings++;
					}
				}
			}
		}
		$total_listings += $add_to_listing_count;
		
		//If any more listing item types are added, need to do that too.
		
		if ($total_listings <= $cart->price_plan['max_ads_allowed']){
			//note that the total listings count includes this current listing!
			return true;
		}
		trigger_error('ERROR CART: Max ads reached, not allowed to add any more listings!');
		
		$cart->site->messages = $cart->db->get_text(true,10202);
		$cart->addErrorMsg('cart_display',$cart->site->messages[500615].$cart->price_plan['max_ads_allowed']);
		
		//kinda dirty, but it works:  set the action to delete and remove the listing, then display the main cart view
		$cart->deleteProcess();
		$cart->current_step = $cart->cart_variables['step'] = 'cart';
		$cart->cartDisplay();
		require GEO_BASE_DIR . 'app_bottom.php';
		exit;
	}
	
	protected static function _insertListing ($order_item, $sell_type)
	{
		//TODO: Make this use session vars more carefully
		$cart = geoCart::getInstance();
		$cart->init(true);
		
		$db = 0;//just for passing to old functions
		
		$cart->site->get_ad_configuration();
		$current_time = $listing_starts = geoUtil::time();
		
		$cart->site->session_variables = $order_item->get('session_variables');
		trigger_error('DEBUG CART: Session Vars: <pre>'.print_r($cart->site->session_variables,1).'</pre>');
		$cart->site->session_variables['sell_type'] = $sell_type;
		$cart->site->classified_id = $order_item->get('listing_id');
		$cart->site->terminal_category = $order_item->getCategory();
		//set this to minutes by using the first line
		//$listing_ends =  $cart->site->DateAdd("d",$listing_starts,$cart->site->classified_variables["classified_length"]);
		
		
		if ($sell_type == 1) {
			//this is a classified ad
			//set the expiration of the ad to number of days from now
			//will use the duration to set the life of the ad once the ad is approved by admin or credit card purchase
			$listing_ends =  $cart->site->DateAdd("d",$listing_starts,$cart->db->get_site_setting('expire_unfinished_period'));
		} else if ($sell_type == 2 || $sell_type == 4) {
			//Finding auction_ends based on start_time, end_time and classified_length
			if($cart->site->session_variables["end_time"] == 0) {
				if($cart->site->session_variables["start_time"] == 0) {
					$listing_ends = $cart->site->DateAdd("d",$current_time,$cart->site->session_variables["classified_length"]);
				} else {
					$listing_ends = $cart->site->DateAdd("d",$cart->site->session_variables["start_time"],$cart->site->session_variables["classified_length"]);
				}
			} elseif(is_array($cart->site->session_variables['end_time'])) {
				//end_time still saved as an array from dropdowns
				//need to convert to ticktime
				$ends = $cart->site->session_variables["end_time"];				
				$listing_ends = $cart->site->get_time($ends['end_hour'], $ends['end_minute'], $ends['end_month'],$ends['end_day'],$ends['end_year']);
			} else {
				$listing_ends = $cart->site->session_variables['end_time'];
			}

			$listing_starts = $current_time;
			//final fee
			if ($cart->price_plan['charge_percentage_at_auction_end']) {
				$cart->site->session_variables['final_fee'] = 1;
			} else {
				$cart->site->session_variables['final_fee'] = 0;
			}
		} else {
			trigger_error('ERROR CART: sell_type not 1 or 2, its '.$sell_type);
			throw new Exception('Error:  sell_type value ('.$sell_type.') is not valid, it needs to be 1 or 2.');
		}
		
		
		if ($cart->site->session_variables["currency_type"]) {
			trigger_error('DEBUG CART: Setting currency type..');
			$sql = "SELECT `precurrency`, `postcurrency`, `conversion_rate` FROM ".geoTables::currency_types_table." WHERE `type_id` = ? LIMIT 1";
			$show_currency = $cart->db->GetRow($sql, array($cart->site->session_variables["currency_type"]));
			
			if ($show_currency === false) {
				trigger_error('ERROR CART SQL: sql ERROR! sql: '.$sql.' Error: '.$cart->db->ErrorMsg());
				return false;
			}
			if (is_array($show_currency) && count($show_currency)) {
				$cart->site->session_variables['precurrency'] = $show_currency['precurrency'];
				$cart->site->session_variables['postcurrency'] = $show_currency['postcurrency'];
				$cart->site->session_variables['conversion_rate'] = $show_currency['conversion_rate'];
			}
		}

		if (strlen(trim($cart->site->session_variables["email_option"])) == 0) {
			//get the sellers default email address
			$cart->site->session_variables["email_option"] = $cart->user_data['email'];
		}

		$cart->order->setCreated($listing_starts);

		
		$cart->site->session_variables['seller'] = $cart->order->getBuyer();
		if(!$cart->site->session_variables['seller']) {
			//no seller id = anonymous -- get anon user id
			$anonReg = geoAddon::getRegistry('anonymous_listing');
			if($anonReg) {
				$anon_id = $anonReg->get('anon_user_id',0);
				$cart->site->session_variables['seller'] = $anonReg->get('anon_user_id',0);
				
				//set order to have anonymous id
				//TODO: there's probably a better place to put this...
				$cart->order->setBuyer($anon_id);
				$cart->order->save();
			}
		}
		
		
		$cart->site->session_variables['order_item_id'] = $order_item->getId();
		$cart->site->session_variables['date'] = $current_time;
		$cart->site->session_variables['ends'] = $cart->site->session_variables['end_time'] = $listing_ends;
		$cart->site->session_variables['category'] = $order_item->getCategory();
		$cart->site->session_variables['price_plan_id'] = $order_item->getPricePlan();
		
		$listing_id = (isset($cart->site->classified_id))? $cart->site->classified_id: 0;
		$new_id = self::_insertListingFromSessionVars($cart->site->session_variables,$listing_id);
		if (!$new_id) {
			//error inserting data into db:
			trigger_error('ERROR CART TRANSACTIONS: Error inserting listing into db.');
			return false;
		}
		
		if (!$listing_id) {
			//This is a new listing (not an update of a previously-tried one),
			//so set up id and session vars
			
			$order_item->set('listing_id',$new_id);
			$cart->site->classified_id = $cart->site->session_variables['classified_id'] = $cart->site->session_variables['listing_id'] = $new_id;
			//make sure the new listing ID is saved, to prevent instances where a new listing is created
			//but an error prevents it from getting to the step where it remembers the listing id
			$order_item->set('session_variables',$cart->site->session_variables);
			$order_item->save();
		}
		
		if (geoPC::is_ent()) {
			//TODO: Will need to make this work with the new system
			//Seller buyer transactions, allow them to be dynamically called.
			$vars = array(
			'listing_id' => $cart->site->classified_id
			);
			geoSellerBuyer::callUpdate('insertNewListing',$vars);
		}
		
		//Listing inserted!
		return true;
	}
	
	protected static function _insertListingFromSessionVars($session_variables, $listing_id = 0){
		$db = DataAccess::getInstance();
		//Parts of insert query
		$name_parts = array();
		$val_parts = array();
		//parts of update query
		$parts = array();
		
		
		//query data the same for insert or update
		$query_data = array();
		//Use the same loop to generate the different query parts, since code duplication is a no-no.
		foreach ($session_variables as $i => $val){
			$keys = (isset(self::$session_to_listing_key_map[$i]))? self::$session_to_listing_key_map[$i]: $i;
			$keys = (is_array($keys))? $keys : array($keys);
			//loop through each translation and set it, this allows one session var to be assigned to multiple
			//listing rows.
			foreach ($keys as $key) {
				if (isset(self::$listing_vars_to_update[$key])){
					$name_parts [] = "`$key`";
					$val_parts[] = "?";
					
					$parts [] = "`$key` = ?";
					//encode value according to what type it is
					switch(self::$listing_vars_to_update[$key]){
						case 'toDB':
							if (is_array($val) && $key == 'seller_buyer_data' && geoPC::is_ent()) {
								//special case
								$val = serialize($val);
							}
							$query_data [] = trim(geoString::toDB($val));
							break;
						case 'int':
							$query_data [] = intval($val);
							break;
						case 'float':
							$query_data [] = floatval($val);
							break;
						case 'bool':
							$query_data [] = (($val)? 1: 0);
							break;
						default:
							//not altered, for fields like "date"
							$query_data [] = $val;
							break;
					}
				}
			}
		}
		
		if ($listing_id)
		{
			//THIS IS AN UPDATE OF PREVIOUSLY ENTERED DATA
			
			//Use the $parts generated for the parts of the query.
			$sql = "UPDATE ".geoTables::classifieds_table." SET ".implode(", ",$parts)." WHERE `id` = ? LIMIT 1";
			$query_data[] = $listing_id;
			$result = $db->Execute($sql, $query_data);
			
			if (!$result)
			{
				trigger_error("ERROR SQL CART TRANSACTIONS: SQL: $sql \n Error Msg: {$db->ErrorMsg()}");
				return false;
			}
			$isNew = false;
			$newID = $listing_id;
		} else {
			//THIS IS NOT AN UPDATE OF A PREVIOUSLY TRIED CLASSIFIED AD
			
			//Since this is first time inserted, set the order item ID
			if (isset($session_variables['order_item_id']) && $session_variables['order_item_id']) {
				//only set order item ID first time it is inserted into DB, after that
				//if the order item ID has to change, it must be done so by manually
				//changing it directly on the listing itself.
				$name_parts[] = "`order_item_id`";
				$val_parts[] = "?";
				$query_data[] = (int)$session_variables['order_item_id'];
			}
			
			//Use the $name_parts and $val_parts for this query, generated above the if/else
			$sql = "INSERT INTO ".geoTables::classifieds_table." ( ".implode(", ",$name_parts)." ) VALUES ( ".implode(", ",$val_parts)." )";
			$result = $db->Execute($sql, $query_data);
			
			if (!$result)
			{
				trigger_error('ERROR CART SQL: sql ERROR! sql: '.$sql.' Error: '.$db->ErrorMsg());
				return false;
			}
			$isNew = true;
			$newID = $db->Insert_ID();
		}
		$qSearch = $tSearch = null;
		if (isset($session_variables['question_value'])) {
			//make sure category questions are removed before re-inserting them
			$sql = "DELETE FROM ".geoTables::classified_extra_table." WHERE
				`classified_id` = $newID";
			$db->Execute($sql);
			
			//insert questions and tags and update the search text according to them
			$qSearch = self::insertCatQuestions($newID, $session_variables);
			if ($qSearch === false) {
				trigger_error('ERROR CART TRANSACTIONS: Error when inserting category questions, so error when iserting listing.');
				return false;
			}
		}
		if (isset($session_variables['tags'])) {
			$tSearch = self::updateTags($newID, $session_variables['tags']);
			if ($tSearch === false) {
				trigger_error('ERROR CART TRANSACTIONS: Error when inserting category questions, so error when iserting listing.');
				return false;
			}
		}
		if ($isNew || ($qSearch !== null && $tSearch !== null)) {
			//question AND tag vars are specified, so update search text
			$search_text = $qSearch.$tSearch;
			//make sure search values are updated
			$sql = "UPDATE ".geoTables::classifieds_table." SET
				`search_text` = ?
				WHERE `id` = ?";
			//echo $sql." is the query<br />\n";
			$result = $db->Execute($sql, array(geoString::toDB($search_text.''),$newID));
			if (!$result) {
				trigger_error('ERROR SQL: sql - '.$sql.' error: '.$db->ErrorMsg());
				return false;
			}
		}
		
		if (isset($session_variables['anonymous_password']) && geoAddon::getUtil('anonymous_listing')) {
			//insert anonymous password into table
			$sql = "INSERT INTO `geodesic_addon_anonymous_listing` (`listing_id`, `password`, `ip_address`) VALUES (?, ?, ?)";
			$result = $db->Execute($sql, array($newID, $session_variables['anonymous_password'], getenv('REMOTE_ADDR')));
			if(!$result) {
				trigger_error('ERROR CART SQL: sql ERROR! sql: '.$sql.' Error: '.$db->ErrorMsg());
				return false;
			}
		}
		
		//let order items have at it
		geoOrderItem::callUpdate('listing_insertListingFromSessionVars', array ('session_variables' => $session_variables, 'listing_id' => $newID), null, true);
		
		return $newID;
	}
	
	public static function geoCart_deleteProcess(){
		//Remove from the session_variables
		$cart = geoCart::getInstance();
		
		//go through each child, and call deleteProcess
		$original_id = $cart->item->getId();
		$items = $cart->order->getItem();
		foreach ($items as $k => $item){
			if (is_object($item) && $item->getId() != $cart->item->getId() && is_object($item->getParent()) && $item->getParent()->getId() == $cart->item->getId()){
				//this is a child of this item...
				//Set the cart's main item to be this item, so that the deleteProcess gets
				//what it is expecting...
				$cart->initItem($item->getId(),false);
				geoOrderItem::callUpdate('geoCart_deleteProcess',null,$item->getType());
			}
		}
		if ($cart->item->getId() != $original_id){
			//change the item back to what it was originally.
			$cart->initItem($original_id);
		}
		
		//Nothing to do specifically for main listing item, everything that is done is done in children.
	}
	
	public function processRemove ()
	{
		if ($this->get('listing_id')) {
			//delete the listing
			$db = DataAccess::getInstance();
			$db->Execute('DELETE FROM '.geoTables::classifieds_table.' WHERE `id` = ? LIMIT 1', array($this->get('listing_id')));
			
			$this->removeTags($this->get('listing_id'));
			
			geoCategory::updateListingCount($this->getCategory());
		}
		return true;
	}
	
	public function processRemoveData ()
	{
		if (!$this->getId()) return true; //just to be sure the ID is known
		
		//set any listings that use this order ID as main order id to 0
		$db = DataAccess::getInstance();
		$db->Execute("UPDATE `geodesic_classifieds` SET `order_item_id`=0 WHERE `order_item_id`=?", array($this->getId()));
		return true;
	}
	
	protected static function _copyListing($listing_id, $item_type, $allow_archive = true, $item = null)
	{
		trigger_error('DEBUG CART: Copy Listing Here');
		if ($item === null) {
			$cart = geoCart::getInstance();
			$item = $cart->item;
		}
		if (!is_object($item)) {
			return false;
		}
		$listing_id = intval($listing_id);
		if (!$listing_id){
			return false;
		}
		//get the listing data
		$session_variables = self::_getSessionVarsFromListing($listing_id, $allow_archive);
		if (!$session_variables){
			//echo __line__.' error<br />';
			return false;
		}
		//echo 'session:<pre>'.print_r($session_variables,1).'</pre>';
		$session_variables['listing_copy_id'] = $listing_id;
		//force it to create new listing
		$session_variables['listing_id'] = $session_variables['live'] = false;
		if (isset($cart)) {
			$cart->site->listing_id = $cart->site->classified_id = false;
		}
		
		//reset current/final bids to 0 for the new listing
		$session_variables['current_bid'] = $session_variables['final_price'] = 0;
		
		$item->set('listing_id',false);
		$item->set('live',false);
		
		//let itself know it's a copy, besides in the session vars
		$item->set('listing_copy_id',$listing_id);
		
		//set the category, but make sure it exists first!
		$category = $session_variables['category'];
		if(!geoCategory::getBasicInfo($category)) {
			//if session variable category is not found, then the listing table was changed directly somehow, but it holds the "correct" value
			//this seems to happen in rare cases where the admin edits categories, but the sessvars for expired listings are not affected
			$oldListing = geoListing::getListing($listing_id);
			$category = $oldListing->category;
		}
		$item->setCategory($category);
		
		$price_plan = (isset($session_variables['price_plan']))? $session_variables['price_plan'] : $session_variables['price_plan_id'];
		$item->setPricePlan($price_plan, $session_variables['seller']);
		
		$item->set('session_variables',$session_variables);
		$item->save();
		if (isset($cart)) {
			$cart->site->session_variables = $session_variables;
		}
		
		//allow other items such as images to also copy
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		geoOrderItem::callUpdate('copyListing', $item, $children);
		
		//now insert the listing...
		self::_insertListing($item, $item_type);
		return true;
	}
	
	/**
	 * Public access method that gets session vars array, as result of the session
	 * vars combined from all order items used for that session var.
	 * 
	 * @param int $listingId
	 * @return array
	 * @since Version 5.1.0
	 */
	public static function getCombinedSessionVars ($listingId)
	{
		return self::_getSessionVarsFromListing($listingId, false, true);
	}
	
	private static $_sessionVarsFromListing = array();
	protected static function _getSessionVarsFromListing($listing_id, $allow_archive = true, $force_refresh = false)
	{
		$allow_archive = intval($allow_archive);
		$listing_id = intval($listing_id);
		if (!$listing_id) {
			//throw new Exception ('listing ID not set!');
			trigger_error('ERROR CART: Listing ID not specified, cant get session vars for listing.');
			return false;
		}
		if (!$force_refresh && isset(self::$_sessionVarsFromListing[$listing_id][$allow_archive])) {
			//so it can be called multiple times, and only do it once
			return self::$_sessionVarsFromListing[$listing_id][$allow_archive];
		}
		$db = DataAccess::getInstance();
		
		$listing = geoListing::getListing($listing_id, true, $allow_archive);
		//get the listing data
		
		if (!$listing) {
			trigger_error('ERROR CART: Error getting listing details!');
			return false;
		}
		
		$item_id = $listing->order_item_id;
		//make sure the item id exists
		$itemTest = ($item_id)? geoOrderItem::getOrderItem($item_id): false;
		if (!$itemTest || $item_id == 0 || ($itemTest && $itemTest->getType() == 'listing_renew_upgrade')) {
			//Legacy listing, create a new order item based on legacy settings
			$item_id = self::_createItemForLegacyListing($listing_id, $allow_archive);
		}
		if (!$item_id) {
			trigger_error("ERROR CART: original order item id not known, returning false.");
			return false;
		}
		$session_variables = array();
		
		$all_items = $listing->getAllOrderItems();
		$first = true;
		foreach ($all_items as $row) {
			if (!$first && $row == $item_id) {
				//first item managed to get itself in there twice, probably an artifact of order item
				//in the system prior to these changes to how it works.
				//just skip it.
				continue;
			}
			$item = geoOrderItem::getOrderItem($row);
			
			if (is_object($item) && ($first || $item->getStatus() == 'active')) {
				//item is currently active (need to check status from object, not from DB, in case any items have changed
				//status but not serialized yet)
				
				//add the session vars
				$vars = $item->get('session_variables');
				if (is_array($vars)) {
					$session_variables = array_merge($session_variables, $vars);
				}
			}
			$first = false;
		}
		self::$_sessionVarsFromListing[$listing_id][$allow_archive] = $session_variables;
		return $session_variables;
	}
	
	protected static function _sellSuccessEmail($listing_id=0)
	{
		trigger_error('DEBUG EMAIL: in sellSuccessEmail()');
		
		//TODO: Only send 1 e-mail for a group of listings, don't need to be sending 10 e-mails if user buys 10 listings at once!
		$listing_id = intval($listing_id);
		if (!$listing_id) {
			return false;
		}
		$db = DataAccess::getInstance();
		$listing = geoListing::getListing($listing_id,false);
		if (!is_object($listing)) {
			trigger_error('ERROR CART: Listing not an object, can not send e-mail.');
			return false;
		}
		if ($db->get_site_setting('send_successful_placement_email')) {
			$msgs = $db->get_text(true,51);
			//TODO: Use a "user class" or something so we don't end up getting the user's info multiple times in one page load
			
			$anonReg = geoAddon::getRegistry('anonymous_listing');
			if($anonReg) {
				$anon_user_id = $anonReg->get('anon_user_id',false);
			} else {
				$anon_user_id = false;
			}
			
			if ($listing->seller != 0 && $listing->seller != $anon_user_id) {
				//Nonymous listing
				$user = geoUser::getUser($listing->seller);
				if ($user) {
					$subject = $msgs[712];
					$message = trim($msgs[713])." ".$user->getSalutation();
					$message .= $msgs[714]."\n\n";
					$message .= $db->get_site_setting('classifieds_url')."?a=2&b=".$listing_id;
					$db->sendMail($user->email,$subject,$message);
				}
			} else {
				//Anonymous listing
				if(strlen($listing->email)) {
					$anonText = geoAddon::getText('geo_addons','anonymous_listing');
					$subject = $msgs[712];
					$message = trim($msgs[713])."\n\n";
					$message .= $msgs[714]."\n\n";
					$message .= $db->get_site_setting('classifieds_url')."?a=2&b=".$listing_id."\n";
					
					$item = geoOrderItem::getOrderItem($listing->order_item_id);
					$anonPass = $item->get('anonPass');
					
					$message .= $anonText['emailText'].' '.$anonPass;
					trigger_error('DEBUG EMAIL: about to send mail with text: '.$message);
					$db->sendMail(geoString::fromDB($listing->email),$subject,$message);
					trigger_error('DEBUG EMAIL: sent mail');
					
				}
			}
		}
		if ($db->get_site_setting('send_admin_placement_email')) {
			$subject = "A Listing has been placed!!";
			$message = "Hello Admin,\n";
			$message .= "A listing has been placed on your site. See the link below for the listing details.\n\n";
			//TODO: Add to message info about viewing payment details in the admin, once that is created...
			
			//link used in E-MAIL:  DO NOT NEED TO CONVERT TO W3C!
			$message .= $db->get_site_setting('classifieds_url')."?a=2&b=".$listing_id;
			$db->sendMail($db->get_site_setting('site_email'),$subject,$message);
		}
		return true;
	}
	/**
	 * 
	 * This is deprecated,  Use geoUser::getSalutation() instead.
	 * 
	 * @param array $person
	 * @deprecated
	 */
	protected static function _getSalutation($person){
		if (is_object($person) && $person->ID) {
			return geoUser::getUser($person->ID)->getSalutation();
		} elseif (is_array($person) && $person['id']) {
			//use array notation.
			return geoUser::getUser($person['id'])->getSalutation();
		}
		//it is not an array, and not an object, who knows what it is.
		return '';
	}
	
	public static function adminItemDisplay ($item_id)
	{
		if (!$item_id){
			return '';
		}
		$item = geoOrderItem::getOrderItem($item_id);
		if (!is_object($item) || $item->getType() != self::$_type) {
			return '';
		}
		
		$info = '';
		$db = DataAccess::getInstance();
		$session_variables = $item->get('session_variables');
		$listing_id = $item->get('listing_id');
		if (self::$_type == 'listing_renew_upgrade' && $listing_id) {
			$session_variables = array_merge(self::_getSessionVarsFromListing($listing_id), $session_variables);
		}
		
		$listing = geoListing::getListing($listing_id);
		$listingLocked = false;
		if (is_object($listing) && $listing->isLocked()) {
			$listingLocked = true;
			$info .= geoHTML::addOption('Modification in Progress', 'Further modifications locked.'.geoHTML::showTooltip('Modification in Progress', 'Modifications to this listing are currently locked pending completion of an edit, renewal, or upgrade in progress. Use this if you need to manually unlock the listing.').'<br />'.geoHTML::addButton('Force Unlock', '?page=orders_list_items_item_unlock&item_id='.$item_id)); 
		}
		$listingIdTitle = $listing_id;
		
		if ($listing && !$listing->isExpired()) {
			$viewLink = 'index.php?page=users_view_ad&b='.$listing_id;
			$listingIdTitle .= " <a href='$viewLink' class='mini_button'>View/Edit Listing Details</a> ";
		} else if ($listing_id) {
			$listingIdTitle .= " (Listing seems to be expired or removed)";
		}
		
		
		$info .= geoHTML::addOption('Listing ID',$listingIdTitle);
		$info .= geoHTML::addOption('Title',geoString::specialChars($session_variables['classified_title']));
		$info .= geoHTML::addOption('Description','<textarea disabled="disabled" style="border: 2px solid #88AACC; overflow: auto; height: 200px; width: 450px; padding: 10px;">'.geoString::specialChars($session_variables['description']).'</textarea>');
		//Call children and let them display info about themselves as well
		$children = geoOrderItem::getChildrenTypes(self::$_type);
		$info .= geoOrderItem::callDisplay('adminItemDisplay',$item_id,'',$children);
		
		$overview = 'This is a brief overview only of the basic listing info applied by this order item.  ';
		if ($listing && !$listing->isExpired()) {
			$overview .= 'There may have been edits applied that are not reflected here, you can see the latest full details on <a href="'.$viewLink.'">this page</a>.';
		} else {
			$overview .= 'The listing affected by this order item no longer exists, it may have expired or been removed, or the order item or order might have been canceled.';
		}
		
		$info .= geoHTML::addOption('View full details/Edit Details',$overview);
		
		$extrasURL = '?mc=users&page=users_restart_ad&b='.$listing_id;
		$info .= geoHTML::addOption('Listing Extras', geoHTML::addButton('Add/Remove Listing Extras', $extrasURL));
		//$info .= '<pre>'.print_r($session_variables,1).'</pre>';
		return $info;
	}
	
	/**
	 * Function that creates an initial order item for a specified listing, for the purpose of setting up session vars for that listing.
	 * 
	 * This only sets up the bare bones item, it doesn't attach stuff like bolding and stuff.  This is only to establish the base session vars.
	 * 
	 * @param int $listing_id
	 */
	public static function _createItemForLegacyListing ($listing_id, $allow_archive = true)
	{
		//clean vars
		$listing_id = intval($listing_id);
		if (!$listing_id) {
			trigger_error('ERROR CART: Invalid listing ID, returning false.');
			return false;
		}
		//This is an old listing placed before the cart system, or was not able to get session vars for some reason
		//aka a legacy listing.
		//Generate the session variables based on the listing info
		
		$listing = geoListing::getListing($listing_id, true, $allow_archive);
		
		if (!is_object($listing)) {
			trigger_error('ERROR CART: Copy id for listing '.$listing_id.' could not be found in main table, object for listing doesn\'t work.');
			return false;
		}
		if ($listing->order_item_id) {
			//see if initial order item is good
			$orderItem = geoOrderItem::getOrderItem($listing->order_item_id);
			if ($orderItem && $orderItem->getId() && $orderItem->getType() !== 'listing_renew_upgrade') {
				//initial item already exists!  (Don't count if item is listing_renew_upgrade to
				//account for bug in previous versions where order item ID got set incorrectly
				return $orderItem->getId();
			}
		}
		$data = $listing->toArray();
		//echo 'raw data: <pre>'.print_r($data,1).'</pre><br />';
		
		//first reverse-engineer the translation
		$translations = array();
		foreach (self::$session_to_listing_key_map as $to => $val) {
			$val = (is_array($val))? $val: array ($val);
			foreach ($val as $from) {
				$translations[$from] = $to;
			}
		}
		$session_variables = array();
		foreach ($data as $key => $val) {
			if (is_numeric($key) || !isset(self::$listing_vars_to_update[$key])) {
				//ignore
				continue;
			}
			
			switch (self::$listing_vars_to_update[$key]) {
				case 'toDB':
					if (is_array($val) && $key == 'seller_buyer_data' && geoPC::is_ent()) {
						//special case
						$val = unserialize($val);
					}
					$val = geoString::fromDB($val);
					break;
				case 'int':
					$val = intval($val);
					break;
				case 'float':
					$val = floatval($val);
					break;
				case 'bool':
					$val = (($val)? true: false);
					break;
				default:
					//not altered, for fields like "date"
					break;
			}
			if (array_key_exists($key,$translations)) {
				$key = $translations[$key];
			}
			$session_variables[$key] = $val;
		}
		$session_variables['classified_id'] = $session_variables['listing_id'] = $listing_id;
		$db = DataAccess::getInstance();
		//echo ('session vars: <pre>'.print_r($session_variables,1).'</pre><br />');
		
		//Populate extra questions
		$sql = "SELECT * FROM ".geoTables::classified_extra_table." WHERE `classified_id` = $listing_id ORDER BY `display_order`";
		$extras = $db->GetAll($sql);
		foreach ($extras as $row) {
			$session_variables['question_value'][$row['question_id']] = geoString::fromDB($row['value']);
			$session_variables['question_display_order'][$row['question_id']] = $row['display_order'];
		}
		
		//TODO: Populate images - does that need doing?
		
		//Special cases for session vars
		$session_variables['legacy_expired'] = ($listing->isExpired())? 1: 0;
		if ($session_variables['buy_now_only']) {
			$session_variables['auction_minimum'] = null;
		} else if ($listing->isExpired()) {
			$session_variables['auction_minimum'] = 0.01;
		} else {
			$session_variables['auction_minimum'] = (floatval($data['starting_bid']) <= 0.01)? 0.01: floatval($data['starting_bid']);
		}
		
		//get tags
		$tags = geoListing::getTags($listing_id);
		if ($tags) {
			$session_variables['tags'] = implode(', ',$tags);
		}
		
		$session_variables['legacy_listing'] = 'legacy_listing'; //let anyone who cares know that this is started from a legacy listing
		
		//now figure out what type of item to create
		$type = null;
		switch ($data['item_type']) {
			case 2:
				$type = 'auction';
				break;
				
			case 4:
				$type = 'reverse_auctions';
				break;
				
			case 3:
				$type = 'job_posting';
				break;
				
			case 1:
				//break ommitted on purpose
			default:
				$type = 'classified';
				break;
		}
		
		//create a new item
		$item = geoOrderItem::getOrderItem($type);
		if (!is_object($item)) {
			//something went wrong
			trigger_error('ERROR CART: When creating item for legacy listing, item false.');
			return false;
		}
		
		if (!$listing->isExpired()) {
			//not archived, so we can use the following info
			$item->setCategory($data['category']);
			$item->setPricePlan($data['price_plan_id']);
			//make sure price plan ID is still good
		} else {
			//don't know the price plan or category if it has expired
		}
		
		$item->setCreated($data['date']);
		$item->setStatus('active');
		$item->set('session_variables',$session_variables);
		$item->set('legacy_listing', 'legacy_listing');
		$item->set('legacy_expired',$listing->isExpired());
		$item->set('listing_id',$listing_id);
		
		//allow children items to do needed stuff for the item
		$children = geoOrderItem::getChildrenTypes($type);
		geoOrderItem::callUpdate('listing_placement_common_createItemForLegacyListing',
			array('item'=>$item, 'listing'=> $listing), $children);
		
		$item->save();
		$item_id = $item->getId();
		if ($item_id) {
			//set the order item ID manually here
			$listing->order_item_id = $item_id;
		}
		
		return $item_id;
	}
	/**
	 * Used to get array of session vars to listing key map
	 * outside of this class
	 * 
	 * @return array
	 */
	public static function getSessionToListingKeyMap ()
	{
		return self::$session_to_listing_key_map;
	}
	
	/**
	 * Used to get array of listing vars and how each one should be
	 * treated outside of this class
	 * @return array
	 */
	public static function getListingVarsToUpdate ()
	{
		return self::$listing_vars_to_update;
	}
	
	public static function jitLabel()
	{
		$cart = geoCart::getInstance();
		return $cart->site->messages[500768];
	}
	
	public static function jitDisplay()
	{
		$view = geoView::getInstance();
		$cart = geoCart::getInstance();
		
		$cart->site->page_id = 10202;
		$cart->site->get_text();
		
		$view->errorMsg = $cart->error_msgs['jit'];
		
		//check to see if the email address they gave matches one in the db already
		$email = $cart->site->session_variables['email_option'];
		$sql = "SELECT `email` FROM ".geoTables::userdata_table." WHERE `email` = ?";
		$result = $cart->db->GetOne($sql, array($email));
		if($result) {
			//email exists
			$view->emailExists = true;
		}
		
		$view->allow_user_pass = $cart->db->get_site_setting('jit_allow_user_pass') ? true : false;
		
		$view->max_user_length = $cart->db->get_site_setting('max_user_length');
		$view->max_pass_length = $cart->db->get_site_setting('max_pass_length');
		
		//id of cart session -- remember this, so that after logging in, we can re-assign it to this user
		$cart_id = $cart->cart_variables['id'];
		
		$procURL = $cart->getProcessFormUrl();
		$view->loginURL = $procURL . '&amp;jit=login';
		setcookie('jit_suspend', $cart_id, 0, '/'); //remember cart id across login
		$view->continueURL = $procURL . '&amp;jit=continue';
		
		$type = $cart->item->getType();
		$view->backURL = $cart->db->get_site_setting('classifieds_url') . '?a=cart&amp;main_type='.$type.'&amp;step='.$type.':details';
		
		//add security image, if it's turned on for login
		$secure = geoAddon::getUtil('security_image');
		if($secure && $secure->check_setting('login')) {
			$security_text =& geoAddon::getText('geo_addons','security_image');
			$error = $cart->site->error_messages['securityCode'];
			$section = "login";
			$view->securityImageHTML = $secure->getHTML($error, $security_text, $section, false);
			$cart->site->header_font_stuff .= $secure->getJs();		
		}
		
		$view->setBodyTpl('shared/jit_login_form.tpl','','order_items');
		
		$cart->site->display_page();
	}
	
	public static function jitCheckVars()
	{
		$jit = $_REQUEST['jit'];
		$cart = geoCart::getInstance();
		
		$cart->site->page_id = 10202;
		$cart->site->get_text();
		
		//get an Auth object, for logging in later
		include_once(CLASSES_DIR."authenticate_class.php");
		$auth = new Auth(0,$cart->db->getLanguage(),geoPC::getInstance());
		
		if($jit === 'login') {			
			//user wants to login -- go ahead and show login page
			$auth->login_form(0, '', '');
			exit(); //don't go on with cart process after showing login page			
		} else {
			//user not logging in, so do stealth registration:
			//create a randomized username/password
			//insert them into the db
			//email them to the user
			//log the user in automatically
			
			if($cart->item->get('newUser')) {
				//already done this once, user probably refreshed or something
				$username = $cart->item->get('newUser');
				$password = $cart->item->get('newPass');
			} else {
				if($cart->db->get_site_setting('jit_allow_user_pass')) {
					$username = $_POST['username'];
					$password = $_POST['password'];
					$confirm = $_POST['confirm'];

					if(!$username || !$password || !$confirm) {
						$cart->addErrorMsg('jit',$cart->site->messages[500784]);
						$cart->addError();
						return;
					}
					if($username == $password) {
						//username and password cannot be the same
						$cart->addErrorMsg('jit',$cart->site->messages[500783]);
						$cart->addError();
						return;
					}
					if($password != $confirm) {
						//username and password cannot be the same
						$cart->addErrorMsg('jit',$cart->site->messages[500785]);
						$cart->addError();
						return;
					}
					
					$max_user = $cart->db->get_site_setting('max_user_length');
					$min_user = $cart->db->get_site_setting('min_user_length');
					$max_pass = $cart->db->get_site_setting('max_pass_length');
					$min_pass = $cart->db->get_site_setting('min_pass_length');
					if(strlen($username) < $min_user) {
						$cart->addErrorMsg('jit',$cart->site->messages[500885].$min_user);
						$cart->addError();
						return;
					}
					if(strlen($username) > $max_user) {
						$cart->addErrorMsg('jit',$cart->site->messages[500886].$max_user);
						$cart->addError();
						return;
					}
					if(strlen($password) < $min_pass) {
						$cart->addErrorMsg('jit',$cart->site->messages[500887].$min_pass);
						$cart->addError();
						return;
					}
					if(strlen($password) > $max_pass) {
						$cart->addErrorMsg('jit',$cart->site->messages[500888].$max_pass);
						$cart->addError();
						return;
					}
		
		
					$sql = "select * from ".geoTables::logins_table." where username = ?";
					$result = $cart->db->Execute($sql, array($username));
					if($result && $result->RecordCount() > 0) {
						//username already exists
						$cart->addErrorMsg('jit',$cart->site->messages[500786]);
						$cart->addError();
						return;
					}
				} else {
					//create unique username
					//(start with a random 4-digit number and add 1 digit at a time until a unique name is found or the limit is exceeded)
					$username = 'user' . rand(1000,9999);
					do {
						if(strlen($username) >= $cart->db->get_site_setting('max_user_length')) {
							//it's statistically improbable we'll ever get to this point, but just in case:
							//if we ever reach this, start over
							$username = 'user' . rand(1000,9999); 
						}
						$username .= rand(0,9); //add another digit each pass to minimize runtime and add extensibility
						$sql = "select * from geodesic_logins where username=?";
						$result = $cart->db->Execute($sql, array($username));
					} while($result->RecordCount() > 0);
					
					//generate password
					$password = substr(md5(uniqid(rand(), true)), 0, $cart->db->get_site_setting('max_pass_length'));
				}
				
				//add to logins table, get new user ID
				$sql = "INSERT INTO ".geoTables::logins_table." (username, password) VALUES (?, ?)";
				$cart->db->Execute($sql, array($username, $password));
				
				$newId = $cart->db->Insert_Id(); 
				
				
				//grab sessvars
				$session_variables = $cart->site->session_variables;
				
				//update sessvars to be sold by this user
				$session_variables['seller'] = $newId;
				
				//add user into userdata table, stealing info from listing and making up some of the rest
				
				$sql = "INSERT INTO ".geoTables::userdata_table." (
				`id`,`username`,`email`,`firstname`,`lastname`,
				`address`,`zip`,`city`,`state`,`country`,
				`phone`,`phone2`,`fax`,`date_joined`,`communication_type`
				) VALUES (
				?,?,?,?,?,
				?,?,?,?,?,
				?,?,?,?,?
				)";
				
				$userInfo = array(
					'id' => $newId, 'username' => $username, 'email' => $session_variables['email_option'].'',
					'firstname' => 'GuestUser', 'lastname' => 'GuestUser', 'address' => $session_variables['address'].'',
					'zip' => $session_variables['zip_code'].'', 'city' => $session_variables['city'].'', 'state' => $session_variables['state'].'',
					'country' => $session_variables['country'].'', 'phone' => $session_variables['phone_1_option'].'', 'phone2' => $session_variables['phone_2_option'].'',
					'fax' => $session_variables['fax_option'].'', 'date_joined' => geoUtil::time(), 'communication_type' => $cart->db->get_site_setting('default_communication_setting')
				);
				
				$result = $cart->db->Execute($sql, $userInfo);
				if(!$result) {
					trigger_error('ERROR JIT: failed to insert into userdata table<br />sql: '.$sql.'<br />error: '.$cart->db->ErrorMsg());
					$cart->addErrorMsg('jit', $cart->site->messages[500787]);
					$cart->addError();
					return false;
				}
	
				//add to usergroupspriceplans table, too
				
				//find out the default group and priceplans
				$sql = "SELECT `group_id`, `price_plan_id`, `auction_price_plan_id` FROM ".geoTables::groups_table." WHERE `default_group` = 1";
				$group = $cart->db->GetRow($sql);
				
				//insert with default data
				$sql = "INSERT INTO ".geoTables::user_groups_price_plans_table." (`id`, `group_id`, `price_plan_id`, `auction_price_plan_id`) VALUES (?,?,?,?)";
				$result = $cart->db->Execute($sql, array($newId, $group['group_id'], $group['price_plan_id'], $group['auction_price_plan_id']));
				if(!$result) {
					trigger_error('ERROR JIT: failed to insert into usergroupspriceplans table<br />sql: '.$sql.'<br />error: '.$cart->db->ErrorMsg());
					$cart->addErrorMsg('jit', $cart->site->messages[500787]);
					$cart->addError();
					return false;
				}
				
				$userInfo['password'] = $password;
				geoAddon::triggerUpdate('user_register', $userInfo);
				
				//save changes to sessvars
				$cart->site->session_variables = $session_variables;
			}
			
			//make a note here: we've already created a user, so don't make a new one if the enduser does something silly like refreshes the page
			$cart->item->set('newUser', $username);
			$cart->item->set('newPass', $password);
			
			//send an email to the user with his new login information
			$subject = $cart->site->messages[500775];
			$body = $cart->site->messages[500776].$cart->db->get_site_setting('classifieds_url')."\n\n".
				$cart->site->messages[500777].$username."\n".
				$cart->site->messages[500778].$password.$cart->site->messages[500779];
			geoEmail::sendMail($session_variables['email_option'], $subject, $body);
			
			//while we're in the business of being sneaky, let's go ahead and log the user in with the account we've just created
			//have to go through the validate form or login won't work quite right...
			$loginInfo = array('username' => $username, 'password' => $password);
			
			if(isset($_REQUEST['b']['securityCode'])) {
				//pass the security image along, as well
				$loginInfo['securityCode'] = $_REQUEST['b']['securityCode']; 
			}
			
			$login_result = $auth->validate_login_form($loginInfo, 0);
			exit();
						
		}
		
	}
	
	public static function jitProcess()
	{
		//nothing to do here
		return true;
	}
	
	public static function removeTags ($listingId)
	{
		$db = DataAccess::getInstance();
		
		$listingId = (int)$listingId;
		
		if (!$listingId) {
			//not valid listing ID
			return false;
		}
		
		//first remove existing tags for listing
		$sql = "DELETE FROM ".geoTables::tags." WHERE `listing_id`=$listingId";
		if (!$db->Execute($sql)) {
			trigger_error('ERROR SQL: Error running '.$sql.' : error: '.$db->ErrorMsg());
			return false;
		}
		return true;
	}
	
	public static function updateTags ($listingId, $tags)
	{
		$db = DataAccess::getInstance();
		
		$listingId = (int)$listingId;
		$tags = (is_array($tags))? $tags : explode(', ',$tags);
		//remove any blank tags, tags will be cleaned already but sometimes an
		//empty string for a tag can get through, this should stop it.
		$tags = array_diff($tags, array (''));
		
		if (!$listingId) {
			//not valid listing ID
			return false;
		}
		
		if (!self::removeTags($listingId)) {
			return false;
		}
		
		$sql = $db->Prepare("INSERT INTO ".geoTables::tags." (`listing_id`, `tag`) VALUES (?, ?)");
		$search_text = '';
		
		foreach ($tags as $tag) {
			//tags should already be cleaned at this point
			$result = $db->Execute($sql, array($listingId, geoString::toDB($tag)));
			if (!$result) {
				trigger_error('ERROR SQL: Error inserting tag for listing.  Error: '.$db->ErrorMsg());
				return false;
			}
			//add tag to search text
			$search_text .= $tag.' - ';
		}
		return $search_text;
	}
	
	public static function insertCatQuestions ($listingId, $session_variables)
	{
		$db = DataAccess::getInstance();
		
		$session_variables["question_value"] = isset($session_variables["question_value"]) ? $session_variables["question_value"] : array();
		$num_questions = count($session_variables["question_value"]);
		
		$search_text = '';
		
		if ($num_questions > 0) {
			foreach ($session_variables["question_value"] as $key => $value) {
				if ((strlen(trim($value)) > 0) || (strlen(trim($session_variables["question_value_other"][$key])) > 0)) {
					//there is a value in this questions so put it in the db
					$sql = "SELECT * FROM ".geoTables::classified_sell_questions_table." WHERE `question_id` = ?";
					$question_result = $db->Execute($sql, array($key));
					
					if (!$question_result) {
						trigger_error('ERROR SQL: sql - '.$sql.' error: '.$db->ErrorMsg());
						
						return false;
					} else if ($question_result->RecordCount() == 1) {
						$show = $question_result->FetchNextObject();
						if (strlen(trim($session_variables["question_value_other"][$key])) > 0) {
							//$cart->site->body .="use the other value for ---".$key."<br />\n";
							$use_this_value = geoString::fromDB($session_variables["question_value_other"][$key]);
						} else {
							$use_this_value = geoString::fromDB($value);
						}
						if ($show->CHOICES == "check") {
							$checkbox = 1;
						} else if ($show->CHOICES == "url") {
							$checkbox = 2;
						} else {
							$checkbox = 0;
						}
						$use_this_value = str_replace("\n"," ",$use_this_value);
						$sql = "insert into ".geoTables::classified_extra_table."
							(classified_id,name,question_id,value,explanation,checkbox,display_order)
							values
							(".$listingId.",\"".geoString::toDB($show->NAME)."\",\"".$key."\",\"".geoString::toDB($use_this_value)."\",
							\"".geoString::toDB($show->EXPLANATION)."\",".$checkbox.",".$show->DISPLAY_ORDER.")";
						$current_insert_result = $db->Execute($sql);
						
						if (!$current_insert_result) {
							trigger_error('ERROR SQL: sql - '.$sql.' error: '.$db->ErrorMsg());
							
							return false;
						}
						$search_text .= $use_this_value." - ";
					}
				} // end of if
			} // end of for $i
		}// end of if num_questions > 0
		$session_variables["group_value"] = isset ($session_variables["group_value"]) ? $session_variables["group_value"] : array();
		$num_group_questions = count($session_variables["group_value"]);
		
		if ($num_group_questions > 0 ) {
			foreach ($session_variables["group_value"] as $key => $value) {
				if ((strlen(trim($value)) > 0) || (strlen(trim($session_variables["group_value_other"][$key])) > 0)) {
					//there is a value in this questions so put it in the db
					$sql = "SELECT * FROM ".geoTables::classified_sell_questions_table." WHERE question_id = \"".$key."\"";
					$question_result = $db->Execute($sql);
					
					if (!$question_result) {
						trigger_error('ERROR SQL: sql - '.$sql.' error: '.$db->ErrorMsg());
						
						return false;
					} elseif ($question_result->RecordCount() == 1) {
						$show = $question_result->FetchNextObject();
						if (strlen(trim($session_variables["group_value_other"][$key])) > 0) {
							//$cart->site->body .="use the other value for ---".$key."<br />\n";
							$use_this_value = geoString::fromDB($session_variables["group_value_other"][$key]);
						} else {
							$use_this_value = geoString::fromDB($value);
						}
						if ($show->CHOICES == "check") {
							$checkbox = 1;
						} else if ($show->CHOICES == "url") {
							$checkbox = 2;
						} else {
							$checkbox = 0;
						}
						$sql = "insert into ".geoTables::classified_extra_table."
							(classified_id,name,question_id,value,explanation,checkbox,group_id)
							values
							(?,?,?,?,?,?,?)";
						$sql_array = array($listingId,geoString::toDB($show->NAME),$key,geoString::toDB($use_this_value),
							geoString::toDB($show->EXPLANATION),$checkbox,$show->GROUP_ID);
						$insert_result = $db->Execute($sql,$sql_array);
						
						if (!$insert_result) {
							trigger_error('ERROR SQL: sql - '.$sql.' error: '.$db->ErrorMsg());
							
							return false;
						}
						$search_text .= $use_this_value." - ";
					}
				} // end of if
			} // end of for $i
		}
		
		return $search_text;
	}
}