<?php
//send_ad_expiration_emails.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20980              $ ##
## File last change date:       ##
##  $Date:: 2011-01-24 17:23:#$ ##
##                              ##
##################################

if (!defined('GEO_CRON_RUN')){
	die('NO ACCESS');
}
$util = new expiration_util();

//send expiration notices
if ($this->db->get_site_setting('send_classified_expire_email') || $this->db->get_site_setting('send_auction_expire_email') || ($this->db->get_site_setting("send_admin_end_email") && geoPC::is_ent()))
{
	$this->log("START CRON: send ad expiration emails cron", __line__);
	
	//settings may be decimal values, but let's round to the nearest second to keep things clean
	$send_classified_expire_time = (round($this->db->get_site_setting('send_classified_expire_email') * 86400) + geoUtil::time());
	$send_auction_expire_time = (round($this->db->get_site_setting('send_auction_expire_email') * 86400) + geoUtil::time());
	
	//in case one of these settings is set but the other isn't
	$expire_time_not_set_classified = ($this->db->get_site_setting('send_classified_expire_email') == 0) ? true : false;
	$expire_time_not_set_auction = ($this->db->get_site_setting('send_auction_expire_email') == 0) ? true : false;
	
	for($i=1; $i<=2; $i++)
	{
		if(!geoPC::is_classifieds()) $i = 2;
		else if (!geoPC::is_auctions() && $i==2) break;
		
		if($i==1) $this->log("sending classified expiration notices",__line__);
		else $this->log("sending auction expiration notices",__line__);
		
		if($i==1 && $expire_time_not_set_classified) continue;
		if(($i==2 || $i==4) && $expire_time_not_set_auction) continue;

		$expire_time = ($i == 1) ? $send_classified_expire_time : $send_auction_expire_time;
		$this->log("\$expire_time is ".$expire_time,__line__);
		
		
		$sql = "select * from ".$this->db->geoTables->classifieds_table." where
			(ends < ".$expire_time." and sold_displayed = 0 and expiration_notice = 0 and live=1 and item_type=".$i." and delayed_start = 0)";

		if($this->db->get_site_setting('send_ad_expire_frequency'))
		{
			$sql .= " OR (expiration_notice = 1 and sold_displayed = 0 and live = 1 and delayed_start = 0 and item_type=".$i." and
				(((expiration_last_sent + ".$this->db->get_site_setting('send_ad_expire_frequency').") <= ".geoUtil::time().") and expiration_last_sent != 0))";
		}
		$sql .= " ORDER BY seller"; // order essential for sending multiple items per email

		$this->log("Query: ".$sql);
		
		$send_expiration_result = $this->db->Execute($sql);
		if (!$send_expiration_result) {
			$this->log("QUERY FAILED. MySQL Said: ".$this->db->ErrorMsg());
			return false;
		} elseif ($send_expiration_result->RecordCount() > 0) {
			//$this->page_id = 52;
			//$this->get_text();
			$msgs = $this->db->get_text(true, 52);
			$lastSeller = "";
			$message_body = "";
			$admin_body = "";
			$ids = array();

			$subject = urldecode($msgs[723]);
			$from = $this->db->get_site_setting('site_email');
			while ($show = $send_expiration_result->FetchRow())
			{
				if($show['seller'] == $lastSeller) {
					// user has multiple expiring ads
					$message_body .= urldecode($show['title'])."\n";
					$message_body .= $this->db->get_site_setting('classifieds_url')."?a=2&amp;b=".$show['id']."\n\n";
					$admin_body .= urldecode($show['title'])."\n";
					$admin_body .= $this->db->get_site_setting('classifieds_url')."?a=2&amp;b=".$show['id']."\n\n";
					$ids[] = $show["id"];
					$this->log("added listing #".$show['id']);
				} else {
					// this is a "new" user
					//send a mail to "last" user
					if ($lastSeller != "" && (($this->db->get_site_setting('send_classified_expire_email') && $i==1) || ($this->db->get_site_setting('send_auction_expire_email') && $i==2)))
       	  			{
        	  			$util->sendMail($user_data->EMAIL, $subject, $message_body);
  						foreach($ids as $complete)
          				{
  							$sql = "update ".$this->db->geoTables->classifieds_table." set	expiration_notice = 1, expiration_last_sent = ".geoUtil::time()." where id = ".$complete;
	  						$update_expiration_result = $this->db->Execute($sql);
		  					if(!$update_expiration_result)
		  					{
		  						$this->log("update query failed. exiting. mysql said: ".$this->db->ErrorMsg(),__line__);
		  						return false;
		  					}
	          			}
					}
					//begin new mail
					$this->log("assembling email to send to user ".$show['seller'],__line__);
					$user_data = $util->get_user_data($show['seller']);
					$message_body = urldecode($msgs[724])." ".geoUser::getUser($show['seller'])->getSalutation();
					$message_body .= urldecode($msgs[725])."\n\n";
					$message_body .= urldecode($show['title'])."\n";
					$message_body .= $this->db->get_site_setting('classifieds_url')."?a=2&amp;b=".$show['id']."\n\n";
					$admin_body .= "[User: ".$user_data->USERNAME."]\n";
					$admin_body .= urldecode($show['title'])."\n";
					$admin_body .= $this->db->get_site_setting('classifieds_url')."?a=2&amp;b=".$show['id']."\n\n";
					$ids = array(); // clear array for the start of each user
					$ids[] = $show["id"];
					$this->log("added listing #".$show['id'],__line__);
					$lastSeller = $show['seller'];
				}	
			}
			//send last mail outside loop
       		if ($lastSeller != "")
	    	{
      			$util->sendMail($user_data->EMAIL, $subject, $message_body);
       			foreach($ids as $complete)
        		{
 					$sql = "update ".$this->db->geoTables->classifieds_table." set	expiration_notice = 1, expiration_last_sent = ".geoUtil::time()." where id = ".$complete;
 					$update_expiration_result = $this->db->Execute($sql);
					if(!$update_expiration_result)
        			{
						$this->log("update query failed. exiting. mysql said: ".$this->db->ErrorMsg(),__line__);
						return false;
  					}
        		}
			}
			if($this->db->get_site_setting("send_admin_end_email") && geoPC::is_ent())
				$util->send_admin_end_email($admin_body, $i);
		}
    }  	
   	$this->log("END CRON: of send ad expiration emails cron",__line__);
}

//NOTE:  we return true AFTER the class declaration, otherwise on some servers
//the class is never parsed

/**
 * Utility class holding functions needed by this task
 */
class expiration_util
{
	var $verbose = false;
	var $db;
	var $cron;
	
	function __construct()
	{
		$this->db = DataAccess::getInstance();
		$this->cron = geoCron::getInstance();
	}
	
	function send_admin_end_email($admin_body, $listing_type=1)
	{
		if(!geoPC::is_ent()) {
			return false;
		}
		$type = ($listing_type == 1) ? "classifieds" : "auctions";
		
		$this->cron->log("sending an email to admin (".$type.")",__line__);
		
		$message_body = "The following ".$type." will expire soon\n\n";
		$message_body .= $admin_body;
		$subject = $type . " expiring soon";
		$this->sendMail($this->db->get_site_setting('site_email'), $subject, $message_body);
	}

	function sendMail($to, $subject, $content)
	{
		$this->cron->log("Sending mail to: ".$to,__line__);
		$this->db->sendMail($to, $subject, $content);
	}
	
	function get_user_data($user_id=0)
	{
		if ($user_id)
		{
			$db = DataAccess::getInstance();
			if ($db->get_site_setting('use_mambo'))
			{
				$this->cron->log("attempting to get user data from mambo",__line__);
			}
			else
			{
				$sql_query = "select * from ".$db->geoTables->userdata_table.",".$db->geoTables->user_groups_price_plans_table." where
					".$db->geoTables->userdata_table.".id = ".$db->geoTables->user_groups_price_plans_table.".id and ".$db->geoTables->userdata_table.".id = ".$user_id;
				$this->cron->log("USERDATA query: ".$sql_query,__line__);
				$user_data_result = $db->Execute($sql_query);
				
				if (!$user_data_result)
				{
					$this->cron->log("query failed. MySQL said: ".$db->ErrorMsg(),__line__);
					return false;
				}
				elseif ($user_data_result->RecordCount() == 1)
				{
					$show_user = $user_data_result->FetchNextObject();
					$this->cron->log("got data for user ".$show_user->ID,__line__);
					return $show_user;
				}
				else
				{
					$this->cron->log("ERROR: Found 0 or more than 1 users with this ID.",__line__);
					return false;
				}
			}
		}
		else
		{
			$this->cron->log("get_user_data() didn't get user_id.",__line__);
			return false;
		}
	} //end of function get_user_data
}

return true;
