<?php
//expire_groups_and_plans.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 15599              $ ##
## File last change date:       ##
##  $Date:: 2009-02-03 11:24:#$ ##
##                              ##
##################################

if (!defined('GEO_CRON_RUN')){
	die('NO ACCESS');
}
$this->log('Top of expire_groups_and_plans!',__line__);
$sql = "select * from ".geoTables::expirations_table." where expires < ".$this->time();
$type_result = $this->db->Execute($sql);
if (!$type_result)
{
	$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(),__line__);
	return false;
}

while ($show = $type_result->FetchNextObject()) {
	if ($show->TYPE == 1) {
		$sql = "select group_expires_into from ".$this->db->geoTables->groups_table." where group_id = ?";
		$expire_into_result = $this->db->Execute($sql, $show->TYPE_ID);
		if (!$expire_into_result)
		{
			$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(), __line__);
			return false;
		}
		elseif ($expire_into_result->RecordCount() == 1)
		{
			$show_expire_into = $expire_into_result->FetchNextObject();
			//expire group
			if ($show->TYPE_ID_EXPIRES_TO)
			{
				$sql = "update ".$this->db->geoTables->user_groups_price_plans_table." set
					group_id = ?
					where group_id = ?";
				$update_group_result = $this->db->Execute($sql, array($show_expire_into->GROUP_EXPIRES_INTO, $show->TYPE_ID));
				if (!$update_group_result)
				{
					$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(),__line__);
					return false;
				}
			}
		}
	}
	elseif ($show->TYPE == 2)
	{
		//expire price plans
		$sql = "select * from ".$this->db->geoTables->price_plans_table." where price_plan_id = ?";
		$price_plan_result = $this->db->Execute($sql, array($show->TYPE_ID));
		if (!$price_plan_result)
		{
			$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(),__line__);
			return false;
		}
		elseif ($price_plan_result->RecordCount() == 1)
		{
			if ($show->USER_ID)
			{
				//expires this specific users price plan
				$show_price_plan = $price_plan_result->FetchNextObject();

				//check to see if ads expire with price plan
				if ($show_price_plan->AD_AND_SUBSCRIPTION_EXPIRATION == 1)
				{
					$sql = "update ".$this->db->geoTables->classifieds_table." set
						live = 0
						where seller = ?";
					$update_live_result = $this->db->Execute($sql, array($show->USER_ID));
					if ($update_live_result===false)
					{
						$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(),__line__);
						return false;
					}
				}
				if ($show_price_plan->PRICE_PLAN_EXPIRES_INTO)
				{
					$sql = "update ".$this->db->geoTables->user_groups_price_plans_table." set
						price_plan_id = ?
						where id = ?";
					$update_price_plan_result = $this->db->Execute($sql, array($show_price_plan->PRICE_PLAN_EXPIRES_INTO, $show->USER_ID));
					if ($update_price_plan_result===false)
					{
						$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(), __line__);
						return false;
					}
				}
			}
			else
			{
				//expires this price plan for every user
				$show_price_plan = $price_plan_result->FetchNextObject();
				if ($show_price_plan->AD_AND_SUBSCRIPTION_EXPIRATION == 1)
				{

					$sql = "select * ".$this->db->geoTables->user_groups_price_plans_table."
						where price_plan_id = ?";
					$select_users_result = $this->db->Execute($sql, array($show->TYPE_ID));
					if ($select_users_result===false)
					{
						$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(), __line__);
						return false;
					}
					elseif ($select_users_result->RecordCount() > 0)
					{
						while ($show_users = $select_users_result->FetchNextObject())
						{
							$sql = "update ".$this->db->geoTables->classifieds_table." set
								live = 0
								where seller = ?";
							$update_live_result = $this->db->Execute($sql, array($show_users->ID));
							if (!$update_live_result)
							{
								$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(), __line__);
								return false;
							}
						}
					}
				}
				if ($show_price_plan->PRICE_PLAN_EXPIRES_INTO)
				{
					$sql = "update ".$this->db->geoTables->user_groups_price_plans_table." set
						price_plan_id = ?
						where price_plan_id = ?";
					$update_price_plan_result = $this->db->Execute($sql, array($show_price_plan->PRICE_PLAN_EXPIRES_INTO, $show->TYPE_ID));
					//$this->body .=$sql."<br>\n";
					if (!$update_price_plan_result)
					{
						$this->log('DB Error:  Sql: '.$sql.' Error: '.$this->db->ErrorMsg(), __line__);
						return false;
					}
				}
			}
		}
	}
	//delete the expiration
	$sql = "delete from ".$this->db->geoTables->expirations_table." where expiration_id = ?";
	$delete_result = $this->db->Execute($sql, array($show->EXPIRATION_ID));
	//$this->body .=$sql."<br>\n";
	$this->log('Finished moving one plan.',__line__);
}
return true; //finished task all the way.