<?php
//browse_tag.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21039              $ ##
## File last change date:       ##
##  $Date:: 2011-02-08 17:15:#$ ##
##                              ##
##################################

class Browse_tag extends geoBrowse {
	var $config = array();
	private static $listing_config = array();
	var $subcategory_array = array();
	var $notify_data = array();
	var $debug_browse = 0;
	var $lcv = 0;
	var $browsing_options = array();
	private $sql;
	private $filters;
	private $query_data = array();
	private static $smarty_object_are_registered;
	private $tag;
	
	public function __construct ($tag, $page=0)
	{
		$this->db = DataAccess::getInstance();
		$user_id = geoSession::getInstance()->getUserId();
		$this->site_category = 0;
		
		if ($page) {
			$this->page_result = $page;
		} else {
			$this->page_result = 1;
		}
		
		if (isset($_REQUEST['o']) && is_numeric($_REQUEST['o'])) {
			$this->browsing_options['choice'] = (int)$_REQUEST['o'];
		}
		$this->tag = geoFilter::cleanListingTag($tag);
		
		parent::__construct();
	}

	
	/**
	 * Displays a tag's listings
	 * 
	 * @param int $browse_type not sure what this is for really...
	 */
	public function browseTag($browse_type=0)
	{
		$this->page_id = 10210;
		$this->get_text();
		$browseType = array('param' => 0);
		if (geoPC::is_print() && $this->db->get_site_setting('disableAllBrowsing')) {
			//browsing disabled, do not show browsing contents
			$this->display_page();
			return;
		}
		if ($browse_type) {
			$browseType["param"] = $browse_type;
		}
		
		$view = geoView::getInstance();
		
		// $browseType["param"] holds the value of the $browse_type parameter of this function
		if ($browseType["param"] == 0) {
			
			if ($this->db->get_site_setting('default_display_order_while_browsing') != -1) {
				//this setting used if site has been updated from pre-3.1, but admin hasn't set the class/auc-specific settings yet
				$browseType["legacy"] = $this->db->get_site_setting('default_display_order_while_browsing'); 	
			} else {
				$browseType["classified"] = $this->db->get_site_setting('default_classified_order_while_browsing');
				$browseType["auction"] = $this->db->get_site_setting('default_auction_order_while_browsing');
			}
		}
		
		$orderBy = array();
		foreach($browseType as $key => $value) {
			$orderBy[$key] = $this->getOrderByString($value);
		}
		$tables = '';
		if ($this->db->isBrowsingWhereClause()) {
			$this->filters = $this->db->getBrowsingWhereClause();
			
			foreach ($this->filters['tables'] as $table) {
				if ($table) $tables .= ', '.$table;
			}
		}
		$cTable = geoTables::classifieds_table;
		$tTable = geoTables::tags;
		
		$sql = "SELECT * FROM $cTable, $tTable $tables
					  WHERE $tTable.`listing_id` = $cTable.`id` AND $tTable.`tag`=? and live = 1 ";
				
		$sql .= $this->_setBrowsingOptions();
		
		$query_data = array(''.geoString::toDB($this->tag));
		if ($this->filters) {
			$sql .= " AND ".$this->filters['sql'];
			foreach ($this->filters['data'] as $d) {
				$query_data[] = $d;
			}
		}
				
		//set up display order
		$this->browse_type = (isset($browseType["param"]))? $browseType["param"]: 0;
		
		if(isset($orderBy["param"]) && strlen(trim($orderBy["param"])) > 0) { 
			//if function is called with a parameter
			$listing_order = $orderBy["param"];
		} else if(isset($orderBy["legacy"]) && $orderBy["legacy"]) {
			//if site admin has not yet run admin > browse form, we are in legacy display mode
			$listing_order = $orderBy["legacy"];
		} else {
			//follow site defaults
			if (!geoPC::is_classifieds()) {
				$listing_order = $orderBy['auction'];
			} else {
				//use classified if classified only or classauctions
				$listing_order = $orderBy['classified'];
			}
		}
		
		//how many ads to show on this page?
		$adsToShow = (int)$this->db->get_site_setting('number_of_ads_to_display');
		if (!$adsToShow) $adsToShow = 1;//need to show at least one per page...
		
		$adsStart = (($this->page_result -1) * $adsToShow);
		
		$limit = " LIMIT $adsStart, $adsToShow";
		
		//query for counting is a bit different
		$sql_count = str_replace('*', 'count(id)', $sql);

		//figure out whether to show classifieds, auctions, or both
		$opt_type = $this->browsing_options['type']; //from browsing options module
		$config_type = $this->configuration_data['listing_type_allowed']; //from site (or category) config
		
		$total_returned = (int)$this->db->GetOne($sql_count, $query_data);
		
		$result = $this->db->Execute($sql.' '.$listing_order.$limit, $query_data);

		if (!$result) {
			$this->error_message = '<span class="error_message">'.$this->messages[500820].'</span>';
			return false;
		}
		
		//total number of pages to make available
		$numPages = max(1, ceil($total_returned / $adsToShow));
		
		if ($this->page_result > $numPages) {
			//trying to access a page that doesn't exist
			//(could be a search engine crawling an outdated url)
			$this->error_message = "<span class=\"error_message\">".$this->messages[500820]."</span>";
			$this->browse_error();
			return false;
		} else if ($total_returned == 0) {
			//no results found, don't use error, but do cause a 404 is applicable
			self::pageNotFound();
		}
		
		$view->options_qs = $this->browsing_options['query_string']; //o= parameter of links that need to preserve browsing module setting 
		
		//get this category's name
		if ($this->site_category) {
			$current_category_name = geoCategory::getName($this->site_category);
			$parent_id = $this->site_category;
		}
		$view->tag = $this->tag;
		
		$this->display_browse_result($result);
		
		if ($adsToShow < $total_returned) {
			if($browseType['param']) {
				$c = $browseType['param'];
			} elseif ($browseType['category']) {
				$c = $browseType['category'];
			} else {
				$c = 0;
			}
			$c=($c)? "&amp;c=$c" : '';
			$url = $this->db->get_site_setting('classifieds_file_name')."?a=tag&amp;tag=".geoString::specialChars($this->tag).$this->browsing_options['query_string']."$c&amp;page=";
			$css = "browsing_result_page_links";
			$view->pagination = geoPagination::getHTML($numPages, $this->page_result, $url, $css);
		}
		
		$view->setBodyTpl('tag.tpl', '', 'browsing');
		$this->display_page();
		return true;
		
		
	}

	public function _setBrowsingOptions ()
	{
		$choice_option = (isset($this->browsing_options['choice']))? $this->browsing_options['choice']: 0;
		
		switch($choice_option) {
			//add appropriate conditions to sql for option selected from category_browsing_options module
			//$this->browsing_options['query_string'] holds the value to add to querystring of links on the page to perpetuate the selection
			//$this->browsing_options['type']: 1 for classifieds, 2 for auctions, 0 for both
			case 1:
				//listings ending in next 24 hours
				$this->browsing_options['sql'] = " and ends < " . (geoUtil::time() + 86400) . " ";
				$this->browsing_options['query_string'] = "&amp;o=1";
				$this->browsing_options['type'] = 0;
				break;
				
			case 2:
				//auctions using buy now
				if (geoPC::is_auctions()) {
					$this->browsing_options['sql'] = " and buy_now > 0 ";
					$this->browsing_options['query_string'] = "&amp;o=2";
					$this->browsing_options['type'] = 2;
				}
				break;
				
			case 3:
				//auctions using buy now only
				if (geoPC::is_auctions()) {
					$this->browsing_options['sql'] = " and buy_now_only != 0 ";
					$this->browsing_options['query_string'] = "&amp;o=3";
					$this->browsing_options['type'] = 2;
				}
				break;
				
			case 4:
				//auctions with bids
				if (geoPC::is_auctions()) {
					$this->browsing_options['sql'] = " and minimum_bid > starting_bid ";
					$this->browsing_options['query_string'] = "&amp;o=4";
					$this->browsing_options['type'] = 2;
				}
				break;
				
			case 5:
				//auctions without bids
				if (geoPC::is_auctions()) {
					$this->browsing_options['sql'] = " and minimum_bid = starting_bid ";
					$this->browsing_options['query_string'] = "&amp;o=5";
					$this->browsing_options['type'] = 2;
				}
				break;
				
			case 6:
				//listings with pictures
				$this->browsing_options['sql'] = " and image > 0 ";
				$this->browsing_options['query_string'] = "&amp;o=6";
				$this->browsing_options['type'] = 0;
				break;
				
			case 7:
				//browse by classifieds only (CA-only feature)
				if (geoPC::is_class_auctions()) {
					$this->browsing_options['sql'] = "";
					$this->browsing_options['query_string'] = "&amp;o=7";
					$this->browsing_options['type'] = 1;
				}
				break;
				
			case 8:
				//browse by auctions only (CA-only feature)
				if (geoPC::is_class_auctions()) {
					$this->browsing_options['sql'] = "";
					$this->browsing_options['query_string'] = "&amp;o=8";
					$this->browsing_options['type'] = 2;
				}
				break;
				
			case 9:
				//browse by auctions only (CA-only feature)
				if (geoPC::is_class_auctions()) {
					$this->browsing_options['sql'] = "";
					$this->browsing_options['query_string'] = "&amp;o=9";
					$this->browsing_options['type'] = 4;
				}
				break;
				
			default:
				$this->browsing_options['sql'] = "";
				$this->browsing_options['query_string'] = "";
				$this->browsing_options['type'] = 0;

		}
		
		if (strlen($this->browsing_options['sql']) > 0) {
			return $this->browsing_options['sql'];
		}
		return '';
	}

	public function display_browse_result ($browse_result, $auction=0, $featured=0)
	{
		$this_copy =& $this;
		$overload = geoAddon::triggerDisplay('overload_Browse_tag_display_browse_result', array ('browse_result'=>$browse_result, 'header_css' => $header_css, 'featured' => $featured, 'auction' => $auction, 'this' => $this_copy), geoAddon::OVERLOAD);
		if ($overload !== geoAddon::NO_OVERLOAD) {
			return $overload;
		}
		
		$db = DataAccess::getInstance();
		$tpl_vars = array();
		
		if ($browse_result->RecordCount() < 1) {
			//no listings in this tag
			$tpl_vars['no_listings'] = $this->messages[500821];
		} else {
			$cfg = $listings = $headers = array();
			
			$fields = $this->fields->getDisplayLocationFields('tags');
			
			//set up header view vars
			$headers['css'] = 'browsing_result_table_header';
			
			$cfg['sort_links'] = true;
			$cfg['browse_url'] = $db->get_site_setting('classifieds_file_name')."?a=tag&amp;tag=".geoString::specialChars($this->tag).$this->browsing_options['query_string']."&amp;c=";
			$cfg['listing_url'] = $db->get_site_setting('classifieds_file_name')."?a=2&amp;b=";
			
			$cfg['cols']['type'] = (geoPC::is_class_auctions() && $db->get_site_setting('listing_type_allowed') == 0) ? true : false;
			$headers['type'] = array(
				'css' => 'item_type_column_header',
				'text' => $this->messages[500868]
			);
			
			$cfg['cols']['business_type'] = ($fields['business_type']) ? true : false;
			$headers['business_type'] = array(
				'css' => 'business_type_column_header',
				'text' => $this->messages[500822]
			);
			if($this->browse_type == 43) $headers['business_type']['reorder'] = 44;
			elseif($this->browse_type == 44) $headers['business_type']['reorder'] = 0;
			else $headers['business_type']['reorder'] = 43;
			
			$cfg['cols']['image'] = ($fields['photo']) ? true : false;
			$headers['image'] = array(
				'css' => 'photo_column_header',
				'text' => $this->messages[500823]
			);
			
			$cfg['cols']['title'] = ($fields['title']) ? true : false;
			$headers['title'] = array(
				'css' => 'title_column_header',
				'text' => $this->messages[500824]
			);
			if($this->browse_type == 5) $headers['title']['reorder'] = 6;
			elseif($this->browse_type == 6) $headers['title']['reorder'] = 0;
			else $headers['title']['reorder'] = 5;
			$cfg['description_under_title'] = ($fields['description'] && $this->configuration_data['display_ad_description_where']) ? true : false;

			$cfg['cols']['description'] = ($fields['description'] && !$cfg['description_under_title']) ? true : false;
			$headers['description'] = array(
				'css' => 'description_column_header',
				'text' =>  $this->messages[500825]
			);
			
			//Listing tags column
			$cfg['cols']['tags'] = ($fields['tags'])? true : false;
			$headers['tags'] = array(
				'css' => 'tags_column_header',
				'text' =>  $this->messages[500879]
			);
								
			for($i = 1; $i <= 20; $i++) {
				if (geoPC::is_ent() && $fields['optional_field_'.$i]) {
					$cfg['cols']['optionals'][$i] = true;
					$headers['optionals'][$i] = array(
						'css' => 'optional_field_header_'.$i,
						'text' => $this->messages[500825+$i]
					);
					$browse1 = ($i <= 10) ? ( 2 * ($i-1) + 15 ) : ( 2 * ($i-11) + 45 ) ; //15, 17, 19, ... : 45, 47, 49, ...
					$browse2 = $browse1 + 1;
					if($this->browse_type == $browse1) $headers['optionals'][$i]['reorder'] = $browse2;
					elseif($this->browse_type == $browse2) $headers['optionals'][$i]['reorder'] = 0;
					else $headers['optionals'][$i]['reorder'] = $browse1;
				} else {
					$cfg['cols']['optionals'][$i] = false;
				}
			}
			
			$cfg['cols']['address'] = ($fields['address']) ? true : false;
			$headers['address'] = array(
				'css' => 'address_column_header',
				'text' => $this->messages[500846]
			);
			
			$cfg['cols']['city'] = ($fields['city']) ? true : false;
			$headers['city'] = array(
				'css' => 'city_column_header',
				'text' => $this->messages[500847]
			);
			if($this->browse_type == 35) $headers['city']['reorder'] = 36;
			elseif($this->browse_type == 36) $headers['city']['reorder'] = 0;
			else $headers['city']['reorder'] = 35;
			
			$cfg['cols']['state'] = ($fields['state']) ? true : false;
			$headers['state'] = array(
				'css' => 'state_column_header',
				'text' => $this->messages[500848]
			);
			if($this->browse_type == 37) $headers['state']['reorder'] = 38;
			elseif($this->browse_type == 38) $headers['state']['reorder'] = 0;
			else $headers['state']['reorder'] = 37;
			
			$cfg['cols']['country'] = ($fields['country']) ? true : false;
			$headers['country'] = array(
				'css' => 'country_column_header',
				'text' => $this->messages[500849]
			);
			if($this->browse_type == 39) $headers['country']['reorder'] = 40;
			elseif($this->browse_type == 40) $headers['country']['reorder'] = 0;
			else $headers['country']['reorder'] = 39;
			
			$cfg['cols']['zip'] = ($fields['zip']) ? true : false;
			$headers['zip'] = array(
				'css' => 'zip_column_header',
				'text' => $this->messages[500850]
			);
			if($this->browse_type == 41) $headers['zip']['reorder'] = 42;
			elseif($this->browse_type == 42) $headers['zip']['reorder'] = 0;
			else $headers['zip']['reorder'] = 41;
					
			$cfg['cols']['price'] = ($fields['price']) ? true : false;
			$headers['price'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[500851]
			);
			if($this->browse_type == 1) $headers['price']['reorder'] = 2;
			elseif($this->browse_type == 2) $headers['price']['reorder'] = 0;
			else $headers['price']['reorder'] = 1;
							

			$cfg['cols']['num_bids'] = ($auction && $fields['num_bids']) ? true : false;
			$headers['num_bids'] = array(
				'css' => 'number_bids_header',
				'text' => $this->messages[500852]
			);
			
		
			$cfg['cols']['entry_date'] = ((!$auction && $fields['classified_start']) || ($auction && $fields['auction_start'])) ? true : false;
			$headers['entry_date'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[500853]
			);
			if($this->browse_type == 68) $headers['entry_date']['reorder'] = 67;
			elseif($this->browse_type == 67) $headers['entry_date']['reorder'] = 0;
			else $headers['entry_date']['reorder'] = 68;
			
			$cfg['cols']['time_left'] = ((!$auction && $fields['classified_time_left']) || ($auction && $fields['auction_time_left'])) ? true : false;
			$headers['time_left'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[500854]
			);
			if($this->browse_type == 70) $headers['time_left']['reorder'] = 69;
			elseif($this->browse_type == 69) $headers['time_left']['reorder'] = 0;
			else $headers['time_left']['reorder'] = 70;
			
			$cfg['cols']['edit'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['edit'] = array(
				'css' => 'price_column_header',
				'text' => 'edit'
			);
			
			$cfg['cols']['delete'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['delete'] = array(
				'css' => 'price_column_header',
				'text' => 'delete'
			);

			/**
			 * Addon core event:
			 * name: Browse_tag_display_browse_result_addHeader
			 * vars: array (this => Object) (this is the instance of $this.
			 * return: array (class => string (CSS Class), text => string (what should be displayed)
			 */
			$tpl_vars['addonHeaders'] = geoAddon::triggerDisplay('Browse_tag_display_browse_result_addHeader', array('this'=>$this, 'tag_fields' => $fields), geoAddon::ARRAY_ARRAY);
			
			if ($this->configuration_data['popup_while_browsing']) {
				$cfg['popup'] = true;
				$cfg['popup_width'] = $this->configuration_data['popup_while_browsing_width'];
				$cfg['popup_height'] = $this->configuration_data['popup_while_browsing_height'];
			} else {
				$cfg['popup'] = false;
			}
			$cfg['icons'] = array(
				'sold' => geoTemplate::getUrl('',$this->messages[500798]),
				'buy_now' => geoTemplate::getUrl('',$this->messages[500799]),
				'reserve_met' => geoTemplate::getUrl('',$this->messages[500800]),
				'no_reserve' => geoTemplate::getUrl('',$this->messages[500802]),
			);
			
			$cfg['empty'] = $this->messages[500227];//What???
			
			$tpl_vars['cfg'] = $cfg;
			$tpl_vars['headers'] = $headers;
			
			//now set up all the listing data
			
			//common text
			$text = array(
				'item_type' => array(
					'classified' => $this->messages[500867],
					'auction' => $this->messages[500866]
				),
				'business_type' => array(
					1 => $this->messages[500855],
					2 => $this->messages[500856],
				),
				'time_left' => array(
					'weeks' => $this->messages[500857],
					'days' => $this->messages[500858],
					'hours' => $this->messages[500859],
					'minutes' => $this->messages[500860],
					'seconds' => $this->messages[500861],
					'closed' => $this->messages[500862]
				)
			);
			
			while ($row = $browse_result->FetchRow()) {
				$id = $row['id']; //template expects $listings to be keyed by classified id
				
				//use the common geoBrowse class to do all the common heavy lifting
				$listings[$id] = $this->commonBrowseData($row, $text, $featured);
				
				//css is different enough to not include in the common file
				$listings[$id]['css'] = 'browsing_result_table_body_' . (($count++ % 2 == 0) ? 'even' : 'odd') . (($row['bolding']) ? '_bold' : '');
				
				//also do addons separately
				$listings[$id]['addonData'] = geoAddon::triggerDisplay('Browse_tag_display_browse_result_addRow', array('this'=>$this,'show_classifieds' => $row, 'tag_fields' => $fields), geoAddon::ARRAY_ARRAY);
			}
			$tpl_vars['listings'] = $listings;
		}
		geoView::getInstance()->setBodyVar($tpl_vars);
	}
}
