<?php 
//browse_newest_ads.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

class Browse_newest_ads extends geoBrowse {
	var $subcategory_array = array();
	var $notify_data = array();
	var $sort_type;
	var $lookback;

//########################################################################

	public function __construct ($category_id=0,$page=0,$browse_type=0)
	{
		$this->site_category = (int)$category_id;

		$this->db = DataAccess::getInstance();
		
		$this->get_ad_configuration();
		
		$this->page_result = ($page)? $page:1;
		$this->browse_type = $browse_type;
		
		parent::__construct();
	} //end of function Browse_newest_ads

//###########################################################

	public function browse ($sort_type=0,$lookback=0)
	{
		if (!geoCategory::getBasicInfo($this->site_category)) {
			//invalid category
			$this->browse_error();
		}
		
		$this->browse_type = $sort_type;
		$this->lookback = $lookback;
		$this->page_id = 64;
		$this->get_text();
		
		$view = geoView::getInstance();
		
		if ($this->db->get_site_setting('display_sub_category_ads')) {
			$this->get_sql_in_statement($db,$this->site_category);
		} else {
			$this->in_statement = " in (".$this->site_category.") ";
		}
		
		$category = ($this->site_category) ? '`category` '.$this->in_statement.' AND ' : '';
		
		switch ($this->lookback) {
			case 2:
				//last 2 weeks
				$cutoff_time = (geoUtil::time() - (86400 * 14));
				$header_display = $this->messages[902];
				break;
				
			case 3:
				//last 3 weeks
				$cutoff_time = (geoUtil::time() - (86400 * 21));
				$header_display = $this->messages[903];
				break;
				
			case 4:
				//last 24 hours
				$cutoff_time = (geoUtil::time() - 86400);
				$header_display = $this->messages[900];
				break;
			
			case 1:
				//break ommitted on purpose
				
			default:
				//last 1 week
				$cutoff_time = (geoUtil::time() - (86400 * 7));
				$header_display = $this->messages[901];
				break;
		}
		
		//add browsing where clause so that category counts dynamically retrieved,
		//and category cache is not used
		$this->db->addBrowsingWhereClause('browsing_newest_ads', "`date` > $cutoff_time");
		
		if (($this->browse_type == 0) && ($this->db->get_site_setting('default_display_order_while_browsing'))) {
			$this->browse_type = $this->db->get_site_setting('default_display_order_while_browsing');
		}
		$order_by = $this->getOrderByString();
		
		$query_data = array();
		$filter_sql = $tables = '';
		if ($this->db->isBrowsingWhereClause()) {
			$filters = $this->db->getBrowsingWhereClause();
			$filter_sql .= " AND ".$filters['sql'];
			foreach ($filters['data'] as $d) {
				$query_data[] = $d;
			}
			foreach ($filters['tables'] as $t) {
				$tables .= ', '.$t;
			}
		}
		//NOTE:  where date > ## is added using browsing where clause above, don't need to add here too...
		$sql = "select * from ".geoTables::classifieds_table."$tables where ".$category." live = 1 $filter_sql";
		
		$sql_count = str_replace("*", "count(id)", $sql);
		
		$adsToShow = $this->db->get_site_setting('number_of_ads_to_display');
		$orderLimit = $order_by." ,date desc limit ".(($this->page_result -1) * $adsToShow).",".$adsToShow;
		
		if (geoPC::is_classifieds() && ($this->db->get_site_setting('listing_type_allowed') == 0 || $this->db->get_site_setting('listing_type_allowed') == 1)) {
			$classifieds_count_sql = $sql_count . ' and item_type = 1';
			$total_returned_ads = $this->db->GetOne($classifieds_count_sql, $query_data);
			$classifieds_sql = $sql." and item_type = 1 ".$orderLimit;
			$result = $this->db->Execute($classifieds_sql, $query_data);			
		}
		if (geoPC::is_auctions() && ($this->db->get_site_setting('listing_type_allowed') == 0 || $this->db->get_site_setting('listing_type_allowed') == 2)) {
			$auctions_count_sql = $sql_count . ' and (item_type = 2 or item_type = 4)';
			$total_returned_auctions = $this->db->GetOne($auctions_count_sql, $query_data);
			$auctions_sql = $sql." and (item_type = 2 or item_type = 4) ".$orderLimit;
			$result_auctions = $this->db->Execute($auctions_sql, $query_data);
		}

		if (!$result && !$result_auctions) {
			
			$this->error_message = '<span class="error_message">'.urldecode($this->messages[65]).'</span>';
			return false;
		}
		
		//set up total_returned as the larger of the two, so that pagination goes all the way to the end
		$total_returned = ($total_returned_ads > $total_returned_auctions) ? $total_returned_ads : $total_returned_auctions;
		
		$numPages = max(1, ceil($total_returned / $this->db->get_site_setting('number_of_ads_to_display')));
		if ($this->page_result > $numPages) {
			//trying to access a page that doesn't exist
			//(could be a search engine crawling an outdated url)
			$this->error_message = "<span class=\"error_message\">".urldecode($this->messages[65])."</span>";
			$this->browse_error();
			return false;
		}
		
		//get this category's name
		if ($this->site_category) {
			$current_category_name = geoCategory::getName($this->site_category);
			$parent_id = $this->site_category;
		} else {
			$current_category_name = new stdClass();
			$current_category_name->CATEGORY_NAME = urldecode($this->messages[904]);
			$parent_id = 0;
		}
		$view->current_category_name = $current_category_name->CATEGORY_NAME;
		
		$text = array(
			'back_to_normal_link' => $this->messages[888],
			'tree_label' => $this->messages[890],
			'main_category' => $this->messages[891],
			'no_subcats' => $this->messages[889]
		);
		$view->category_cache = $category_cache = $this->categoryBrowsing($text, 'newest_');
		
		if (geoPC::is_classifieds() && ($this->db->get_site_setting('listing_type_allowed') == 0 || $this->db->get_site_setting('listing_type_allowed') == 1)) {
			//featured ads
			$view->show_classifieds = true;
			$view->classified_browse_result = $this->display_browse_result($result);
		}
		if (geoPC::is_auctions() && ($this->db->get_site_setting('listing_type_allowed') == 0 || $this->db->get_site_setting('listing_type_allowed') == 2)) {
			//featured auctions
			$view->show_auctions = true;
			$view->auction_browse_result = $this->display_browse_result($result_auctions, 1);
		}
		
		if ($this->db->get_site_setting('number_of_ads_to_display') < $total_returned) {
			$c_str = ($this->browse_type) ? '&amp;c='.$this->browse_type : '';
			$url = $this->db->get_site_setting('classifieds_file_name')."?a=11&amp;b=".$this->site_category.$c_str."&amp;d=".$this->lookback."&amp;page=";
			$css = "browsing_result_page_links";
			$view->pagination = geoPagination::getHTML($numPages, $this->page_result, $url, $css);
		}

		$view->setBodyTpl('newest_ads.tpl', '', 'browsing');
		$this->display_page();
		return true;
	} //end of function browse

//####################################################################################

	function display_browse_result($browse_result, $auction=0)
	{
		$db = DataAccess::getInstance();
		$tpl = new geoTemplate('system','browsing');
		if($browse_result->RecordCount() < 1) {
			//no listings in this category
			if($auction) {
				$tpl->no_listings = $this->messages[100898];
			} else {
				$tpl->no_listings = $this->messages[898];
			}
		} else {
			
			$cfg = $listings = $headers = array();
			//use main browsing display settings for now
			$fields = $this->fields->getDisplayLocationFields('browsing');
			
			//set up header view vars
			$headers['css'] = 'browsing_result_table_header';
			
			$cfg['sort_links'] = true;
			$cfg['browse_url'] = $this->db->get_site_setting('classifieds_file_name')."?a=11&amp;b=".$this->site_category."&amp;d=".$this->lookback."&amp;c=";
			$cfg['listing_url'] = $this->db->get_site_setting('classifieds_file_name')."?a=2&amp;b=";
			
			$cfg['cols']['business_type'] = ($fields['business_type']) ? true : false;
			$headers['business_type'] = array(
				'css' => 'business_type_column_header',
				'text' => $this->messages[1404]		
			);
			if($this->browse_type == 43) $headers['business_type']['reorder'] = 44;
			elseif($this->browse_type == 44) $headers['business_type']['reorder'] = 0;
			else $headers['business_type']['reorder'] = 43;

			$cfg['cols']['image'] = ($fields['photo']) ? true : false;
			$headers['image'] = array(
				'css' => 'photo_column_header',
				'text' => $this->messages[893]	
			);
			
			$cfg['cols']['title'] = ($fields['title']) ? true : false;
			$headers['title'] = array(
				'css' => 'title_column_header',
				'text' => $this->messages[894]
			);
			if($this->browse_type == 5) $headers['title']['reorder'] = 6;
			elseif($this->browse_type == 6) $headers['title']['reorder'] = 0;
			else $headers['title']['reorder'] = 5;
			$cfg['description_under_title'] = ($fields['description'] && $this->configuration_data['display_ad_description_where']) ? true : false;

			$cfg['cols']['description'] = ($fields['description'] && !$cfg['description_under_title']) ? true : false;
			$headers['description'] = array(
				'css' => 'description_column_header',
				'text' =>  $this->messages[895]
			);
			
			//Listing tags column
			$cfg['cols']['tags'] = ($fields['tags'])? true : false;
			$headers['tags'] = array(
				'css' => 'tags_column_header',
				'text' =>  $this->messages[500878]
			);
								
			for($i = 1; $i <= 20; $i++) {
				if(geoPC::is_ent() && $fields['optional_field_'.$i]) {
					$cfg['cols']['optionals'][$i] = true;
					$headers['optionals'][$i] = array(
						'css' => 'optional_field_header_'.$i,
						'text' => (($i <= 10) ? $this->messages[968+$i] : $this->messages[2280+$i]) 
					);
					$browse1 = ($i <= 10) ? ( 2 * ($i-1) + 15 ) : ( 2 * ($i-11) + 45 ) ; //15, 17, 19, ... : 45, 47, 49, ...
					$browse2 = $browse1 + 1;
					if($this->browse_type == $browse1) $headers['optionals'][$i]['reorder'] = $browse2;
					elseif($this->browse_type == $browse2) $headers['optionals'][$i]['reorder'] = 0;
					else $headers['optionals'][$i]['reorder'] = $browse1;
				} else {
					$cfg['cols']['optionals'][$i] = false;
				}
			}
	
			$cfg['cols']['address'] = false;
			
			$cfg['cols']['city'] = ($fields['city']) ? true : false;
			$headers['city'] = array(
				'css' => 'city_column_header',
				'text' => $this->messages[1335]
			);
			if($this->browse_type == 35) $headers['city']['reorder'] = 36;
			elseif($this->browse_type == 36) $headers['city']['reorder'] = 0;
			else $headers['city']['reorder'] = 35;
			
			$cfg['cols']['state'] = ($fields['state']) ? true : false;
			$headers['state'] = array(
				'css' => 'state_column_header',
				'text' => $this->messages[1336]
			);
			if($this->browse_type == 37) $headers['state']['reorder'] = 38;
			elseif($this->browse_type == 38) $headers['state']['reorder'] = 0;
			else $headers['state']['reorder'] = 37;
			
			$cfg['cols']['country'] = ($fields['country']) ? true : false;
			$headers['country'] = array(
				'css' => 'country_column_header',
				'text' => $this->messages[1337]
			);
			if($this->browse_type == 39) $headers['country']['reorder'] = 40;
			elseif($this->browse_type == 40) $headers['country']['reorder'] = 0;
			else $headers['country']['reorder'] = 39;
			
			$cfg['cols']['zip'] = ($fields['zip']) ? true : false;
			$headers['zip'] = array(
				'css' => 'zip_column_header',
				'text' => $this->messages[1338]
			);
			if($this->browse_type == 41) $headers['zip']['reorder'] = 42;
			elseif($this->browse_type == 42) $headers['zip']['reorder'] = 0;
			else $headers['zip']['reorder'] = 41;
					
			$cfg['cols']['price'] = ($fields['price']) ? true : false;
			$headers['price'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[896]
			);
			if($this->browse_type == 1) $headers['price']['reorder'] = 2;
			elseif($this->browse_type == 2) $headers['price']['reorder'] = 0;
			else $headers['price']['reorder'] = 1;
							

			$cfg['cols']['num_bids'] = ($auction && $fields['num_bids']) ? true : false;
			$headers['num_bids'] = array(
				'css' => 'newest_bids_column_header',
				'text' => $this->messages[102537]
			);
			
		
			$cfg['cols']['entry_date'] = ((!$auction && $fields['classified_start']) || ($auction && $fields['auction_start'])) ? true : false;
			$headers['entry_date'] = array(
				'css' => 'entry_date_column_header',
				'text' => $this->messages[897]
			);
			if($this->browse_type == 68) $headers['entry_date']['reorder'] = 67;
			elseif($this->browse_type == 67) $headers['entry_date']['reorder'] = 0;
			else $headers['entry_date']['reorder'] = 68;
			
			$cfg['cols']['time_left'] = ((!$auction && $fields['classified_time_left']) || ($auction && $fields['auction_time_left'])) ? true : false;
			$headers['time_left'] = array(
				'css' => 'newest_time_left_column_header',
				'text' => $this->messages[102538]
			);
			if($this->browse_type == 70) $headers['time_left']['reorder'] = 69;
			elseif($this->browse_type == 69) $headers['time_left']['reorder'] = 0;
			else $headers['time_left']['reorder'] = 70;
			
			$cfg['cols']['edit'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['edit'] = array(
				'css' => 'time_left_column_header',
				'text' => 'edit'
			);
			
			$cfg['cols']['delete'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['delete'] = array(
				'css' => 'time_left_column_header',
				'text' => 'delete'
			);
							
			if($this->configuration_data['popup_while_browsing']) {
				$cfg['popup'] = true;
				$cfg['popup_width'] = $this->configuration_data['popup_while_browsing_width'];
				$cfg['popup_height'] = $this->configuration_data['popup_while_browsing_height'];
			} else {
				$cfg['popup'] = false;
			}
			$cfg['icons'] = array(
				'sold' => geoTemplate::getUrl('',$this->messages[500798]),
				'buy_now' => geoTemplate::getUrl('',$this->messages[500799]),
				'reserve_met' => geoTemplate::getUrl('',$this->messages[500800]),
				'no_reserve' => geoTemplate::getUrl('',$this->messages[500802]),
			);
			
			$cfg['empty'] = '-';
			
			$tpl->addonHeaders = false;
			$tpl->cfg = $cfg;
			$tpl->headers = $headers;
			
			//now set up all the listing data
			
			//common text
			$text = array(
				'business_type' => array(
					1 => $this->messages[1405],
					2 => $this->messages[1406],
				),
				'time_left' => array(
					'weeks' => $this->messages[102539],
					'days' => $this->messages[102540],
					'hours' => $this->messages[102541],
					'minutes' => $this->messages[102542],
					'seconds' => $this->messages[102543],
					'closed' => $this->messages[100051]
				)
			);
			
			while($row = $browse_result->FetchRow()) {
				$id = $row['id']; //template expects $listings to be keyed by classified id
				
				//use the common geoBrowse class to do all the common heavy lifting
				$listings[$id] = $this->commonBrowseData($row, $text);
				
				//css is different enough to not include in the common file
				$listings[$id]['css'] = 'browsing_result_table_body_' . (($count++ % 2 == 0) ? 'even' : 'odd') . (($row['bolding']) ? '_bold' : '');
				
				//also do addons separately
				//(no addons hook here yet, but showing by way of example)
				$listings[$id]['addonData'] = false;
			}
			$tpl->listings = $listings;
	
		}
		$return = $tpl->fetch('common/listing_set.tpl');	
		return $return;
	}
}