<?php 
//browse_featured_text_ads.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################


class Browse_featured_text_ads extends geoBrowse {
	var $subcategory_array = array();
	var $notify_data = array();
	
	var $debug_featured_text = 0;

//########################################################################

	public function __construct ($db,$classified_user_id,$language_id,$category_id=0,$page=0,$filter_id=0,$state_filter=0,$zip_filter=0,$zip_filter_distance=0,$product_configuration=0)
	{
		if(!geoPC::is_ent()) return;
		if ($category_id) {
			$this->site_category = $category_id;
		} elseif ($classified_id) {
			$show = $this->get_classified_data($classified_id);
			$this->site_category = $show->CATEGORY;
		} else {
			$this->site_category = 0;
		}
		if ($limit) {
			$this->browse_limit = $limit;
		}
		
		$db = $this->db = DataAccess::getInstance();
		
		$this->get_ad_configuration($db);
		
		$this->page_result = ($page)? $page: 1;
		$this->affiliate_group_id = $affiliate_group_id;
		$this->affiliate_id = 0;
		//FIXME: State and zip filter isn't used this way any more...
		$this->state_filter = $state_filter;
		$this->zip_filter = $zip_filter;
		$this->zip_filter_distance = $zip_filter_distance;
		parent::__construct();
	}

//###########################################################

	function browse()
	{
		if(!geoPC::is_ent()) {
			return false;
		}
		
		if(!geoCategory::getBasicInfo($this->site_category)) {
			//invalid category
			$this->browse_error();
		}
		
		$db = DataAccess::getInstance();
		$this->page_id = 63;
		$this->get_text();
		
		if (geoPC::is_print() && $this->db->get_site_setting('disableAllBrowsing')) {
			//browsing disabled, do not show browsing contents
			$this->display_page();
			return true;
		}
		
		$view = geoView::getInstance();
		
		if ($this->site_category) {
			if ($this->configuration_data['display_sub_category_ads']) {
				$this->get_sql_in_statement($db,$this->site_category);
			} else {
				$this->in_statement = " in (".$this->site_category.") ";
			}
			$category_sql = ' and `category` '.$this->in_statement;
		} else {
			$category_sql = '';
		}
		$query_data = array();
		$filter_sql = $tables = '';
		if ($db->isBrowsingWhereClause()) {
			$filters = $db->getBrowsingWhereClause();
			$filter_sql .= " AND ".$filters['sql'];
			foreach ($filters['data'] as $d) {
				$query_data[] = $d;
			}
			foreach ($filters['tables'] as $table) {
				$tables .= ', '.$table;
			}
		}
		$sql = "SELECT * FROM ".geoTables::classifieds_table."$tables WHERE 
			live = 1 and (featured_ad = 1 or featured_ad_2 = 1 or featured_ad_3 = 1 or featured_ad_4 = 1 or featured_ad_5 = 1)";
		
		if($category_sql) {
			$sql .= $category_sql;
		}
		$sql .= $filter_sql;
		
		$sql_count = str_replace('*','count(id)',$sql);

		$adsPerPage = $db->get_site_setting('number_of_ads_to_display');
		
		$orderByStatement .= " order by better_placement desc,date desc limit ".(($this->page_result -1) * $adsPerPage).",".$adsPerPage;

		if(geoPC::is_classifieds()) {
			$classifieds_count_sql = $sql_count . ' and item_type = 1';
			$total_returned_ads = $db->GetOne($classifieds_count_sql, $query_data);
			$classifieds_sql = $sql." and item_type = 1 ".$orderByStatement;
			$result = $db->Execute($classifieds_sql, $query_data);
		}
		if(geoPC::is_auctions()) {
			$auctions_count_sql = $sql_count . ' and (item_type = 2 or item_type = 4)';
			$total_returned_auctions = $db->GetOne($auctions_count_sql, $query_data);
			$auctions_sql = $sql." and item_type = 2 ".$orderByStatement;
			$result_auctions = $db->Execute($auctions_sql, $query_data);
		}
		
		if (!$result && !$result_auctions) {
			//echo $db->ErrorMsg();
			echo $classifieds_sql;
			$this->error_message = '<span class="error_message">'.urldecode($this->messages[65]).'</span>';
			return false;
		}
		
		//set up total_returned as the larger of the two, so that pagination goes all the way to the end
		$total_returned = ($total_returned_ads > $total_returned_auctions) ? $total_returned_ads : $total_returned_auctions;
		
		$numPages = max(1, ceil($total_returned / $db->get_site_setting('number_of_ads_to_display')));
		if($this->page_result > $numPages) {
			//trying to access a page that doesn't exist
			//(could be a search engine crawling an outdated url)
			$this->error_message = "<span class=\"error_message\">".urldecode($this->messages[65])."</span>";
			$this->browse_error();
			return false;
		}
				
		//get this category's name
		if ($this->site_category) {
			$current_category_name = geoCategory::getName($this->site_category);
			$parent_id = $this->site_category;
		} else {
			$current_category_name = new stdClass();
			$current_category_name->CATEGORY_NAME = urldecode($this->messages[1334]);
			$parent_id = 0;
		}
		$view->current_category_name = $current_category_name->CATEGORY_NAME;
		$text = array(
			'back_to_normal_link' => $this->messages[876],
			'tree_label' => $this->messages[878],
			'main_category' => $this->messages[879],
			'no_subcats' => $this->messages[877]
		);
		$view->category_cache = $category_cache = $this->categoryBrowsing($text, 'featured_text_');
		
		if (geoPC::is_classifieds() && $result->RecordCount() > 0) {
			//featured ads
			$view->show_classifieds = true;
			$view->classified_browse_result = $this->display_browse_result($result);
		}
		if (geoPC::is_auctions() && $result_auctions->RecordCount() > 0) {
			//featured auctions
			$view->show_auctions = true;
			$view->auction_browse_result = $this->display_browse_result($result_auctions, 1);
		}
		
		if ($db->get_site_setting('number_of_ads_to_display') < $total_returned) {
			$url = $db->get_site_setting('classifieds_url')."?a=9&amp;b=".$this->site_category."&page=";
			$css = "browsing_result_page_links";
			$view->pagination = geoPagination::getHTML($numPages, $this->page_result, $url, $css);
		}

		$view->setBodyTpl('featured_text_ads.tpl', '', 'browsing');
		$this->display_page();
		return true;
	} //end of function browse

//####################################################################################

	function display_browse_result($browse_result, $auction=0)
	{
		$db = DataAccess::getInstance();
		$tpl = new geoTemplate('system','browsing');
		if($browse_result->RecordCount() < 1) {
			//no listings in this category
			if($auction) {
				$tpl->no_listings = $this->messages[100885];
			} else {
				$tpl->no_listings = $this->messages[885];
			}
		} else {
			
			$cfg = $listings = $headers = array();
			$fields = $cfg['cols'] = $this->fields->getDisplayLocationFields('browsing');
			
			//set up header view vars
			$headers['css'] = 'browsing_result_table_header';
			
			$cfg['sort_links'] = $cfg['browse_url'] = false; //can't reorder this table by clicking headers
			if ($this->affiliate_id) {
				$cfg['listing_url'] = $this->configuration_data['affiliate_url']."?aff=".$this->affiliate_id."&amp;a=2&amp;b=";
			} else {
				$cfg['listing_url'] = $db->get_site_setting('classifieds_file_name')."?a=2&amp;b=";
			}
			
			$headers['business_type'] = array(
				'css' => 'business_type_column_header',
				'text' => $this->messages[1262]			
			);
			
			//browsing by text -- no images to show
			$cfg['cols']['image'] = false;
			
			$headers['title'] = array(
				'css' => 'title_column_header',
				'text' => (($auction) ? $this->messages[100881] : $this->messages[881])
			);
			$cfg['description_under_title'] = ($fields['description'] && $this->configuration_data['display_ad_description_where']) ? true : false;
							
			$cfg['cols']['description'] = ($fields['description'] && !$cfg['description_under_title']) ? true : false;
			$headers['description'] = array(
				'css' => 'description_column_header',
				'text' =>  $this->messages[882]
			);
			
			//Listing tags column
			$cfg['cols']['tags'] = ($fields['tags'])? true : false;
			$headers['tags'] = array(
				'css' => 'tags_column_header',
				'text' =>  $this->messages[500877]
			);
								
			for($i = 1; $i <= 20; $i++) {
				if (geoPC::is_ent() && $fields['optional_field_'.$i]) {
					$cfg['cols']['optionals'][$i] = true;
					$headers['optionals'][$i] = array(
						'css' => 'optional_field_header_'.$i,
						'text' => (($i <= 10) ? $this->messages[958+$i] : $this->messages[1846+$i]) 
					);
				} else {
					$cfg['cols']['optionals'][$i] = false;
				}
			}
			
			$headers['city'] = array(
				'css' => 'city_column_header',
				'text' => $this->messages[1407]
			);
			
			$headers['state'] = array(
				'css' => 'state_column_header',
				'text' => $this->messages[1408]
			);
			
			$headers['country'] = array(
				'css' => 'country_column_header',
				'text' => $this->messages[1409]
			);
			
			$headers['zip'] = array(
				'css' => 'zip_column_header',
				'text' => $this->messages[1410]
			);
			
			$headers['price'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[883]
			);

			$cfg['cols']['num_bids'] = ($auction) ? $cfg['cols']['num_bids'] : false;
			$headers['num_bids'] = array(
				'css' => 'number_bids_header',
				'text' => $this->messages[102529]
			);
			
			$cfg['cols']['entry_date'] = ((!$auction && $fields['classified_start']) || ($auction && $fields['auction_start'])) ? true : false;
			$headers['entry_date'] = array(
				'css' => 'entry_date_column_header',
				'text' => $this->messages[884]
			);
			
			$cfg['cols']['time_left'] = ((!$auction && $fields['classified_time_left']) || ($auction && $fields['auction_time_left'])) ? true : false;
			$headers['time_left'] = array(
				'css' => 'time_left_column_header',
				'text' => $this->messages[102530]
			);
			
			$cfg['cols']['edit'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['edit'] = array(
				'css' => 'time_left_column_header',
				'text' => 'edit'
			);
			
			$cfg['cols']['delete'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['delete'] = array(
				'css' => 'time_left_column_header',
				'text' => 'delete'
			);
							
			if($this->configuration_data['popup_while_browsing']) {
				$cfg['popup'] = true;
				$cfg['popup_width'] = $this->configuration_data['popup_while_browsing_width'];
				$cfg['popup_height'] = $this->configuration_data['popup_while_browsing_height'];
			} else {
				$cfg['popup'] = false;
			}
			$cfg['icons'] = array(
				'sold' => geoTemplate::getUrl('',$this->messages[500798]),
				'buy_now' => geoTemplate::getUrl('',$this->messages[500799]),
				'reserve_met' => geoTemplate::getUrl('',$this->messages[500800]),
				'no_reserve' => geoTemplate::getUrl('',$this->messages[500802]),
			);
			
			$cfg['empty'] = '-';
			
			$tpl->addonHeaders = false;
			$tpl->cfg = $cfg;
			$tpl->headers = $headers;
			
			//now set up all the listing data

			//common text
			$text = array(
				//the rest of the code for business_type is here, but the text entries are missing...
				'business_type' => array(
					1 => '',
					2 => ''
				),
				'time_left' => array(
					'weeks' => $this->messages[102532],
					'days' => $this->messages[102533],
					'hours' => $this->messages[102534],
					'minutes' => $this->messages[102535],
					'seconds' => $this->messages[102535],
					'closed' => $this->messages[100053]
				)
			);
			
			while($row = $browse_result->FetchRow()) {
				$id = $row['id']; //template expects $listings to be keyed by classified id
				
				//use the common geoBrowse class to do all the common heavy lifting
				$listings[$id] = $this->commonBrowseData($row, $text);
				
				//css is different enough to not include in the common file
				$listings[$id]['css'] = 'browsing_result_table_body_' . (($count++ % 2 == 0) ? 'even' : 'odd') . (($row['bolding']) ? '_bold' : '');
				
				//also do addons separately
				//(no addons hook here yet, but showing by way of example)
				$listings[$id]['addonData'] = false;
			}
			$tpl->listings = $listings;
	
		}
		$return = $tpl->fetch('common/listing_set.tpl');	
		return $return;
	}

}