<?php 
//browse_displays_sellers_ads.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21219              $ ##
## File last change date:       ##
##  $Date:: 2011-03-25 10:49:#$ ##
##                              ##
##################################

class Browse_display_sellers_ads extends geoBrowse {
	var $subcategory_array = array();
	var $notify_data = array();
	var $seller_id = 0;

//########################################################################

	public function __construct ($db,$classified_user_id,$language_id,$category_id=0,$page=0,$seller_id=0,$product_configuration=0)
	{
		if ($category_id) {
			$this->site_category = $category_id;
		} else if ($classified_id) {
			$show = $this->get_classified_data($classified_id);
			$this->site_category = $show->CATEGORY;
		} else {
			$this->site_category = 0;
		}
		if ($limit) {
			$this->browse_limit = $limit;
		}
		
		$db = $this->db = DataAccess::getInstance();
		
		$this->get_ad_configuration($db);
		
		$this->page_result = ($page)? $page: 1;
		$this->seller_id = $seller_id;
		parent::__construct();
	} //end of function Browse_display_sellers_ads

//###########################################################

	function browse()
	{
		$this->page_id = 55;
		$this->get_text();
		$view = geoView::getInstance();
		$tpl_vars = array();
		
		//browse the auctions in this category that are open

		$seller = geoUser::getUser($this->seller_id);
		
		//make seller username available as main template variable
		$tpl_vars['username'] = $view->seller_username = $seller->username;
		//$seller_data = $this->get_user_data($this->seller_id);

		$exposed = array();
		
		if($seller->expose_email) {
			$exposed[] = array(
				'label' => $this->messages[1575],
				'value' => $seller->email
			);
		}
		
		if($seller->expose_company_name) {
			$exposed[] = array(
				'label' => $this->messages[1576],
				'value' => $seller->company_name
			);
		}
		
		if($seller->expose_firstname || $seller->expose_lastname) {
			$exposed[] = array(
				'label' => $this->messages[1577],
				'value' => $seller->firstname .' '. $seller->lastname
			);
		}
		
		if($seller->expose_address) {
			$exposed[] = array(
				'label' => $this->messages[1579],
				'value' => $seller->address
			);
		}
		
		$location = '';
		if($seller->expose_city) {
			$location .= $seller->city;
		}
		if($seller->expose_state) {
			$location .= ' '.$seller->state;
		}
		if($seller->expose_zip) {
			$location .= ' '.$seller->zip;
		}
		$location = trim($location);
		if(strlen($location)) {
			$exposed[] = array(
				'label' => $this->messages[1580],
				'value' => $location
			);
		}
		
		if($seller->expose_country) {
			$exposed[] = array(
				'label' => $this->messages[1582],
				'value' => $seller->country
			);
		}
		
		if($seller->expose_phone) {
			$exposed[] = array(
				'label' => $this->messages[1584],
				'value' => $seller->phone
			);
		}
		
		if($seller->expose_phone2) {
			$exposed[] = array(
				'label' => $this->messages[1585],
				'value' => $seller->phone2
			);
		}
		
		if($seller->expose_fax) {
			$exposed[] = array(
				'label' => $this->messages[1586],
				'value' => $seller->fax
			);
		}
		
		if($seller->expose_url) {
			$exposed[] = array(
				'label' => $this->messages[1587],
				'value' => $seller->url
			);
		}
		
		//REGISTRATION optional fields (only 10 instead of 20)
		for($i=1; $i<=10; $i++) {
			$exp = 'expose_optional_'.$i;
			$data = 'optional_field_'.$i;
			if($seller->$exp) {
				$exposed[] = array(
					'label' => $this->messages[1587+$i],
					'value' => $seller->$data
				); 
			}
		}
		
		$tpl_vars['exposed'] = $exposed;

		$db = DataAccess::getInstance();
		
		$sql_count = "select count(id) as total from ".geoTables::classifieds_table." where	seller = ".$this->seller_id." and live = 1";
		$sql = "select * from ".geoTables::classifieds_table." where
			seller = ".$this->seller_id." and live = 1
			order by better_placement desc,date desc 
			limit ".(($this->page_result - 1) * $this->configuration_data['number_of_ads_to_display']).",".$this->configuration_data['number_of_ads_to_display'];
		
		$result = $db->Execute($sql);
		if (!$result) {
			return false;
		}
		
		$total_returned = $db->GetOne($sql_count);
		$numPages = max(1, ceil($total_returned / $this->configuration_data['number_of_ads_to_display']));
		if($this->page_result > $numPages) {
			//trying to access a page that doesn't exist
			//(could be a search engine crawling an outdated url)
			$this->error_message = "<span class=\"error_message\">".urldecode($this->messages[65])."</span>";
			$this->browse_error();
			return false;
		}
		
		//display_browse_result sets up its vars in the view class, but leaves it to this function to actually display stuff
		$this->display_browse_result($result);
			
			
		if ($this->configuration_data['number_of_ads_to_display'] < $total_returned)
		{
			

			$tpl_vars['current_page'] = $this->page_result;
			$tpl_vars['total_pages'] = $numPages;

			$url = $this->configuration_data['classifieds_url']."?a=6&amp;b=".$this->seller_id."&amp;page=";
			$css = "sellers_ads_more_results";
			$tpl_vars['pagination'] = geoPagination::getHTML($numPages, $this->page_result, $url, $css);
		} else {
			$tpl_vars['pagination'] = false;
		}
		
		$view->setBodyTpl('sellers_other_ads.tpl','','browsing')->setBodyVar($tpl_vars);
		$this->display_page();
		return true;
	}

//####################################################################################

	function display_browse_result($browse_result)
	{
		$db = DataAccess::getInstance();
		$view = geoView::getInstance();
		
		if($browse_result->RecordCount() < 1) {
			$view->no_listings = $this->messages[751];
		} else {
			
			$cfg = $listings = $headers = array();
			//use main browsing display settings for now
			$fields = $this->fields->getDisplayLocationFields('browsing');
			
			//set up header view vars
			$headers['css'] = 'seller_result_table_header';
			
			$cfg['sort_links'] = $cfg['browse_url'] = false; //can't reorder this table by clicking headers
			if ($this->affiliate_id) {
				$cfg['listing_url'] = $this->configuration_data['affiliate_url']."?aff=".$this->affiliate_id."&amp;a=2&amp;b=";
			} else {
				$cfg['listing_url'] = $db->get_site_setting('classifieds_file_name')."?a=2&amp;b=";
			}
			
			$cfg['cols']['type'] = (geoPC::is_class_auctions() && $db->get_site_setting('listing_type_allowed') == 0) ? true : false;
			$headers['type'] = array(
				'css' => 'seller_title_column_header',
				'text' => $this->messages[200008]			
			);
			
			$cfg['cols']['image'] = ($fields['photo']) ? true : false;
			$headers['image'] = array(
				'css' => 'seller_photo_column_header',
				'text' => $this->messages[753]
			);
			
			$cfg['cols']['title'] = ($fields['title']) ? true : false;
			$headers['title'] = array(
				'css' => 'seller_title_column_header',
				'text' => $this->messages[752]
			);
			$cfg['description_under_title'] = ($fields['description'] && $this->configuration_data['display_ad_description_where']) ? true : false;
			
			$cfg['cols']['description'] = ($fields['description'] && !$cfg['description_under_title']) ? true : false;
			$headers['description'] = array(
				'css' => 'seller_description_column_header',
				'text' => (($cfg['description_under_title']) ? $this->messages[21] : $this->messages[754])
			);
			
			//Listing tags column
			$cfg['cols']['tags'] = ($fields['tags'])? true : false;
			$headers['tags'] = array(
				'css' => 'tags_column_header',
				'text' =>  $this->messages[500876]
			);
			
			for ($i = 1; $i <= 20; $i++) {
				if (geoPC::is_ent() && $fields['optional_field_'.$i]) {
					$cfg['cols']['optionals'][$i] = true;
					$headers['optionals'][$i] = array(
						'css' => 'optional_field_header_'.$i,
						'text' => (($i <= 10) ? $this->messages[1048+$i] : $this->messages[1705+$i]) 
					);
				} else {
					$cfg['cols']['optionals'][$i] = false;
				}
			}
			
			$cfg['cols']['address'] = false;
			
			$cfg['cols']['city'] = ($fields['city']) ? true : false;
			$headers['city'] = array(
				'css' => 'city_column_header',
				'text' => $this->messages[1415]
			);
			
			$cfg['cols']['state'] = ($fields['state']) ? true : false;
			$headers['state'] = array(
				'css' => 'state_column_header',
				'text' => $this->messages[1416]
			);
			
			$cfg['cols']['country'] = ($fields['country']) ? true : false;
			$headers['country'] = array(
				'css' => 'country_column_header',
				'text' => $this->messages[1417]
			);
			
			$cfg['cols']['zip'] = ($fields['zip']) ? true : false;
			$headers['zip'] = array(
				'css' => 'zip_column_header',
				'text' => $this->messages[1418]
			);
			
			$cfg['cols']['price'] = ($fields['price']) ? true : false;
			$headers['price'] = array(
				'css' => 'seller_price_column_header',
				'text' => $this->messages[755]
			);
			
			$cfg['cols']['num_bids'] = false; //num_bids not shown here
			
			$cfg['cols']['entry_date'] = ((geoPC::is_classifieds() && $fields['classified_start']) || (geoPC::is_auctions() && $fields['auction_start'])) ? true : false;
			$headers['entry_date'] = array(
				'css' => 'seller_entry_date_column_header',
				'text' => $this->messages[756]
			);
			
			$cfg['cols']['time_left'] = ((geoPC::is_classifieds() && $fields['classified_time_left']) || (geoPC::is_auctions() && $fields['auction_time_left'])) ? true : false;
			$headers['time_left'] = array(
				'css' => 'seller_time_left_column_header',
				'text' => $this->messages[102546]
			);
			
			$cfg['cols']['edit'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['edit'] = array(
				'css' => 'seller_time_left_column_header',
				'text' => 'edit'
			);
			
			$cfg['cols']['delete'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['delete'] = array(
				'css' => 'seller_time_left_column_header',
				'text' => 'delete'
			);
			
			//a couple last-minute config settings before we go ahead and give $cfg to the view class
			if($this->configuration_data['popup_while_browsing']) {
				$cfg['popup'] = true;
				$cfg['popup_width'] = $this->configuration_data['popup_while_browsing_width'];
				$cfg['popup_height'] = $this->configuration_data['popup_while_browsing_height'];
			} else {
				$cfg['popup'] = false;
			}
			
			$cfg['icons'] = array(
				'sold' => geoTemplate::getUrl('',$this->messages[500798]),
				'buy_now' => geoTemplate::getUrl('',$this->messages[500799]),
				'reserve_met' => geoTemplate::getUrl('',$this->messages[500800]),
				'no_reserve' => geoTemplate::getUrl('',$this->messages[500802]),
			);
			
			$cfg['empty'] = '-';
			
			$view->addonHeaders = false; //TODO (maybe): add addon hooks from normal browsing to here
			$view->cfg = $cfg;
			$view->headers = $headers;
			
			//now set up all the listing data
			
			//common text
			$text = array(
				'item_type' => array(
					'classified' => $this->messages[200010],
					'auction' => $this->messages[200009]
				),
				'time_left' => array(
					'weeks' => $this->messages[3284],
					'days' => $this->messages[3285],
					'hours' => $this->messages[3286],
					'minutes' => $this->messages[3287],
					'seconds' => $this->messages[3288],
					'closed' => $this->messages[100051]
				)
			);
			
			$listings = array();
			$count = 0;
			
			while($row = $browse_result->FetchRow()) {
				$id = $row['id']; //template expects $listings to be keyed by classified id
				
				//use the common geoBrowse class to do all the common heavy lifting
				$listings[$id] = $this->commonBrowseData($row, $text);
				
				//css is different enough to not include in the common file
				$listings[$id]['css'] = 'seller_result_table_body_' . (($count++ % 2 == 0) ? 'even' : 'odd') . (($row['bolding']) ? '_bold' : '');
				
				//also do addons separately
				//(no addons hook here yet, but showing by way of example)
				$listings[$id]['addonData'] = false;
				
				
			}
			$view->listings = $listings;
		}
	}
}