<?php
//browse_ads.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

class Browse_ads extends geoBrowse {
	var $config = array();
	private static $listing_config = array();
	var $subcategory_array = array();
	var $notify_data = array();
	var $debug_browse = 0;
	var $lcv = 0;
	var $browsing_options = array();
	private $sql;
	private $filters;
	private $query_data = array();
	private static $smarty_object_are_registered;
	
	
	public function __construct ($classified_user_id = 0,$language_id,$category_id=0,$page=0,$classified_id=0)
	{
		$db = $this->db = DataAccess::getInstance();
		$user_id = geoSession::getInstance()->getUserId();
		if ($category_id) {
			$this->site_category = $category_id;
		} elseif ($classified_id) {
			$show =& $this->get_classified_data($classified_id);
			$this->site_category = $show->CATEGORY;
		} else {
			$this->site_category = 0;
		}
		if (isset($limit)) {
			$this->browse_limit = $limit;
		}
		
		if ($page) {
			$this->page_result = $page;
		} else {
			$this->page_result = 1;
		}
		
		
		if(isset($_REQUEST['o']) && is_numeric($_REQUEST['o'])) {
			$this->browsing_options['choice'] = $_REQUEST['o'];
		}
		
		parent::__construct();
	}

	
	/**
	 * Displays a category's listings
	 * @param int $browse_type The numeric category ID
	 */
	function browseCategory($browse_type=0)
	{
		$this->page_id = 3;
		$this->get_text();
		$browseType = array();
		
		if (geoPC::is_print() && $this->db->get_site_setting('disableAllBrowsing')) {
			//browsing disabled, do not show browsing contents
			$this->display_page();
			return true;
		}
		
		if($browse_type) {
			$browseType["param"] = $browse_type;
		}
		
		$db = DataAccess::getInstance();
		$view = geoView::getInstance();

		if (!$this->site_category) {
			if (!$this->browse_main()) {
				$this->error_message = "<span class=\"error_message\">".urldecode($this->messages[65])."</span>";
				return false;
			}
			return true;	
		}
		// site_category is just the ID of whatever category the user wants to view
		
		if(!geoCategory::getBasicInfo($this->site_category)) {
			//user put in an invalid category id
			//(probably an outdated link from a search engine to a deleted category)
			//show the home page
			$this->error_message = "<span class=\"error_message\">".urldecode($this->messages[65])."</span>";
			$this->browse_error();
			return false;
		}
	
		if ($this->db->get_site_setting('display_sub_category_ads')) {
			$this->get_sql_in_statement($db,$this->site_category);
		} else {
			$this->in_statement = " in (".$this->site_category.") ";
		}
		
		// $browseType["param"] holds the value of the $browse_type parameter of this function
		if ($browseType["param"] == 0) {
			if (geoPC::is_ent()) {
				//the default display order can be set on a category by category basis
				$sql = "select * from ".geoTables::categories_table." where category_id = ?";
				$category_order_result = $db->Execute($sql, array($this->site_category));
				if (!$category_order_result) {
					return false;
				} elseif ($category_order_result->RecordCount() == 1) {
					$show_category_default = $category_order_result->FetchRow();
		
					if (($show_category_default["default_display_order_while_browsing_category"]) && ($show_category_default["use_site_default"] == 1)) {
						$browseType["category"] = $show_category_default["default_display_order_while_browsing_category"];
					}
				}
			}
			if($db->get_site_setting('default_display_order_while_browsing') != -1) {
				//this setting used if site has been updated from pre-3.1, but admin hasn't set the class/auc-specific settings yet
				$browseType["legacy"] = $this->db->get_site_setting('default_display_order_while_browsing'); 	
			} else {
				$browseType["classified"] = $this->db->get_site_setting('default_classified_order_while_browsing');
				$browseType["auction"] = $this->db->get_site_setting('default_auction_order_while_browsing');
			}
		}
		
		$orderBy = array();
		foreach($browseType as $key => $value) {
			$orderBy[$key] = $this->getOrderByString($value);
		}
		$tables = '';
		if ($db->isBrowsingWhereClause()) {
			$this->filters = $db->getBrowsingWhereClause();
			
			foreach ($this->filters['tables'] as $table) {
				if ($table) $tables .= ', '.$table;
			}
		}
		$sql = "SELECT * FROM ".geoTables::classifieds_table."$tables
					  WHERE category ".$this->in_statement." and live = 1 ";
				
		$sql .= $this->_setBrowsingOptions();
		
		$query_data = array();
		if ($this->filters) {
			$sql .= " AND ".$this->filters['sql'];
			foreach ($this->filters['data'] as $d) {
				$query_data[] = $d;
			}
		}
				
		//set up display order
		$this->browse_type = (isset($browseType["param"]))? $browseType["param"]: 0;
		
		if(isset($orderBy["param"]) && strlen(trim($orderBy["param"])) > 0) { 
			//if function is called with a parameter
			$classifieds_order = $auctions_order = $orderBy["param"];
		} else if (isset($orderBy["category"]) && $orderBy["category"] && ($show_category_default["use_site_default"] == 1) && geoPC::is_ent()){
			//if we're supposed to be following a specific category's settings
			$classifieds_order = $auctions_order = $orderBy["category"];
		} else if(isset($orderBy["legacy"]) && $orderBy["legacy"]) {
			//if site admin has not yet run admin > browse form, we are in legacy display mode
			$classifieds_order = $auctions_order = $orderBy["legacy"];
		} else {
			//follow site defaults
			$classifieds_order = $orderBy["classified"];
			$auctions_order = $orderBy["auction"];
		}
		
		//how many ads to show on this page?
		$adsToShow = $db->get_site_setting('number_of_ads_to_display');
		$limit .= " limit ".(($this->page_result -1) * $adsToShow).",".$adsToShow;
		
		//query for counting is a bit different
		$sql_count = str_replace('*', 'count(id)', $sql);

		//set up to grab featured listings
		if (($this->db->get_site_setting('use_featured_feature')) && ($this->page_result == 1) && ($this->db->get_site_setting('number_of_featured_ads_to_display'))) {
			$show_featured = true;
			$seed = rand();
			$featured_where = ' and (featured_ad = 1 or featured_ad_2 = 1 or featured_ad_3 = 1 or featured_ad_4 = 1 or featured_ad_5 = 1) ';
			$featured_order = ' order by rand('.$seed.') ';
			$featured_limit = ' limit '.$db->get_site_setting('number_of_featured_ads_to_display');
		} else {
			$show_featured = false;
		}

		//figure out whether to show classifieds, auctions, or both
		$opt_type = $this->browsing_options['type']; //from browsing options module
		$config_type = $this->configuration_data['listing_type_allowed']; //from site (or category) config
		$show_auctions = (!geoPC::is_auctions() || $opt_type == 1 || $config_type == 1) ? false : true;
		$show_classifieds = (!geoPC::is_classifieds() || $opt_type == 2 || $opt_type == 4 || $config_type == 2) ? false : true;
				
		if($show_classifieds) {
			$classifieds_count_sql = $sql_count . ' and item_type = 1';
			$total_returned_ads = $db->GetOne($classifieds_count_sql, $query_data);
			$classifieds_sql = $sql." and item_type = 1 ".$classifieds_order.$limit;
			$result = $db->Execute($classifieds_sql, $query_data);
			if($show_featured) {
				$featured_classifieds_sql = $sql.' and item_type = 1 '.$featured_where.$featured_order.$featured_limit;
				$featured_classifieds_result = $db->Execute($featured_classifieds_sql, $query_data);
				if($featured_classifieds_result->RecordCount() > 0) {
					$view->show_featured_classifieds = true;		
				}
			}
		}
		if($show_auctions) {
			$auctions_count_sql = $sql_count . ' and (item_type = 2 or item_type = 4)';
			$total_returned_auctions = $db->GetOne($auctions_count_sql, $query_data);
			$auctions_sql = $sql." and (item_type = 2 or item_type = 4) ".$auctions_order.$limit;
			$result_auctions = $db->Execute($auctions_sql, $query_data);
			if($show_featured) {
				$featured_auctions_sql = $sql.' and (item_type = 2 or item_type = 4) '.$featured_where.$featured_order.$featured_limit;
				$featured_auctions_result = $db->Execute($featured_auctions_sql, $query_data);
				if($featured_auctions_result->RecordCount() > 0) {
					$view->show_featured_auctions = true;		
				}		
			}
		}

		if (!$result && !$result_auctions) {
			$this->error_message = '<span class="error_message">'.urldecode($this->messages[65]).'</span>';
			return false;
		}
		
		if(!$db->get_site_setting('display_sub_category_ads') && $db->get_site_setting('place_ads_only_in_terminal_categories')) {
			//if ads can only be placed in terminal categories, and upper-level categories don't show ads in child categories
			//check to make sure there aren't any ads errantly in this category, and if there are none, don't display any of the headers having to do
			//with there being ads in this category (since there are no ads to show in this category)
			if($total_returned_ads == 0) {
				$show_classifieds = false;
			}
			if($total_returned_auctions == 0) {
				$show_auctions = false;
			}
		}
		
		//set up total_returned as the larger of the two, so that pagination goes all the way to the end
		$total_returned = ($total_returned_ads > $total_returned_auctions) ? $total_returned_ads : $total_returned_auctions;
		
		//total number of pages to make available
		$numPages = max(1, ceil($total_returned / $adsToShow));
		if($this->page_result > $numPages) {
			//trying to access a page that doesn't exist
			//(could be a search engine crawling an outdated url)
			$this->error_message = "<span class=\"error_message\">".urldecode($this->messages[65])."</span>";
			$this->browse_error();
			return false;
		}
		
		$view->options_qs = $this->browsing_options['query_string']; //o= parameter of links that need to preserve browsing module setting 
		
		//get this category's name
		if ($this->site_category) {
			$current_category_name = geoCategory::getName($this->site_category);
			$parent_id = $this->site_category;
		}
		
		$view->current_category_name = $current_category_name->CATEGORY_NAME;
		$view->category_id = $this->site_category;

		$view->category_cache = $this->categoryBrowsing();
		
		$view->featured_links = (geoPC::is_ent()) ? true : false;
		
		if ($show_classifieds) {
			$view->show_classifieds = true;
			if($show_featured) {
				$view->featured_classifieds = $this->display_browse_result($featured_classifieds_result, 0, 1);
			}
			$view->classified_browse_result = $this->display_browse_result($result, 0, 0);
		}
		if ($show_auctions) {
			$view->show_auctions = true;
			if($show_featured) {
				$view->featured_auctions = $this->display_browse_result($featured_auctions_result, 1, 1);
			}
			$view->auction_browse_result = $this->display_browse_result($result_auctions, 1, 0);
		}
		
		if ($adsToShow < $total_returned) {
			
			
			if($browseType['param']) {
				$c = $browseType['param'];
			} elseif ($browseType['category']) {
				$c = $browseType['category'];
			} else {
				$c = 0;
			}
			
			$url = $db->get_site_setting('classifieds_file_name')."?a=5&amp;b=".$this->site_category.$this->browsing_options['query_string']."&amp;c=".$c."&amp;page=";
			$css = "browsing_result_page_links";
			$view->pagination = geoPagination::getHTML($numPages, $this->page_result, $url, $css);
		}
		
		if ($this->page_result > 1) {
			//see if there is template for 3_secondary
			$tpl = $view->getTemplateAttachment('3_secondary', $this->language_id, $this->site_category, false);
			if (strlen($tpl)) {
				//there is a 3_secondary template to use, use that instead of one 
				//assigned for page 3
				$this->page_id = '3_secondary';
			}
		}
		
		$view->setBodyTpl('main.tpl', '', 'browsing');
		$this->display_page();
		return true;
		
		
	}
	
	public function _setBrowsingOptions()
	{
		$choice_option = (isset($this->browsing_options['choice']))? $this->browsing_options['choice']: 0;
		
		switch($choice_option) {
			//add appropriate conditions to sql for option selected from category_browsing_options module
			//$this->browsing_options['query_string'] holds the value to add to querystring of links on the page to perpetuate the selection
			//$this->browsing_options['type']: 1 for classifieds, 2 for auctions, 0 for both
			case 1:
				//listings ending in next 24 hours
				$this->browsing_options['sql'] = " and ends < " . (geoUtil::time() + 86400) . " ";
				$this->browsing_options['query_string'] = "&amp;o=1";
				$this->browsing_options['type'] = 0;
				break;
			case 2:
				//auctions using buy now
				if(geoPC::is_auctions()) {
					$this->browsing_options['sql'] = " and buy_now > 0 ";
					$this->browsing_options['query_string'] = "&amp;o=2";
					$this->browsing_options['type'] = 2;
				}
				break;
			case 3:
				//auctions using buy now only
				if(geoPC::is_auctions())
				{
					$this->browsing_options['sql'] = " and buy_now_only != 0 ";
					$this->browsing_options['query_string'] = "&amp;o=3";
					$this->browsing_options['type'] = 2;
				}
				break;
			case 4:
				//auctions with bids
				if(geoPC::is_auctions()) {
					$this->browsing_options['sql'] = " and minimum_bid > starting_bid ";
					$this->browsing_options['query_string'] = "&amp;o=4";
					$this->browsing_options['type'] = 2;
				}
				break;
			case 5:
				//auctions without bids
				if(geoPC::is_auctions()) {
					$this->browsing_options['sql'] = " and minimum_bid = starting_bid ";
					$this->browsing_options['query_string'] = "&amp;o=5";
					$this->browsing_options['type'] = 2;
				}
				break;
			case 6:
				//listings with pictures
				$this->browsing_options['sql'] = " and image > 0 ";
				$this->browsing_options['query_string'] = "&amp;o=6";
				$this->browsing_options['type'] = 0;
				break;
			case 7:
				//browse by classifieds only (CA-only feature)
				if(geoPC::is_class_auctions())
				{
					$this->browsing_options['sql'] = "";
					$this->browsing_options['query_string'] = "&amp;o=7";
					$this->browsing_options['type'] = 1;
				}
				break;
			case 8:
				//browse by auctions only (CA-only feature)
				if(geoPC::is_class_auctions()) {
					$this->browsing_options['sql'] = "";
					$this->browsing_options['query_string'] = "&amp;o=8";
					$this->browsing_options['type'] = 2;
				}
				break;
			case 9:
				//browse by auctions only (CA-only feature)
				if(geoPC::is_class_auctions()) {
					$this->browsing_options['sql'] = "";
					$this->browsing_options['query_string'] = "&amp;o=9";
					$this->browsing_options['type'] = 4;
				}
				break;
			default:
				$this->browsing_options['sql'] = "";
				$this->browsing_options['query_string'] = "";
				$this->browsing_options['type'] = 0;

		}
		
		if(strlen($this->browsing_options['sql']) > 0) {
			return $this->browsing_options['sql'];
		}
		
	}

	public function display_browse_result($browse_result, $auction=0, $featured=0)
	{
		$this_copy =& $this;
		$overload = geoAddon::triggerDisplay('overload_Browse_ads_display_browse_result', array ('browse_result'=>$browse_result, 'header_css' => $header_css, 'featured' => $featured, 'auction' => $auction, 'this' => $this_copy), geoAddon::OVERLOAD);
		if ($overload !== geoAddon::NO_OVERLOAD) {
			return $overload;
		}
		
		$db = DataAccess::getInstance();
		$tpl = new geoTemplate('system','browsing');
		if ($browse_result->RecordCount() < 1) {
			//no listings in this category
			if($auction) {
				$tpl->no_listings = $this->messages[100017];
			} else {
				$tpl->no_listings = $this->messages[17];
			}
		} else {
			$cfg = $listings = $headers = array();
			
			$fields = $this->fields->getDisplayLocationFields('browsing');
			
			//set up header view vars
			$headers['css'] = 'browsing_result_table_header';
			
			$cfg['sort_links'] = true;
			$cfg['browse_url'] = $db->get_site_setting('classifieds_file_name')."?a=5&amp;b=".$this->site_category.$this->browsing_options['query_string']."&amp;c=";
			$cfg['listing_url'] = $db->get_site_setting('classifieds_file_name')."?a=2&amp;b=";
			
			$cfg['cols']['business_type'] = ($fields['business_type']) ? true : false;
			$headers['business_type'] = array(
				'css' => 'business_type_column_header',
				'text' => $this->messages[1262]		
			);
			if($this->browse_type == 43) $headers['business_type']['reorder'] = 44;
			elseif($this->browse_type == 44) $headers['business_type']['reorder'] = 0;
			else $headers['business_type']['reorder'] = 43;
			
			$cfg['cols']['image'] = ($fields['photo']) ? true : false;
			$headers['image'] = array(
				'css' => 'photo_column_header',
				'text' => $this->messages[23]	
			);
			
			$cfg['cols']['title'] = ($fields['title']) ? true : false;
			$headers['title'] = array(
				'css' => 'title_column_header',
				'text' => $this->messages[19]
			);
			if($this->browse_type == 5) $headers['title']['reorder'] = 6;
			elseif($this->browse_type == 6) $headers['title']['reorder'] = 0;
			else $headers['title']['reorder'] = 5;
			$cfg['description_under_title'] = ($fields['description'] && $this->configuration_data['display_ad_description_where']) ? true : false;

			$cfg['cols']['description'] = ($fields['description'] && !$cfg['description_under_title']) ? true : false;
			$headers['description'] = array(
				'css' => 'description_column_header',
				'text' =>  $this->messages[21]
			);
			
			//Listing tags column
			$cfg['cols']['tags'] = ($fields['tags'])? true : false;
			$headers['tags'] = array(
				'css' => 'tags_column_header',
				'text' =>  $this->messages[500875]
			);
			
			for($i = 1; $i <= 20; $i++) {
				if(geoPC::is_ent() && $fields['optional_field_'.$i]) {
					$cfg['cols']['optionals'][$i] = true;
					$headers['optionals'][$i] = array(
						'css' => 'optional_field_header_'.$i,
						'text' => (($i <= 10) ? $this->messages[921+$i] : $this->messages[1685+$i]) 
					);
					$browse1 = ($i <= 10) ? ( 2 * ($i-1) + 15 ) : ( 2 * ($i-11) + 45 ) ; //15, 17, 19, ... : 45, 47, 49, ...
					$browse2 = $browse1 + 1;
					if($this->browse_type == $browse1) $headers['optionals'][$i]['reorder'] = $browse2;
					elseif($this->browse_type == $browse2) $headers['optionals'][$i]['reorder'] = 0;
					else $headers['optionals'][$i]['reorder'] = $browse1;
				} else {
					$cfg['cols']['optionals'][$i] = false;
				}
			}
			
			$cfg['cols']['address'] = ($fields['address']) ? true : false;
			$headers['address'] = array(
				'css' => 'address_column_header',
				'text' => $this->messages[500167]
			);
			
			$cfg['cols']['city'] = ($fields['city']) ? true : false;
			$headers['city'] = array(
				'css' => 'city_column_header',
				'text' => $this->messages[1199]
			);
			if($this->browse_type == 35) $headers['city']['reorder'] = 36;
			elseif($this->browse_type == 36) $headers['city']['reorder'] = 0;
			else $headers['city']['reorder'] = 35;
			
			$cfg['cols']['state'] = ($fields['state']) ? true : false;
			$headers['state'] = array(
				'css' => 'state_column_header',
				'text' => $this->messages[1200]
			);
			if($this->browse_type == 37) $headers['state']['reorder'] = 38;
			elseif($this->browse_type == 38) $headers['state']['reorder'] = 0;
			else $headers['state']['reorder'] = 37;
			
			$cfg['cols']['country'] = ($fields['country']) ? true : false;
			$headers['country'] = array(
				'css' => 'country_column_header',
				'text' => $this->messages[1201]
			);
			if($this->browse_type == 39) $headers['country']['reorder'] = 40;
			elseif($this->browse_type == 40) $headers['country']['reorder'] = 0;
			else $headers['country']['reorder'] = 39;
			
			$cfg['cols']['zip'] = ($fields['zip']) ? true : false;
			$headers['zip'] = array(
				'css' => 'zip_column_header',
				'text' => $this->messages[1202]
			);
			if($this->browse_type == 41) $headers['zip']['reorder'] = 42;
			elseif($this->browse_type == 42) $headers['zip']['reorder'] = 0;
			else $headers['zip']['reorder'] = 41;
					
			$cfg['cols']['price'] = ($fields['price']) ? true : false;
			$headers['price'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[27]
			);
			if($this->browse_type == 1) $headers['price']['reorder'] = 2;
			elseif($this->browse_type == 2) $headers['price']['reorder'] = 0;
			else $headers['price']['reorder'] = 1;
							

			$cfg['cols']['num_bids'] = ($auction && $fields['num_bids']) ? true : false;
			$headers['num_bids'] = array(
				'css' => 'number_bids_header',
				'text' => $this->messages[103041]
			);
			
		
			$cfg['cols']['entry_date'] = ((!$auction && $fields['classified_start']) || ($auction && $fields['auction_start'])) ? true : false;
			$headers['entry_date'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[22]
			);
			if($this->browse_type == 68) $headers['entry_date']['reorder'] = 67;
			elseif($this->browse_type == 67) $headers['entry_date']['reorder'] = 0;
			else $headers['entry_date']['reorder'] = 68;
			
			$cfg['cols']['time_left'] = ((!$auction && $fields['classified_time_left']) || ($auction && $fields['auction_time_left'])) ? true : false;
			$headers['time_left'] = array(
				'css' => 'price_column_header',
				'text' => $this->messages[103008]
			);
			if($this->browse_type == 70) $headers['time_left']['reorder'] = 69;
			elseif($this->browse_type == 69) $headers['time_left']['reorder'] = 0;
			else $headers['time_left']['reorder'] = 70;
			
			$cfg['cols']['edit'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_edit', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['edit'] = array(
				'css' => 'price_column_header',
				'text' => 'edit'
			);
			
			$cfg['cols']['delete'] = (geoSession::getInstance()->getUserID() == 1 || geoAddon::triggerDisplay('auth_listing_delete', true, geoAddon::NOT_NULL)) ? true : false;
			$headers['delete'] = array(
				'css' => 'price_column_header',
				'text' => 'delete'
			);

			/**
			 * Addon core event:
			 * name: Browse_ads_display_browse_result_addHeader
			 * vars: array (this => Object) (this is the instance of $this.
			 * return: array (class => string (CSS Class), text => string (what should be displayed)
			 */
			$tpl->addonHeaders = geoAddon::triggerDisplay('Browse_ads_display_browse_result_addHeader', array('this'=>$this, 'browse_fields'=>$fields, 'auction' => $auction, 'featured' => $featured), geoAddon::ARRAY_ARRAY);
			
			if ($this->configuration_data['popup_while_browsing']) {
				$cfg['popup'] = true;
				$cfg['popup_width'] = $this->configuration_data['popup_while_browsing_width'];
				$cfg['popup_height'] = $this->configuration_data['popup_while_browsing_height'];
			} else {
				$cfg['popup'] = false;
			}
			$cfg['icons'] = array(
				'sold' => geoTemplate::getUrl('',$this->messages[500798]),
				'buy_now' => geoTemplate::getUrl('',$this->messages[500799]),
				'reserve_met' => geoTemplate::getUrl('',$this->messages[500800]),
				'no_reserve' => geoTemplate::getUrl('',$this->messages[500802]),
			);
			
			$cfg['empty'] = $this->messages[500227];
			
			$tpl->cfg = $cfg;
			$tpl->headers = $headers;
			
			//now set up all the listing data
			
			//common text
			$text = array(
				'business_type' => array(
					1 => $this->messages[1263],
					2 => $this->messages[1264],
				),
				'time_left' => array(
					'weeks' => $this->messages[103003],
					'days' => $this->messages[103004],
					'hours' => $this->messages[103005],
					'minutes' => $this->messages[103006],
					'seconds' => $this->messages[103007],
					'closed' => $this->messages[100051]
				)
			);
			
			while($row = $browse_result->FetchRow()) {
				$id = $row['id']; //template expects $listings to be keyed by classified id
				
				//use the common geoBrowse class to do all the common heavy lifting
				$listings[$id] = $this->commonBrowseData($row, $text, $featured);
				
				//css is different enough to not include in the common file
				$listings[$id]['css'] = 'browsing_result_table_body_' . (($count++ % 2 == 0) ? 'even' : 'odd') . (($row['bolding']) ? '_bold' : '');
				
				//also do addons separately
				$listings[$id]['addonData'] = geoAddon::triggerDisplay('Browse_ads_display_browse_result_addRow', array('this'=>$this,'show_classifieds' => $row, 'browse_fields' => $fields, 'auction' => $auction, 'featured' => $featured), geoAddon::ARRAY_ARRAY);
			}
			$tpl->listings = $listings;
	
		}
		$return = $tpl->fetch('common/listing_set.tpl');	
		return $return;
	}
	



//####################################################################################

	public function main ()
	{
		$this->page_id = 2;
		$this->get_text();
		if (!$this->db->get_site_setting('no_home_bodyhtml')) {
			//populate the body_html on home page
			
			$this->body .="<table cellpadding=\"5\" cellspacing=\"1\" border=\"0\" width=\"100%\">\n";
			if (strlen(trim($this->messages[29])) > 0)
				$this->body .="<tr class=\"main_page_title\">\n\t<td style=\"height:20px;\">".urldecode($this->messages[29])."</td>\n</tr>\n";
			if (strlen(trim($this->messages[30])) > 0)
				$this->body .="<tr class=\"main_page_message\">\n\t<td style=\"height:20px;\">".urldecode($this->messages[30])."</td>\n</tr>\n";
			$this->body .="<tr>\n\t<td >\n\t";
			if (!$this->browse_main($db)) {
				$this->body .= 'error...';
				$this->browse_error();
			}
				
			$this->body .="</td>\n</tr>\n";
			$this->body .="</table>\n";
		}
		$this->display_page();
		return true;
	 } //end of function main

//####################################################################################

	function browse_main() {
		$html = '';
		if ($this->db->get_site_setting('display_category_navigation'))  {
			//for simplicity...
			$this->body .= $this->categoryBrowsing();
		}
		return true;
	 } //end of function main


//###################################################################################
	function send_admin_end_email($admin_body, $listing_type=1)
	{
		if(!geoPC::is_ent()) {
			return false;
		}
		$type = ($listing_type == 1) ? "classifieds" : "auctions";
		$message_body = "The following ".$type." will expire soon\n\n";
		$message_body .= $admin_body;
		$subject = $type . " expiring soon";
		$this->sendMail($this->db->get_site_setting('site_email'), $subject, $message_body);
	}
//###################################################################################

	function admin_delete_classified($db,$classified_id=0) {
		$debug_admin_delete = 0;
		if (!$classified_id) {
			$this->error_message = urldecode($this->messages[81]);
			trigger_error('Listing ID not given');
			return false;
		}

		$sql = "select * from ".$this->classifieds_table." where id = ?";
		$get_ad_result = $this->db->Execute($sql, array($classified_id));

		if (false === $get_ad_result || !$get_ad_result->RecordCount()) {
			$this->error_message = urldecode($this->messages[81]);
			trigger_error('Could not find listing');
			return false;
		}

		$show = $get_ad_result->FetchRow();
		$category_string = $this->get_category_string($db,$show['category']);

		if ((strlen(trim($show['duration'])) == 0) || is_null($show['duration'])) {
			$show['duration'] = 0;
		}

		$sql = "REPLACE ".$this->classifieds_expired_table."
			(id,seller,title,date,description,category,
			duration,location_state,location_zip,location_country,ends,search_text,ad_ended,reason_ad_ended,viewed,
			bolding,better_placement,featured_ad,precurrency,price,postcurrency,
			business_type,optional_field_1,optional_field_2,optional_field_3,optional_field_4,optional_field_5,
			optional_field_6,optional_field_7,optional_field_8,optional_field_9,optional_field_10,
			optional_field_11,optional_field_12,optional_field_13,optional_field_14,optional_field_15,
			optional_field_16,optional_field_17,optional_field_18,optional_field_19,optional_field_20,phone,phone2,fax,email,auction_type,
			final_fee,final_price,item_type)
			VALUES
			(".$show['id'].",
			\"".$show['seller']."\",
			\"".$show['title']."\",
			\"".$show['date']."\",
			\"".$show['description']."\",
			\"".$category_string."\",
			".$show['duration'].",
			\"".$show['location_state']."\",
			\"".$show['location_zip']."\",
			\"".$show['location_country']."\",
			\"".$show['ends']."\",
			\"".urlencode($show['search_text'])."\",
			".geoUtil::time().",
			\"expired\",
			".$show['viewed'].",
			\"".$show['bolding']."\",
			\"".$show['better_placement']."\",
			\"".$show['featured_ad']."\",
			\"".$show['precurrency']."\",
			\"".$show['price']."\",
			\"".$show['postcurrency']."\",
			\"".$show['business_type']."\",
			\"".$show['optional_field_1']."\",
			\"".$show['optional_field_2']."\",
			\"".$show['optional_field_3']."\",
			\"".$show['optional_field_4']."\",
			\"".$show['optional_field_5']."\",
			\"".$show['optional_field_6']."\",
			\"".$show['optional_field_7']."\",
			\"".$show['optional_field_8']."\",
			\"".$show['optional_field_9']."\",
			\"".$show['optional_field_10']."\",
			\"".$show['optional_field_11']."\",
			\"".$show['optional_field_12']."\",
			\"".$show['optional_field_13']."\",
			\"".$show['optional_field_14']."\",
			\"".$show['optional_field_15']."\",
			\"".$show['optional_field_16']."\",
			\"".$show['optional_field_17']."\",
			\"".$show['optional_field_18']."\",
			\"".$show['optional_field_19']."\",
			\"".$show['optional_field_20']."\",
			\"".$show['phone']."\",
			\"".$show['phone2']."\",
			\"".$show['fax']."\",
			\"".$show['email']."\",
			\"".$show['auction_type']."\",
			\"".$show['final_fee']."\",
			\"".$show['final_price']."\",
			\"".$show["item_type"]."\")";

		if (false === $this->db->Execute($sql)) {
			$this->error_message = urldecode($this->messages[81]);
			trigger_error('Could not move listing');
			return false;
		}
		
		$delete_ad_result = geoListing::remove($show['id']);
		
		if (!$delete_ad_result) {
			$this->error_message = urldecode($this->messages[81]);
			trigger_error('Could not listing for deletion');
			return false;
		}
		
		$this->update_category_count($db,$show['category']);
		header("Location: ".$this->db->get_site_setting('classifieds_url')."?a=5&amp;b=".$show['category']);
		return true;
	} //end of function admin_delete_classified

}
