<?php
//auction_bid_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 13243              $ ##
## File last change date:       ##
##  $Date:: 2008-07-01 15:52:#$ ##
##                              ##
##################################

class Auction_reverse_bid extends geoSite {

	var $auction_id;
	var $classified_user_id;
	var $bid_error = 0;
	var $bid_success = 0;
	var $auction;
	var $bidder;
	var $dutch_bidders;
	var $winning_dutch_bidder = 0;
	var $dutch_bidder_quantity = 0;
	var $DEBUG_BID = 0;
	var $filename = "auction_bid_class.php";
	var $function_name;
	var $separator;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Auction_reverse_bid (&$db,$language_id,$classified_user_id,$auction_id,$product_configuration=0)
	{
		parent::__construct();
		$this->auction_id = $auction_id;
		$this->auction = $this->get_classified_data($this->auction_id);
		if ($this->DEBUG_BID) {
			trigger_error("DEBUG STATS: userid".$this->userid." auction id:".$this->auction_id);
		}

		$this->separator = "\n";
	} // end of function Auction_bid

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function bid_setup($db,$buy_now=0,$bid_amount=0,$aff_id=0)
	{
		$this->page_id = 10163;
		$this->get_text();
		
		$view = geoView::getInstance();
		$db = DataAccess::getInstance();		
				
		$verification_check = $_REQUEST["e"];
		
		//show the form to bid on this auction
		if (!$this->userid || !$this->auction_id) {
			return false;
		}		
		
		//get auction information
		$this->bidder = $this->get_user_data($this->userid);
		$this->auction = $this->get_classified_data($this->auction_id);	

		if (($this->db->get_site_setting('black_list_of_buyers')) && ($this->db->get_site_setting('invited_list_of_buyers'))) {
			$invited = $this->check_invitedlist($this->db,$this->auction->SELLER,$this->userid);
			$banned = $this->check_blacklist($this->db,$this->auction->SELLER,$this->userid);
			if ($invited == 1) {
				$can_bid = 1;
			} else {
				if ($banned) {
					$can_bid = 0;
				} elseif ($invited == 2) {	
					$can_bid = 1;
				}
			}
		} elseif ($this->db->get_site_setting('black_list_of_buyers')) {
			//check black list only
			if ($this->check_blacklist($this->db,$this->auction->SELLER,$this->userid)) {
				$can_bid = 0;
			} else {
				$can_bid = 1;
			}
		} elseif ($this->db->get_site_setting('invited_list_of_buyers')) {
			//check invited only
			if ($this->check_invitedlist($this->db,$this->auction->SELLER,$this->userid)) {
				//this user is on the invited list
				$can_bid = 1;
			}
		} else {
			//no checks on who the bidder is, is needed, so they can probably bid.
			$can_bid = 1;
		}

		$bid_amount['bid_amount'] = geoNumber::deformat($bid_amount['bid_amount']);
		if (!$can_bid) {
			return false;
		}		

		//show the form to bid on this auction
		if (($this->userid) && ($this->auction_id))
		{
			//get auction information
			$this->auction = $this->get_classified_data($this->auction_id);
			$this->bidder = $this->get_user_data($this->userid);

			if ($this->DEBUG_BID)
			{
				echo $this->userid." is the auction user id<br/>\n";
				echo $this->auction." is the auction<br/>\n";
				echo $this->bidder." is the bidder<br/>\n";
			}
			
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$can_bid." is can_bid before can_bid if <br/>\n";
			if ($can_bid)
			{
				if($this->DEBUG_BID)
				{
					echo $this->auction->START_STATS . ' is the start time.<br/>';
					echo geoUtil::time() . ' is the time.<br/>';
				}
				if($this->auction->START_STATS > geoUtil::time())
				{
					$this->bid_error = 8;
					if($this->DEBUG_BID) echo "start time is greater than current time<br/>\n";
					return false;
				}

				if ($this->DEBUG_BID)
				{
					echo $this->auction." is auction<br/>\n";
					echo $this->bidder." is bidder<br/>\n";
					echo $this->auction->LIVE." is auction->LIVE<br/>\n";
				}

				if (($this->auction) && ($this->bidder) && ($this->auction->LIVE == 1))
				{
					if ($this->auction->SELLER == $this->bidder->ID)
					{
						$this->bid_error = 4;
						return false;
					}
					
					if ($verification_check == "verify")
					{
						$this->body .= "<form action=".$this->db->get_site_setting('classifieds_file_name')."?a=1029&b=".$this->auction_id."&e=verified&aff=$aff_id method=post>\n";
						$this->body .= "<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n";
						$this->body .= "<tr class=page_title>\n\t<td colspan=2>".urldecode($this->messages[102437])."</td>\n</tr>\n";
						$this->body .= "<tr class=display_auction_title>\n\t<td colspan=2>".urldecode($this->auction->TITLE)."</td>\n</tr>\n";
	
						if (($buy_now) && ($this->auction->BUY_NOW))
						{
							$this->body .= "<input type=hidden name=c[bid_amount] value=".$this->auction->BUY_NOW.">";
							$this->body .= "<input type=hidden name=d value=1>";
							$this->body .= "<tr class=page_instructions>\n\t<td colspan=2>".urldecode($this->messages[102442])."</td>\n</tr>\n";
							$this->body .= "<tr>\n\t<td class=info_label width=\"40%\">".urldecode($this->messages[500237])."</td>\n\t";
							$display_amount = $this->show_money($this->auction->BUY_NOW,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
							$this->body .= "<td class=right_data>$display_amount</td></tr>\n";
							$this->body .= "<tr class=submit_button>\n\t<td colspan=2><input type=submit name=c[buy_now_bid] value=\"".urldecode($this->messages[500238])."\">\n\t</td>\n</tr>\n";
						    $this->body .= "<tr>\n\t<td colspan='2'><a href=\"".$this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\">".urldecode($this->messages[103055])."</a>\n\t</td>\n</tr>\n";
						}
						else
						{
							//regular auction type
							$this->body .= "<tr class=page_instructions>\n\t<td colspan=2>".urldecode($this->messages[102438])."</td>\n</tr>\n";
							$this->body .= "<tr>\n\t<td class=info_label width=\"40%\">".urldecode($this->messages[500242])."</td>\n\t";
							$this->body .= "<td class=right_data>".urldecode($this->auction->PRECURRENCY)." ".$this->show_money($bid_amount["bid_amount"],0,0,1)." ".urldecode($this->auction->POSTCURRENCY)."<input type=hidden name=c[bid_amount] value=\"".$this->show_money($bid_amount["bid_amount"],0,0,1)."\"></td>\n</tr>\n";
							$this->body .= "<tr class=submit_button>\n\t<td colspan=2><input type=submit name=submit value=\"".urldecode($this->messages[500236])."\">\n\t</td>\n</tr>\n";
						    $this->body .= "<tr>\n\t<td colspan='2'><a href=\"".$this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\">".urldecode($this->messages[103055])."</a>\n\t</td>\n</tr>\n";
						}
	
						$this->body .= "</table>\n</form>\n";
							
					}
					else
					{

						$this->body .= "<form action=".$this->db->get_site_setting('classifieds_file_name')."?a=1029&b=".$this->auction_id."&e=verify&aff=$aff_id method=post>\n";
						$this->body .= "<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n";
						$this->body .= "<tr class=page_title>\n\t<td colspan=2>".urldecode($this->messages[102437])."</td>\n</tr>\n";
						$this->body .= "<tr class=display_auction_title>\n\t<td colspan=2>".urldecode($this->auction->TITLE)."</td>\n</tr>\n";
	
						if (($buy_now) && ($this->auction->BUY_NOW))
						{
							$this->body .= "<input type=hidden name=c[bid_amount] value=".$this->auction->BUY_NOW.">";
							$this->body .= "<input type=hidden name=d value=1>";
							$this->body .= "<tr class=page_instructions>\n\t<td colspan=2>".urldecode($this->messages[102442])."</td>\n</tr>\n";
							$this->body .= "<tr>\n\t<td class=info_label width=\"40%\">".urldecode($this->messages[102443])."</td>\n\t";
							$display_amount = $this->show_money($this->auction->BUY_NOW,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
							$this->body .= "<td class=right_data>$display_amount</td></tr>\n";
							$this->body .= "<tr class=submit_button>\n\t<td colspan=2><input type=submit name=c[buy_now_bid] value=\"".urldecode($this->messages[102444])."\">\n\t</td>\n</tr>\n";
							$this->body .= "<tr>\n\t<td colspan=2><a href=\"".$this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\">".urldecode($this->messages[103055])."</a>\n\t</td>\n</tr>\n";
						}
						else
						{
							//get minimum bid amount
							$bid_to_show = $this->get_maximum_bid($db);
							//regular auction type
							$this->body .= "<tr class=page_instructions>\n\t<td colspan=2>".urldecode($this->messages[102438])."</td>\n</tr>\n";
							$this->body .= "<tr>\n\t<td class=info_label width=\"40%\">".urldecode($this->messages[102440])."</td>\n\t";
							$this->body .= "<td class=right_data>".urldecode($this->auction->PRECURRENCY)." <input type=text name=c[bid_amount] value=\"".$this->show_money($bid_to_show,0,0,1)."\"> ".urldecode($this->auction->POSTCURRENCY)."</td>\n</tr>\n";
							$this->body .= "<tr class=submit_button>\n\t<td colspan=2><input type=submit name=submit value=\"".urldecode($this->messages[102439])."\">\n\t</td>\n</tr>\n";
							$this->body .= "<tr>\n\t<td colspan=2><a href=\"".$this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\">".urldecode($this->messages[103055])."</a>\n\t</td>\n</tr>\n";
						}
	
						$this->body .= "</table>\n</form>\n";
					}
					$this->display_page($db);
					return true;
				}
				else
				{
					//bad bid setup
					return false;
				}

			}
			else
			{
				//this user cannot bid on this auction
				//they are blacklisted or not on the invited list
				//this is a hacking attempt to bypass these features
				return false;
			}
		}
		else
		{
			//bad initialization setup
			return false;
		}
	} // end of function bid_setup

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function bid_error($db,$aff_id=0)
	{
		$this->page_id = 10164;
		$this->get_text();

		//not enough information to bid
		$this->body .= "<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n";
		$this->body .= "<tr class=page_title>\n\t<td>".urldecode($this->messages[102457])."</td>\n</tr>\n";
		$this->body .= "<tr class=page_instructions>\n\t<td>";
		switch ($this->bid_error)
		{
			case 1: //current bidder is the low bidder
				$this->body .= urldecode($this->messages[102458]);
				break;
			case 2: //lower bid
				$this->body .= urldecode($this->messages[102459]);
				break;
			case 3: //unrecognizable data for bid amount
				$this->body .= urldecode($this->messages[102460]);
				break;
			case 4: //seller cannot make a bid on their own auction
				$this->body .= urldecode($this->messages[102462]);
				break;
			case 5: //cannot bid before start time
				$this->body .= urldecode($this->messages[102817]);
				break;
			default: //internal bidding error
				$this->body .= urldecode($this->messages[102461]);
				break;
		} //end of switch
		$this->body .= "</td>\n</tr>\n";
  		$this->body .= "<tr class=edit_approval_links>\n\t<td colspan=2>
  			<a href=".$this->db->get_site_setting('classifieds_file_name')."?a=5&b=".$this->auction->CATEGORY." class=edit_approval_links>".urldecode($this->messages[102720])."</a></td>\n</tr>\n";
  		//back to auction
  		$this->body .= "<tr class=edit_approval_links>\n\t<td colspan=2>
  			<a href=".$this->db->get_site_setting('classifieds_file_name')."?a=2&b=".$this->auction_id." class=edit_approval_links>".urldecode($this->messages[102721])."</a></td>\n</tr>\n";

		$this->body .= "</table>\n";
		$this->display_page($db);
	} // end of function bid_error

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function bid_successful($db,$aff_id=0)
	{
		$this->page_id = 10165;
		$this->get_text();
		$function_name = "bid_successful";

		//successful bid
		$this->body .= "<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n";
		$this->body .= "<tr class=page_title>\n\t<td colspan=2>".urldecode($this->messages[102447])."</td>\n</tr>\n";

		//refresh auction data
		$this->auction = $this->get_classified_data($this->auction_id);
		$this->body .= "<tr>\n\t<td class=info_label width=\"50%\">".urldecode($this->messages[102450])."</td>\n\t";
		$this->body .= "<td class=right_data>".urldecode($this->auction->TITLE)."</td>\n</tr>\n";

		$this->body .= "<tr class=page_instructions>\n\t<td colspan=2>";
		switch ($this->bid_success)
		{
			case 1: //you are current high bidder,  your high bid is saved
				$this->body .= urldecode($this->messages[500363]);
				break;
			case 3: //bid received but you have been outbid
				$this->body .= urldecode($this->messages[102449]);
				break;
			case 4: //buy now bid accepted
				$this->body .= urldecode($this->messages[500364]);
				//on-site payment text
				if (geoPC::is_ent()){
					//seller/buyer
					$vars = array (
						'listing_id' => $this->auction_id,
						'winning_bidder_id' => $this->userid,
						'listing_details' => $this->auction,
						'final_price' => $this->auction->BUY_NOW
					);
					$this->body .= geoSellerBuyer::callDisplay('displayPaymentLinkBuyNowSuccess', $vars);
				}
			default: //internal bidding error
		} //end of switch
		$this->body .= "</td>\n</tr>\n";
		$this->body .= "<tr>\n\t<td class=info_label>".urldecode($this->messages[102451])."</td>\n\t";

		if ($this->bid_success != 4)
		   $money_source = $this->auction->CURRENT_BID;
		else
			$money_source = $this->auction->BUY_NOW;

		$display_amount = $this->show_money($money_source,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		$this->body .= "<td class=right_data>$display_amount</td>\n</tr>\n";

  		//category
  		$this->body .= "<tr class=page_instructions>\n\t<td colspan=2>
  			<a href=".$this->db->get_site_setting('classifieds_file_name')."?a=5&b=".$this->auction->CATEGORY." class=page_instructions>".urldecode($this->messages[102454])."</a></td>\n</tr>\n";
  		//back to auction
  		$this->body .= "<tr class=page_instructions>\n\t<td colspan=2>
  			<a href=".$this->db->get_site_setting('classifieds_file_name')."?a=2&b=".$this->auction_id." class=page_instructions>".urldecode($this->messages[102453])."</a></td>\n</tr>\n";

		$this->body .= "</table>\n";

		$this->insert_favorite($this->db, $this->auction_id);
		
		$this->display_page($db);
	} // end of function bid_successful

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function process_bid($db,$bid_info=0,$aff_id=0)
	{
		$function_name = "process_bid";

		if($this->DEBUG_BID)
		{
			//$this->userid
			trigger_error("TOP OF PROCESS BID
			{$bid_info[bid_amount]} is bid amount at top<br/>
			 $this->auction_id is the auction id <br/>
			 $this->auction->SELLER is the seller<br/>
			 ".$this->userid." is the bidder <br/>
			 {$this->db->get_site_setting('number_format')} is NUMBER_FORMAT<br/>\n
			"
			);
			 
		}

		$bid_info['bid_quantity'] = trim($bid_info['bid_quantity']);
		$bid_info['bid_amount'] = trim($bid_info['bid_amount']);

		$bid_amount = geoNumber::deformat($bid_info['bid_amount']);

		if (!ereg("^[0-9]{1,10}.?[0-9]{0,2}$", $bid_amount))
		{
			$this->bid_error = 3;
			if ($this->DEBUG_BID)
				echo $this->bid_error." 3 - is error<br/>\n";
			return false;
		}

		if ($this->DEBUG_BID)
		{
			echo $bid_amount." is bid amount after formatting change<br/>\n";
		}

		settype($bid_amount, "float");

		if ($this->DEBUG_BID)
		{
			echo $bid_amount." is bid amount after formatting change2<br/>\n";
		}

		$this->auction = $this->get_classified_data($this->auction_id);

		$seller = $this->get_user_data($this->auction->SELLER);
		$this->bidder = $this->get_user_data($this->userid);

		
		trigger_error("
		{$bid_amount} is \$bid_amount at top<br/>\n
		{$this->auction_id} is the auction id<br/>
		{$this->auction->SELLER} is the auction->SELLER<br/>
		".$this->userid." is the bidder(classified_user_id)<br/>
		{$this->db->get_site_setting('number_format')} is NUMBER_FORMAT<br/>\n
		");
		

		if (($bid_amount) && ($this->auction) && ($this->bidder) && ($seller) && ($this->auction->LIVE == 1)
		&& (($this->auction->ENDS > geoUtil::time()) || ($this->auction->DELAYED_START == 1)))
		{
			if ($seller->ID == $this->bidder->ID)
			{
				$this->bid_error = 4;
				if ($this->db->get_site_setting('debug_bid'))
					echo $this->bid_error." 4 - is error<br/>\n";
				return false;
			}
			$quantity = 1;
			if($this->DEBUG_BID) echo "quantity is set to 1<BR>\n";
			//regular auction
			//EXTENDED STATS ON BIDS?
			$current_time = geoUtil::time();
			if (isset($bid_info["buy_now_bid"]) && $bid_info["buy_now_bid"])
			{
				$this->page_id = 10167;
				$this->get_text();
				//this user is closing the auction by choosing the buy now option
				$sql = "update ".$this->classifieds_table."
					set live = 0,
					delayed_start = 0,
					current_bid = ?,
					price = ?,
					minimum_bid = ?,
					final_price = ?,
					ends = ?
					where id = ?";
				$query_data = array($this->auction->BUY_NOW, $this->auction->BUY_NOW,$this->auction->BUY_NOW, $this->auction->BUY_NOW, geoUtil::time(), $this->auction_id );
				$update_result = $this->db->Execute($sql, $query_data);
				$this->auction->FINAL_PRICE = $this->auction->BUY_NOW;
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update data in auctions table by auction id");
				}
				if (!$update_result)
				{
					$this->error_message = urldecode($this->messages[81]);
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					return false;
				}
				//insert buy now bid
				$insert_bid_result = $this->insert_into_bid_table($this->auction->BUY_NOW,$current_time,$this->auction->QUANTITY,1);
				if (!$insert_bid_result)
				{
					//put things back
					$reset_current_price_result = $this->set_current_and_price_to_zero();
					return false;
				}

				$sql = "insert into ".$this->auctions_feedbacks_table."
					(rated_user_id,rater_user_id,date,auction_id)
					values (?, ?, ?, ?)";
				$query_data = array	($this->auction->SELLER,$this->bidder->ID,geoUtil::time(),$this->auction_id);
				$insert_feedback_result = $this->db->Execute($sql, $query_data);
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "auctions_feedbacks_table", "insert data into feedback table by auction, bidder, and seller id");
				}
				if (!$insert_feedback_result)
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					$this->error_message = urldecode($this->messages[81]);
					return false;
				}

				$sql = "insert into ".$this->auctions_feedbacks_table."
					(rated_user_id,rater_user_id,date,auction_id)
					values (?, ?, ?, ?)";
				$query_data = array	($this->bidder->ID,$this->auction->SELLER,geoUtil::time(),$this->auction_id);
				$insert_feedback_result = $this->db->Execute($sql, $query_data);
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "auctions_feedbacks_table", "insert data into feedback table by auction, bidder, and seller id");
				}
				if (!$insert_feedback_result)
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					$this->error_message = urldecode($this->messages[81]);
					return false;
				}
				geoOrderItem::callUpdate('buy_now_close',$vars);
				
				//send emails to seller and buy now bidder
			    //to buy now bidder
			    $this->email_buy_now_bidder_and_seller($aff_id,$seller);

				$this->update_category_count($db,$this->auction->CATEGORY);
				$this->bid_success = 4;
				return true;
			}

			//get minimum bid
			$maximum_bid = $this->get_maximum_bid($db);
			if (!$maximum_bid)
			{
				return false;
			}
			if ($this->DEBUG_BID) {
				echo $bid_amount." is bid_amount<br>\n";
				echo $maximum_bid." is maximum_bid<br>";
				
			}
			if ($bid_amount <= $maximum_bid)
			{
				$this->auction_extension_check($current_time);
				//the current bid is less than or equal to the maximum bid
				//check to make sure the current bidder is not winning already
				$auction_ends = date($this->db->get_site_setting('entry_date_configuration'),$this->auction->ENDS);

				//get the information on the current high bid
				$sql = "select * from ".$this->bid_table." where auction_id=? order by bid asc,time_of_bid asc limit 1";
				$low_bid_result = $this->db->Execute($sql, array($this->auction_id));
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$this->auction_id."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "get data from bid table by auction id");
				}
				if (!$low_bid_result)
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					return false;
				}
				elseif ($low_bid_result->RecordCount() == 1)
				{
					//there is a current high bid
					$show_low_bidder = $low_bid_result->FetchNextObject();
					if ($show_low_bidder->BIDDER == $this->bidder->ID)
					{
						//check to see if the current high bidder can update their bid
						$allow_bidding_against_self = $this->db->get_site_setting('allow_bidding_against_self');
			
						if ($allow_bidding_against_self)
						{
							//this will allow the client to add to their bid...
							//add a proxy bid if they do not have one or...
							//add to their current proxy bid if they have on on this auction
								
							//check to see if there is a current proxy bid
							$sql = "select * from ".$this->autobid_table." where auction_id = ?";
							$get_autobid_result = $this->db->Execute($sql, array($this->auction_id));
							if ($this->DEBUG_BID) 
							{
								echo 'LINE '.__LINE__.' '.$sql." - ".$this->auction_id."<br/>\n";
							};
		
						  	if (!$get_autobid_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}
							elseif ($get_autobid_result->RecordCount() == 0)
							{			
								if ($this->DEBUG_BID) echo __LINE__." - there is no proxy bid in the database<br>\n";
								//there is no current proxy bid
								//enter this bid as the current proxy bid for this bidder	
								//need to check against the reserve price	
								if ($this->auction->RESERVE_PRICE != 0)	
								{
									if ($this->DEBUG_BID) echo __LINE__." - there is a reserve price<br>\n";
									//there is a reserve...check that it has been met
									if ($maximum_bid < $this->auction->RESERVE_PRICE)
									{
										if ($this->DEBUG_BID) echo __LINE__." - maximum_bid is less than reserve_price - so insert proxy bix<br>\n";
										//the reserve has been met...insert this bid
										//as the proxy for this bidder on this auction
										//no need to update the auction as none of that will change
										//only the proxy will be added
										$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
										$this->send_current_low_bidder_email($db,$this->bidder->ID);
										$this->bid_success = 1;
										$this->start_delayed_auction();
										return true;
									}
									else
									{
										//the reserve has not been met
										//check that the bid_amount beats the reserve or not
										if ($this->DEBUG_BID) echo __LINE__." - maximum_bid is equal to or greater than reserve_price<br>\n";
										if ($bid_amount < $this->auction->RESERVE_PRICE)
										{
											if ($this->DEBUG_BID) echo __LINE__." - but the bid_amount is less than reserve_price - insert bid<br>\n";
											//enter the current bid to the reserve prise
											//enter any amount above the reserve price as the proxy bid for this bidder
											$set_minimum_result = $this->update_maximum_current_and_price(($this->auction->RESERVE_PRICE - $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
											if (!$set_minimum_result)
											{
												if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
												return false;
											}
											else
											{
												$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
												if (!$insert_bid_result)
												{
													//put things back
													$reset_current_price_result = $this->set_current_and_price_to_zero();
													return false;
												}
												else
												{
													$a_bid = $this->auction->RESERVE_PRICE;
													//insert bid into the autobid table because it was greater then minimum_bid
													//minimum_bid is the current minimum because there were no previous bids
													$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
													if (!$insert_autobid_result)
													{
														if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
														return false;
													}
													$this->send_current_low_bidder_email($db,$this->bidder->ID);
													$this->bid_success = 1;
													$this->start_delayed_auction();
													return true;
												}
											}												
										}
										else
										{
											//$bid_amount >= $this->auction->RESERVE_PRICE
											//enter the bid_amount as the current bid only
											if ($this->DEBUG_BID) echo __LINE__." - bid_amount is greater than reserve_price - insert bid<br>\n";
											$set_minimum_result = $this->update_maximum_current_and_price(($bid_amount - $increment),$bid_amount,$bid_amount);
											if (!$set_minimum_result)
											{
												if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
												return false;
											}
											else
											{
												$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
												if (!$insert_bid_result)
												{
													//put things back
													$reset_current_price_result = $this->set_current_and_price_to_zero();
													return false;
												}
											}				
											$this->send_current_low_bidder_email($db,$this->bidder->ID);
											$this->bid_success = 1;
											$this->start_delayed_auction();
											return true;
										}
									}
								}
								else
								{
									//there is no current proxy and 
									//there is no reserve so insert the bid_amount
									//as a proxy bid for this bidder on this auction
									if ($this->DEBUG_BID) echo __LINE__." - there is no proxy bid, no reserve_price so insert proxy bid<br>\n";
									$a_bid = $bid_amount;
									$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
									if (!$insert_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									$this->send_current_low_bidder_email($db,$this->bidder->ID);
									$this->bid_success = 1;
									$this->start_delayed_auction();
									return true;
								}
							}
							elseif ($get_autobid_result->RecordCount() == 1)
							{
								//this bidder has a current proxy bid
								//check to see current proxy bid is higher than amount just bid or not
								if ($this->DEBUG_BID) echo __LINE__." - there is a proxy bid in the database for this bidder<br>\n";
								$show_autobid = $get_autobid_result->FetchNextObject();
								if ($bid_amount < $show_autobid->MAXBID)
								{
									if ($this->DEBUG_BID) echo __LINE__." - bid_amount is greater than autobid - update autobid of this bidder with current amount<br>\n";
									//update the current proxy bid with the current bid
									$a_bid = $bid_amount;
									$sql = "update ".$this->autobid_table." set
										time_of_bid = ? ,
										quantity = ?,
										maxbid = ?
										where auction_id = ? and
										bidder = ?";
									$query_data = array	($current_time, $quantity, $bid_amount, $this->auction_id, $this->bidder->ID);
									$update_autobid_result = $this->db->Execute($sql, $query_data);
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									if($this->db->get_site_setting('debug_bid'))
									{
										$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "insert data into auctions table");
									}
									if (!$insert_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									$this->send_current_low_bidder_email($db,$this->bidder->ID);
									$this->bid_success = 1;
									$this->start_delayed_auction();
									return true;										
								}
								else
								{
									//the bid_amount was equal to or lesser than the current proxy bid
									//so do nothing
									if ($this->DEBUG_BID) echo __LINE__." - there is a proxy bid in the database for this bidder but current bid is higher..do not update proxy bid<br>\n";
									return true;
								}
							}
							else
							{
								//there is more than one proxy bid...big error
								$this->bid_error = 1;
								if ($this->DEBUG_BID)
									echo $this->bid_error." 1 - is error because more than one proxy bid in database for this auction<br/>\n";
								return false;									
									
							}
						}
						else
						{
							$this->bid_error = 1;
							if ($this->DEBUG_BID)
								echo $this->bid_error." 1 - is error - not allowed to edit own bid<br/>\n";
							return false;
						}
					}
					else
					{
						/*
						 * there is a bid on this auction but do nothing in this place for now
						 
						//there is a current bid on this reverse auction
						//the current bidder does NOT match the current low bidder
						//this bid is equal to or lower than the current maximum bid
						if ($this->DEBUG_BID) echo __LINE__." - there is a current bid on this auction<br>\n";
						$increment = $this->get_increment($db,$bid_amount);
					
						$set_minimum_result = $this->update_maximum_current_and_price(($bid_amount - $increment),$bid_amount,$bid_amount);
						if (!$set_minimum_result)
						{
							if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
							return false;
						}
						else
						{
							if ($this->DEBUG_BID) echo __LINE__." - insert bid in the database for this bidder<br>\n";
							$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
							if (!$insert_bid_result)
							{
								//put things back
								$reset_current_price_result = $this->set_current_and_price_to_zero();
								return false;
							}
							else
							{
								$a_bid = $this->auction->RESERVE_PRICE;
								$this->send_current_low_bidder_email($db,$this->bidder->ID);
								$this->bid_success = 1;
								$this->start_delayed_auction();
								return true;
							}
						}		
						*/				
						
					}
				}
				else
				{
					//there is no current low bid
					//got here because there are no bids yet on this item
					//no current bid...this is first bid
				}	
				//set current bid minus increment as the maximum bid in auction table
				
				//insert amount bid as the current bid
				//get the maximum bid
				//get increment first
				$less_than_reserve_straight_bid = $this->db->get_site_setting('less_than_reserve_straight_bid');
				
				if ($this->auction->CURRENT_BID == 0)
				{
					if ($this->DEBUG_BID) echo __LINE__." - there is no current_bid on this auction yet<br>\n";
					//got here because there are no bids yet on this item
					//set current bid as the minimum bid in auction table

					if (($this->auction->RESERVE_PRICE > 0) && ($bid_amount <= $this->auction->RESERVE_PRICE))
					{
						if ($this->DEBUG_BID) echo __LINE__." - there is a reserve and bid_amount is less than reserve_price<br>\n";
						//no current bid...this is first bid
						//there is a reserve and the bid amount is below or equal to the reserve (current bid beats the reserve)
						//insert current bid as reserve price
						//insert amount below reserve price as proxy
						//get the minimum bid
						//get increment first
						$increment = $this->get_increment($db,$this->auction->RESERVE_PRICE);
						
						$set_minimum_result = $this->update_maximum_current_and_price(($this->auction->RESERVE_PRICE - $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
						if (!$set_minimum_result)
						{
							if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
							return false;
						}
						else
						{
							if ($this->DEBUG_BID) echo __LINE__." - insert bid for this bidder<br>\n";
							$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
							if (!$insert_bid_result)
							{
								//put things back
								$reset_current_price_result = $this->set_current_and_price_to_zero();
								return false;
							}
							else
							{
								$a_bid = $this->auction->RESERVE_PRICE;
								if ($bid_amount < $this->auction->RESERVE_PRICE)
								{
									//insert bid into the autobid table because it was greater then minimum_bid
									//minimum_bid is the current minimum because there were no previous bids
									if ($this->DEBUG_BID) echo __LINE__." - bid_amount is less than reserve_price so insert proxy bid<br>\n";
									$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
									if (!$insert_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
								}
								$this->send_current_low_bidder_email($db,$this->bidder->ID);
								$this->bid_success = 1;
								$this->start_delayed_auction();
								return true;
							}
						}
					}
					elseif (($this->auction->RESERVE_PRICE > 0) && ($bid_amount > $this->auction->RESERVE_PRICE) && $less_than_reserve_straight_bid)
					{
						//no current bid...this is first bid
						//there is a reserve
						//amount bid is more than reserve
						//amount bid is less than minimum bid
						//and the admin wants this bid entered directly as a full bid...no proxy bid
						if ($this->DEBUG_BID) echo __LINE__." - there is a reserve_price and bid_amount is greater than reserve_price and less_than_reserve_straight_bid is 1<br>\n";
						$increment = $this->get_increment($db,$bid_amount);
						$set_minimum_result = $this->update_maximum_current_and_price(($bid_amount - $increment),$bid_amount,$bid_amount);
						if (!$set_minimum_result)
						{
							if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
							return false;
						}
						else
						{
							if ($this->DEBUG_BID) echo __LINE__." - insert bid for this bidder<br>\n";
							$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
							if (!$insert_bid_result)
							{
								//put things back
								$reset_current_price_result = $this->set_current_and_price_to_zero();
								return false;
							}
							$this->send_current_low_bidder_email($db,$this->bidder->ID);
							$this->bid_success = 1;
							$this->start_delayed_auction();
							return true;
						}							
					}
					else
					{
						//no current bid...this is first bid
						//set current bid to starting bid
						//set minimum bid to starting bid minus increment
						//get the minimum bid
						//get increment first
						if ($this->DEBUG_BID) echo __LINE__." - no current bid on this auction<br>\n";
						$increment = $this->get_increment($db,$this->auction->STARTING_BID);

						$set_minimum_result = $this->update_maximum_current_and_price(($this->auction->STARTING_BID - $increment),$this->auction->STARTING_BID,$this->auction->STARTING_BID);
						if (!$set_minimum_result)
						{
							if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
							return false;
						}
						else
						{
							if ($this->DEBUG_BID) echo __LINE__." - insert bid for this bidder<br>\n";
							$insert_bid_result = $this->insert_into_bid_table($this->auction->STARTING_BID,$current_time,$quantity);
							if (!$insert_bid_result)
							{
								//put things back
								$reset_current_price_result = $this->set_current_and_price_to_zero();
								return false;
							}
							else
							{
								$a_bid = $maximum_bid;
								if ($bid_amount < $maximum_bid)
								{
									//insert bid into the autobid table because it was greater then minimum_bid
									//minimum_bid is the current minimum because there were no previous bids
									if ($this->DEBUG_BID) echo __LINE__." - bid_amount is less the maximum_bid so insert proxy bid<br>\n";
									$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
									if (!$insert_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
								}
								$this->send_current_low_bidder_email($db,$this->bidder->ID);
								$this->bid_success = 1;
								$this->start_delayed_auction();
								return true;
							}
						}
					}
	  			} // end of if ($this->auction->CURRENT_BID == 0)
	  			else
	  			{
	  				//got here because this auction already has a bid on it
	  				//this bid is below the minimum bid so at least some bid activity will take place.
					//check to see if there is a current autobid
					if ($this->DEBUG_BID) echo __LINE__." - auction already has bid on it - check for proxy bid<br>\n";
					$sql = "select * from ".$this->autobid_table." where auction_id = ?";
					$get_autobid_result = $this->db->Execute($sql, array($this->auction_id));
					if ($this->DEBUG_BID) 
					{
						echo 'LINE '.__LINE__.' '.$sql." - ".$this->auction_id."<br/>\n";
					};

					if (!$get_autobid_result)
					{
						if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
						return false;
					}
					elseif ($get_autobid_result->RecordCount() == 0)
					{
						//there is no proxy bid for this auction
						//this bid is below the minimum
						//this bid is the lowest bid so far

						//check to see if reserve is above current minimum bid
						if ($this->DEBUG_BID) echo __LINE__." - there is no proxy bid<br>\n";
						if (($bid_amount <= $this->auction->RESERVE_PRICE) && ($this->auction->RESERVE_PRICE !=0 )
							&& ($maximum_bid >= $this->auction->RESERVE_PRICE))
						{
							if ($this->DEBUG_BID) echo __LINE__." - bid_amount is less than reserve_price, reserve_price exists and maximum_bid is greater than reserve_price<br>\n";
							//a reserve exists
							//the bid amount is below the reserve but the current minimum bid was above the reserve price.
							//the reserve price becomes the new current bid
							//the new maximum bid for this auction is the reserve minus the increment
							$increment = $this->get_increment($db,$this->auction->RESERVE_PRICE);
							$set_minimum_result = $this->update_maximum_current_and_price(($this->auction->RESERVE_PRICE - $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
							if (!$set_minimum_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}
							else
							{
								if ($this->DEBUG_BID) echo __LINE__." - insert bid for this bidder<br>\n";
								$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									//put things back
									$set_minimum_result = $this->update_maximum_current_and_price($this->auction->MINIMUM_BID,$this->auction->CURRENT_BID,$this->auction->CURRENT_BID);
									return false;
								}
								else
								{
									if ($bid_amount < $this->auction->RESERVE_PRICE)
									{
										//insert bid into the autobid table because it was greater then minimum_bid
										//minimum_bid is the current minimum because there were no previous bids
										if ($this->DEBUG_BID) echo __LINE__." - bid_amount is greater than reserve_price so insert proxy bid<br>\n";
										$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
											return false;
										}
									}
									$this->send_current_low_bidder_email($db,$this->bidder->ID);
									$this->send_outbid_email($db,$show_low_bidder->BIDDER);
									$this->bid_success = 1;
									return true;
								}
							}
						}
						elseif (($bid_amount > $this->auction->RESERVE_PRICE) && ($this->auction->RESERVE_PRICE !=0 ))	
						{
							//there is no proxy bid for this auction
							//bid amount is more than reserve
							//the reserve exists
							//the minimum is more that the reserve
							//the bid amount is at least the minimum bid
								
							if ($less_than_reserve_straight_bid)
	  						{
	  							//this bid will be entered directly as a bid...no proxy
	  							$increment = $this->get_increment($db,$bid_amount);
	  							$update_current_bid_result = $this->update_maximum_current_and_price(($bid_amount - $increment),$bid_amount,$bid_amount);
								if (!$update_current_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								else
								{
									if (isset($quantity)){
										$quantity_to_use = $quantity;
									} elseif (isset($quantity_bidder_receiving)){
										$quantity_to_use = $quantity_bidder_receiving;
									} else {
										//what do we use as quantity?
										trigger_error('DEBUG AUCTION BID SQL: Useing quantity of 1 because $quantity and $quantity_bidder_receiving are both not set.');
										$quantity_to_use = 1;
									}										
									$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity_to_use);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}		
								}  							
	  						}
	  						else
	  						{
	  							$increment = $this->get_increment($db,$maximum_bid);
	  							//this bid is equal to the minimum bid
	  							$update_current_bid_result = $this->update_maximum_current_and_price(($maximum_bid - $increment),$maximum_bid,$maximum_bid);
								if (!$update_current_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								else
								{		  							
		  							if ($bid_amount < $maximum_bid)
		  							{
		  								//if this bid greater than minimum...enter the minimum bid and the proxy	
		  								//enter the proxy
										//got here because no bid in the autobid and bid is large enough to insert into the autobid table
										$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$query_data[0]." - ".$query_data[1]." - ".$query_data[2]." - ".$query_data[3]." - ".$query_data[4]." - "."<br/>\n";
											return false;
										}
		  							}
		  							else
		  							{
		  								//just enter the bid (above)...there is no proxy to enter
		  							}
								}
	  							//enter the bid
								if (isset($quantity)){
									$quantity_to_use = $quantity;
								} elseif (isset($quantity_bidder_receiving)){
									$quantity_to_use = $quantity_bidder_receiving;
								} else {
									//what do we use as quantity?
									trigger_error('DEBUG AUCTION BID SQL: Useing quantity of 1 because $quantity and $quantity_bidder_receiving are both not set.');
									$quantity_to_use = 1;
								}
								$insert_bid_result = $this->insert_into_bid_table($maximum_bid,$current_time,$quantity_to_use);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}		  							
	  						}
							$this->bid_success = 1;
							$this->send_current_low_bidder_email($db,$this->bidder->ID);
							$this->send_outbid_email($db,$show_low_bidder->BIDDER);
							return true;		  						
											
						}
						else
						{
							//there is no proxy bid for this auction
							//the reserve has already been met or is 0
							//the current bid becomes the minimum bid
							//the minimum bid becomes the current minimum bid plus increment
							if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' no proxy - reserve met - current bid is new minimum<br/>\n';
							$increment = $this->get_increment($db,$maximum_bid);
							$update_current_bid_result = $this->update_maximum_current_and_price(($maximum_bid - $increment),$maximum_bid,$maximum_bid);
							if (!$update_current_bid_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}
							else
							{
								if (isset($quantity)){
									$quantity_to_use = $quantity;
								} elseif (isset($quantity_bidder_receiving)){
									$quantity_to_use = $quantity_bidder_receiving;
								} else {
									//what do we use as quantity?
									trigger_error('DEBUG AUCTION BID SQL: Useing quantity of 1 because $quantity and $quantity_bidder_receiving are both not set.');
									$quantity_to_use = 1;
								}
								$insert_bid_result = $this->insert_into_bid_table($maximum_bid,$current_time,$quantity_to_use);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								else
								{
									if ($bid_amount < $maximum_bid)
									{
										//got here because no bid in the autobid and current bid beats the current maximum bid so insert into the autobid table
										$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity_to_use);
										if (!$insert_autobid_result)
										{
											if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$query_data[0]." - ".$query_data[1]." - ".$query_data[2]." - ".$query_data[3]." - ".$query_data[4]." - "."<br/>\n";
											return false;
										}
									}
									$this->bid_success = 1;
									$this->send_current_low_bidder_email($db,$this->bidder->ID);
									$this->send_outbid_email($db,$show_low_bidder->BIDDER);
									return true;
								}
							}
						}
					}
  					else //of ($get_autobid_result->RecordCount() == 0)
  					{
						//there is proxy bid for this auction
						//there already is a price in the autobid table lower than the current price
						//pull the price from the autobid table and test it against this bid
						if ($this->DEBUG_BID) echo "LINE ".__LINE__." there is a proxy bid<br/>\n";
						$show_autobid = $get_autobid_result->FetchNextObject();

						//get increment for the maxbid range
						$increment = $this->get_increment($db,$show_autobid->MAXBID);
          				$maxbid_increment = $show_autobid->MAXBID - $increment;
						if ($bid_amount < $show_autobid->MAXBID)
						{
							if ($this->DEBUG_BID) echo "LINE ".__LINE__." current bid beats the proxy bid<br/>\n";
							//current bid is less than maxbid of other user
							//we have a new lowest bid
							if (($show_autobid->MAXBID <= $this->auction->RESERVE_PRICE) ||
								($this->auction->RESERVE_PRICE == 0) ||
								($bid_amount > $this->auction->RESERVE_PRICE) )
							{
								if ($this->DEBUG_BID) echo "LINE ".__LINE__." proxy bid beats or equals the reserve<br/>\n";
								//Max bid set is equal to the reserve price or bid amount is more than reserve price
								//current bid is more than the reserve but less than proxy bid
								if ($bid_amount < $maxbid_increment)
								{
									if ($this->DEBUG_BID) echo "LINE ".__LINE__." bid amount is less than proxy - increment<br/>\n";
									$increment = $this->get_increment($db,$maxbid_increment);
									//Maxbid_increment becomes the new current bid for this bidder
									//enter maxbid_increment into bid table as the current bid of the current bidder
									//update autobid enter bid as the maxbid for this table
									//update auctions table set maxbid_increment as the current bid
									$update_result = $this->update_maximum_current_and_price(($maxbid_increment - $increment),$maxbid_increment,$maxbid_increment);
									if (!$update_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($maxbid_increment,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$sql = "update ".$this->autobid_table."  set
										maxbid = ?,
										bidder = ?
										where auction_id = ?";
									$update_autobid_result = $this->db->Execute($sql, array($bid_amount, $this->bidder->ID, $this->auction_id));
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									if($this->db->get_site_setting('debug_bid'))
									{
										$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "update max bid and bidder in auctions table by auction id");
									}
									if (!$update_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$a_bid = $maxbid_increment;
									//bidder is current high bidder
									$this->bid_success = 1;
									$this->send_current_low_bidder_email($db,$this->bidder->ID);
									$this->send_outbid_email($db,$show_low_bidder->BIDDER);
									return true;
								} //end of if ($bid > $maxbid_increment)
			  					elseif ($bid_amount == $maxbid_increment)
								{
									//maxbid_increment becomes the new current bid
									//enter maxbid_increment into the bid table as the current bid for this bidder
									//update auctions table set maxbid_increment as the current bid
									//delete this auction from the autobid table
									if ($this->DEBUG_BID) echo "LINE ".__LINE__." current bid is equal to proxy - increment<br/>\n";
									$increment = $this->get_increment($db,$maxbid_increment);
									$update_result = $this->update_maximum_current_and_price(($maxbid_increment - $increment),$maxbid_increment,$maxbid_increment);
									if (!$update_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($maxbid_increment,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$delete_autobid_result = $this->delete_from_autobid_table();
									if (!$delete_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}
									$this->bid_success = 1; //bid made but not high bid
									$this->send_current_low_bidder_email($db,$this->bidder->ID);
									$this->send_outbid_email($db,$show_low_bidder->BIDDER);
									return true;
								} //end of elseif ($bid == $maxbid_increment)
			  					else
								{
									//bid is less than the current maxbid in the autobid table
									//but not less than the incremented autobid value
									//enter bid into the bid table as the bid for this bidder
									//update auctions table current bid equals bid
									//delete this auction from the autobid table
									if ($this->DEBUG_BID) echo "LINE ".__LINE__." current bid does not beat proxy - increment<br/>\n";
									$increment = $this->get_increment($db,$maxbid_increment);
									$update_result = $this->update_maximum_current_and_price(($bid_amount - $increment),$bid_amount,$bid_amount);
									if (!$update_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$delete_autobid_result = $this->delete_from_autobid_table();
									if (!$delete_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}

									$this->send_current_low_bidder_email($db,$this->bidder->ID);
									$this->send_outbid_email($db,$show_low_bidder->BIDDER);
									$this->bid_success = 1;
									return true;
								}// end of else
							}
							else
							{
								//bid amount is equal to or less than reserve price
								//got here because the max proxy bid was more than reserve
								//and there is a reserve price
								//and the current bid is less than the reserve price
								if ($this->DEBUG_BID) echo "LINE ".__LINE__." proxy did not beat reserve bid but the current bid did beat reserve<br/>\n";
								//set the new minimum bid = reserve price
								//set proxy bid amount if necessary
								//remove old proxy bid
								$increment = $this->get_increment($db,$this->auction->RESERVE_PRICE);
								$set_minimum_result = $this->update_maximum_current_and_price(($this->auction->RESERVE_PRICE - $increment),$this->auction->RESERVE_PRICE,$this->auction->RESERVE_PRICE);
								if (!$set_minimum_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								else
								{
									$delete_autobid_result = $this->delete_from_autobid_table();
									if (!$delete_autobid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										return false;
									}										
										
									$insert_bid_result = $this->insert_into_bid_table($this->auction->RESERVE_PRICE,$current_time,$quantity);
									if (!$insert_bid_result)
									{
										if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
										//put things back
										$reset_current_price_result = $this->set_current_and_price_to_zero();
										return false;
									}
									else
									{
										if ($bid_amount < $this->auction->RESERVE_PRICE)
										{
											//insert bid into the autobid table because it was less then minimum_bid
											//minimum_bid is the current minimum because there were no previous bids
											$insert_autobid_result = $this->insert_into_autobid_table($bid_amount,$current_time,$quantity);
											if (!$insert_autobid_result)
											{
												if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
												return false;
											}
										}
										$this->send_outbid_email($db,$show_low_bidder->BIDDER);
										$this->send_current_low_bidder_email($db,$this->bidder->ID);
										$this->bid_success = 1;
									}
									return true;
								}
							}// bid amount is equal to or greater than reserve price
	  					} //end of if ($bid_amount > $show_autobid->MAXBID)
	  					elseif ($bid_amount == $show_autobid->MAXBID)
	  					{
							//Bid amount is equal to the max bid by another user
							//the old bid stands as the new current bid
							//show_autobid[maxbid] is entered into the bid table as a bid for the old bidder
							//remove this auction from the autobid table
							if ($this->DEBUG_BID) echo "LINE ".__LINE__." proxy and current bid are equal<br/>\n";
							$increment = $this->get_increment($db,$bid_amount);
							$update_result = $this->update_maximum_current_and_price(($bid_amount - $increment),$bid_amount,$bid_amount);
							if (!$update_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}

							$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$show_autobid->QUANTITY,0,$show_autobid->BIDDER);
							if (!$insert_bid_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}

							$insert_bid_result = $this->insert_into_bid_table($bid_amount,($current_time+1),$quantity);
							if (!$insert_bid_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}

							$delete_autobid_result = $this->delete_from_autobid_table();
							if (!$delete_autobid_result)
							{
								if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
								return false;
							}

							$this->bid_success = 3;
							$this->send_outbid_email($db,$this->bidder->ID);
							return true;

	  					} //end of elseif ($bid_amount == $show_autobid->MAXBID)
	  					else
	  					{
	  						//Bid is more than the max bid - current bid does NOT beat proxy bid
	  						if ($this->DEBUG_BID) echo "LINE ".__LINE__." current bid does not beat proxy bid<br/>\n";
							$increment = $this->get_increment($db,$bid_amount);
							$incremented_bid = $bid_amount - $increment;
							if ($show_autobid->MAXBID < $incremented_bid)
							{
								//show_autobid["maxbid"] remains the same in the autobid table
								//bid is entered into the bid table as a bid for the current bidder
								//incremented bid becomes the new bid for the autobid bidder in the bid table at the same time
								//incremented_bid becomes the current bid in the auction table

								$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$insert_bid_result = $this->insert_into_bid_table($incremented_bid,$current_time,$quantity,0,$show_autobid->BIDDER);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$increment = $this->get_increment($db,$incremented_bid);
								$update_result = $this->update_maximum_current_and_price(($incremented_bid - $increment),$incremented_bid,$incremented_bid);
								if (!$update_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$this->bid_success = 3;
								$this->send_outbid_email($db,$this->bidder->ID);
								return true;
		  					} //if ($show_autobid->MAXBID > $incremented_bid)
			  				elseif ($show_autobid->MAXBID == $incremented_bid)
			  				{
								// the autobid and the incremented bid are equal
								//the old show_autobid[maxbid] is the new current bid in the auction table
								//show_autobid[maxbid] is entered into bid table as the current bid for the show_autobid[bidder]
								//this auction is removed from the autobid table
								//current bid is entered into the bid table for the current bidder first the old bid is entered

								$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}
								
			  					$insert_bid_result = $this->insert_into_bid_table($incremented_bid,$current_time,$quantity,0,$show_autobid->BIDDER);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}								

								$increment = $this->get_increment($db,$incremented_bid);
								$update_result = $this->update_maximum_current_and_price(($incremented_bid - $increment),$incremented_bid,$incremented_bid);
								if (!$update_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$delete_autobid_result = $this->delete_from_autobid_table();
								if (!$delete_autobid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$this->bid_success = 3;
								$this->send_outbid_email($db,$this->bidder->ID);
								return true;

			  				} //end of elseif ($show_autobid->MAXBID == $incremented_bid)
							else
							{
								//show_autobid[maxbid] is greater than bid but not bigger than incremented bid
								//show_autobid[maxbid] becomes the current bid in the auction table
								//bid is entered into the bid table as a bid for the current bidder
								//show_autobid[maxbid] is entered into the bid table as a bid for the autobid bidder
								//this auction is removed from the autobid table

								$insert_bid_result = $this->insert_into_bid_table($bid_amount,$current_time,$quantity);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$insert_bid_result = $this->insert_into_bid_table($show_autobid->MAXBID,$current_time,$quantity,0,$show_autobid->BIDDER);
								if (!$insert_bid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$increment = $this->get_increment($db,$show_autobid->MAXBID);
								$update_result = $this->update_maximum_current_and_price(($show_autobid->MAXBID - $increment),$show_autobid->MAXBID,$show_autobid->MAXBID);
								if (!$update_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$delete_autobid_result = $this->delete_from_autobid_table();
								if (!$delete_autobid_result)
								{
									if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
									return false;
								}

								$this->bid_success = 3;
								$this->send_outbid_email($db,$this->bidder->ID);
								return true;

			  				} //endof else elseif ($show_autobid->MAXBID == $incremented_bid)
						} //end of else
	  				} //end of else of if ($get_autobid_result->RecordCount() == 0)
  				} //end of else of if(current_bid == 0)
			}
			else
			{
				//bid_amount not enough
				//raise your bid
				$this->bid_error = 2;
				if ($this->db->get_site_setting('debug_bid'))
					echo $this->bid_error."2 - is error<br/>\n";
				return false;
			}
			
		}
		else
		{
			return false;
		}
	} //end of function process_bid

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_maximum_bid($db)
	{
		if (floatval($this->auction->CURRENT_BID) < 0.01 && floatval($this->auction->STARTING_BID) >= 0.01)
		{
			//echo floatval($this->auction->CURRENT_BID) . ' <= 0 AND ' . floatval($this->auction->STARTING_BID) . ' > 0';
			return $this->auction->STARTING_BID;
		}
		elseif (floatval($this->auction->CURRENT_BID) <= 0.00 && floatval($this->auction->STARTING_BID) <= 0.00)
		{
			//check maximum bid in case a value was placed there but not
			//in the starting bid
			if (floatval($this->auction->MINIMUM_BID) > 0)
			{
				return $this->auction->MINIMUM_BID;
			}
			else
			{
				return 0.01;
			}
		}
		else
		{
			//get bid increment
			$increment = $this->get_increment($db,$this->auction->CURRENT_BID);
			if ($increment)
				return $this->auction->CURRENT_BID - $increment;
			else
			{
				return false;
			}
		}
	} // end of function get_maximum_bid

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_increment($db,$amount)
	{
		$function_name = "get_increment";
		

		$sql = "select `increment` from ".geoTables::increments_table." where
			`low` <= ? ORDER BY `low` DESC limit 1";
        $increment_result = $this->db->Execute($sql, array($amount));
        if ($this->DEBUG_BID)
        {
        	echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
        	echo $amount." is \$amount<BR>\n";
        }

		if (!$increment_result)
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
			$this->error_message = urldecode($this->messages[100081]);
			return 1;
		}
		elseif  ($increment_result->RecordCount() == 1)
		{
			$show_increment = $increment_result->FetchNextObject();
			 if ($this->DEBUG_BID) echo $show_increment->INCREMENT." is \$show_increment->INCREMENT<Br>\n";
			 if ($show_increment->INCREMENT == 0){
			 	//it messes things up if the increment is 0, so make it $1 instead.
			 	return 1;
			 }
			 return $show_increment->INCREMENT;
		}
		else
		{
			return 1;
		}
	} //end of function get_increment

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function send_current_low_bidder_email($db,$bidder_id)
	{
		//echo "Inside send_current_low_bidder_email in auction_bid_class<br/>";
		$this->page_id = 10168;
		$this->get_text();
		$bidder_info = $this->get_user_data($bidder_id);

		if (($bidder_info) && ($this->auction))
		{
			$message_data["subject"] = urldecode($this->messages[102480]);
			$message_data['message'] = $this->get_salutation($bidder_info);

			$message_data["message"] .= urldecode($this->messages[102481]);
			$message_data["message"] .= $this->show_email_auction_specs($db,$bidder_id);
			$this->sendMail($bidder_info->EMAIL, $message_data['subject'],$message_data['message']);

			return true;
		}
		else
		{
			return false;
		}
	} //end of function send_current_low_bidder_email

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function send_outbid_email(& $db,$bidder_id)
	{
		$this->page_id = 10169;
		$this->get_text();
		$bidder_info = $this->get_user_data($bidder_id);

		if (($bidder_info) && ($this->auction))
		{
			$message_data['message'] = $this->get_salutation($bidder_info);

			$message_data["message"] .= urldecode($this->messages[102474])."\n";
			$message_data["message"] .= $this->show_email_auction_specs($db);
			$message_data["subject"] = urldecode($this->messages[102473]);
			$this->sendMail($bidder_info->EMAIL, $message_data["subject"], $message_data["message"]);

			return true;
		}
		else
		{
			return false;
		}
	} //end of send_outbid_email


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function show_email_auction_specs($db,$bidder_id=0)
	{
		$this->page_id = 10170;
		$this->get_text();
		$function_name = "show_email_auction_specs";

		if ($this->auction)
		{
			$email_auction_data = "\r\n".urldecode($this->messages[102475]).urldecode($this->auction->TITLE);
			//$email_auction_data .= "$this->separator".urldecode($this->messages[102476]).urldecode($this->auction->DESCRIPTION);

			//get current bid
			$sql = "select current_bid from ".$this->classifieds_table."
				where id = ?";
			$get_current_result = $this->db->Execute($sql, array($this->auction_id));
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
			if($this->db->get_site_setting('debug_bid'))
			{
				$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "get current bid from auctions table by auction id");
			}
			if (!$get_current_result)
			{
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				return false;
			}
			elseif ($get_current_result->RecordCount() == 1)
			{
				$show_current_bid = $get_current_result->FetchNextObject();
				$display_amount = $this->show_money($show_current_bid->CURRENT_BID,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
				$email_auction_data .= "\r\n".urldecode($this->messages[102482])." ".$display_amount."\n\n";
			}

			if ($bidder_id)
			{
				$sql = "select * from ".$this->autobid_table." where auction_id = ? and bidder = ?";
				$get_autobid_result = $this->db->Execute($sql, array($this->auction_id, $bidder_id));
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$this->auction_id.", ".$bidder_id."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "get data from autobid table by auction and bidder id");
				}
				if (!$get_autobid_result)
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
					return false;
				}
				elseif ($get_autobid_result->RecordCount() == 1)
				{
					$show_autobid = $get_autobid_result->FetchNextObject();
					$display_amount = $this->show_money($show_autobid->MAXBID,$this->db->get_site_setting('precurrency'),$this->db->get_site_setting('postcurrency'));
					$email_auction_data .= "\r\n".urldecode($this->messages[102483])." ".$display_amount."\n\n";
				}
			}
			$email_auction_data .= "\r\n".urldecode($this->messages[102478]).date($this->db->get_site_setting('entry_date_configuration'),$this->auction->ENDS);
			$email_auction_data .= "\r\n".urldecode($this->messages[102479])."\r\n".$this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
			return $email_auction_data;
		}
	} //function show_email_auction_specs

//##############################################################################

	/** THIS FUNCTION IS NOT USED.
	 *	The system uses the get_bid_history() in auction_bid_class.php for all types of auctions.
	 *  This can probably be deleted, but leaving it here for now, to be safe (12/8/09) 
	 */
	function get_bid_history($db,$auction_id,$aff_id=0)
	{
		$this->page_id = 10171;
		$this->get_text();
		$function_name = "get_bid_history";

		if ($auction_id)
		{
			$sql = "select * from ".$this->db->geoTables->bid_table." where auction_id = ? order by time_of_bid asc,bid desc";
			$bid_history_result = $this->db->Execute($sql, array($auction_id));
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$auction_id."<br/>\n";
			if($this->db->get_site_setting('debug_bid'))
			{
				$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "get data from autobid table by auction and bidder id");
			}

			if (!$bid_history_result)
			{
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				return false;
			}
			elseif ($bid_history_result->RecordCount() > 0)
			{
				$current_auction = $this->get_classified_data($auction_id);
				//there are bids on this auction and show them
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$this->body." is the body so far<br/>\n";
				$this->body .= "<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n";
				$this->body .= "<tr class=page_title>\n\t<td colspan=4>".urldecode($this->messages[102466])."</td>\n</tr>\n";
				$this->body .= "<tr class=page_instructions>\n\t<td colspan=4>".urldecode($this->messages[102467])."</td>\n</tr>\n";
				$this->body .= "<tr class=browsing_result_table_header>\n\t<td>".urldecode($this->messages[102469])."</td>\n\t";
				$this->body .= "<td>".urldecode($this->messages[102470])."</td>\n\t";
				$this->body .= "<td>".urldecode($this->messages[102471])."</td>\n</tr>\n\t";
				$this->row_count = 0;
				while ($show_bid = $bid_history_result->FetchNextObject())
				{
					if (($this->row_count % 2) == 0)
						$css_row_tag = "browsing_result_table_body_even";
					else
						$css_row_tag = "browsing_result_table_body_odd";

					$this->body .= "<tr class=".$css_row_tag."><td>".date($this->db->get_site_setting('entry_date_configuration'),$show_bid->TIME_OF_BID)."</td>\n\t";
					$display_amount = $this->show_money($show_bid->BID,$current_auction->PRECURRENCY,$current_auction->POSTCURRENCY);
					$this->body .= "<td>$display_amount</td>\n\t";
					$bidder_data = $this->get_user_data($show_bid->BIDDER);
					$this->body .= "<td>".$bidder_data->USERNAME;
					//if (!defined('VIEW_EMAIL_AFTER_AUCTION_OVER'))
					//	$view_email_after_auction_over = 0;
					//else
					//	$view_email_after_auction_over = VIEW_EMAIL_AFTER_AUCTION_OVER;
					$view_email_after_auction = $this->db->get_site_setting('view_email_after_auction');
					if (($this->userid == $current_auction->SELLER) && ($view_email_after_auction_over))
						$this->body .= " (".$bidder_data->EMAIL.")";
					$this->body .= "</td>\n\t</tr>\n";
					$this->row_count++;
				}
  				$this->body .= "<tr class=edit_approval_links>\n\t<td colspan=3><a href=".$this->db->get_site_setting('classifieds_file_name')."?a=2&b=".$auction_id." class=edit_approval_links>".urldecode($this->messages[102468])."</a></td>\n</tr>\n";
				$this->body .= "</table>";
			}
			else
			{
				//there were no bids for this auction
				$this->body .= "<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">\n";
				$this->body .= "<tr class=page_title>\n\t<td colspan=3>".urldecode($this->messages[102466])."</td>\n</tr>\n";
				$this->body .= "<tr class=page_instructions>\n\t<td colspan=3>".urldecode($this->messages[102467])."</td>\n</tr>\n";
				$this->body .= "<tr class=page_instructions>\n\t<td colspan=3>".urldecode($this->messages[102472])."</td>\n</tr>\n";
			    $this->body .= "<tr class=page_instructions>\n\t<td colspan=2><a href=".$this->db->get_site_setting('classifieds_file_name')."?a=2&b=".$auction_id." class=page_instructions>".urldecode($this->messages[102468])."</a></td>\n</tr>\n";
				$this->body .= "</table>";
			}
			$this->display_page($db);
			return true;
		}
		else
		{
			return false;
		}

	} //end of function get_bid_history

//##############################################################################

	/**
	 * generates text for additional fees
	 */
	function get_additional_fee_text(){
		//display any optional fields that add to the cost.
		$additional_costs = array ( 'total' => 0);
		$message_data = '';
		$userId = $this->auction->SELLER;
		$groupId = ($userId)? geoUser::getUser($userId)->group_id : 0;
		
		$fields = geoFields::getInstance($groupId, $this->auction->CATEGORY);
		for ($i = 1; $i < 21; $i++){
			//go through all the optional fields, see if they add cost, and if they do,
			//see if the value actually adds any cost (not 0 or blank field)
			$option = 'OPTIONAL_FIELD_'.$i;
			$fieldName = 'optional_field_'.$i;
			if ($fields->$fieldName->field_type=='cost' && $this->auction->$option>0){
				//this optional field needs to be displayed.
				$additional_costs[$i] = $this->show_money($this->auction->$option,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
				$additional_costs['total'] += $this->auction->$option;
			}
		}
		if ($additional_costs['total']>0){
			//there are additional costs to display!
			$message_data.= urldecode($this->messages[500033])."\n";
			foreach ($additional_costs as $key => $cost){
				//go through all the additional costs and display them
				if ($key != 'total')//don't display the total twice!
					$message_data.=$cost."\n";
			}
			//display the additional fee total.
			$message_data.=urldecode($this->messages[500035]).$this->show_money($additional_costs['total'],$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY)."\n\n";
			//display the grand total
			$grand_total = $this->auction->BUY_NOW+$additional_costs['total'];
			$grand_total = $this->show_money($grand_total,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
			$message_data.=urldecode($this->messages[500036]).$grand_total."\n\n";
			//display the additional fee disclaimer
			$message_data.=urldecode($this->messages[500034])."\n\n";
		}
		return $message_data;
	}
	//##############################################################################

	/**
	 * Emails buy-now bidder and seller
	 */
	function email_buy_now_bidder_and_seller(& $aff_id,& $seller){
		//send emails to seller and buy now bidder
	    //to buy now bidder
	    $message_data['message'] = $this->get_salutation($this->bidder);

		$message_data["message"] .= urldecode($this->messages[102493])."\n\n";
		$display_amount = $this->show_money($this->auction->BUY_NOW,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		//if ($this->DEBUG_BID) { echo 'Auction Info: <pre>'; var_dump($this->auction); var_dump($this->configuration_data); echo "</pre><br />\n"; }
		$message_data["message"] .= urldecode($this->messages[102494]).$display_amount."\n\n";
		//add additional fees text
		$additional_fees = $this->get_additional_fee_text();
		$message_data["message"] .= $additional_fees;
		$message_data["message"] .= $seller->FIRSTNAME." ".$seller->LASTNAME."\n".$seller->EMAIL."\n\n";
		$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
		$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
			
		if (geoPC::is_ent()){
			//see if there should be seller to buyer text
			$vars = array(
				'listing_id' => $this->auction->ID,
				'winning_bidder_id' => $this->bidder->ID,
				'listing_details' => $this->auction,
				'final_price' => $this->auction->BUY_NOW
			);
			$sb_links = geoSellerBuyer::callDisplay('displayPaymentLinkBuyNowEmail', $vars);
			if (strlen($sb_links) > 0){
				$message_data['message'].="\n".$sb_links;
			}
		}
		$message_data["subject"] = urldecode($this->messages[102492]);

		if ($this->DEBUG_BID)
		{
			echo $message_data["message"]." is the message sent to the high bidder<br/>\n";
		}


		if ($this->DEBUG_BID){
			echo 'E-mailing buy now bidder:<pre>';
			var_dump($message_data);
			echo "</pre><br />\n";
		}
		$this->sendMail($this->bidder->EMAIL, $message_data["subject"], $message_data["message"]);

		//to seller
		$message_data['message'] = $this->get_salutation($seller);

		$message_data["message"] .= urldecode($this->messages[102496])."\n\n";
		$display_amount = $this->show_money($this->auction->BUY_NOW,$this->auction->PRECURRENCY,$this->auction->POSTCURRENCY);
		$message_data["message"] .= urldecode($this->messages[102494])." ".$display_amount."\n\n";
		//add additional fees text
		$message_data["message"] .= $additional_fees;
		$message_data["message"] .= $this->bidder->FIRSTNAME." ".$this->bidder->LASTNAME."\n".$this->bidder->EMAIL."\n\n";
		$message_data["message"] .= urldecode($this->auction->TITLE)."\n";
		$message_data["message"] .= $this->db->get_site_setting('classifieds_url')."?a=2&b=".$this->auction_id."\n\n";
		$message_data["subject"] = urldecode($this->messages[102495]);
		if ($this->DEBUG_BID){ echo 'E-mailing buy now seller:  <pre>'; var_dump($message_data); echo "</pre><br />\n"; }
		$this->sendMail($seller->EMAIL, $message_data["subject"], $message_data["message"]);

	} //end of function email_buy_now_bidder_and_seller
	
//##############################################################################

	function start_delayed_auction() {
		if ($this->auction->DELAYED_START == 1)
		{
			//set the start time to now
			//set the end time to the current start time plus the duration
			//set delayed_start to 0 
			
			$start_time = geoUtil::time();
			$auction_length = $this->auction->DURATION * 86400;
			$end_time = geoUtil::time() + $auction_length;
			$sql = "update ".$this->db->geoTables->classifieds_table." set 
				date = ? ,
				ends = ? ,
				delayed_start = 0
				where id = ? ";
			$start_auction_result = $this->db->Execute($sql, array($start_time, $end_time, $this->auction_id));
			if (!$start_auction_result)
			{
				echo $this->db->ErrorMsg()." is the errormsg<br>\n";
				echo $sql." is the sql<br>\n";
				echo $start_time." is the \$start_time<br>\n";
				echo $end_time." is the \$start_time<br>\n";
				echo $this->auction_id." is the \$this->auction_id<br>\n";
				return false;
			}
			else
			{
				//successfully started auction from delayed start state
				return true;
			}
		}
		else
		{
			//this is not a delayed start auction
			return true;
		}
	} //end of function start_delayed_auction
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function insert_into_bid_table($bid=0,$current_time=0,$quantity=0,$buy_now_bid=0,$bidder=0)
	{
		if ($bidder == 0)
		{
			//use the current bidder logged in
			$bidder = $this->bidder->ID;
		}
		else
		{
			//use the bidder passed in...could be from proxy	
		}
		if ($bid && $current_time && $quantity)
		{
			$sql = "insert into ".$this->bid_table."
				(auction_id,bidder,bid,time_of_bid,quantity,buy_now_bid)
				values (?, ?, ?, ?, ?, ?)";
			$query_data = array	($this->auction_id, $bidder, $bid,$current_time,$quantity,$buy_now_bid);
			$insert_bid_result = $this->db->Execute($sql, $query_data);
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$this->auction_id.", ".$bidder.", ".$bid.", ".$current_time.", ".$quantity.", ".$buy_now_bid."<br/>\n";
			if($this->db->get_site_setting('debug_bid'))
			{
				$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "insert data into bid table");
			}
			if ($insert_bid_result)
				return true;
			else
			{
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
				return false;
			}
		}
		else
		{
			return false;
		}
		
	} //end of function insert_into_bid_table
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_maximum_current_and_price($minimum,$current,$price)
	{
		$sql = "update ".$this->classifieds_table." set
			minimum_bid = ?,
			current_bid = ?,
			price = ?
			where id=?";
		$bid_result = $this->db->Execute($sql, array( $minimum, $current, $price, $this->auction_id));
		if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." ".$minimum.", ".$current.", ".$price.", ".$this->auction_id."<br/>\n";
		if($this->db->get_site_setting('debug_bid'))
		{
			$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update data in auctions table by auction id");
		}		
		if ($bid_result)
		{
			return true;
		}
		else
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
			return false;
		}
		
	} //end of function update_maximum_current_and_price
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function set_current_and_price_to_zero()
	{
		$sql = "update ".$this->classifieds_table."
			set current_bid = 0,
			set price = 0
			where id = ?";
		$set_minimum_result = $this->db->Execute($sql, array($this->auction_id));
		if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$this->auction_id."<br/>\n";
		if (!$set_minimum_result)
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
			return false;
		}
		
		if($this->db->get_site_setting('debug_bid'))
		{
			$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update data in auction table by auction id");
		}		
		return true;
	}
	
//###################################################################################

	function auction_extension_check($current_time)
	{
		if($this->db->get_site_setting('auction_extension_check') > 0)
		{
			//Fetch the time of the current bid
			//Check current_bid time is greater than auction_ends - auction_extension_check and less than
			// auction_ends
			//if true, add auction_extension to auction_ends and update the data
			//else do nothing
			if(($current_time >=($this->auction->ENDS-$this->db->get_site_setting('auction_extension_check')*60))
				&& ($current_time <= $this->auction->ENDS))
			{
				$this->auction->ENDS = $this->auction->ENDS+$this->db->get_site_setting('auction_extension')*60;
				//echo $this->auction->ENDS." is the new end time <br/>";
				$sql = "update ".$this->classifieds_table."
					set ends = ?
					where id = ?";
				$update_result = $this->db->Execute($sql, array($this->auction->ENDS, $this->auction_id));
				if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				if($this->db->get_site_setting('debug_bid'))
				{
					$this->debug_display($sql, $db, $this->filename, $function_name, "classifieds_table", "update ends attribute in auction table by auction id");
				}
				else
				{
					if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
				}
			}
			else
			{
				//echo "Time is not in auction extension check range<br/>";
			}
		}		
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function insert_into_autobid_table($bid=0,$current_time=0,$quantity=0)
	{
		if ($bid && $current_time && $quantity)
		{
			$sql = "insert into ".$this->autobid_table."
				(auction_id,bidder,maxbid,time_of_bid,quantity)
				values (?, ?, ?, ?, ?)";
			$query_data = array	($this->auction_id, $this->bidder->ID, $bid, $current_time, $quantity);
			$insert_autobid_result = $this->db->Execute($sql, $query_data);
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." - ".$this->auction_id.", ".$this->bidder->ID.", ".$bid.", ".$current_time.", ".$quantity."<br/>\n";
			if($this->db->get_site_setting('debug_bid'))
			{
				$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "insert data into auctions table");
			}
			if ($insert_autobid_result)
				return true;
			else
			{
				if ($this->DEBUG_BID) 
				{
					echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
					echo $this->auction_id." is \$this->auction_id<br>\n";
					echo $this->bidder->ID." is \$this->bidder->ID<br>\n";
					echo $bid." is \$bid<br>\n";
					echo $current_time." is \$current_time<br>\n";
					echo $quantity." is \$quantity<br>\n";
				}
				return false;
			}
		}
		else
		{
			return false;
		}
		
	} //end of function insert_into_autobid_table	
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function delete_from_autobid_table()
	{
		$sql = "delete from ".$this->autobid_table."  where auction_id = ?";
		$delete_autobid_result = $this->db->Execute($sql, array($this->auction_id));
		if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql."<br/>\n";
		if($this->db->get_site_setting('debug_bid'))
		{
			$this->debug_display($sql, $db, $this->filename, $function_name, "bid_table", "delete data in bid table by auction id");
		}
		if ($delete_autobid_result)
		{
			return true;
		}
		else
		{
			if ($this->DEBUG_BID) echo 'LINE '.__LINE__.' '.$sql." error: ".$this->db->ErrorMsg()."<br/>\n";
			return false;
		}
		
	} //end of function insert_into_bid_table		
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	
	
} //end of class Auction_bid
