<?php
//edit.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 19862              $ ##
## File last change date:       ##
##  $Date:: 2010-06-25 10:00:#$ ##
##                              ##
##################################


if (!defined('IN_GEO_API')){
	exit('No access.');
}

$generic_error = 'Username or Password not correct.';

if (!isset($args['username']) || (!isset($args['password']) && !isset($args['password_bypass']))){
	//user or pass not sent?
	return $this->return_error_with_delay($generic_error.__line__);
}
if (!isset($args['password_bypass'])) $args['password_bypass'] = false;

if (strlen(trim($args['username'])) == 0 || (strlen(trim($args['password'])) == 0 && !$args['password_bypass'])){
	//string length 0
	return $this->return_error_with_delay($generic_error.__line__);
}

if (!$args['password_bypass'] && !$this->product_configuration->verify_credentials($args['username'], $args['password'])){
	return $this->return_error_with_delay($generic_error.__line__);
}

//user and pass check out, get token
$sql = 'SELECT `api_token` FROM `geodesic_logins` WHERE `username` = ? AND `id` != 1 LIMIT 1';
$result = $this->db->Execute($sql, array(trim($args['username'])));
if (!$result || $result->RecordCount() != 1){
	return $this->return_error_with_delay('Error getting token for use, DB error.');
}
$row = $result->FetchRow();
$token = $row['api_key'];
if (strlen(trim($token)) == 0){
	$token = $this->resetUserToken($args['username']);
}
//return token
return $token;