<?php
//changeStatus.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 19862              $ ##
## File last change date:       ##
##  $Date:: 2010-06-25 10:00:#$ ##
##                              ##
##################################

if (!defined('IN_GEO_API')){
	exit('No access.');
}

//generic error to give in any situation where user/pass/token is not working.
$generic_error = 'Username or password or user token was incorrect or was not specified, request to change status has failed.';

if (!isset($args['username']) || !(isset($args['password']) || isset($args['token'])) ){
	//give same generic error whether it's not sent, username not found, or password doesn't match.
	//Error needs to be the same for security reasons, to make it harder to guess user/pass combinations.
	return $this->return_error_with_delay(__line__.$generic_error);
}

$username = $args['username'];

if (strlen(trim($username))==0){
	return $this->return_error_with_delay($generic_error);
}

//check the user/password/token first...
if (isset($args['password'])){
	//verify using user/pass
	if (!$this->product_configuration->verify_credentials($username, $args['password'])){
		//user or pass does not match.
		return $this->return_error_with_delay($generic_error);
	}
} else {
	//verify using token
	$token = (isset($args['token']))? $args['token']: '';
	if (!$this->checkUserToken($username, $token)){
		//token is not valid
		return $this->return_error_with_delay($generic_error);
	}
	//made it this far, the token checks out.
}

if (!isset($args['status'])) {
	return $this->return_error_with_delay('New status (0 for suspended, 1 for active) not specified.');
}
$status = ($args['status'])? 1 : 0;

//set status for user
$sql = "UPDATE `geodesic_logins` SET `status`=? WHERE `username` = ? LIMIT 1";
$result = $this->db->Execute($sql, array($status, $username));
if (!$result){
	//doh!
	return $this->return_error_with_delay('DB Error updating status.');//.$this->db->ErrorMsg());
}

return 'Update user status was a success.';