<?php
//getListing.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20337              $ ##
## File last change date:       ##
##  $Date:: 2010-09-13 15:03:#$ ##
##                              ##
##################################

if (!defined('IN_GEO_API')){
	exit('No access.');
}

//search among the listings in a specific category for a specific string
//NOTE: either or both of the category or search string may be blank/not present
//if neither are passed in, this should return ALL live listings


$searchStr = trim($args['search_string']);

//optionally, search in a specific category
$category = trim($args['category']);

$sql = "SELECT `id`, `title`, `description`, `price`, `current_bid`, `buy_now`, `buy_now_only`, `item_type` FROM `geodesic_classifieds` WHERE `live` = 1 ";

$conditions = $params = array();

if($category && is_numeric($category)) {
	//searching in a specific category (and its subcategories)
	//if this is not present, will search all categories 
	
	//get in_statement for this category
	$catSql = "SELECT `in_statement` FROM `geodesic_categories` WHERE `category_id` = ?";
	$in = $this->db->GetOne($catSql, array($category));
	
	//add it to the main query
	$sql .= " AND `category` $in ";
}

if(strlen($searchStr) > 0) {
	//search for a specific string
	//if this is not present, should pull all listings in the specified category	
	
	$title = geoString::fromDB($searchStr); //data comes in urlencoded -- undo that first
	
	//format string for searching in the database
	$title = geoString::specialChars($title);
	
	
	//set up to escape hardcoded SQL-specific search characters
	$find = array ('%','_');
	$replace = array ('\%','\_');
	$title = str_replace($find,$replace,geoString::toDB($title));
	
	$description = str_replace($find,$replace,geoString::toDB($searchStr));
	
	//search in the title
	$conditions[] = "`title` LIKE '%".$title."%'";
	
	//note: description requires one less specialChars pass than other fields
	//so use $searchStr instead of $title
	$conditions[] = "`description` LIKE '%".$description."%'";
	
	//search `search_text` field (category-specific questions) -- formatted the same as title
	$conditions[] = "`search_text` LIKE '%".$title."%'";
	
	if(geoPC::is_ent()) {
		for($i = 1; $i < 20; $i++) {
			//search site-wide optional fields -- formatted the same as title
			$conditions[] = "`optional_field_$i` LIKE '%".$title."%'";
		}
	}
	$sql .= " AND (".implode(' OR ',$conditions).") ";
}

$result = $this->db->Execute($sql);
if (!$result){
	//db error:
	return $this->return_error_with_delay($sql.' :: '.$this->db->ErrorMsg(),0);
}

$return = array();
while($line = $result->FetchRow()) {
	
	//get the lead thumbnail for this listing
	$sql = "SELECT image_url, thumb_url FROM geodesic_classifieds_images_urls WHERE classified_id = ? ORDER BY display_order ASC LIMIT 1";
	$imgRow = $this->db->GetRow($sql, array($line['id']));
	$img = ($imgRow['thumb_url']) ? $imgRow['thumb_url'] : $imgRow['image_url'];
	if(!$img) {
		$img = '';
	} elseif(substr($img, 0,4) != 'http') {
		//this is a local reference to an image -- make it be the full URL instead
		$base_url = str_replace($this->db->get_site_setting('classifieds_file_name'),'',$this->db->get_site_setting('classifieds_url'));
		$img = $base_url . $img;
	} else {
		//image is already a complete URL (probably bulkuploaded). don't jack with it
	}
	
	//set up description
	$desc = geoFilter::listingDescription($line['description']);
	$desc = str_replace(array("\n","\r","\t"), '', $desc); //remove newlines and tab characters.
	$desc = geoString::toDB($desc); //redo db encoding for transmit across the net
	$desc = str_replace('+','%20', $desc); //iPhone can't decode '+', so use '%20' instead
	
	//figure out which price to show
	if($line['item_type'] == 1) {
		$price = $line['price'];
	} else {
		$price = ($line['buy_now_only'] == 1) ? $line['buy_now'] : $line['current_bid'];
	}
	$price = geoString::displayPrice($price);
	
	//format title for iphone
	$title = geoString::fromDB($line['title']); //undo db encoding
	$title = geoString::specialCharsDecode($title); // undo HTML filtering here, because iPhone can't
	$title = geoString::toDB($title); //redo db encoding for transmit across the net
	$title = str_replace('+','%20', $title); //iPhone can't decode '+', so use '%20' instead
	
	
	//assemble data to send to requester
	$listing = array(
		'listingId' => $line['id'],
		'title' => $title,
		'description' => $desc,
		'price' => $price,
		'thumbnail' => $img
	);
	$return[] = $listing;
}

return $return;