<?php
//getListing.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20242              $ ##
## File last change date:       ##
##  $Date:: 2010-08-23 12:06:#$ ##
##                              ##
##################################

if (!defined('IN_GEO_API')){
	exit('No access.');
}

//check to see if a specified user or e-mail exists already in the Geo software.

if (!isset($args['listing_id']) || !$args['listing_id'] || !is_numeric($args['listing_id'])){
	return $this->return_error_with_delay('Error:  Need a listing ID to get information for a listing.', 0);
}

$fields = ($args['fields']) ? $args['fields'] : '*';

$sql = "SELECT ".$fields." FROM `geodesic_classifieds` WHERE `id` = ?";
$result = $this->db->GetRow($sql, array($args['listing_id']));
if (!$result){
	return $this->return_error_with_delay('DB Error!  Please try again.',0);
}

$listing['fields'] = $result;



//get images, too
//TODO: consider getting only the lead image here (and doing all of them on a separate request)
$sql = "SELECT image_url, thumb_url FROM `geodesic_classifieds_images_urls` WHERE `classified_id` = ? order by display_order ASC";
$result = $this->db->Execute($sql, array($args['listing_id']));
//TODO: default "no picture" image

$base_url = str_replace($this->db->get_site_setting('classifieds_file_name'),'',$this->db->get_site_setting('classifieds_url'));

$images = array();
for($i = 0; $line = $result->FetchRow(); $i++) {
	
	$images[] = array(
		'full' => ((substr($line['image_url'], 0,4) != 'http') ? $base_url.$line['image_url'] : $line['image_url']),
		'thumb' => ((substr($line['thumb_url'], 0,4) != 'http') ? $base_url.$line['thumb_url'] : $line['thumb_url']),
	);
}
$listing['images'] = $images;
return $listing;