<?php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 10492              $ ##
## File last change date:       ##
##  $Date:: 2007-04-30 10:02:#$ ##
##                              ##
##################################

function AJAXErrorHandler( $errno, $errstr, $errfile, $errline, $errcontext ) {
	/*	
    The first parameter, errno, contains the level of the error raised, as an integer. 
    The second parameter, errstr, contains the error message, as a string. 
    The third parameter is optional, errfile, which contains the filename that the error was raised in, as a string. 
    The fourth parameter is optional, errline, which contains the line number the error was raised at, as an integer.
    */
	ob_start();
	if (!defined('E_DEPRECATED')) define('E_DEPRECATED', 8192);//constant added on PHP 5.3
	if (!defined('E_USER_DEPRECATED')) define('E_USER_DEPRECATED', 16384);//constant added on PHP 5.3
	
    if( $errno & ( E_NOTICE | E_WARNING | E_STRICT | E_DEPRECATED | E_USER_DEPRECATED ) ) {
    	ob_end_clean();
    	return true;
    }
    ob_end_clean();
    if( strpos( $errstr, 'DEBUG') === 0 ) {
		return true;
	}
	if( strpos( $errstr, 'ERROR') === 0 ) {
		return true;
	}
	if( $errno & ( E_ERROR | E_PARSE | E_CORE_ERROR | E_COMPILE_ERROR | E_RECOVERABLE_ERROR ) ) {
		die( "<error>{$errstr} on line {$errline} of {$errfile}</error>" );
	} else if( $errno & E_USER_NOTICE) {
		echo "<user_error>{$errstr} on line {$errline} of {$errfile}</user_error>";
	} else {
		echo "<error>{$errno} {$errstr} on line {$errline} of {$errfile}</error>";
	}
}

class geoAjax {
	var $directory = '';
	
	/**
	 * Gets an instance of the geoAjax class.
	 * @return geoAjax
	 */
	public static function getInstance()
	{
		return Singleton::getInstance('geoAjax');
	}
	
	public static function isAjax ()
	{
		return (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest');
	}
	
	function Ajax() {
		ob_start();
	}
	
	function notAuthorized() {
		trigger_error( 'Not authorized' );
		exit;
	}
	
	function dispatch( $controller, $action, $data = '' ) {
		if(strstr($controller,"addon_")){
 			// check for addons
 			$addon = true;
 			include(GEO_BASE_DIR.'get_common_vars.php');
 			$addonName = str_replace("addon_","",$controller);
 			
 			if(!$addon->isEnabled($addonName)) {
 				trigger_error( $addonName . ' is not enabled or installed');
 				exit;
 			}
 			
 			$filename = ADDON_DIR . $addonName . '/'.$this->directory.'.ajax.php';
 			$class = 'addon_' . $addonName . '_'.$this->directory.'_ajax';
 		} else {
			//account for changed admin, addon, or classes dir
			if ($this->directory == 'ADMIN'){
				//allows admin directory name to change without need of changing PHP files.
				$dir_start = ADMIN_DIR;
			} else if (strpos($this->directory,'ADDON_') === 0){
				//if the directory starts with ADDON_
				$dir_start = str_replace('ADDON_',ADDON_DIR,$this->directory) . '/';
			} else if ($this->directory == 'CLASSES') {
				//allows classes directory name to change without need of changing PHP files.
				$dir_start = CLASSES_DIR;
			} else {
				//not a special case, this is located in a directory that cannot have
				//a changed name.
				$dir_start = GEO_BASE_DIR.$this->directory.'/';
			}
			
			$filename = $dir_start.'AJAXController/' . $controller . '.php';
			
			
			$class = $this->directory.'_AJAXController_' . $controller;
 		}
		
		if( !$controller || !$action ) {
			trigger_error( 'Not enough data to perform request' );
			exit;
		}
		
		if( !file_exists($filename) ) {
			trigger_error( 'Cannot find ' . $filename );
			exit;
		}
		
		require_once $filename;
		
		if( !class_exists($class) ) {
			trigger_error( 'Class ' . $class . ' does not exist' );
			exit;
		}
		$methods = get_class_methods($class);
		if( !in_array( strtolower($action), $methods) && !in_array( $action, $methods ) ) {
			trigger_error( $action . ' does not exist in ' . $class );
			exit;
		}
		
		$ajax = new $class();
		echo $ajax->$action( $data );
	}
	
	function encodeJSON( $data ) {
		return json_encode($data);
	}

	function decodeJSON( $data ) {
		return json_decode($data);
	}
	
	public function jsonHeader ()
	{
		//set header for charset, otherwise it won't show up right for weird charsets..
		$charset = geoString::getCharsetTo();
		if (!$charset){
			//if not using charsetTo, then use the charsetclean setting.
			$charset = geoString::getCharset();
		}
		//set header for json content, usually used by prototype.
		header('Content-Type: application/json; charset='.$charset);
	}
}
//For backwards compatibility, remove once all locations have been updated to use Ajax.
class Ajax extends geoAjax {}