<?php
// admin_state_management_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20911              $ ##
## File last change date:       ##
##  $Date:: 2011-01-13 15:41:#$ ##
##                              ##
##################################

class State_management extends Admin_site {

	var $internal_error_message = "There was an internal error";
	var $data_error_message = "Not enough data to complete request";
	var $page_text_error_message = "No text connected to this page";
	var $no_pages_message = "No pages to list";

	var $text_management_title_message = "State Management Admin";
	var $text_management_instruction_message = "You can control the states that this application displays in it's state dropdown
		boxes throughout the site within this administration tool.  Add new states by using the form supplied or delete a specific state
		using the delete button next to the state you wish to delete.  The states will appear in alphabetical order.";

	var $state_error;
	var $db;
	var $menu_loader;
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function State_management($db=0, $product_configuration=0)
	{
		$this->Admin_site($db, $product_configuration);
		$this->db = DataAccess::getInstance();
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_state_list()
	{
		$this->body .= "<form action=index.php?mc=geographic_setup&page=geographic_states_provinces method=post>
			<script type=\"text/javascript\">
				function validate(field)
				{
					re = /([^0-9.])/;
					if (field.value.match(re))
					{
						alert('You must enter a numeric value only.');
						field.value=\"\";
						field.focus();
					}
				}
				function display_percent(field,percent_id)
				{
					if (field.value == 1)
						document.getElementById(percent_id).style.display = 'none';
					else
						document.getElementById(percent_id).style.display = '';
				}
			</script>
			";

		$this->additional_header_html .= "
		<script type='text/javascript'>
			function checkAll( table )
			{
				boxes = document.getElementById(table+'_table').getElementsByTagName('input');
				for( x in boxes )
				{
					if ( boxes[x].type == 'checkbox' )
						boxes[x].checked = true;
				}
			}
			function uncheckAll( table )
			{
				boxes = document.getElementById(table+'_table').getElementsByTagName('input');
				for( x in boxes )
				{
					if ( boxes[x].type == 'checkbox' )
						boxes[x].checked = false;
				}
			}
			function hideTable( table )
			{	
				theTable = document.getElementById(table+'_table');
				container = document.getElementById(table+'_listItem');
				
				if( theTable.style.display == 'none' ) {
					theTable.style.display = '';
					container.style.borderColor = '#006699';
				} else {
					theTable.style.display = 'none';
					container.style.borderColor = '#EAEAEA';
				}
			}
		</script>";





		$country_query = "SELECT country_id, name FROM ".$this->db->geoTables->countries_table.' ORDER BY display_order ASC';
		$country_rs = $this->db->Execute($country_query);
		
		if (!$country_rs)
		{
			$this->error_message = $this->internal_error_message;
			return false;
		}
	
		$count = 0;

		$this->body .= "
		<fieldset id='NewState'>
				<legend>Add New State / Province</legend>
				<div>
				<table cellpadding=3 cellspacing=1 border=0 width=\"100%\">
					<tr>
						<td class=col_hdr_left width=\"10%\">
							Parent Country
						</td><td class=col_hdr_left width=\"30%\">
							State / Province
						</td><td class=col_hdr width=\"10%\">
							Abbrev.
						</td><td class=col_hdr width=\"15%\">
						<nobr>Display Order".geoHTML::showTooltip('display order', 'Control the display order of all your dropdown boxes here. States will be displayed according to their "display order" in ascending order')."</nobr>
					</td><td class=col_hdr_left width=\"15%\">
						<nobr>Tax".geoHTML::showTooltip('tax','Values can range from 0.0001 to 99999.9999')."</nobr>
					</td><td class=col_hdr_left width=\"10%\">
						<nobr>Tax Type".geoHTML::showTooltip('tax type','Decide whether to charge a flat tax vs. a percentage based on the <strong>user\'s registered state/province.</strong><br />For example, if you wish to charge $1.25 tax for every purchase, regardless of the amount of purchase, then choose "flat tax" and set tax = 1.25 <br />If, however, you wish to charge a 1.25% tax based on the amount of purchase, then choose "rate" and set tax = 1.25 <br /><strong>WARNING: The tax will be calculated using the same type of currency as the sub-total at the time of purchase. </strong>')."</nobr>
					</td><td class=col_hdr width=\"10%\">
							&nbsp;
						</td>
					</tr>
							";
		if ($this->state_error)
			$this->body .= "<tr>
						<td colspan=100% class=medium_error_font align=center>
							".$this->state_error."
						</td>
					</tr>";
		$this->body .= "
					<tr class=row_color2>
						<td class=medium_font>
							<select name=b[parent_id]>
								".$this->display_parent_dropdown_opts()."
							</select>
						</td><td class=medium_font>
							<input type=text name=b[name] size=30 maxsize=255>
						</td><td align=center>
							<input type=text name=b[abbreviation] size=5 maxsize=255>
						</td><td align=center>
							<input onkeyup=\"javascript:validate(this)\" type=text name=b[order] size=5>
						</td><td>
							<nobr><input onkeyup=\"javascript:validate(this)\" type=text name=b[tax] size=8 maxlength=10><b id=percent>%</strong></nobr>
						</td><td class=medium_font>
							<nobr><input onclick=\"javascript:display_percent(this,'percent')\" type=radio name=b[tax_type] value=0 checked><strong>rate</strong> (ie 8.25 %)</nobr><br>
							<nobr><input onclick=\"javascript:display_percent(this,'percent')\" type=radio name=b[tax_type] value=1><strong>flat tax</strong></nobr>
						</td>";
		if (!$this->admin_demo()) {
			$this->body .= "	<td align=center>
							<input type=submit name='auto_save' value=\"Save\">
						</td>";
		}
		$this->body .= "
					</tr>
				</table>
				</div>
			</fieldset>";		
		
		$this->body .= "
			<fieldset id='CurrentStates'>
				<legend>Current State / Province / Country Associations</legend>
				<div>";
		
		$this->body .= "
					<table>
						<tr>
							<td class=col_hdr col span=100%>State(s) / Province(s) Reassignment</td>
						<tr>
							<td class=medium_font align=\"center\"><br />
								Reassign \"checked\" States / Provinces to this Parent Country:<br /><br />
								<select name='d[mass_country]'>
									".$this->display_parent_dropdown_opts()."
								</select>
							</td>
						</tr>
					</table>";
		
		$this->body .= "<div style='text-align: center;'><input type=submit name='auto_save' value=\"Save\" class='mini_button' /></div>";
		
		$this->body .= '<ul class="expandable_list">';
		
		// GET UNASSIGNED
		$state_query = "SELECT * FROM ".$this->db->geoTables->states_table." WHERE parent_id = 0 ORDER BY display_order, name";
		$state_rs = $this->db->Execute($state_query);
		if (!$state_rs)
		{
			$this->error_message = $this->internal_error_message;
			return false;
		}			
		

		if ($state_rs->RecordCount() > 0)
		{
			$this->body .= '<li style="border: 5px solid #006699; padding: 4px;">';
			
			$this->body .= "<span class='large_font'><b>Unassigned</b></span>";
			$this->body .= "<table cellpadding=3 cellspacing=1 border=0 width=\"100%\" id='unassigned_table'>";
			
			$this->body .= $this->get_country_header('unassigned');
		
			$this->row_count = 0;
			while ($state = $state_rs->FetchRow())
			{
				$this->display_this_state($state, $count, $result);
				$this->row_count++;
				$count++;
			}
			$this->body .= "</table>";
			$this->body .= '</li>';
		}	

		
		// GET ASSIGNED
		while ( $country = $country_rs->fetchRow() )
		{
			$this->body .= '<li style="padding: 4px;" id="'.geoString::specialChars($country['name'],null,ENT_QUOTES).'_listItem">';
			
			$this->body .= "<span class='large_font'><b><a href=\"javascript:hideTable('".geoString::specialChars($country['name'],null,ENT_QUOTES,false,true)."');\">"
			.$country['name']."</a></b></span>
			<table cellpadding=3 cellspacing=1 border=0 width=\"100%\" id='".geoString::specialChars($country['name'],null,ENT_QUOTES)."_table' style='display: none;'>";

			$this->body .= $this->get_country_header($country['name']);
			
			$state_query = "SELECT * FROM ".$this->db->geoTables->states_table." WHERE parent_id = ".$country['country_id']." ORDER BY display_order, name";
			$state_rs = $this->db->Execute($state_query);
			if (!$state_rs)
			{
				$this->error_message = $this->internal_error_message;
				return false;
			}			
			

			if ($state_rs->RecordCount() > 0)
			{
				$this->row_count = 0;
				while ($state = $state_rs->FetchRow())
				{
					$this->display_this_state($state, $count, $result);
					$this->row_count++;
					$count++;
				}
			}			
			else
			{
				$this->body .= "<tr>
								<td colspan=100%>
									<div class='page_note_error'>There are no States / Provinces to display.</div>
								</td>
							</tr>";
			}
			
			$this->body .= "</table>";
			
			$this->body .= '</li>';
		}
		
		$this->body .= '</ul>';
		
		$this->body .= "
		<div style='text-align: center;'><input type=submit name='auto_save' value=\"Save\" class='mini_button' /></div>
		</div></fieldset>";
		
		return true;
	} //end of function display_state_list

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_country_header($country)
	{
		$return = "
				<tr class=row_color_black>
					<td class=col_hdr_left width=\"5%\" style='text-align: center;'>
						<input type='checkbox' onclick='if(this.checked)checkAll(\"".geoString::specialChars($country,null,ENT_QUOTES,false,true)."\"); else uncheckAll(\"".geoString::specialChars($country,null,ENT_QUOTES,false,true)."\");' />
					</td><td class=col_hdr_left width=\"20%\">
						State/Province
					</td><td class=col_hdr width=\"10%\">
						Abbrev.
					</td><td class=col_hdr width=\"15%\">
						<nobr>Display Order".geoHTML::showTooltip('display order', 'Control the display order of all your dropdown boxes here. States will be displayed according to their "display order" in ascending order')."</nobr>
					</td><td class=col_hdr_left width=\"15%\">
						<nobr>Tax".geoHTML::showTooltip('tax','Values can range from 0.0001 to 99999.9999')."</nobr>
					</td><td class=col_hdr_left width=\"15%\">
						<nobr>Tax Type".geoHTML::showTooltip('tax type','Decide whether to charge a flat tax vs. a percentage based on the <strong>user\'s registered state/province.</strong><br />For example, if you wish to charge $1.25 tax for every purchase, regardless of the amount of purchase, then choose "flat tax" and set tax = 1.25 <br />If, however, you wish to charge a 1.25% tax based on the amount of purchase, then choose "rate" and set tax = 1.25 <br /><strong>WARNING: The tax will be calculated using the same type of currency as the sub-total at the time of purchase. </strong>')."</nobr>
					</td><td class=col_hdr_left width=\"15%\">&nbsp;</td>
				</tr>";
		return $return;
	}
	

	function display_this_state($text, $count, $result=0)
	{
		
		$display_tax_rate = (strstr($text["tax"],'.')) ? rtrim(rtrim($text["tax"],0),'.') : $text["tax"];
		$display_tax_value = sprintf("%01.2f",$text["tax"]);
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td class=medium_font style='text-align: center;'>
					<input type='checkbox' name='d[countryedit".$count."]' />
				</td><td class=medium_font>
					<strong>".$text["name"]."</strong>
				</td><td class=medium_font align=center>
					<strong>".$text["abbreviation"]."</strong>
				</td><td align=center>
					<input onkeyup=\"javascript:validate(this)\" type=text name='d[order".$count."]' value='".$text["display_order"]."' size=5>
				</td><td>
					<nobr><input onkeyup=\"javascript:validate(this)\" type=text name='d[tax".$count."]' value='".(($text['tax_type'] == 0) ? $display_tax_rate : $display_tax_value)."' size=8 maxlength=10>
					<b id=percent".$count." style=display:"
					.(($text['tax_type'] == 1) ? 'none' : '').">%</strong></nobr>
				</td><td class=medium_font valign=top>
					<nobr><input onclick=\"javascript:display_percent(this,'percent".$count."')\" type=radio name='d[tax_type".$count."]' value=0 "
					.(($text['tax_type'] == 0) ? 'checked' : '').">
					<strong>rate</strong> (ie 8.25 %)</nobr><br>
					<nobr><input onclick=\"javascript:display_percent(this,'percent".$count."')\" type=radio name='d[tax_type".$count."]' value=1 "
					.(($text['tax_type'] == 1) ? 'checked' : '').">
					<strong>flat tax</strong></nobr>
				</td><td align=center>
				".geoHTML::addButton('delete', "index.php?mc=geographic_setup&page=geographic_states_provinces&c=".$text["state_id"]."&auto_save=1", false, '', 'lightUpLink mini_cancel')."
					<input type=hidden name=d[id".$count."]"." value=".$text["state_id"].">
				</td>				
			</tr>";

	} //end of function display_this_state

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_state($insert_state_info="",$update_state_info="")
	{
		if (PHP5_DIR) 
			$menu_loader = geoAdmin::getInstance();
		else 
			$menu_loader =& geoAdmin::getInstance();
			
		if($update_state_info)
		{
			$sql_query = "SELECT * FROM ".$this->states_table." ORDER BY display_order,name";
			$result = $this->db->Execute($sql_query);
			if (!$result)
			{
				return false;
			}
			else
			{
				for($i=0; $i < $result->RecordCount(); $i++)
				{
					if ( isset($update_state_info["id".$i]) )
					{
						$tax = ($update_state_info["tax".$i]) ? $update_state_info["tax".$i] : 0;
						$sql_query = "UPDATE ".$this->states_table." SET
							display_order = ".$update_state_info["order".$i].",
							tax = $tax,
							tax_type = ".$update_state_info["tax_type".$i];
						if ( $update_state_info["countryedit".$i] == "on" && $update_state_info["mass_country"] != "none")
							$sql_query .= ",
							parent_id = ".$update_state_info["mass_country"];
						$sql_query .= " WHERE
							state_id = ".$update_state_info["id".$i];
						$update = $this->db->Execute($sql_query);
						if (!$update)
						{
							echo $sql_query;
							return false;
						}
					}
				}
			}
		}
		if ($insert_state_info)
		{
			if ((strlen(trim($insert_state_info["name"])) > 0) && (strlen(trim($insert_state_info["abbreviation"])) > 0))
			{
				$sql_query = "INSERT INTO ".$this->states_table."
						(parent_id,name,abbreviation, display_order,tax,tax_type)
						VALUES(
							'".$insert_state_info['parent_id']."',
							'".addslashes($insert_state_info['name'])."',
							'".addslashes($insert_state_info['abbreviation'])."',
							'".$insert_state_info['order']."',
							'".$insert_state_info['tax']."',
							'".$insert_state_info['tax_type']."')";
				$result = $this->db->Execute($sql_query);
				if (!$result)
				{
					return false;
				}				
			}
		}
		if( !$this->check_for_any_tax( $db )) {
			trigger_error("ERROR: Could not update tax setting");
		}
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function delete_state($state_id=0)
	{
		if (!$state_id)
			return false;
		$sql_query = "DELETE FROM ".$this->states_table."
			WHERE state_id = ".$state_id;
		$result = $this->db->Execute($sql_query);
		if (!$result)
			return false;
		return true;
	} //end of function delete_state

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_parent_dropdown_opts($current=0)
	{
		$sql = "SELECT * FROM ".$this->db->geoTables->countries_table.' ORDER BY `display_order` ASC';
		
		$rs = $this->db->Execute($sql);
		

		if( $rs )
		{
			$return_val = "<option value='none'>Select Parent Country</option>";
			$return_val .= "<option value='0'>Unassigned</option>";		
			while ( $show = $rs->fetchRow() )
			{
				
				$return_val .= "<option value='".$show['country_id']."'";
				if ( $current == $show['country_id'] && $current != 0)
					$return_val .= " selected";	
				$return_val .= ">".$show['name']."</option>\n"; 	
			} 
		}
		return $return_val;
	}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_geographic_states_provinces()
	{
		$admin = geoAdmin::getInstance();
		$this->body .= $admin->getUserMessages();
		
		$this->display_state_list();
		
		$this->display_page();		
	}
	function update_geographic_states_provinces()
	{
		if ( $_REQUEST["c"] ) {
			return $this->delete_state($_REQUEST["c"]);
		}
		if ( $_REQUEST["b"] || $_REQUEST["d"] ) {
			return $this->update_state($_REQUEST["b"],$_REQUEST["d"]);
		}
		
	}
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
}
