<?php
// admin_country_management_class.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 19862              $ ##
## File last change date:       ##
##  $Date:: 2010-06-25 10:00:#$ ##
##                              ##
##################################

class Country_management extends Admin_site {

	var $internal_error_message = "There was an internal error";
	var $data_error_message = "Not enough data to complete request";
	var $page_text_error_message = "No text connected to this page";
	var $no_pages_message = "No pages to list";

	var $text_management_title_message = "Geographic Setup > Country Management Admin";
	var $text_management_instruction_message = "You can control the countries that this application displays in it's country dropdown
		boxes throughoutt the site within this administration tool.  Add new countries by using the form supplied or delete a specific country
		using the delete button next to the country you wish to delete.  The countries will appear in alphabetical order.";

	var $country_error;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Country_management($db, $product_configuration=0)
	{
		$this->Admin_site($db, $product_configuration);
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_country_list($db)
	{
		$this->body .= "<SCRIPT language=\"JavaScript1.2\">";
		// Set title and text for tooltip
		$this->body .= "
			Text[1] = [\"display order\", \"Control the display order of all your dropdown boxes here.  Countries will be displayed according to their \\\"display order\\\" in ascending order.\"]\n
			Text[2] = [\"tax\", \"Values can range from 0.0001 to 99999.9999\"]\n
			Text[3] = [\"tax type\", \"Decide whether to charge a flat tax vs. a percentage based on the <strong>user's registered country.</strong> <br>For example, if you wish to charge $1.25 tax for every purchase, regardless of the amount of purchase, then choose \\\"flat tax\\\" and set tax = 1.25 <br>If however, you wish to charge a 1.25% tax based on the amount of purchase, then choose \\\"rate\\\" and set tax = 1.25 <br><strong>WARNING: The tax will be calculated using the same type of currency as the sub-total at the time of purchase. </strong>\"]\n
			";
		// Set style for tooltip
		//echo "Style[0] = [\"white\",\"\",\"\",\"\",\"\",,\"black\",\"#ffffcc\",\"\",\"\",\"\",,,,2,\"#b22222\",2,24,0.5,0,2,\"gray\",,2,,13]\n";
		$this->body .= "</script>";

		$sql_query = "select * from ".$this->countries_table." order by display_order, name";
		$result = $db->Execute($sql_query);
		if (!$result)
		{
			$this->error_message = $this->internal_error_message;
			return false;
		}
		$this->body .= "<form action=index.php?mc=geographic_setup&page=geographic_countries method=post>\n";
		$this->body .= "
			<script type=\"text/javascript\">
				function validate(field)
				{
					re = /([^0-9.])/;
					if (field.value.match(re))
					{
						alert('You must enter a numeric value only.');
						field.value=\"\";
						field.focus();
					}
				}
				function display_percent(field,percent_id)
				{
					if (field.value == 1)
						document.getElementById(percent_id).style.display = 'none';
					else
						document.getElementById(percent_id).style.display = '';
				}
			</script>
			<table cellpadding=3 cellspacing=0 border=0 align=center width=100%>
				<tr>
					<td align=center>
						
						<fieldset id='CurrentCountry'><legend>Current Main Region List</legend><table cellpadding=3 cellspacing=1 border=0 width=\"100%\">
							<tr>
								<td class=col_hdr_left>
									Country
								</td>
								<td class=col_hdr>
									Abbrev.
								</td>
								<td class=col_hdr>
									<nobr>Display Order</nobr>
								</td>
								<td class=col_hdr_left>
									<nobr>Tax".$this->show_tooltip(2,1)."</nobr>
								</td>
								<td class=col_hdr_left>
									<nobr>Tax Type".$this->show_tooltip(3,1)."</nobr>
								</td>
								<td class=col_hdr>
									<script type='text/javascript'>
										function setAllCheckboxes(trigger)
										{
											checked = trigger.checked;
											$$('input').each(function(e){
												if(e.type == 'checkbox' && e != trigger) {
													e.checked = checked;
												}
											});
										}
									</script>
									Delete? <input type='checkbox' onclick='setAllCheckboxes(this);' />
									
								</td>
							</tr>";

		if ($result->RecordCount() > 0)
		{
			$this->row_count = 0;
			$count = 0;
			while ($show = $result->FetchRow())
			{
				$this->display_this_country($show, $count, $result);
				$this->row_count++;
				$count++;
			}
		}
		else
		{
			$this->body .= "<tr>
								<td colspan=100%>
									<div class=page_note_error>There are no regions to display.</div>
								</td>
							</tr>";
		}
		$this->body .= "</table>
						<script type='text/javascript'>
							function checkForDeletes()
							{
								checks = 0;
								states = 0;
								checkboxes = $$('input').each(function(e){
									if(e.type == 'checkbox' && e.checked) {
										checks++;
										states += e.value * 1;
									}
								});
								if(checks > 0) {
									return true;
								} else {
									return false;
								}
							}
						</script>
						<input type=submit onclick=\"if(checkForDeletes()){ return confirm('Are you sure you want to delete '+checks+' countries '+((states > 0) ? 'AND '+states+' attached states' : '')+'? This action cannot be undone.'); }\" name='auto_save' value=\"Save\">
						</fieldset>";
						
		$this->body .= "<fieldset id='NewCountry'>
						<legend>Add New Country</legend>
						<table cellpadding=3 cellspacing=1 border=0 width=\"100%\">
							<tr>
								<td class=col_hdr_left width=\"30%\">
									Country Name
								</td>
								<td align=center class=col_hdr width=\"10%\">
									Abbrev.
								</td>
								<td class=col_hdr width=\"15%\">
									<nobr>Display Order</nobr>
								</td>
								<td class=col_hdr_left width=\"15%\">
									<nobr>Tax".$this->show_tooltip(2,1)."</nob<strong>								</td>
								<td class=col_hdr_left width=\"20%\">
									<nobr>Tax Type".$this->show_tooltip(3,1)."</nobr>
								</td>
								<td class=col_hdr_left width=\"10%\">&nbsp;</td>
							</tr>
							";
		if ($this->country_error)
			$this->body .= "<tr>
								<td colspan=100% class=medium_error_font align=center>
									".$this->country_error."
								</td>
							</tr>";
		$this->body .= "
							<tr class=row_color2>
								<td class=medium_font>
									<input type=text name=b[name] size=30 maxsize=255>
								</td>
								<td align=center>
									<input type=text name=b[abbreviation] size=5 maxsize=255>
								</td>
								<td align=center>
									<input onkeyup=\"javascript:validate(this)\" type=text name=b[order] size=5>
								</td>
								<td>
									<nobr><input onkeyup=\"javascript:validate(this)\" type=text name=b[tax] size=8 maxlength=10><b id=percent>%</strong></nobr>
								</td>
								<td class=medium_font>
									<nobr><input onclick=\"javascript:display_percent(this,'percent')\" type=radio name=b[tax_type] value=0 checked><strong>rate</strong> (ie 8.25 %)</nobr><br>
									<nobr><input onclick=\"javascript:display_percent(this,'percent')\" type=radio name=b[tax_type] value=1><strong>flat tax</strong></nobr>
								</td>
								<td align=center>
									<input type=submit name='auto_save' value=\"Save\">
								</td>
							</tr>
						</table></fieldset>
					</td>
				</tr>
				<tr colspan=100% align=center>
					<td>
						<input type=reset value=\"Reset\">";
		
		$this->body .= "
					</td>
				</tr>
			</table>";
		return true;
	} //end of function display_country_list

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_this_country($text, $count, $result=0)
	{
		$display_tax_rate = (strstr($text["tax"],'.')) ? rtrim(rtrim($text["tax"],0),'.') : $text["tax"];
		$display_tax_value = sprintf("%01.2f",$text["tax"]);
		
		//find out how many states attached to this country
		$id = $text['country_id'];
		$db = DataAccess::getInstance();
		$sql = "select count(state_id) from ".geoTables::states_table." WHERE parent_id = ?";
		$states = $db->GetOne($sql, array($id));
		if(!$states) {
			$states = 0; //make sure it's set to an int
		}
		
		$this->body .= "
			<tr class=".$this->get_row_color().">
				<td class=medium_font>
					<strong>".$text["name"]."</strong>
				</td>
				<td class=medium_font align=center>
					<strong>".$text["abbreviation"]."</strong>
				</td>
				<td align=center>
					<input onkeyup=\"javascript:validate(this)\" type=text name='d[order".$count."]' value='".$text["display_order"]."' size=5>

				</td>
				<td>
					<nobr><input onkeyup=\"javascript:validate(this)\" type=text name='d[tax".$count."]' value='".(($text['tax_type'] == 0) ? $display_tax_rate : $display_tax_value)."' size=8 maxlength=10>
					<b id=percent".$count." style=display:"
					.(($text['tax_type'] == 1) ? 'none' : '').">%</strong></nobr>
				</td>
				<td class=medium_font valign=top>
					<nobr><input onclick=\"javascript:display_percent(this,'percent".$count."')\" type=radio name='d[tax_type".$count."]' value=0 "
					.(($text['tax_type'] == 0) ? 'checked' : '').">
					<strong>rate</strong> (ie 8.25 %)</nobr><br>
					<nobr><input onclick=\"javascript:display_percent(this,'percent".$count."')\" type=radio name='d[tax_type".$count."]' value=1 "
					.(($text['tax_type'] == 1) ? 'checked' : '').">
					<strong>flat tax</strong></nobr>
				</td>
				<td align='center' valign='middle'>
					<input type='checkbox'  name='delete[".$text["country_id"]."]' value='".$states."' />
				</td>
				<input type=hidden name=d[id".$count."]"." value=".$text["country_id"].">
			</tr>";

	} //end of function display_this_country

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_country($db,$insert_country_info="",$update_country_info="")
	{
		if($update_country_info)
		{
			$sql_query = "SELECT * FROM ".$this->countries_table." ORDER BY display_order,name";
			$result = $db->Execute($sql_query);
			if (!$result)
			{
				return false;
			}
			else
			{
				for($i=0; $i < $result->RecordCount(); $i++)
				{
					$tax = ($update_country_info["tax".$i]) ? $update_country_info["tax".$i] : 0;
					$sql_query = "UPDATE ".$this->countries_table." SET
						display_order = ".$update_country_info["order".$i].",
						tax = $tax,
						tax_type = ".$update_country_info["tax_type".$i]." WHERE
						country_id = ".$update_country_info["id".$i];
					$update = $db->Execute($sql_query);
					if (!$result)
					{
						return false;
					}
				}
			}
			$deleteThese = $_POST['delete'];
			$deleted = 0;
			$numAttachedStates = 0;
			foreach($deleteThese as $countryId => $numAttachedStates) {
				if(is_numeric($numAttachedStates)) { //$numAttachedStates can be 0. as long as it's a number, go ahead and delete
					if($this->delete_country($db, $countryId)) {
						$deleted++;
						$deletedStates += $numAttachedStates;
					}	
				}
			}
			if($deleted > 0) {
				geoAdmin::m('Successfully deleted '.$deleted.' countries'.(($numAttachedStates > 0) ? " and $numAttachedStates states" : '').'.',geoAdmin::NOTICE);
				geoAdmin::m('Settings saved.'); //so that settings saved message is still displayed when deleting alongside other actions
			}
		}
		if ($insert_country_info)
		{
			if ((strlen(trim($insert_country_info["name"])) > 0) && (strlen(trim($insert_country_info["abbreviation"])) > 0))
			{
				$sql_query = "INSERT INTO ".$this->countries_table."
					(name,abbreviation, display_order,tax,tax_type)
					VALUES( ?, ?, ?, ?, ?)";
				$data = array (
					$insert_country_info['name'],
					$insert_country_info['abbreviation'],
					$insert_country_info['order'],
					$insert_country_info['tax'],
					$insert_country_info['tax_type']
				);
				$result = $db->Execute($sql_query, $data);
				if (!$result)
				{
					return false;
				}
				
			}
		}
		if( !$this->check_for_any_tax( $db )) {
			trigger_error("ERROR: Could not update tax setting");
		}
		return true;
	}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function delete_country($db,$country_id=0)
	{
		if (PHP5_DIR) 
			$menu_loader = geoAdmin::getInstance();
		else 
			$menu_loader =& geoAdmin::getInstance();
			
		if (!$country_id)
			return false;
			
		$sql = "DELETE FROM ".geoTables::states_table." WHERE parent_id = ?";
		$result = $db->Execute($sql, array($country_id));
		
		$sql_query = "DELETE FROM ".$this->countries_table." WHERE country_id = ".$country_id;
		$result = $db->Execute($sql_query);
		if (!$result)
			return false;
		return true;
	} //end of function delete_country

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	function display_geographic_countries()
	{
		if (PHP5_DIR) 
			$menu_loader = geoAdmin::getInstance();
		else 
			$menu_loader =& geoAdmin::getInstance();

		$this->body .= $menu_loader->getUserMessages();
				
		if (!$this->display_country_list($this->db))
			return false;
		$this->display_page();		
	}
	function update_geographic_countries()
	{
		if ( $_REQUEST["b"] || $_REQUEST["d"] )
			return $this->update_country($this->db,$_REQUEST["b"],$_REQUEST["d"]);
	}
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
} //end of class Country_management

