<?php
//Invoice.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 16853              $ ##
## File last change date:       ##
##  $Date:: 2009-06-25 17:22:#$ ##
##                              ##
##################################

// DON'T FORGET THIS
if(class_exists( 'admin_AJAX' ) or die());

class ADMIN_AJAXController_Invoice extends admin_AJAX {
	/**
	 * Gets the user data and stores it in this->user_data in array format.
	 *
	 * @return unknown
	 */
	private function _getUserData($user_id){
		$user_id = intval($user_id);
		
		if (!$user_id) {
			return false;
		}
		$db = DataAccess::getInstance();
		$sql = "SELECT * FROM ".geoTables::userdata_table." as ud, ".geoTables::user_groups_price_plans_table." as ug WHERE 
					ud.id = ug.id AND ud.id = ? LIMIT 1";
		$result = $db->Execute($sql, array($user_id));
		if (!$result) {
			trigger_error('ERROR SQL: Retrieving user data, sql: '.$sql.' error: '.$this->db->ErrorMsg());
			return false;
		}
		
		return $result->FetchRow();
	}
	
	public function getInvoice()
	{
		$admin = geoAdmin::getInstance();
		
		$invoice_id = intval($_GET['invoice_id']);
		if ($invoice_id) {
			$invoice = geoInvoice::getInvoice($invoice_id);
		}
		if (!$invoice_id || !is_object($invoice) || $invoice->getId() != $invoice_id) {
			echo 'Invalid Invoice ID, or no invoice specified, unable to retrieve invoice.';
			
			return;
		}
		
		$tpl = new geoTemplate('admin');
		$order_id = $invoice->getOrder()->getId();
		$tpl->order_id = $order_id;
		$tpl->invoice_id = $invoice_id;
		$tpl->order_amount = $invoice->getOrder()->getOrderTotal();
		$tpl->invoice_amount = $invoice->getInvoiceTotal();
		$tpl->pay_amount = $invoice->getInvoiceTotal() * -1;
		$tpl->invoice_date = $invoice->getCreated();
		$tpl->invoice_due_date = $invoice->getDue();
		$tpl->print = $print = (isset($_GET['print']))? true: false;
		$tpl->printUrl = 'AJAX.php?controller=Invoice&action=getInvoice&invoice_id='.$invoice_id.'&print=1';
		
		if ($print){
			header('Content-Type: text/html;');
		} 
		
		
		$client = $this->_getUserData($invoice->getOrder()->getBuyer());
		//merge billing data entered during checkout, on top of user's data.
		$tpl->client = array_merge($client, $invoice->getBillingInfo());
		
		$tpl->companyAddress = DataAccess::getInstance()->get_site_setting('company_address',1);
		//set up transactions
		$transactions = $invoice->getTransaction();
		$tVals = array();
		foreach ($transactions as $transaction) {
			if (is_object($transaction)) {
				//$transaction = geoTransaction::getTransaction($transaction->getId());
				$id = $transaction->getId();
				if ($transaction->getStatus()){
					$class = ($transaction->getAmount() > 0)? 'payment': 'due';
				} else {
					$class = 'pending';
				}
				$tVals[$id] = array (
					'desc' => $transaction->getDescription(),
					'date' => $transaction->getDate(),
					'type' => $transaction->getGateway()->getTitle(),
					'status' => $transaction->getStatus(),
					'amount' => $transaction->getAmount(),
					'amount_class' => $class
				);
			}
		}
		$tpl->transactions = $tVals;
		$info = '';
		//un-comment to have invoice details put into the admin invoice view in HTML source:
		//$info = "<!--  Invoice info (debug):\n".print_r($invoice,1)." -->";
		echo $tpl->fetch('orders/invoice');
	}
}