<?php
//addons/security_image/util.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

# Security Image Addon
require_once ADDON_DIR . 'security_image/info.php';
class addon_security_image_util extends addon_security_image_info
{
	var $db;
	var $recaptchaError;
	
	public function core_registration_check_info ($vars)
	{
		$info = $vars['info'];
		$registerClass = $vars['this'];
		$api = $vars['api'];
		
		if ($api) {
			//don't check security image when in api call
			return;
		}
		if ($this->check_setting('registration') && !$this->check_security_code($info["securityCode"])) {
			//add error
			$registerClass->error['securityCode'] ="error";
			$registerClass->error_found++;
		}
	}
	
	// Constructor
	function __construct()
	{
		$this->db = DataAccess::getInstance();
	}
	// Checks the security code with an entered value
	public function check_security_code( $enteredCode )
	{
		$reg = geoAddon::getRegistry($this->name);
		
		if ($reg->imageType=='recaptcha') {
			//validate against recaptcha
			$private = $reg->recaptcha_private_key;
			
			$params = array ();
			//params needed by recaptcha.. see http://code.google.com/apis/recaptcha/docs/verify.html
			$params['privatekey'] = $private;
			$params['remoteip'] = $_SERVER["REMOTE_ADDR"];
			$params['challenge'] = $_POST["recaptcha_challenge_field"];
			$params['response'] = $_POST["recaptcha_response_field"];
			
			$response = geoPC::urlPostContents('http://www.google.com/recaptcha/api/verify', $params);
			$response = explode("\n",$response);
			
			if (trim ($response [0]) == 'true') {
				return true;
			} else {
				$this->recaptchaError = $response[1];
				return false;
			}
		} else {
			//use built-in checking
			$sql = "select securityString from geodesic_sessions where classified_session = ?";
			$result = $this->db->Execute($sql, array($_COOKIE["classified_session"]));
			$result = $result->FetchRow();
			if(!isset($result['securityString']) || strlen($result['securityString']) == 0|| strtoupper($result["securityString"])!=strtoupper( $enteredCode ))
			{
				//case-insensitive check - did not match, or there is no security string found for this session.
				return false;
			}
			return true;
		}
	}
	// Access function for 'secure_registration'
	function check_setting($section)
	{
		$reg = geoAddon::getRegistry($this->name);
		return $reg->get('secure_'.$section);
	}
	
	function getJs()
	{
		$tpl = new geoTemplate('addon','security_image');
		$tpl->assign('imageType', geoAddon::getRegistry($this->name)->imageType);
		return $tpl->fetch('js.tpl');
	}
	public function getHTML($error, $text, $section, $include_js = true)
	{
		$reg = geoAddon::getRegistry($this->name);
		
		$tpl = new geoTemplate(geoTemplate::ADDON, $this->name);
		
		$tpl->assign('imageType', $reg->imageType);
		
		if ($reg->imageType=='recaptcha') {
			$tpl->assign('recaptcha_theme', $reg->recaptcha_theme);
			$tpl->assign('recaptcha_server', (geoSession::isSSL())? self::RECAPTCHA_API_SECURE_SERVER : self::RECAPTCHA_API_SERVER);
			$tpl->assign('recaptcha_pub_key', $reg->recaptcha_pub_key);
			//TODO:  error message
			$tpl->assign('recaptcha_error', $this->recaptchaError);
		}
		
		$js = ($include_js) ? $this->getJs() : '';
		
		$tpl->assign('error', ($error)? $text['error'] : '');
		$tpl->assign('label', $text[$section.'_label']);
		
		//auto vars available to each one
		$reg = geoAddon::getRegistry($this->name);
		
		$tpl->assign('w', $reg->width);
		$tpl->assign('h', $reg->height);
		
		$html = $tpl->fetch($section.'.tpl');
		$return = $js . $html;
		
		return $return;
	}
}