<?php
//addons/google_maps/setup.php

/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 13429              $ ##
## File last change date:       ##
##  $Date:: 2008-07-15 10:35:#$ ##
##                              ##
##################################

# google_maps Addon

require_once ADDON_DIR . 'google_maps/info.php';

class addon_google_maps_setup extends addon_google_maps_info
{
	public function enable ()
	{
		if (!$this->enableCheck()) {
			//trial addon used on non-trial license
			geoAdmin::m("This is a trial addon, it cannot be used for a non-trial package.",geoAdmin::ERROR);
			return false;
		}
		return true;
	}
	
	public function upgrade ($oldVersion)
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		if ($oldVersion == '1.0.0') {
			//transfer over settings and remove old table, now we use addon registry.
			$all = $db->GetAll("SELECT * FROM `geodesic_addon_google_maps`");
			$reg = geoAddon::getRegistry('google_maps',true);
			
			foreach ($all as $row) {
				$reg->set($row['setting'], $row['value']);
			}
			$reg->save();
			$db->Execute('DROP TABLE IF EXISTS `geodesic_addon_google_maps`');
		}
		return true;
	}
}