// $Rev: 17817 $

var addon_google_maps = {
	init : function (lat, longitude, location) {
		if (!GBrowserIsCompatible()) {
			//not compatible browser
			//alert('browser not compatible, cannot show google maps.');
			return;
		}
		if (!lat || !longitude) {
			return;
		}

		var map = new GMap2($("map_canvas"));
		var center = new GLatLng(lat, longitude);
		map.setCenter(center, 13);
		map.setUIToDefault();
		
		var marker = new GMarker(center, {draggable: false});
		
		//make the info box appear,  to open it when it is dragged (if dragging is on) use "dragend" as event instead of "click"
		GEvent.addListener(marker, "click", function() {
			marker.openInfoWindowHtml(location);
		});
		
		//add the red thingy
		map.addOverlay(marker);
	}
};
