<?php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

require_once ADDON_DIR . 'geographic_navigation/info.php';

class addon_geographic_navigation_util extends addon_geographic_navigation_info
{
	private $_regError;
	public function core_registration_check_info($vars)
	{
		$info = $vars['info'];
		$registerClass = $vars['this'];
		$api = $vars['api'];
		
		$reg = geoAddon::getRegistry($this->name);
		if (!$reg->userUse) {
			//nothing to do
			return false;
		}
		
		$use = (isset($info['geographic_navigation_addon'][1]) && $info['geographic_navigation_addon'][1]);
		if ($reg->userRequire && !$use) {
			//oops!  it's required!
			
			$msgs = self::_getText();
			//do error in way we'll remember
			
			$this->_regError = $msgs['errorUserRequired'];
			$registerClass->error_found++;
			return;
		}
		if ($reg->userEndRequire && $use) {
			//check to make sure selected region is a terminating one.
			
			if (!$this->checkTerminatingRegions($info['geographic_navigation_addon'])) {
				$msgs = self::_getText();
				$this->_regError = $msgs['errorUserEndRequired'];
				$registerClass->error_found++;
			}
		}
	}
	
	public function core_registration_add_variable($info)
	{
		$reg = geoAddon::getRegistry($this->name);
		if (!$reg->userUse) {
			//do not display
			return false;
		}
		$name = 'geographic_navigation_addon';
		$return = array(
			'name' => $name,
			'value' => (($info[$name]) ? $info[$name] : 0)
		);
		return $return;
	}
	
	public function core_registration_add_field_display ($regFields)
	{
		$reg = geoAddon::getRegistry($this->name);
		if (!$reg->userUse) {
			//do not display
			return false;
		}
		
		$view = geoView::getInstance();
		
		$view->addJScript('addons/geographic_navigation/regions.js');
		
		$tpl = new geoTemplate (geoTemplate::ADDON, 'geographic_navigation');
		
		$regionId = $countryId = $stateId = $highestLevel = 0;
		
		//figure out the highest region selected
		if (isset($regFields['geographic_navigation_addon'])) {
			$alreadyRegions = $regFields['geographic_navigation_addon'];
			
			foreach ($alreadyRegions as $level => $val) {
				if (strpos($val, 'country') !== false) {
					//an alternate selected country
					$countryId = (int)str_replace('country','',$val);
				} else if (strpos($val, 'state') !== false) {
					$stateId = (int)str_replace('state','',$val);
				} else if (strpos($val, 'region') !== false && $level > $highestLevel) {
					$highestLevel = $level;
					$regionId = str_replace('region','',$val);
				}
			}
		}
		
		$tpl->levels = $this->getLevelsFor($regionId, $stateId, $countryId);
		$tpl->pre = 'c';
		$tpl->showInSearchBox = geoAddon::getRegistry($this->name)->showInSearchBox;
		
		$msgs = $tpl->msgs = $this->_getText();
		$return = array(
			'label' => $msgs['registerLocationLabel'],
			'type' => 'roll_my_own_type',
			'value' => $tpl->fetch('listing_region_select/box.tpl'),
			'error' => $this->_regError,
		);
		return $return;
	}
	
	public function core_registration_add_field_update ($data)
	{
		$reg = geoAddon::getRegistry($this->name);
		if (!$reg->userUse) {
			//do not display
			return false;
		}
		$user_id = (int)$data['user_id'];
		
		//this will be:
		//0 if not confirming (straight to userdata)
		//1 if adding to confirm table
		//2 if moving from confirm table to userdata
		$confirmation_step = $data['confirmation_step'];
		$confirmation_id = (int)$data['confirmation_id'];
		if (!$user_id && !$confirmation_id) {
			return false;
		}
		$registration_variables = $data['registration_variables'];
		
		switch($confirmation_step) {
			case 0:
				//add this user's data
				$this->setRegionsForUser($user_id, $registration_variables['geographic_navigation_addon']);
				break;
				
			case 1:
				//must do email confirmation first, which uses a different ID scheme
				$this->setRegionsForUserConfirm($user_id, $registration_variables['geographic_navigation_addon']);
				break;
				
			case 2:
				//user confirmed -- transfer value from confirmation table to real one
				$db = 1;
				include GEO_BASE_DIR . 'get_common_vars.php';
				$sql = "UPDATE ".self::USER_TABLE." SET `confirmation`=0, `user`=? WHERE `confirmation`=?";
				$result = $db->Execute($sql, array($user_id, $confirmation_id));
				break;
		}
	}
	
	public function core_Search_classifieds_search_form ($vars)
	{
		$searchClass = $vars['this'];
		$fields = $vars['search_fields'];
		
		if (!$fields['addon_geographic_navigation_location']) {
			//search not turned on
			return;
		}
		
		$return = array();
		$view = geoView::getInstance();
		$view->addJScript('addons/geographic_navigation/regions.js');
		
		$tpl = new geoTemplate (geoTemplate::ADDON, 'geographic_navigation');
		
		$regionId = $countryId = $stateId = $highestLevel = 0;
		
		$tpl->levels = $this->getLevelsFor($regionId, $stateId, $countryId);
		$tpl->pre = 'b';
		$tpl->showInSearchBox = geoAddon::getRegistry($this->name)->showInSearchBox;
		
		$tpl->msgs = $msgs = $this->_getText();
		$return [] = array (
			'label' => $msgs['searchLocationLabel'],
			'data' => $tpl->fetch('listing_region_select/box.tpl'),
			'skipBreakAfter' => true, //make it skip the <hr> after this one, so there is nothing between our 2 search fields
		);
		
		return $return;
	}
	
	public function core_Search_classifieds_Search_filterWhereClause ($whereClause)
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$regions = (isset($_REQUEST['b']['geographic_navigation_addon']) && is_array($_REQUEST['b']['geographic_navigation_addon']))? $_REQUEST['b']['geographic_navigation_addon'] : array();
		
		if (!count($regions)) {
			//nothing selected
			return $whereClause;
		}
		
		//the "top" region selected
		$regionId = 0;
		while ($regionId == '0' && count($regions)) {
			//nothing is selected at this level, keep checking one level up
			$regionId = array_pop($regions);
		}
		$part = '';
		if (strpos($regionId,'region') !== false) {
			//selected a region
			$regionId = (int)str_replace('region','',$regionId);
			if (!$regionId) {
				//not valid or it's 0 which is not valid
				return $whereClause;
			}
			//get an array of listings (note that region is (int)'d at this point
			$sql = "SELECT `listing` FROM ".self::LISTING_TABLE." WHERE `region_id`=$regionId";
			$listings = array ();
			$rows = $db->GetAll($sql);
			foreach ($rows as $row) {
				if ($row['listing']) {
					$listings[$row['listing']] = $row['listing'];
				}
			}
			$part = '`id` IN ('.implode(', ',$listings).')';
		} else if (strpos($regionId, 'state') !== false) {
			//selected a state
			$stateId = (int)str_replace('state','',$regionId);
			if (!$stateId) {
				//invalid or something
				return $whereClause;
			}
			$region = geoRegion::getInstance();
			//get the main region
			$countryId = (int)$db->GetOne("SELECT `parent_id` FROM ".geoTables::states_table." WHERE `state_id`=$stateId");
			if ($countryId) {
				$abreviation = $region->getSubRegionAbbreviationById($stateId,$countryId);
				$statename = $region->getSubRegionNameById($stateId, $countryId);
		 		$subSql = array();
		 		if ($abreviation) {
		 			$subregion = $db->qstr(geoString::toDB($abreviation));
		 			$subSql [] = "`location_state`=$subregion";
		 		}
				if ($statename) {
					$regionname = $db->qstr(geoString::toDB($statename));
					$subSql[] = "`location_state`=$regionname";
				}
				if ($subSql) {
					$part = '('.implode(' OR ',$subSql).')';
				}
			}
		} else if (strpos($regionId, 'country') !== false) {
			//selected a country
			$countryId = (int)str_replace('country','',$regionId);
			if ($countryId) {
				$region = geoRegion::getInstance();
				$regionname = $db->qstr(geoString::toDB($region->getRegionNameById($countryId)));
				if ($regionname) {
					//echo "region name: $regionname";
					$part = "`location_country`=$regionname";
				}
			}
		}
		
		if ($part) {
			if (strlen(trim($whereClause)) > 0) {
				$whereClause .= " AND ".$part;
			} else {
				$whereClause = $part;
			}
		}
		
		return $whereClause;
	}
	
	public function core_geoFields_getDefaultFields ($vars)
	{
		$categoryId = $vars['categoryId'];
		$groupId = $vars['groupId'];
		
		//expected to return using following format:
		$return = array (
			'addon_geographic_navigation_location' => array (
				/**
				 * NOTE: We HIGHLY recommend prepending the "field index" (example_widget)
				 * with your addon name to avoid field name collisions with other addons
				 * or possible future added core fields
				 */
				'label' => 'Geographic Location',
				'type' => 'other',
				'type_extra' => 'on_off',
				'type_extra_label' => 'Require Full Location Depth',
			),
			//you can add as many fields as you want.
		);
		return $return;
	}
	
	
	/**
	 * This is return array type of core event.  Expected to return an array that
	 * will be used to display a header in browsing results.  See this method's 
	 * source for more documentation.
	 * 
	 * @param array $vars Associative array of stuff.
	 * @return array An array of arrays, See method's source for more documentation.
	 * @since Geo Version 4.0.4
	 */
	public function core_Browse_ads_display_browse_result_addHeader ($vars)
	{
		$object = $vars['this'];
		$fields = $vars['browse_fields'];
		
		if (!$fields['addon_geographic_navigation_location']) {
			//not supposed to show in here
			return;
		}
		
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		
		$headings = array();
		//first heading to add
		$headings [] = array (
			'text' => $msgs['browsingHeader'],
		);
		return $headings;
	}
	
	/**
	 * This is return array type of core event.  Expected to return array of 
	 * strings, each string will be inserted into it's own table column.  See 
	 * this method's source for more documentation.
	 * 
	 * @param array $vars Associative array of stuff.
	 * @return array an array of stuff to display, or false.
	 * @since Geo Version 4.0.4
	 */
	public function core_Browse_ads_display_browse_result_addRow ($vars)
	{
		$listing_data = $vars['show_classifieds'];
		$fields = $vars['browse_fields'];
		
		if (!$fields['addon_geographic_navigation_location']) {
			//not supposed to show in here
			return;
		}
		
		$rows = array();
		$parts = $this->getRegionsForDisplay($listing_data['id'],0);
		
		$rows[] = implode (' &gt; ', $parts);
		
		return $rows;
	}
	
	/**
	 * This is return array type of core event.  Expected to return an array that
	 * will be used to display a header in browsing results.  See this method's 
	 * source for more documentation.
	 * 
	 * @param array $vars Associative array of stuff.
	 * @return array An array of arrays, See method's source for more documentation.
	 * @since Geo Version 5.1.0
	 */
	public function core_Browse_tag_display_browse_result_addHeader ($vars)
	{
		$fields = $vars['tag_fields'];
		
		if (!$fields['addon_geographic_navigation_location']) {
			//not supposed to show in here
			return;
		}
		
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		
		$headings = array();
		//first heading to add
		$headings [] = array (
			'text' => $msgs['browsingHeader'],
		);
		return $headings;
	}
	
	public function core_Browse_tag_display_browse_result_addRow ($vars)
	{
		$listing_data = $vars['show_classifieds'];
		$fields = $vars['tag_fields'];
		
		if (!$fields['addon_geographic_navigation_location']) {
			//not supposed to show in here
			return;
		}
		
		$rows = array();
		$parts = $this->getRegionsForDisplay($listing_data['id'],0);
		
		$rows[] = implode (' &gt; ', $parts);
		
		return $rows;
	}
	
	public function core_Search_classifieds_BuildResults_addHeader ($vars)
	{
		//$vars is an associative array of variables passed from the original function.
		//See the original function for further docs on what each one is.
		$fields = $vars['search_fields'];
		
		if (!$fields['addon_geographic_navigation_location']) {
			//not supposed to show in here
			return;
		}
		
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		
		$headings = array();
		//first heading to add
		$headings [] = array (
			'text' => $msgs['browsingHeader'],
		);
		return $headings;
	}
	
	public function core_Search_classifieds_BuildResults_addRow ($vars)
	{
		$fields = $vars['search_fields'];
		$listingId = $vars['listing_id'];
		
		if (!$fields['addon_geographic_navigation_location']) {
			//not supposed to show in here
			return;
		}
		
		$rows = array();
		$parts = $this->getRegionsForDisplay($listingId,0);
		
		$rows[] = implode (' &gt; ', $parts);
		
		return $rows;
	}
	
	public function core_module_search_box_add_search_fields ($vars)
	{
		$page = $vars['page'];
		$show_module = $vars['show_module'];
		
		$reg = geoAddon::getRegistry($this->name);
		if (!$reg->showInSearchBox) {
			return '';
		}
		
		$view = geoView::getInstance();
		$view->addJScript('addons/geographic_navigation/regions.js');
		
		$tpl = new geoTemplate (geoTemplate::ADDON, 'geographic_navigation');
		
		$regionId = $countryId = $stateId = $highestLevel = 0;
		$region = $this->getCurrentRegion();
		$countryId = (strpos($region, 'country')!==false)? str_replace('country','',$region) : 0;
		$stateId = (strpos($region, 'state')!==false)? str_replace('state','',$region) : 0;
		$regionId = (strpos($region, 'region')!==false)? str_replace('region','',$region) : 0;
		
		$tpl->levels = $this->getLevelsFor($regionId, $stateId, $countryId);
		$tpl->pre = 'b';
		$tpl->breakBetweenLevels = true;
		
		$msgs = $this->_getText();
		//cheat a little, set select to be different
		$msgs['selectRegions'] = $msgs['allRegionsSelect'];
		$tpl->msgs = $msgs;
		$tpl->showInSearchBox = geoAddon::getRegistry($this->name)->showInSearchBox;
		
		return $tpl->fetch('listing_region_select/levels.tpl');
	}
	
	public function core_module_title_prepend_text ()
	{
		//NOTE:  at this time, categories only display end category in title module,
		//so we do same for regions for consistency.  If/when main software is 
		//changed to show entire category breadcrumb in title module, this can be
		//updated to also show full breadcrumb for region in title.
		$view = geoView::getInstance();
		$reg = geoAddon::getRegistry($this->name);
		if ($view->classified_id) {
			//we are displaying a listing
			if ($reg->showInTitleListing) {
				$regions = $this->getRegionsForDisplay($view->classified_id);
				
				return geoString::specialChars(array_pop($regions)).' : ';
			}
		}
		
		if (!$reg->showInTitle) {
			return '';
		}
		$region = $this->getCurrentRegion();
		if (!$region) {
			//nothing selected currently
			return '';
		}
		$breadcrumb = $this->getBreadcrumbFor($region);
		$entry = array_pop($breadcrumb);
		return geoString::specialChars($entry['label']).' : ';
	}
	
	public function getStatesFor ($country_id)
	{
		$country_id = (int)$country_id;
		if (!$country_id) {
			//oops, no good
			
			return;
		}
		$region = geoRegion::getInstance();
		$subdomains = (geoAddon::getRegistry($this->name)->subdomains == 'on');
		
		$all = $region->getSubRegionList($country_id,self::COLUMN_NAME,true);
		$regions = array();
		foreach($all as $region) {
			$subdomain = ($subdomains)? $region['subdomain'] : '';
			$regions[] = array (
				'id' => 'state'.$region['state_id'],
				'label' => $region['name'],
				'subdomain' => $subdomain,
				'link' => $this->getLinkForRegion('state'.$region['state_id'], $subdomain),
			);
		}
		return $regions;
	}
	
	public function getStateCountForCountry ($countryId)
	{
		$countryId = (int) $countryId;
		if (!$countryId) return 0;
		
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$sql = "SELECT count(*) as count FROM ".geoTables::states_table." WHERE `parent_id`=? AND ".self::COLUMN_NAME."=1";
		$row = $db->GetRow($sql, array($countryId));
		return ($row['count'])? (int)$row['count'] : 0;
	}
	
	public function getRegionCountForState($stateId)
	{
		$stateId = (int) $stateId;
		if (!$stateId) return 0;
		
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$sql = "SELECT count(*) as count FROM ".self::REGION_TABLE." WHERE `parent_state`=?";
		$row = $db->GetRow($sql, array($stateId));
		return ($row['count'])? (int)$row['count'] : 0;
	}
	
	public function getRegionCountFor ($regionId)
	{
		$regionId = (int) $regionId;
		if (!$regionId) return 0;
		
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$sql = "SELECT count(*) as count FROM ".self::REGION_TABLE." WHERE `parent_region`=?";
		$row = $db->GetRow($sql, array($regionId));
		return ($row['count'])? (int)$row['count'] : 0;
	}
	
	public function getRegionsForState($stateId)
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$subdomains = (geoAddon::getRegistry($this->name)->subdomains == 'on');
		if (!is_numeric($stateId)) {
			//get the ID
			$stateId = trim($stateId);
			$sql = "SELECT `state_id` FROM ".geoTables::states_table." WHERE `abbreviation` = ? OR `name` = ?";
			$row = $db->GetRow($sql, array($stateId, $stateId));
			if (isset($row['state_id']) && $row['state_id']) {
				$stateId = $row['state_id'];
			}
		}
		$stateId = (int)$stateId;
		if (!$stateId) {
			return false;
		}
		
		$sql = "SELECT * FROM ".self::REGION_TABLE." WHERE `parent_state`=? ORDER BY `display_order`";
		$all = $db->GetAll($sql, array($stateId));
		if (!$all) {
			return false;
		}
		//auto clean up
		foreach ($all as $id => $val) {
			$all[$id]['label'] = geoString::fromDB($val['label']);
			$all[$id]['id'] = 'region'.$all[$id]['id'];
			$all[$id]['subdomain'] = $subdomain = ($subdomains)? $all[$id]['subdomain'] : '';
			$all[$id]['link'] = $this->getLinkForRegion($all[$id]['id'], $subdomain);
		}
		return $all;
	}
	public function getLevelNumber ($parentState=0, $parentRegion=0)
	{
		$parentState = (int)$parentState;
		$parentRegion = (int)$parentRegion;
		
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$level = 1;
		while (!$parentState && $parentRegion) {
			$sql = "SELECT `parent_region`, `parent_state` FROM ".addon_geographic_navigation_info::REGION_TABLE."
				WHERE `id`=?";
			$row = $db->GetRow($sql, $parentRegion);
			$level ++;
			$parentRegion = (int)$row['parent_region'];
			$parentState = (int)$row['parent_state'];
		}
		if ($parentState) {
			//add 2 levels for country/state
			$level +=2;
		}
		
		return $level;
	}
	
	public function getBreadcrumbFor ($regionName)
	{
		$regionId = $stateId = $countryId = false;
		if (strpos($regionName,'region') !== false) {
			//got a region selected
			$regionId = (int)str_replace('region','',$regionName);
		} else if (strpos($regionName,'state') !== false) {
			//got a state selected
			$stateId = (int)str_replace('state','',$regionName);
		} else if (strpos($regionName,'country') !== false) {
			//got a country selected
			$countryId = (int)str_replace('country','',$regionName);
		}
		
		$db = DataAccess::getInstance();
		
		$regions = array();
		while ($regionId || $stateId || $countryId) {
			if ($regionId) {
				$region = $db->GetRow("SELECT * FROM ".self::REGION_TABLE." WHERE `id`=?", array($regionId));
				
				$region['id'] = 'region'.$regionId;
				$region['label'] = geoString::fromDB($region['label']);
				$region['link'] = $this->getLinkForRegion('region'.$regionId, $region['subdomain']);
				
				//shift it onto the front of the array
				array_unshift($regions, $region);
				
				$stateId = (int)$region['parent_state'];
				$regionId = (int)$region['parent_region'];
				$countryId = false;
			} else if ($stateId) {
				$region = $db->GetRow("SELECT `name` as `label`, `subdomain`, `parent_id` FROM ".geoTables::states_table." WHERE `state_id`=?", array($stateId));
				
				$region['id'] = 'state'.$stateId;
				$region['link'] = $this->getLinkForRegion('state'.$stateId, $region['subdomain']);
				
				//shift it onto the front of the array
				array_unshift($regions, $region);
				
				$stateId = false;
				$regionId = false;
				$countryId = (int)$region['parent_id'];
			} else {
				//gotta be country
				$region = $db->GetRow("SELECT `name` as `label`, `subdomain` FROM ".geoTables::countries_table." WHERE `country_id`=?", array($countryId));
				
				$region['id'] = 'country'.$countryId;
				$region['link'] = $this->getLinkForRegion('country'.$countryId, $region['subdomain']);
				
				//shift it onto the front of the array
				array_unshift($regions, $region);
				
				$stateId = false;
				$regionId = false;
				$countryId = false;
			}
		}
		
		return $regions;
	}
	
	/**
	 * Gets levels for given region, state, and country.  If 0 for all 3, provides
	 * region 1 level regions not attached to a country.
	 * 
	 * @param int $region_id
	 * @param int $state_id
	 * @param int $country_id
	 * @return array
	 */
	public function getLevelsFor ($region_id = 0, $state_id=0, $country_id=0)
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$region_id = (int)$region_id;
		$state_id = (int)$state_id;
		$country_id = (int)$country_id;
		
		$domain = $this->getDomain();
		
		$subdomains = (geoAddon::getRegistry($this->name)->subdomains == 'on');
		
		//only keep the "deeper" set value, rest clear em!
		if ($region_id) $country_id = $state_id = 0;
		if ($state_id) $country_id = 0;
		
		//echo "country: $country_id state: $state_id region: $region_id<br />";
		
		$levels = $finalLevels = array();
		//Get levels "backwards"
		$selected = $isTop = 0;
		while ($region_id xor $state_id) {
			if ($region_id) {
				$currentRegion = $this->getRegionsForRegion($region_id);
			} else {
				$currentRegion = $this->getRegionsForState($state_id);
			}
			if ($currentRegion) {
				if ($selected) $selected = 'region'.$selected;
				$levels[] = array (
					'regions' => $currentRegion,
					'selected' => $selected
				);
			}
			if ($region_id) {
				//now get parents
				$sql = "SELECT `parent_region`, `parent_state` FROM ".self::REGION_TABLE." WHERE `id`=?";
				$row = $db->GetRow($sql, array($region_id));
				if (!isset($row['parent_region'])) {
					//error, didn't find specified region!  Most likely a region
					//was deleted, so pretend nothing is specified.
					$region_id = $state_id = $country_id = 0;
					break;
				}
				
				$selected = $region_id;
				$region_id = (int)$row['parent_region'];
				$state_id = (int)$row['parent_state'];
				if (!$region_id && !$state_id) {
					$isTop = true;
				}
			} else if ($state_id) {
				//just got regions attached to a state, get the parent country
				$selected = $state_id;
				//get the country this state is in
				$sql = "SELECT `parent_id` FROM ".geoTables::states_table." WHERE `state_id`=?";
				$row = $db->GetRow($sql, array($state_id));
				if (isset($row['parent_id'])) {
					$country_id = (int)$row['parent_id'];
				}
				//clear state to proceed
				$state_id = 0;
			}
		}
		$region = geoRegion::getInstance();
		if ($country_id) {
			//get states in this country
			$statesRaw = $region->getSubRegionList($country_id, self::COLUMN_NAME, true);
			//put states in format for use here
			$states = array();
			foreach ($statesRaw as $stateId => $state) {
				$subdomain = ($subdomains)? $state['subdomain'] : '';
				$states[] = array (
					'id' => 'state'.$stateId,
					'label' => $state['name'],
					'subdomain' => $subdomain,
					'link' => $this->getLinkForRegion('state'.$stateId, $subdomain),
				);
			}
			if ($selected) $selected = 'state'.$selected;
			if ($states) {
				$levels[] = array (
					'regions' => $states,
					'selected' => $selected,
				);
			}
			$selected = $country_id;
		}
		
		//get the countries
		$countriesRaw = $region->getRegionsList(self::COLUMN_NAME,true);
		//convert it into looking like region array
		$countries = array();
		foreach ($countriesRaw as $key => $country) {
			$subdomain = ($subdomains)? $country['subdomain'] : '';
			$countries[] = array(
				'id' => 'country'.$key,
				'label' => $country['name'],
				'subdomain' => $subdomain,
				'link' => $this->getLinkForRegion('country'.$key, $subdomain),
			);
		}
		$topRegions = $this->getRegionsForRegion(0);
		if ($topRegions) {
			$countries = array_merge($countries, $topRegions);
		}
		
		//now get any regions not attached to anything
		if ($selected) $selected = (($isTop)? 'region':'country').$selected;
		$levels[] = array (
			'regions' => $countries,
			'selected' => $selected,
		);
		
		//OK now $levels is ass backwards, so straiten it out.
		if ($levels) {
			//there are additional levels to sus out
				
			$level = 1;
			$levels = array_reverse($levels);
			foreach ($levels as $thisLevel) {
				$finalLevels[$level] = $thisLevel;
				$level++;
			}
		}
		return $finalLevels;
	}
	
	public function getRegionsFor ($regionName)
	{
		if (strpos($regionName,'region') !== false) {
			//got a region selected
			$regionId = (int)str_replace('region','',$regionName);
			
			return $this->getRegionsForRegion($regionId);
		} else if (strpos($regionName,'state') !== false) {
			//got a state selected
			$stateId = (int)str_replace('state','',$regionName);
			
			return $this->getRegionsForState($stateId);
		} else if (strpos($regionName,'country') !== false) {
			//got a country selected
			$countryId = (int)str_replace('country','',$regionName);
			
			return $this->getStatesFor($countryId);
		}
		
		//if none of the above, get top level regions
		$region = geoRegion::getInstance();
		$subdomains = (geoAddon::getRegistry($this->name)->subdomains == 'on');
		
		//get the countries
		$countriesRaw = $region->getRegionsList(self::COLUMN_NAME,true);
		//convert it into looking like region array
		$countries = array();
		foreach ($countriesRaw as $key => $country) {
			$subdomain = ($subdomains)? $country['subdomain'] : '';
			$countries[] = array(
				'id' => 'country'.$key,
				'label' => $country['name'],
				'subdomain' => $subdomain,
				'link' => $this->getLinkForRegion('country'.$key, $subdomain)
			);
		}
		$topRegions = $this->getRegionsForRegion(0);
		if ($topRegions) {
			$countries = array_merge($countries, $topRegions);
		}
		return $countries;
	}
	
	private $_linkVars;
	
	public function getLinkForRegion ($regionId, $subdomain)
	{
		if (!isset($this->_linkVars)) {
			$this->_linkVars['subdomains'] = (geoAddon::getRegistry($this->name)->subdomains == 'on');
			$this->_linkVars['domain'] = $this->getDomain(true).'/'.DataAccess::getInstance()->get_site_setting('classifieds_file_name').rtrim($this->getBaseUrl(true),'?&');
			$this->_linkVars['base_url'] = $this->getBaseUrl();	
		}
		
		return ($this->_linkVars['subdomains'] && $subdomain)? "http://{$subdomain}.{$this->_linkVars['domain']}" : "{$this->_linkVars['base_url']}region={$regionId}";
	}
	
	public function getRegionsForRegion($regionId)
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$regionId = (int)$regionId;
		
		$extra = ($regionId)? '': ' AND `parent_state`=0';
		
		$sql = "SELECT * FROM ".self::REGION_TABLE." WHERE `parent_region`=?{$extra} ORDER BY `display_order`";
		$all = $db->GetAll($sql, array($regionId));
		
		//echo "id: $regionId all: ".print_r($all,1);
		if (!$all) {
			return false;
		}
		//auto clean up
		foreach ($all as $id => $val) {
			$all[$id]['label'] = geoString::fromDB($val['label']);
			$all[$id]['id'] = 'region'.$all[$id]['id'];
			$all[$id]['link'] = $this->getLinkForRegion($all[$id]['id'], $all[$id]['subdomain']);
		}
		return $all;
	}
	
	public function setRegionsForListing ($listingId, $regions)
	{
		return $this->setRegionsFor($listingId, $regions, 'listing');
	}
	public function setRegionsForUser($userId, $regions)
	{
		return $this->setRegionsFor($userId, $regions, 'user');
	}
	public function setRegionsForUserConfirm($confirmId, $regions)
	{
		return $this->setRegionsFor($confirmId, $regions, 'user_confirmation');
	}
	
	public function setRegionsFor ($id, $regions, $type = 'listing', $removeExisting = true)
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$geoRegion= geoRegion::getInstance();
		$id = (int)$id;
		if (!$id) {
			return false;
		}
		if (!is_array($regions) || !count($regions)) {
			return false;
		}
		if ($type == 'listing') {
			$sql = "REPLACE INTO ".self::LISTING_TABLE." (`listing`, `region_id`, `region_name`, `level`) VALUES (?, ?, ?, ?)";
			$nameSql = "SELECT `label` FROM ".self::REGION_TABLE." WHERE `id`=?";
			
			$removeSql = "DELETE FROM ".self::LISTING_TABLE." WHERE `listing`=?";
		} else if ($type == 'user' || $type == 'user_confirmation') {
			$sql = "REPLACE INTO ".self::USER_TABLE." (`user`, `confirmation`, `region_id`, `level`) VALUES (?, ?, ?, ?)";
			$nameSql = '';
			$userId = ($type == 'user')? $id : 0;
			$confirmId = ($type == 'user_confirmation')? $id : 0;
			
			$field = ($userId)? 'user': 'confirmation';
			$removeSql = "DELETE FROM ".self::USER_TABLE." WHERE `$field`=?";
		}
		if ($removeExisting) {
			//remove existing
			$db->Execute($removeSql, array($id));
		}
		foreach ($regions as $level => $region) {
			if (!$region) {
				//not set to anything for this level
				continue;
			}
			if (strpos($region,'country') !== false) {
				//country
				if ($type == 'listing') {
					//nothign to do for country on listings, it was already done
					//elsewhere
					continue;
				}
				$countryId = (int)str_replace('country','',$region);
				if (!$countryId) {
					//not set to anything useful
					continue;
				}
				
				$name = $geoRegion->getRegionNameById($countryId);
				if (!$name) {
					continue;
				}
				//Set country for listing/user
				
				//update country in confirmation/userdata table
				$tableName = ($type=='user')? geoTables::userdata_table: geoTables::confirm_table;
				
				$countrySql = "UPDATE $tableName SET `country`=? WHERE `id`=?";
				
				$db->Execute($countrySql, array($name, $id));
			} else if (strpos($region, 'state') !== false) {
				//state
				if ($type == 'listing') {
					//nothign to do for state on listings, it was already done
					//elsewhere
					continue;
				}
				$stateId = (int)str_replace('state','',$region);
				if (!$stateId) {
					//not set to anything useful
					continue;
				}
				
				$name = $geoRegion->getSubRegionAbbreviationById($stateId);
				if (!$name) {
					continue;
				}
				//Set country for listing/user
				
				//update country in confirmation/userdata table
				$tableName = ($type=='user')? geoTables::userdata_table: geoTables::confirm_table;
				
				$stateSql = "UPDATE $tableName SET `state`=? WHERE `id`=?";
				
				$db->Execute($stateSql, array($name, $id));
			} else if (strpos($region, 'region') !== false) {
				//region
				$region = (int)str_replace('region','',$region);
				if (!$region) {
					//not set to anything useful for this level
					continue;
				}
				if ($nameSql) {
					//get the name
					$row = $db->GetRow($nameSql, array($region));
					if ($row === false) {
						//error!
						trigger_error("ERROR SQL: Sql: $nameSql message: ".$db->ErrorMsg());
						return false;
					} else if (!$row) {
						//could not find it?
						return false;
					}
					$label = trim($row['label']);
					//label will be already DB encoded this way
				}
				if ($type == 'listing') {
					$query_data = array(
						$id, $region, $label, (int)$level
					);
				} else if ($type == 'user' || $type == 'user_confirmation') {
					$query_data = array (
						$userId, $confirmId, $region, (int)$level
					);
				}
				if (!$db->Execute($sql, $query_data)) {
					//error executing query!
					trigger_error("ERROR SQL: Sql: $sql message: ".$db->ErrorMsg());
					return false;
				}
			}
		}
		return true;
	}
	
	public function getRegionsForDisplay ($listingId, $userId)
	{
		$db = 1;
		include GEO_BASE_DIR.'get_common_vars.php';
		//figure out the listing ID
		$view = geoView::getInstance();
		
		//sanity checks
		$listingId = (int)$listingId;
		$userId = (int)$userId;
		
		if (!$listingId && !$userId) {
			//id NOT set
			return '';
		}
		
		$regions = array();
		if ($listingId) {
			$listing = geoListing::getListing($listingId);
			if (!$listing) {
				//could not get listing for some reason
				return '';
			}
			if ($listing->location_country) {
				$regions[] = $country = geoString::fromDB($listing->location_country);
				$country_id = (int)$db->GetOne("SELECT `country_id` FROM ".geoTables::countries_table." WHERE `name` LIKE ?",
					array ($country.''));
			}
			if ($listing->location_state) {
				$state = trim(geoString::fromDB($listing->location_state));
				if ($country_id) {
					//figure out actual full state name
					$label = $db->GetOne("SELECT `name` FROM ".geoTables::states_table." WHERE TRIM(`abbreviation`)=? AND `parent_id`=?",
						array ($state.'', $country_id));
					$state = ($label)? $label : $state;
				}
				$regions[] = $state;
			}
			$sql = "SELECT `region_name`, `level` FROM ".self::LISTING_TABLE." WHERE `listing`=? ORDER BY `level`";
			$all = $db->GetAll($sql, array($listingId));
		} else {
			$user = geoUser::getUser($userId);
			if (!$user) {
				//couldn't get user!  Doh!
				return '';
			}
			if ($user->country) {
				$regions[] = geoString::fromDB($user->country);
			}
			if ($user->state) {
				$regions[] = geoString::fromDB($user->state);
			}
			
			$sql = "SELECT `label` as `region_name`, `level` FROM ".self::USER_TABLE." u, ".self::REGION_TABLE." r WHERE u.region_id=r.id AND `user`=? ORDER BY `level`";
			$all = $db->GetAll($sql, array($userId));
		}
		
		foreach ($all as $row) {
			if ($row['region_name']) {
				if ($row['level'] == 1) {
					//this is a level 1 region, so no country/state
					$regions = array();
				}
				$regions[] = geoString::fromDB($row['region_name']);
			}
		}
		return $regions;
	}
	
	public function removeRegionsFor ($id)
	{
		$id = (int)$id;
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$result = $db->Execute("DELETE FROM ".self::LISTING_TABLE." WHERE `listing`=?", array($id));
		if (!$result) {
			trigger_error("ERROR SQL: Sql: $nameSql message: ".$db->ErrorMsg());
			return false;
		}
		return true;
	}
	
	/**
	 * Makes sure the regions selected, that the end one doesn't have any kids.
	 * @param $selectedRegions
	 * @return bool true if it is terminating (does not have kids), false otherwise
	 */
	public function checkTerminatingRegions ($selectedRegions)
	{
		reset($selectedRegions);
		
		$lastSelected = array_pop($selectedRegions);
		if (!$lastSelected) {
			//last one has value set to 0, of course it's false
			return false;
		}
		if (strpos($lastSelected, 'country') !== false) {
			//It's a country, see if there are any states in this country
			$countryId = (int)str_replace('country','',$lastSelected);
			if (!$countryId) return false;
			
			return ($this->getStateCountForCountry($countryId) == 0);
		}
		
		if (strpos($lastSelected, 'state')!== false) {
			//it's a state
			$stateId = (int)str_replace('state', '', $lastSelected);
			if (!$stateId) return false;//some error
			
			return ($this->getRegionCountForState($stateId) == 0);
		}
		if (strpos($lastSelected, 'region') !== false) {
			$regionId = (int)str_replace('region', '', $lastSelected);
			if (!$regionId) return false;
			
			return ($this->getRegionCountFor($regionId) == 0);
		}
		//unknown region
		return false;
	}
	
	public function ajaxSelectRegion ()
	{
		$fieldName = trim($_POST['fieldName']);
		$passedId = trim($_POST['region_id']);
		//figure out if it's a country, state, or region
		$regionId = $stateId = $countryId = 0;
		
		if (strpos($passedId, 'state') !== false) {
			//it's a state
			$stateId = (int)str_replace('state','',$passedId);
		} else if (strpos($passedId,'country') !== false) {
			//it's a country
			$countryId = (int)str_replace('country','',$passedId);
		} else if (strpos($passedId,'region') !== false) {
			//it's a region
			$regionId = (int)str_replace('region','',$passedId);
		}
		
		//Figure out the "pre" from the field name.
		$pre = substr($fieldName,0,strpos($fieldName,'['));
		
		//make sure it's allowed, to clean user input.
		$allowedPre = array ('b','c');
		$pre = (in_array($pre,$allowedPre))? $pre : 'c';
		
		$levels = $this->getLevelsFor($regionId, $stateId, $countryId);
		
		$tpl = new geoTemplate (geoTemplate::ADDON, 'geographic_navigation');
		$tpl->levels = $levels;
		$tpl->ajax = true;
		$tpl->pre = $pre;
		$tpl->msgs = $this->_getText();
		$tpl->showInSearchBox = geoAddon::getRegistry($this->name)->showInSearchBox;
		
		echo $tpl->fetch('listing_region_select/levels.tpl');
	}
	
	public function getDomain ($includeFolder = false)
	{
		//gets the domain
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$site = $db->get_site_setting('classifieds_url');
		$site = preg_replace("|^https?://(www\.)?|",'',$site);
		//clear off the end part
		if (!$includeFolder) {
			$site = preg_replace("/\/.*$/",'',$site);
		} else {
			$site = dirname($site);
		}
		
		return $site;
	}
	
	public function subdomainClean ($subdomain)
	{
		//make it lowercase and trim it
		$subdomain = trim(strtolower($subdomain));
			
		//replace spaces with hyphen
		$subdomain = preg_replace("/[\s]+/",'-',$subdomain);
		
		/**
		 * Changes applied, as per official specification of valid hostnames
		 * in RFC1123:
		 * - Only a-z, 0-9, and hyphens allows (along with . for part seperation)
		 * - each part cannot start or end with a -
		 * - each part cannot be more than 63 chars
		 */
		
		//can only contain a-z, 0-9, dots, and hyphens -
		$subdomain = preg_replace("/[^-a-z0-9.]+/",'',$subdomain);
		//cannot start or end with - or .
		$subdomain = trim($subdomain, '-.');
		
		//clean up each part of the subdomain
		$parts_raw = explode('.',$subdomain);
		$parts = array();
		foreach ($parts_raw as $part) {
			//make sure part is not more than 63 chars
			$part = substr($part, 0, 63);
			//cannot start or end in -
			$part = trim($part, '-');
			
			if (strlen($part)) {
				//there is something left after cleaning it, so add part to array of subdomain parts
				$parts[] = $part;
			}
		}
		//re-put-together parts
		$subdomain = implode('.',$parts);
		return $subdomain;
	}
	
	public function subdomainUsed ($subdomain, $childClass='', $region_id=0)
	{
		$db = DataAccess::getInstance();
		//make sure it is string
		$subdomain = $subdomain.'';
		
		//make sure it does not match something already in system...
		$count = (int)$db->GetOne("SELECT COUNT(*) FROM ".self::REGION_TABLE."
			WHERE ".(($childClass=='isRegion')? "`id` != $region_id AND " : '')."`subdomain`=?", array($subdomain));
		
		//count in countries as well
		$count += (int)$db->GetOne("SELECT COUNT(*) FROM ".geoTables::countries_table."
			WHERE ".(($childClass=='isCountry')? "`country_id` != $region_id AND " : '')."`subdomain`=?", array($subdomain));
		
		//also count in states
		$count += (int)$db->GetOne("SELECT COUNT(*) FROM ".geoTables::states_table."
			WHERE ".(($childClass=='isState')? "`state_id` != $region_id AND " : '')."`subdomain`=?", array($subdomain));
		
		return ($count > 0);
	}
	
	public function getListingCounts ($regionId)
	{
		$reg = geoAddon::getRegistry($this->name);
		$db = DataAccess::getInstance();
		
		$counts = array();
		if (!$regionId) {
			return $counts;
		}
		
		if (strpos($regionId, 'country')!==false) {
			$countryId = (int)substr($regionId,7);
			$regionname = $db->qstr(geoString::toDB(geoRegion::getInstance()->getRegionNameById($countryId)));
			
			$sql = "SELECT COUNT(*) FROM ".geoTables::classifieds_table." as c WHERE `location_country`=$regionname AND `live`=1";
		} else if (strpos($regionId, 'state') !== false) {
			$stateId = (int)substr($regionId,5);
			
			$countryId = (int)$db->GetOne("SELECT `parent_id` FROM ".geoTables::states_table." WHERE `state_id`=$stateId");
			if ($countryId) {
				$region = geoRegion::getInstance();
				$abreviation = $region->getSubRegionAbbreviationById($stateId,$countryId);
				$statename = $region->getSubRegionNameById($stateId, $countryId);
		 		$subSql = array();
		 		if ($abreviation) {
		 			$subregion = $db->qstr(geoString::toDB($abreviation));
		 			$subSql [] = "`location_state`=$subregion";
		 		}
				if ($statename) {
					$regionname = $db->qstr(geoString::toDB($statename));
					$subSql[] = "`location_state`=$regionname";
				}
			}
			
			$sql = "SELECT COUNT(*) FROM ".geoTables::classifieds_table." as c WHERE (".implode(' OR ',$subSql).") AND `live`=1";
		} else {
			$regionId = (int)substr($regionId,6);
			
			//this is easy one, just count number of entries in our table
			$sql = "SELECT COUNT(*) FROM ".self::LISTING_TABLE." as r, ".geoTables::classifieds_table." as c
				WHERE c.id=r.listing AND r.region_id=$regionId AND c.`live`=1";
		}
		
		//ok we got the basic SQL, now just get counts...
		if (geoPC::is_classifieds() && in_array($reg->countFormat, array('ca','ac','c'))) {
			//get classified count
			$counts['classifieds'] = $db->GetOne($sql.' AND c.item_type = 1');
		}
		if (geoPC::is_auctions() && in_array($reg->countFormat, array('ca','ac','a'))) {
			//auction count
			$counts['auctions'] = $db->GetOne($sql.' AND c.item_type != 1');
		}
		if ($reg->countFormat=='all') {
			//note: don't check is_class_auctions here so that it works for all types on the demo
			//combined count
			$counts['all'] = $db->GetOne($sql);
		}
		
		return $counts;
	}
	
	private function _getText ()
	{
		return geoAddon::getText($this->auth_tag, $this->name);
	}
	

	public function getBaseUrl ($queryOnly = false)
	{
		$db = DataAccess::getInstance();
		$skip_list = array('region','subregion');
		$parts = array();
		foreach ($_GET as $key => $value) {
			if (!in_array($key,$skip_list)) {
				if (is_array($value)) {
					foreach ($value as $sub_i => $sub_v) {
						$parts[] = "{$key}[{$sub_i}]=$sub_v";
					}
				} else {
					$parts[] = "$key=$value";
				}
			}
		}
		$base = $db->get_site_setting('classifieds_url');
		if ($queryOnly) {
			$base = '';
		}
		if (count($parts)) {
			return $base.'?'.implode("&",$parts)."&";
		}
		return $base.'?';
	}
	
	public function getCurrentRegion ()
	{
		return geoView::getInstance()->geographic_navigation_region;
	}
	
	/**
	 * Check to make sure the specified region ID is found in the system and currently
	 * enabled.
	 * @param string $region_id
	 * @return bool True if the specified region ID is valid and enabled, false otherwise
	 */
	public function checkRegionId ($region_id)
	{
		$db = DataAccess::getInstance();
		if (strpos($region_id, 'region') === 0) {
			//make sure it is in regions table
			$id = (int)substr($region_id, 6);
			if (!$id) {
				//invalid ID
				return false;
			}
			//check it in DB, make sure region hasn't been removed
			$id_check = (int)$db->GetOne("SELECT `id` FROM ".self::REGION_TABLE." WHERE `id`=$id");
			return ($id_check > 0);
		}
		
		if (strpos($region_id, 'country') === 0) {
			//make sure it is in country table, and a country that has geo nav addon enabled
			$id = (int)substr($region_id, 7);
			if (!$id) {
				//invalid ID
				return false;
			}
			$row = $db->GetRow("SELECT `country_id` FROM ".geoTables::countries_table." WHERE `country_id`=$id AND ".self::COLUMN_NAME."=1");
			return ($row && $row['country_id']);
		}
		
		if (strpos($region_id, 'state') === 0) {
			//make sure it is in states table, and a state that has geo nav addon enabled
			$id = (int)substr($region_id, 5);
			if (!$id) {
				//invalid ID
				return false;
			}
			$row = $db->GetRow("SELECT `state_id` FROM ".geoTables::states_table." WHERE `state_id`=$id AND ".self::COLUMN_NAME."=1");
			return ($row && $row['state_id']);
		}
		
		//it does not match any normal region ID so it must not be a good ID
		return false;
	}
}
