{* $Rev: 19695 $ *}

{$adminMessages}

{literal}
<script type="text/javascript">
	//<![CDATA[
	//simple JS to show/hide fields
	Event.observe(window,'load', function () {
		var toggleDomains = function (action) {
			$('subdomainSettingsLink')[($('subdomainOff').checked)? 'hide' : 'show']();
			$('subdomainSettingsAdd')[($('subdomainOff').checked)? 'hide' : 'show']();
		};
		$('subdomainOff').observe('change', toggleDomains);
		$('subdomainConfig').observe('change', toggleDomains);
		$('subdomainOn').observe('change', toggleDomains);
		toggleDomains(false);
	});
	
	//]]>
</script>

{/literal}
<form action="" method="post" id="subdomainsForm">
<fieldset>
	<legend>Sub Domains</legend>
	<div>
		<p class="page_note_error"><strong>Warning:</strong> The sub-domains listed at bottom of this page must be configured in your hosting control panel to "point" to this installation location prior to enabling the sub-domain feature.  If you do not configure your host properly, enabling sub domains will result in broken links or even a non-functioning site.</p>
		<div class="{cycle values='row_color1,row_color2'}">
			<div class="leftColumn">Sub Domain Usage</div>
			<div class="rightColumn">
				<label><input type="radio" name="subdomains" id="subdomainOff" value="0"{if !$subdomains} checked="checked"{/if} /> Not Used</label><br />
				<label><input type="radio" name="subdomains" id="subdomainConfig" value="configure"{if $subdomains=='configure'} checked="checked"{/if} /> Configure, but Not Enabled</label><br />
				<label><input type="radio" name="subdomains" id="subdomainOn" value="on"{if $subdomains=='on'} checked="checked"{/if} /> Enabled</label><br />
			</div>
			<div class="clearColumn"></div>
		</div>
		<div class="{cycle values='row_color1,row_color2'}" id="subdomainSettingsLink">
			<div class="leftColumn">Sub Domain Settings</div>
			<div class="rightColumn">
				Change sub domain settings for each region on page:<br />
				<a href="index.php?page=geographic_addon_regions">Addons > Geographic Navigation > Regions</a>
			</div>
			<div class="clearColumn"></div>
		</div>
		<div class="center">
			<br /><br />
			<input type="submit" name="auto_save" value="Save Settings" class="mini_button" />
			<div id="subdomainSettingsAdd">
				<br /><br />
				<input type="hidden" name="autoAdd" id="autoAdd" value="0" />
				<input type="submit" name="auto_save" value="Auto-Set Subdomains" class="mini_button" onclick="$('autoAdd').value='add'; return true;" />
				<br /><br />
				<input type="submit" name="auto_save" value="Clear All Subdomains" class="mini_button" onclick="$('autoAdd').value='clear'; return true;" />
			</div>
		</div>
	</div>
</fieldset>
</form>
<fieldset>
	<legend>List of Current Sub Domains</legend>
	<div>
		<div class="page_note">
			Make sure each domain name listed below properly "points" to your site.  We recommend using a wildcard DNS entry so that using any sub domain will take you to the software, especially if you have a lot of regions with sub-domains.  If that is not possible for your host you will need to configure each sub-domain individually in your DNS control panel.
			You will need to contact your host if you need help changing DNS settings.
		</div>
		{if $tooMany}
			<p class="page_note"><strong>Too Many to List:</strong> There are {$count} sub-domains currently in the system, too many to list here.  You will need to set up a wildcard DNS entry so that all sub-domains point to this installation properly.</p>
		{elseif $subDomainList}
			{foreach from=$subDomainList item=data}
				<div style="float: left; padding: 5px;"><strong>{$data.subdomain}</strong>.{$domain}</div>
			{/foreach}
		{else}
			<div class="page_note_error">No sub-domains are currently configured!</div>
		{/if}
	</div>
</fieldset>